function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/modbusCore/rc/baja/FlexAddress
 */

define(['baja!', 'lex!modbusCore', 'Promise'], function (baja, lexs, Promise) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    modbusCoreLex = _lexs[0];

  /**
   * BajaScript representation of a `modbusCore:FlexAddress
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/modbusCore/rc/baja/FlexAddress
   * @extends baja.Struct
   */
  return /*#__PURE__*/function (_baja$Struct) {
    function FlexAddress() {
      _classCallCheck(this, FlexAddress);
      return _callSuper(this, FlexAddress, arguments);
    }
    _inherits(FlexAddress, _baja$Struct);
    return _createClass(FlexAddress, [{
      key: "$getAddressFormatTag",
      value:
      /**
       * Returns the Address Format tag
       * @private
       * @returns {String}
       */
      function $getAddressFormatTag() {
        return this.get("addressFormat").getTag();
      }

      /**
       * Returns the current value as a localized string
       * @returns {string}
       */
    }, {
      key: "toString",
      value: function toString() {
        return modbusCoreLex.get("flexAddress.toString", this.get("addressFormat").getDisplayTag(), this.get("address"));
      }

      /**
       * Returns true if the current FlexAddress is in HexFormat
       * @returns {boolean}
       */
    }, {
      key: "isHexFormat",
      value: function isHexFormat() {
        return this.$getAddressFormatTag() === "hex";
      }

      /**
       * Returns true if the current FlexAddress is in DecimalFormat
       * @returns {boolean}
       */
    }, {
      key: "isDecimalFormat",
      value: function isDecimalFormat() {
        return this.$getAddressFormatTag() === "decimal";
      }

      /**
       * Returns true if the current FlexAddress is in ModbusFormat
       * @returns {boolean}
       */
    }, {
      key: "isModbusFormat",
      value: function isModbusFormat() {
        return this.$getAddressFormatTag() === "modbus";
      }

      /**
       * Returns true if the address is a valid value
       * @returns {boolean}
       */
    }, {
      key: "isValid",
      value: function isValid() {
        var temp;
        var address = this.get("address");
        if (this.isHexFormat()) {
          temp = parseInt(address, 16);
        } else {
          temp = parseInt(address);
        }
        if (isNaN(temp)) {
          return false;
        }
        if (this.isModbusFormat()) {
          return temp >= 0 && temp < 50000;
        }
        return temp >= 0;
      }

      /**
       * Returns true if the address references an analog address
       * @returns {boolean}
       */
    }, {
      key: "isModbusAnalogAddress",
      value: function isModbusAnalogAddress() {
        if (!this.isModbusFormat()) {
          return false;
        }
        var temp = this.getDataAddressNoModbusAltering();
        return temp >= 30000 && temp < 50000;
      }

      /**
       * Returns true if the address references a digital address
       * @returns {boolean}
       */
    }, {
      key: "isModbusDigitalAddress",
      value: function isModbusDigitalAddress() {
        if (!this.isModbusFormat()) {
          return false;
        }
        var temp = this.getDataAddressNoModbusAltering();
        return temp < 30000 && temp >= 0;
      }

      /**
       * Returns true if the address references a holding address
       * @returns {boolean}
       */
    }, {
      key: "isModbusHoldingAddress",
      value: function isModbusHoldingAddress() {
        if (!this.isModbusFormat()) {
          return false;
        }
        var temp = this.getDataAddressNoModbusAltering();
        return temp > 40000 && temp < 50000;
      }

      /**
       * Returns true if the address references an input address
       * @returns {boolean}
       */
    }, {
      key: "isModbusInputAddress",
      value: function isModbusInputAddress() {
        if (!this.isModbusFormat()) {
          return false;
        }
        var temp = this.getDataAddressNoModbusAltering();
        return temp > 30000 && temp < 40000;
      }

      /**
       * Returns true if the address references a coil address
       * @returns {boolean}
       */
    }, {
      key: "isModbusCoilAddress",
      value: function isModbusCoilAddress() {
        if (!this.isModbusFormat()) {
          return false;
        }
        var temp = this.getDataAddressNoModbusAltering();
        return temp < 10000 && temp >= 0;
      }

      /**
       * Returns true if the address references a status address
       * @returns {boolean}
       */
    }, {
      key: "isModbusStatusAddress",
      value: function isModbusStatusAddress() {
        if (!this.isModbusFormat()) {
          return false;
        }
        var temp = this.getDataAddressNoModbusAltering();
        return temp > 10000 && temp < 20000;
      }

      /**
       * Returns the integer value of the address with no modification for Modbus Formats
       * @returns {number}
       */
    }, {
      key: "getDataAddressNoModbusAltering",
      value: function getDataAddressNoModbusAltering() {
        if (this.isHexFormat()) {
          return parseInt(this.get("address"), 16);
        } else {
          return parseInt(this.get("address"));
        }
      }

      /**
       * Returns the adjusted address value of the address modified for Modbus Formats
       * @returns {number}
       */
    }, {
      key: "getDataAddress",
      value: function getDataAddress() {
        var temp = this.getDataAddressNoModbusAltering();
        if (!this.isModbusFormat()) {
          return temp;
        } else {
          if (temp > 40000) {
            return temp - 40001;
          }
          if (temp > 30000) {
            return temp - 30001;
          }
          if (temp > 20000) {
            return temp - 20001;
          }
          if (temp > 10000) {
            return temp - 10001;
          }
          return temp - 1;
        }
      }

      /**
       *
       * @param {Number} address the integer value of the address
       * @returns {Promise}
       */
    }, {
      key: "setAddressFromInt",
      value: function setAddressFromInt(address) {
        var temp;
        if (this.isHexFormat()) {
          temp = address.toString(16);
        } else {
          temp = address.toString();
        }
        return this.set({
          slot: "address",
          value: temp
        });
      }
    }]);
  }(baja.Struct);
});
