/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/modbusCore/rc/util/dataTypeUtil
 */
define([], function () {
  'use strict';

  var exports = {};

  /**
   * Given a data type determine whether it is a 16-bit integer that occupies 2 registers
   *
   * @param {baja.FrozenEnum} dataType a `modbusCore:DataTypeEnum` that is the type of register data
   * being considered
   * @return {boolean} true if it is an integer, false otherwise
   */
  exports.is16BitInteger = function (dataType) {
    return dataType.getTag() === 'integerType' || dataType.getTag() === 'signedInteger';
  };

  /**
   * Given a data type provide number of registers it occupies on a modbus device.
   *
   * @param {baja.FrozenEnum} dataType a `modbusCore:DataTypeEnum` that is the type of register data
   * being considered
   * @return {number} number of registers the data will take up
   */
  exports.getRegisterCount = function (dataType) {
    if (dataType.getTag() === 'doubleType' || dataType.getTag() === 'signed64BitLongType' || dataType.getTag() === 'unsigned64BitLongType') {
      return 4;
    }
    if (!exports.is16BitInteger(dataType)) {
      return 2;
    }
    return 1;
  };
  return exports;
});
