/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */

/**
 * JoinFe JavaScript support for BHxJoinFe.
 */
var join = new Join();
function Join()
{
  this.confirmMessageLine1='Are you sure you want to switch assignment modes?';
  this.confirmMessageLine2='You have made changes, which have not been saved...';
  this.confirmMessageLine3='Press OK to continue, or Cancel to continue in this mode.';

  this.getConfirmMessage = function()
  {
    return this.confirmMessageLine1 + "\n\n" +
           this.confirmMessageLine2 + "\n\n" +
           this.confirmMessageLine3;
  }

  this.addToSelect = function(listName, value, potentialId, scope, mode)
  {
    if(join.findInSelect(listName, value, scope))
    {

      if(mode == false)
        smartTable.fixRows(smartTable.$$(scope + ".assigned~" + potentialId));
      else
        smartTable.fixRows(smartTable.$$(scope + ".potentials~" + potentialId));
      return false;
    }

    var option = document.createElement('option');
    option.innerHTML=value;
    option.value = value;
    option.potentialId = potentialId;
    var colList = smartTable.$$(listName);
    colList.appendChild(option);

    if(mode == false)
      join.fixPotentialVisibility(option, false, scope, mode);
    else
      join.fixAssignedVisibility(option, false, scope, mode);
    return true;
  }

  this.findInSelect = function(listName, value, scope)
  {
    var colList = smartTable.$$(listName);
    for(var i = 0; i<colList.length; i++)
    {
      var option=colList.options[i];
      var match = option.value;
      if( match == value)
        return true;
    }
    return false;
  }

  this.removeFromSelect = function(listName, value, scope, mode)
  {
    var colList = smartTable.$$(listName);
    for(var i = 0; i<colList.length; i++)
    {
      var option=colList.options[i];
      if(option.value == value)
      {
        if(mode == false)
          join.fixPotentialVisibility(option, true, scope, mode);
        else
          join.fixAssignedVisibility(option, true, scope, mode);
        colList.removeChild(option);
      }
    }
  }

  this.clearSelect = function(listName, scope, mode)
  {
    var colList = smartTable.$$(listName);
    while(colList.length > 0)
    {
      var option=colList.options[colList.length-1];
      if(mode == false)
        join.fixPotentialVisibility(option, true, scope, mode);
      else
        join.fixAssignedVisibility(option, true, scope, mode);
      colList.removeChild(option);
    }
  }

  this.clearAllSelect = function(listName, scope)
  {
    var colList = smartTable.$$(listName);
    while(colList.length > 0)
    {
      var option=colList.options[colList.length-1];
      colList.removeChild(option);
    }
  }


  /**
   * Allows a select to return all options back in a form Value
   */
  this.allSelect = function(listName)
  {
    var colList = smartTable.$$(listName);
    var values = "";
    for(var i = 0; i<colList.length; i++)
    {
      var option=colList.options[i];
      if(values.length > 0)
        values+= '|';
      values += option.value;
    }

    hx.setFormValue(listName + "All", values);
  }

  this.fixPotentialVisibility = function(option, visible, scope, mode)
  {
    join.fixVisibility(option, visible, scope + ".assigned", scope + ".potentials", mode);
  }

  this.fixAssignedVisibility = function(option, visible, scope, mode)
  {
    join.fixVisibility(option, visible, scope + ".potentials", scope + ".assigned", mode);
  }

  this.fixVisibility = function(option, visible, scope, scope2, mode)
  {
    if(!visible)
    {
      if(option.potentialId != null)
      {
        var potential = null;
        potential = smartTable.$$(scope + "~" + option.potentialId);
        if(potential.firstChild.className.indexOf("row-disabled") > -1)
        {
          smartTable.styleRow(potential, null, false);
          return;
        }

        smartTable.styleRow(potential, "row-disabled", false);
        var newCopy = potential.cloneNode(true);
        smartTable.unstyleRow(newCopy, false);
        var id = potential.id;
        if(mode == false)
          newCopy.id=id.replace(".assigned~", ".potentials~");
        else
          newCopy.id=id.replace(".potentials~", ".assigned~");
        var table = smartTable.$$(scope2 + ".records");

        table.firstChild.appendChild(newCopy);
        //ie6 hack: It turns out that the .cells[] accessor is only available after you append the row into the DOM tree.
        var tableLength = table.rows[0].cells.length;
        var dataLength  = newCopy.cells.length;

        if(tableLength > dataLength)
        {
          for(var i=dataLength; i<tableLength; i++)
          {
            var extraCol = newCopy.cells[newCopy.cells.length - 1].cloneNode(true);
            extraCol.innerHTML = "&nbsp;";
            newCopy.appendChild(extraCol);
          }
        }
        else if(tableLength < dataLength)
        {
          for(var i=tableLength; i<dataLength; i++)
          {
            newCopy.removeChild(newCopy.cells[newCopy.cells.length - 1]);
          }
        }

        if(table.className == null || table.className.indexOf('loaded') == -1)
          smartTable.addClick(table);
        smartTable.unselectScope(scope2);
        smartTable.unselectScope(scope);
      }
    }
    else
    {
      if(option.potentialId != null)
      {
        var potential = null;
        var id = scope + "~" + option.potentialId;
        potential = smartTable.$$(id);
        if(potential != null)
        {
          smartTable.unstyleRow(potential, false);
        }
        if(mode == false)
          id=id.replace(".assigned~", ".potentials~");
        else
          id=id.replace(".potentials~", ".assigned~");
        var other = smartTable.$$(id);

        other.parentNode.removeChild(other);
        smartTable.unselectScope(scope);
        smartTable.unselectScope(scope2);
      }
    }
  }

  this.hide = function(listName, scope)
  {
    var colList = smartTable.$$(listName);
    for(var i = 0; i<colList.length; i++)
    {
      var option=colList.options[i];
      join.fixPotentialVisibility(option, false, scope);
    }
  }

  this.initUnassigned = function(listName, scope)
  {
    var colList = smartTable.$$(listName);
    for(var i = 0; i<colList.length; i++)
    {
      var option=colList.options[i];
      join.fixPotentialVisibility(option, false, scope);
    }
  }

}
