function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/driver/rc/fe/ProxyConversionMiniEditor
 */
define(['baja!', 'jquery', 'underscore', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'nmodule/webEditors/rc/util/htmlUtils', 'nmodule/webEditors/rc/fe/baja/PopOutEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder', 'nmodule/webEditors/rc/fe/CompositeEditor', 'css!nmodule/driver/rc/driver'], function (baja, $, _, DisplayOnlyEditor, htmlUtils, PopOutEditor, CompositeBuilder, CompositeEditor) {
  'use strict';

  ///////////////////////////////////////////////////////////////////////////////////////////
  //////ProxyConversionDisplayOnlyEditor
  ////////////////////////////////////////////////////////////////////////////////////////////
  var escapeHtml = htmlUtils.escapeHtml;

  /**
   * Displays only the description property of the loaded value
   * @constructor
   */
  var ProxyConversionDisplayOnlyEditor = function ProxyConversionDisplayOnlyEditor() {
    DisplayOnlyEditor.apply(this, arguments);
  };
  ProxyConversionDisplayOnlyEditor.prototype = Object.create(DisplayOnlyEditor.prototype);
  ProxyConversionDisplayOnlyEditor.prototype.constructor = ProxyConversionDisplayOnlyEditor;

  /**
   * Returns the description of the loaded value if supported.
   * Works for TabularConversion, TabularThermistorConversion and NrioTabularThermistorConversion for eg.
   * @param value
   * @returns {String|*}
   */
  ProxyConversionDisplayOnlyEditor.prototype.valueToString = function (value) {
    if (baja.hasType(value, 'kitIo:TabularConversion') || baja.hasType(value, 'ndio:TabularThermistorConversion') || baja.hasType(value, 'nrio:NrioTabularThermistorConversion')) {
      return "[" + escapeHtml(value.getDescription()) + "]";
    }
    return '';
  };

  ///////////////////////////////////////////////////////////////////////////////////////////
  //////ProxyConversionMiniEditor
  ////////////////////////////////////////////////////////////////////////////////////////////

  /**
   * @class
   * @alias module:nmodule/driver/rc/fe/ProxyConversionMiniEditor
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   * @param params
   */
  var ProxyConversionMiniEditor = function ProxyConversionMiniEditor(params) {
    CompositeEditor.apply(this, arguments);
  };
  ProxyConversionMiniEditor.prototype = Object.create(CompositeEditor.prototype);
  ProxyConversionMiniEditor.prototype.constructor = ProxyConversionMiniEditor;
  ProxyConversionMiniEditor.prototype.makeBuilder = function () {
    var that = this,
      builder = new CompositeBuilder(),
      showButton = that.properties().getValue('showButton');
    builder.getKeys = function () {
      return showButton ? ['value', 'button'] : ['value'];
    };
    builder.getConfigFor = function (key) {
      switch (key) {
        case 'value':
          return {
            type: ProxyConversionDisplayOnlyEditor
          };
        case 'button':
          return {
            type: PopOutEditor
          };
      }
    };
    builder.getValueFor = function (key) {
      switch (key) {
        case 'value':
          return this.getDataSource();
        case 'button':
          return this.getEditorFor('value');
      }
    };
    builder.getDomFor = function (key) {
      return $('<div/>').addClass(key).appendTo(that.jq());
    };
    return builder;
  };
  ProxyConversionMiniEditor.prototype.doRead = function () {
    //just want the first one
    return this.getChildWidgets().readAll().then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
        first = _ref2[0];
      return first;
    });
  };
  return ProxyConversionMiniEditor;
});
//# sourceMappingURL=ProxyConversionMiniEditor.js.map
