/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 */

define(['baja!', 'Promise'], function (baja, Promise) {
  'use strict';

  /**
   * API Status: **Private**
   * @exports nmodule/kitPx/rc/utils/kitPxUtils
   */
  var exports = {};

  /**
   * Update a boolean for an OrdTarget. This supports
   * `baja:Boolean', 'baja:StatusBoolean', 'control:BooleanWritable'
   * slots and actions.
   *
   * @param {module:baja/ord/OrdTarget} ordTarget
   * @param {boolean} value
   * @returns {Promise}
   */
  exports.updateBoolean = function (ordTarget, value) {
    var component = ordTarget.getComponent();
    var slot = ordTarget.slot;
    if (slot) {
      if (slot.isProperty()) {
        var slotType = slot.getType();
        if (slotType.is('baja:Boolean')) {
          return component.set({
            slot: slot,
            value: value
          });
        } else if (slotType.is('baja:StatusBoolean')) {
          var statusBoolean = component.get(slot);
          var batch = new baja.comm.Batch();
          return batch.commit(Promise.all([statusBoolean.set({
            slot: 'status',
            value: baja.Status.make({
              orig: statusBoolean.getStatus(),
              bits: baja.Status.NULL,
              state: false
            }),
            batch: batch
          }), statusBoolean.set({
            slot: 'value',
            value: value,
            batch: batch
          })]));
        } else {
          return Promise.reject(new Error('configuration error, property ' + 'must be Boolean or StatusBoolean'));
        }
      } else if (slot.isAction()) {
        var paramType = slot.getParamType();
        if (paramType && paramType.is('baja:Boolean')) {
          return component.invoke({
            slot: slot,
            value: value
          });
        } else {
          throw new Error('configuration error, action must take boolean parameter');
        }
      }
    } else {
      if (baja.hasType(component, 'control:BooleanWritable')) {
        return component.invoke({
          slot: 'set',
          value: value
        });
      } else {
        return Promise.reject(new Error('configuration error, target ' + 'must be BooleanWritable'));
      }
    }
  };
  return exports;
});
