function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 * @author Nutan Naik
 */

/** @jsx spandrel.jsx */
/* global niagara */
/* eslint-env browser */
/**
 * API Status: **Private**
 * @module nmodule/kitPx/rc/ux/LocalizableButton
 * @since Niagara 4.13
 */
define(['baja!', 'dialogs', 'bajaux/spandrel', 'Promise', 'bajaux/Widget', 'nmodule/gx/rc/baja/Brush', 'nmodule/bajaui/rc/ux/Button', 'nmodule/gx/rc/baja/Image', 'nmodule/bajaui/rc/binding/impl/widgetEvents', 'lex!webEditors', 'log!nmodule/kitPx/rc/ux/LocalizableButton', 'css!nmodule/kitPx/rc/kitPx'], function (baja, dialogs, spandrel, Promise, Widget, Brush, Button, Image, widgetEvents, lexs, log) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
      return {
        properties: {
          rootCssClass: 'ux-LocalizableButton ux-Button',
          textFormat: baja.Format.DEFAULT,
          backgroundImage: Image.NULL,
          hyperlink: baja.Ord.DEFAULT,
          hoverTextFormat: baja.Format.DEFAULT,
          statusTextFormat: baja.Format.DEFAULT,
          showHandCursor: true,
          confirmRequired: false
        }
      };
    },
    logSevere = log.severe.bind(log);

  /**
   * @class
   * @alias module:nmodule/kitPx/rc/ux/LocalizableButton
   * @extends module:nmodule/bajaui/rc/ux/Button
   */
  return /*#__PURE__*/function (_spandrel) {
    function LocalizableButton(params) {
      _classCallCheck(this, LocalizableButton);
      return _callSuper(this, LocalizableButton, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(LocalizableButton, _spandrel);
    return _createClass(LocalizableButton, [{
      key: "doLayout",
      value: function doLayout() {
        this.$setBackgroundImage();
        return _superPropGet(LocalizableButton, "doLayout", this, 3)(arguments);
      }

      /**
       * Sets backgroundImage property of the LocalizableButton
       * @private
       */
    }, {
      key: "$setBackgroundImage",
      value: function $setBackgroundImage() {
        var props = this.properties();
        var background = props.getValue('background');
        var backgroundImage = props.getValue('backgroundImage');
        if (background.isNull() && !backgroundImage.isNull()) {
          props.setValue("background", Brush.makeImageBrush(backgroundImage));
        }
      }

      /**
       * Returns css cursor type based on the showHandCursor property
       * @override
       * @returns {string} css cursor type
       */
    }, {
      key: "getCursorType",
      value: function getCursorType() {
        var props = this.properties();
        var showHandCursor = props.getValue('showHandCursor');
        var hyperlink = props.getValue('hyperlink');
        if (showHandCursor || !hyperlink.isNull()) {
          return 'pointer';
        } else {
          return _superPropGet(LocalizableButton, "getCursorType", this, 3)([]);
        }
      }

      /**
       * Subclasses can override this method if they want to ignore the hyperlink.
       * @private
       * @returns {boolean}
       */
    }, {
      key: "$supportsHyperlink",
      value: function $supportsHyperlink() {
        return true;
      }
    }, {
      key: "doInvokeAction",
      value: function doInvokeAction(e) {
        var that = this;
        if (this.$supportsHyperlink()) {
          var hyperlink = getWidgetHyperlink(this);
          if (this.isEnabled() && hyperlink) {
            if (getConfirmRequired(this)) {
              var _lexs = _slicedToArray(lexs, 1),
                lex = _lexs[0];
              return dialogs.showYesNo(lex.get({
                key: "hyperlinkTo",
                args: [hyperlink]
              })).yes(function () {
                return that.$hyperlink(hyperlink);
              }).promise();
            } else {
              return this.$hyperlink(hyperlink);
            }
          }
        }
        return _superPropGet(LocalizableButton, "doInvokeAction", this, 3)(arguments);
      }

      /**
       * Hyperlink and call super.doInvokeAction to emit the proper events.
       * @private
       * @param {String|baja.Ord} hyperlink
       * @returns {Promise}
       */
    }, {
      key: "$hyperlink",
      value: function $hyperlink(hyperlink) {
        var _arguments = arguments,
          _this = this;
        return Promise["try"](function () {
          return niagara.env.hyperlink(hyperlink);
        })["catch"](logSevere).then(function () {
          return _superPropGet(LocalizableButton, "doInvokeAction", _this, 3)(_arguments);
        });
      }
    }]);
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties,
      self = _ref.self,
      renderSuper = _ref.renderSuper;
    var textFormat = properties.textFormat,
      statusTextFormat = properties.statusTextFormat,
      hoverTextFormat = properties.hoverTextFormat,
      buttonStyle = properties.buttonStyle;
    return getFormattedText(textFormat, statusTextFormat, hoverTextFormat).then(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 3),
        formattedText = _ref3[0],
        formattedStatusText = _ref3[1],
        formattedHoverText = _ref3[2];
      return renderSuper(function (state) {
        var properties = state.properties;
        properties.text = formattedText;
        self.$setBackgroundImage();
        var buttonTag = buttonStyle.getTag();
        properties.tooltip = hoverTextFormat !== baja.Format.DEFAULT && buttonTag === 'toolBar' ? formattedHoverText : formattedStatusText;
        return state;
      });
    });
  }, {
    "extends": Button
  }));
  function getWidgetHyperlink(widget) {
    var hyperlink = widget.properties().getValue('hyperlink');
    return !hyperlink.isNull() && hyperlink;
  }
  function getConfirmRequired(widget) {
    return widget.properties().getValue('confirmRequired');
  }
  function getFormattedText(textFormat, statusTextFormat, hoverTextFormat) {
    var promises = [];
    promises.push(textFormat.format());
    statusTextFormat === baja.Format.DEFAULT ? promises.push("") : promises.push(statusTextFormat.format());
    hoverTextFormat === baja.Format.DEFAULT ? promises.push("") : promises.push(hoverTextFormat.format());
    return Promise.all(promises);
  }
});
