/*  
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */

/**
 * AbstractManager JavaScript support.
 *
 * @author    Andy Frank
 * @creation  22 Mar 05
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 * @deprecated Please use 'nmodule/webEditors/rc/wb/mgr/Manager' instead.
 */

////////////////////////////////////////////////////////////////
// AbstractManager
////////////////////////////////////////////////////////////////

var mgr = new AbstractMgr();
function AbstractMgr() {
  ////////////////////////////////////////////////////////////////
  // Selection
  ////////////////////////////////////////////////////////////////

  /**
   * Mark the row as selected or deselected.
   */
  this.select = function (event) {
    // TODO - do we want to do this?  
    //    var checkbox = (!event.target) ? window.event.srcElement : event.target;
    //    var tr = checkbox.parentNode.parentNode;
    //    for (var i=0; i<tr.childNodes.length; i++)
    //    {
    //      var td = tr.childNodes[i];      
    //      if (td.className == "")
    //        td.className = "selectionBackground selectionForeground";
    //      else  
    //        td.className = "";       
    //    }
  };

  /**
   * Select the editor - if selected, make editable, if
   * unselected, make readonly.
   */
  this.selectEditor = function (event) {
    var checkbox = !event.target ? window.event.srcElement : event.target;
    var tr = checkbox.parentNode.parentNode;
    var td = tr.childNodes[2]; // editor
    mgr.enableEditors(td);
  };

  /**
   * Recurse an element toggled enabled state.
   */
  this.enableEditors = function (elem) {
    if (elem.nodeType != 1) return;

    // Toggle enable
    if (elem.nodeName == "INPUT" || elem.nodeName == "SELECT") elem.disabled = !elem.disabled;

    // Recurse children
    for (var i = 0; i < elem.childNodes.length; i++) mgr.enableEditors(elem.childNodes[i]);
  };

  ////////////////////////////////////////////////////////////////
  // Commands
  ////////////////////////////////////////////////////////////////

  /**
   * Invoke the specified command.
   */
  this.invokeCommand = function (name, requireSelection, event) {
    var button = !event.target ? window.event.srcElement : event.target;
    var rows = "";
    var table = button.parentNode.previousSibling;
    var tbody = table.firstChild;
    // Skip th's
    for (var i = 1; i < tbody.childNodes.length; i++) {
      var tr = tbody.childNodes[i];
      var td = tr.firstChild;
      var checkbox = td.firstChild;
      if (checkbox.checked) {
        if (rows.length > 0) rows += ",";
        rows += checkbox.value;
      }
    }

    // Enforce selection if needed
    if (requireSelection && rows.length == 0) {
      alert("No row(s) selected.");
      return;
    }

    // Invoke command
    var body = name;
    if (rows.length > 0) body += "," + rows;
    var msg = new Message();
    var csrfToken = hx.getCsrfToken();
    if (csrfToken) {
      msg.setHeader("x-niagara-csrfToken", csrfToken);
    }
    msg.setHeader("Content-Type", "application/x-niagara-AbstractMgr-InvokeCommand");
    msg.send(window.location, body, this.doInvokeCommand);
  };

  /**
   * Handle invokeCommand response.
   */
  this.doInvokeCommand = function (resp) {
    var text = resp.responseText;
    if (text == "null") {
      window.location.reload(true);
      return;
    }

    // See if there was any javascript attached
    var js = null;
    var start = text.indexOf("<script type='text/javascript'>");
    if (start != -1) {
      var end = text.indexOf("</script>");
      js = text.substring(start + 31, end);
    }
    var path = resp.getResponseHeader("hxPath");
    var content = document.getElementById(path + ".content");
    for (var i = 0; i < content.childNodes.length; i++) {
      var kid = content.childNodes[i];
      kid.style.display = "none";
    }
    var div = document.createElement("div");
    div.name = "mgrCmdWin";
    div.innerHTML = text;
    content.appendChild(div);

    // Evaluate javascript after markup has been added to the DOM
    if (js != null) eval(js);
  };

  /**
   * Cancel a command.
   */
  this.cancelCommand = function (event) {
    var button = !event.target ? window.event.srcElement : event.target;
    var parent = button.parentNode;
    while (parent.name != "mgrCmdWin") parent = parent.parentNode;
    var content = parent.parentNode;
    for (var i = 0; i < content.childNodes.length; i++) {
      var kid = content.childNodes[i];
      if (kid.name == "mgrCmdWin") content.removeChild(kid);else kid.style.display = "block";
    }
  };
}
