function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/kitIo/rc/TabularConversionEditor
 */
define(['nmodule/driver/rc/fe/BaseTabularConversionEditor', 'Promise', 'lex!kitIo', 'nmodule/kitIo/rc/baja/TabularConversion'], function (BaseTabularConversionEditor, Promise, lexs, TabularConversion) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    kitIoLex = _lexs[0];

  /**
   * Bajaux editor for Tabular conversion
   *
   * @class
   * @extends module:nmodule/driver/rc/fe/BaseTabularConversionEditor
   * @alias module:nmodule/kitIo/rc/TabularConversionEditor
   */
  var TabularConversionEditor = function TabularConversionEditor() {
    var that = this;
    BaseTabularConversionEditor.apply(that, arguments);
  };

  //extend and set up prototype chain
  TabularConversionEditor.prototype = Object.create(BaseTabularConversionEditor.prototype);
  TabularConversionEditor.prototype.constructor = TabularConversionEditor;

  /**
   * @see BaseTabularConversionEditor.getInitDomProps
   */
  TabularConversionEditor.prototype.getInitDomProps = function () {
    return {
      labels: {
        desc: kitIoLex.get("TabularConversion.description"),
        source: kitIoLex.get("TabularConversion.point.source"),
        result: kitIoLex.get("TabularConversion.point.result")
      }
    };
  };

  /**
   * Reads the editor data into a TabularConversion object
   * @returns {Promise} promise to be resolved with the current value
   */
  TabularConversionEditor.prototype.doRead = function () {
    return Promise.all([this.$getDescEditor().read(), this.getBuilder().readAll()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        desc = _ref2[0],
        points = _ref2[1];
      return TabularConversion.make(desc, points);
    });
  };
  return TabularConversionEditor;
});
