function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * Copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/* global niagara */

/**
 * API Status: **Private**
 * @module nmodule/vykonPro/rc/HyperlinkListSelectorV1
 */
define(['baja!', 'baja!bajaui:Align,gx:Brush,gx:Font,bajaui:Halign,bajaui:HyperlinkMode,' + 'gx:Insets,bajaui:Valign,gx:Size,baja:VirtualComponent', 'bajaux/spandrel', 'Promise', 'nmodule/webEditors/rc/wb/profile/profileUtils', 'nmodule/bajaui/rc/util/pxUtils', 'log!uxMedia', 'css!nmodule/vykonPro/rc/vykonPro'], function (baja, types, spandrel, Promise, profileUtils, pxUtils, log) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-HyperlinkListSelector',
        enabled: true,
        visible: true,
        font: baja.$('gx:Font', 'null'),
        background: baja.$('gx:Brush', 'null'),
        align: baja.$('bajaui:Halign', 'left'),
        rowAlign: baja.$('bajaui:Valign', 'center'),
        browserTarget: '_self',
        selectionText: 'Select Hyperlink',
        wbTarget: baja.$('bajaui:HyperlinkMode', 'replace')
      }
    };
  };

  /**
   * HyperlinkListSelectorV1 is a Widget for vykonPro:HyperlinkListSelectorV1.
   *
   * @class
   * @alias module:nmodule/vykonPro/rc/HyperlinkListSelectorV1
   * @extends {module:bajaux/Widget}
   */
  return /*#__PURE__*/function (_spandrel) {
    function HyperlinkListSelector(params) {
      _classCallCheck(this, HyperlinkListSelector);
      return _callSuper(this, HyperlinkListSelector, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(HyperlinkListSelector, _spandrel);
    return _createClass(HyperlinkListSelector, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this = this;
        dom.on('change', '.-v-Selector', function (e) {
          hyper(e.target.value, _this);
        });
      }
    }]);
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties,
      rootElement = _ref.rootElement;
    var background = properties.background,
      font = properties.font,
      align = properties.align,
      rowAlign = properties.rowAlign,
      ord = properties.ord,
      selectionText = properties.selectionText;
    if (ord.isNull()) {
      return;
    }
    var sub = new baja.Subscriber();
    var baseOrd = baja.Ord.make({
      base: profileUtils.getCurrentOrd().relativizeToSession(),
      child: ord
    }).normalize();
    return baseOrd.get({
      subscriber: sub
    }).then(function (comp) {
      var hls = rootElement;
      background.applyBackgroundToElement(hls);
      hls.style.justifyContent = toHAlign(align.getTag());
      hls.style.alignItems = toVAlign(rowAlign.getTag());
      var div = document.createElement('div');
      div.classList.add("ux-HyperlinkListSelector-content");
      var isVirtual = comp.getType().is('baja:VirtualComponent');
      var linkNames = [],
        linkOrds = [],
        hyperlinks = [],
        external = [];
      var numberOfLinks = comp.get('numberOfHyperlinks');
      for (var i = 0; i < numberOfLinks; i++) {
        linkNames[i] = comp.get('hyperlinkDisplay' + (i + 1));
        linkOrds[i] = comp.get('hyperlinkOrd' + (i + 1));
        // check if external slot exists to handle backward compatibility
        external[i] = comp.get('external' + (i + 1));
        if (external[i] == null) external[i] = false;
        var nullOrd = false;
        if (linkOrds[i].isNull()) {
          nullOrd = true;
          linkOrds[i] = profileUtils.getCurrentOrd().relativizeToSession();
        }
        if (isVirtual === true && external[i] === false && nullOrd === false) {
          // TODO resolve ord via virtual gateway without NiagaraVirtualUtil support
          // NiagaraVirtualUtil.fromServerOrdToClientVirtual(BOrd.make("slot:/"),ord));
          var vord = linkOrds[i].encodeToString();
          var index = vord.indexOf("station:");
          if (index > -1) {
            vord = vord.substring(index + 9);
          }
          hyperlinks[i] = baja.Ord.make({
            base: comp.getComponentSpace().getNavOrd().relativizeToSession(),
            child: vord
          }).toUri();
        } else if (external[i] === false && nullOrd === false) {
          hyperlinks[i] = baja.Ord.make({
            base: profileUtils.getCurrentOrd().relativizeToSession(),
            child: linkOrds[i].normalize()
          }).toUri();
        } else {
          // this is an external link so don't modify
          hyperlinks[i] = linkOrds[i];
        }
      }
      var selectorSpan = document.createElement('select');
      selectorSpan.classList.add('-v-Selector');
      font.applyToElement(selectorSpan);
      var options = [];
      options.push(new Option(selectionText));
      for (var j = 0; j < numberOfLinks; j++) {
        options.push(new Option(linkNames[j], hyperlinks[j]));
      }
      return [{
        dom: div,
        kids: [{
          dom: selectorSpan,
          kids: options
        }]
      }];
    });
  }));

  /**
   * Horizontal positioning based on css changes to `justifyContent`
   * @param {String} tag
   * @return {String}
   */
  function toHAlign(tag) {
    switch (tag) {
      case 'center':
      case 'fill':
        return 'center';
      case 'left':
        return 'flex-start';
      case 'right':
        return 'flex-end';
    }
  }

  /**
   * Vertical position based on css change to `alignItems`.
   * @param {String} tag
   * @return {String}
   */
  function toVAlign(tag) {
    switch (tag) {
      case 'fill':
      case 'center':
        return 'center';
      case 'top':
        return 'flex-start';
      case 'bottom':
        return 'flex-end';
    }
  }
  function hyper(hyperlink, widget) {
    var browserTarget = widget.properties().getValue('browserTarget');
    if (browserTarget === "_self" || browserTarget === "_parent") {
      return Promise["try"](function () {
        return niagara.env.hyperlink(hyperlink);
      })["catch"](logSevere);
    } else {
      window.open(hyperlink, browserTarget);
    }
  }
  ;
});
