function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/**
 * API Status: **Private**
 * @module nmodule/converters/rc/NumericToSimpleMap
 */

define(['baja!', 'Promise', 'underscore'], function (baja, Promise, _) {
  "use strict";

  /**
   * A bajaux implementation of a NumericToSimpleMap converter.
   * @alias module:nmodule/converters/rc/NumericToSimpleMap
   * @extends baja.Simple
   */
  var NumericToSimpleMap = /*#__PURE__*/function (_baja$Simple) {
    function NumericToSimpleMap(items, def) {
      var _this;
      _classCallCheck(this, NumericToSimpleMap);
      _this = _callSuper(this, NumericToSimpleMap, arguments);
      _this.$items = items;
      _this.$def = def;
      return _this;
    }

    /**
     * Decode a NumericToSimpleMap
     *
     * @param {String} str
     * @return {NumericToSimpleMap}
     */
    _inherits(NumericToSimpleMap, _baja$Simple);
    return _createClass(NumericToSimpleMap, [{
      key: "decodeFromString",
      value: function decodeFromString(str) {
        return NumericToSimpleMap.make({
          str: str
        });
      }

      /**
       *
       * @param {string} str
       * @param {baja.comm.Batch} [batch]
       * @return {Promise}
       */
    }, {
      key: "decodeAsync",
      value: function decodeAsync(str, batch) {
        if (str === "null") {
          return Promise.resolve(NumericToSimpleMap.DEFAULT);
        }

        // Get the prototype instance (used to decode everything else)
        var protoRes = /^([^ ]+) (.*)/.exec(str);
        if (protoRes.length <= 1) {
          throw new Error("Cannot decode NumericToSimpleMap" + str);
        }

        // Decode the prototype simple we're going to decode from
        var typeToImport = protoRes[1];
        return Promise.resolve(baja.importTypes({
          typeSpecs: [typeToImport],
          batch: batch
        })).then(function () {
          return NumericToSimpleMap.make(str);
        });
      }

      /**
       * Determines the type of values in the NumericToSimpleMap.
       * @returns {baja.Type|null}
       */
    }, {
      key: "getValueType",
      value: function getValueType() {
        if (this.$def !== null) {
          return this.$def.getType();
        } else if (this.$items.length > 0) {
          return this.$items[0].value.getType();
        } else {
          return null;
        }
      }

      /**
       * Gets the default value for this map.
       * @returns {baja.Simple}
       */
    }, {
      key: "getDefault",
      value: function getDefault() {
        return this.$def;
      }

      /**
       * Gets the min from the items.
       * @returns {Array.<number>}
       */
    }, {
      key: "getMinimums",
      value: function getMinimums() {
        return _.pluck(this.$items, 'min');
      }

      /**
       * Gets the max from the items.
       * @returns {Array.<number>}
       */
    }, {
      key: "getMaximums",
      value: function getMaximums() {
        return _.pluck(this.$items, 'max');
      }

      /**
       * Gets the value from the items.
       * @returns {Array.<baja.Simple>}
       */
    }, {
      key: "getValues",
      value: function getValues() {
        return _.pluck(this.$items, 'value');
      }

      /**
       * Determines whether NumericToSimpleMap is null based upon the contents of
       * the items array.
       * @returns {boolean} true if null, false if not null
       */
    }, {
      key: "isNull",
      value: function isNull() {
        return this.$items.length === 0;
      }

      /**
       * Make a NumericToSimpleMap
       *
       * @param {Object|string} obj Object Literal for the method's arguments or
       * the string encoding of the NumericToSimpleMap.
       * @param {String} obj.str the String encoding.
       * @return {NumericToSimpleMap}
       */
    }, {
      key: "make",
      value: function make(obj) {
        obj = baja.objectify(obj, "str");
        if (!obj || !obj.str) {
          throw new Error("NumericToSimpleMap.make passed invalid value");
        }
        if (obj.str === "null") {
          return NumericToSimpleMap.DEFAULT;
        }

        // Get the prototype instance (used to decode everything else)
        var protoRes = /^([^ ]+) (.*)/.exec(obj.str);
        if (protoRes.length <= 1) {
          throw new Error("Cannot decode NumericToSimpleMap" + obj.str);
        }

        // Decode the prototype simple we're going to decode from
        var proto = baja.$(protoRes[1]);

        // Separate out the value pairs
        var valPairRegEx = /([^;]*)=(([^;]|;;)*)/g;
        var valPairRes,
          defValue = null,
          value,
          numRegEx,
          numRes,
          items = [];
        valPairRes = valPairRegEx.exec(protoRes[2]);
        while (valPairRes) {
          // Decode the value from the String
          var encodedValue = valPairRes[2].replace(/;;/g, ";");
          value = proto.decodeFromString(encodedValue);
          if (valPairRes[1] === "default") {
            defValue = value;
          } else {
            // Decode the numeric range
            numRegEx = /([^:]*):([^:]*)/;
            numRes = numRegEx.exec(valPairRes[1]);
            if (!numRes || numRes && numRes.length !== 3) {
              throw new Error("Could not decode NumericToSimpleMap: " + valPairRes[1]);
            }

            // Add the item with the min and max range to our array
            items.push({
              min: baja.Double.DEFAULT.decodeFromString(numRes[1]).valueOf(),
              max: baja.Double.DEFAULT.decodeFromString(numRes[2]).valueOf(),
              value: value
            });
          }
          valPairRes = valPairRegEx.exec(protoRes[2]);
        }
        return new NumericToSimpleMap(items, defValue);
      }

      /**
       * Encode the NumericToSimpleMap to a String
       *
       * @return {String}
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        var str = "";
        if (this.$items.length === 0 && this.$def === null) {
          return "null";
        }
        str = "".concat(this.getValueType().toString(), " ");
        this.$items.forEach(function (item) {
          var encodedString = item.value.encodeToString(),
            value = "".concat(item.min, ":").concat(item.max, "=").concat(encodedString.replace(/;/g, ";;"), ";");
          str = str.concat(value);
        });
        if (this.$items.length > 0) {
          str = str.substring(0, str.length - 1);
        }
        if (this.$def !== null) {
          if (this.$items.length > 0) {
            str = str.concat(";");
          }
          var encodedString = this.$def.encodeToString();
          str = str.concat("default=".concat(encodedString.replace(/;/g, ";;")));
        }
        return str;
      }

      /**
       * Equality test
       *
       * @param obj num
       * @return {Boolean}
       */
    }, {
      key: "equals",
      value: function equals(obj) {
        var it, objIt, i;
        if (baja.hasType(obj) && obj.getType().equals(this.getType()) && obj.$items.length === this.$items.length) {
          // Compare items
          for (i = 0; i < this.$items.length; ++i) {
            it = this.$items[i];
            objIt = obj.$items[i];
            if (it.min !== objIt.min || it.max !== objIt.max || !it.value.equals(objIt.value)) {
              return false;
            }
          }

          // Compare default values
          if (this.$def === null) {
            return obj.$def === null;
          } else {
            if (obj.$def === null) {
              return false;
            } else {
              return obj.$def.equals(this.$def);
            }
          }
        }
        return false;
      }

      /**
       * Get a simple by its numeric value or return the default if no mapping.
       *
       * @param {Number} num
       * @return {baja.Simple} the value (or null if no default is specified).
       */
    }, {
      key: "get",
      value: function get(num) {
        var it, i;
        for (i = 0; i < this.$items.length; ++i) {
          it = this.$items[i];
          if (it.min <= num && num <= it.max) {
            return it.value;
          }
        }
        return this.$def;
      }
    }]);
  }(baja.Simple);
  /**
   * Default NumericToSimpleMap instance
   */
  NumericToSimpleMap.DEFAULT = new NumericToSimpleMap([], null);

  /**
   * Make a NumericToSimpleMap
   *
   * @param {Object} obj Object Literal for the method's arguments.
   * @param {String} obj.str the String encoding.
   * @return {NumericToSimpleMap}
   */
  NumericToSimpleMap.make = function (obj) {
    return NumericToSimpleMap.DEFAULT.make(obj);
  };
  return NumericToSimpleMap;
});
