function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/baja/InstallCleanDistFactory
 */

define(['baja!', 'baja!provisioningNiagara:InstallCleanDistStep,provisioningNiagara:InstallCleanDistFactory', 'lex!provisioningNiagara', 'dialogs', 'jquery', 'Promise', 'underscore', 'nmodule/batchJob/rc/baja/UxJobStepFactory', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/PropertySheet', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'nmodule/webEditors/rc/wb/table/model/columns/JsonObjectPropertyColumn'], function (baja, types, lexs, dialogs, $, Promise, _, UxJobStepFactory, BaseWidget, feDialogs, PropertySheet, Table, Row, TableModel, JsonObjectPropertyColumn) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    PROVISIONING_NIAGARA_LEX = _lexs[0];
  var FILE_LIST;
  var once = _.once;
  var loadFiles = once(function () {
    return baja.rpc({
      typeSpec: "provisioningNiagara:ProvisioningNiagaraRpcUtil",
      method: "getCleanDistFiles",
      args: []
    }).then(function (flist) {
      FILE_LIST = flist;
    });
  });
  var getInstallable = function getInstallable(navOrd) {
    return baja.rpc({
      typeSpec: "provisioningNiagara:ProvisioningNiagaraRpcUtil",
      method: "getInstallable",
      args: [navOrd]
    }).then(function (results) {
      var resultsBson = JSON.parse(results);
      return baja.bson.decodeAsync(resultsBson);
    });
  };

  /**
   * A 'provisioningNiagara:InstallCleanDistFactory' editor
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/baja/InstallCleanDistFactory
   * @extends module:nmodule/batchJob/rc/baja/UxJobStepFactory
   */
  return /*#__PURE__*/function (_UxJobStepFactory) {
    function InstallCleanDistFactory() {
      _classCallCheck(this, InstallCleanDistFactory);
      return _callSuper(this, InstallCleanDistFactory, [{
        module: 'provisioningNiagara',
        lex: 'InstallCleanDistFactory'
      }]);
    }

    /**
     * Resolves to a 'provisioningNiagara:ExportCsrJobStep'
     * @returns {Promise<baja.Component|undefined>}
     */
    _inherits(InstallCleanDistFactory, _UxJobStepFactory);
    return _createClass(InstallCleanDistFactory, [{
      key: "makeStep",
      value: function makeStep() {
        return this.$promptForStep(baja.$('provisioningNiagara:InstallCleanDistStep'));
      }

      /**
       * Resolves to a new 'provisioningNiagara:ExportCsrJobStep'
       * @param {Object} params
       * @param {baja.Component} params.step an instance of 'provisioningNiagara:ExportCsrJobStep'
       * @returns {Promise<baja.Component|undefined>}
       */
    }, {
      key: "editStep",
      value: function editStep(_ref) {
        var step = _ref.step;
        return this.$promptForStep(step);
      }

      /**
       * calls the loadFiles function to load the files
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$loadFiles",
      value: function $loadFiles() {
        return loadFiles();
      }

      /**
       * Prompts for the values for the step and creates the new step value
       * @private
       * @param {baja.Component} step an instance of 'provisioningNiagara:ExportCsrJobStep'
       * @returns {Promise<baja.Component|undefined>}
       */
    }, {
      key: "$promptForStep",
      value: function $promptForStep(step) {
        var _this = this;
        var installTo;
        var platformCredentials;
        var stationCredentials;
        return this.$loadFiles().then(function () {
          return _this.$selectInstallFile(step);
        }).then(function (selectedRow) {
          if (selectedRow) {
            return getInstallable(selectedRow.navOrd.encodeToString());
          }
        }).then(function (installable) {
          installTo = installable;
          if (installTo) {
            return _this.$promptForPasswords(step);
          }
        }).then(function (comp) {
          if (comp) {
            platformCredentials = comp.get('platformCredentials').newCopy();
            stationCredentials = comp.get('stationCredentials').newCopy();
            return _this.$showWarning(installTo.getInstallableFileName());
          }
        }).then(function (status) {
          return _this.$buildStep(status, installTo, platformCredentials, stationCredentials);
        });
      }

      /**
       * Allows the user to select a file from the list retrieved from the server
       * @private
       * @returns {Promise<Object>} a JSONObject that contains the selected file entry
       */
    }, {
      key: "$selectInstallFile",
      value: function $selectInstallFile(step) {
        var _this2 = this;
        var fileName = step.getToInstall().getInstallableFileName();
        return this.$buildTableModel().then(function (tableModel) {
          var selectedIndex;
          var rows = tableModel.getRows();
          rows.forEach(function (row, index) {
            var subject = row.getSubject();
            if (subject.name === fileName) {
              selectedIndex = index;
            }
          });
          return feDialogs.showFor({
            title: PROVISIONING_NIAGARA_LEX.get('InstallCleanDistStep.cleanDistDialog.title'),
            summary: PROVISIONING_NIAGARA_LEX.get('InstallCleanDistStep.cleanDistDialog.message'),
            type: _this2.$getSelectedInstallFilesTable(),
            value: tableModel,
            formFactor: 'compact',
            progressCallback: function progressCallback(msg, ed) {
              switch (msg) {
                case 'loaded':
                  if (selectedIndex) {
                    return ed.$getSelection().select(selectedIndex);
                  }
              }
            }
          }).then(function (fileList) {
            //Returns null if factories is empty or null
            return fileList && fileList[0] || null;
          });
        });
      }

      /**
       * Build the table model used for selecting the installation file
       * @private
       * @returns {Promise<module:nmodule/webEditors/rc/wb/table/model/TableModel>}
       */
    }, {
      key: "$buildTableModel",
      value: function $buildTableModel() {
        var _this3 = this;
        return Promise.all(FILE_LIST.map(function (fileEntry) {
          return _this3.$makeRow(fileEntry);
        })).then(function (rows) {
          var nameColumn = new JsonObjectPropertyColumn('name', {
            displayName: PROVISIONING_NIAGARA_LEX.get('InstallCleanDistCredentailsDialog.fileTable.name')
          });
          var modifiedColumn = new JsonObjectPropertyColumn('modified', {
            displayName: PROVISIONING_NIAGARA_LEX.get('InstallCleanDistCredentailsDialog.fileTable.modified')
          });
          var sizeColumn = new JsonObjectPropertyColumn('size', {
            displayName: PROVISIONING_NIAGARA_LEX.get('InstallCleanDistCredentailsDialog.fileTable.size')
          });
          var columns = [nameColumn, modifiedColumn, sizeColumn];
          return new TableModel({
            rows: rows,
            columns: columns
          });
        });
      }

      /**
       * Makes a row for the table model
       * @private
       * @param {Object} fileEntry a JSONObject that contains a file entry
       * @returns {module:nmodule/webEditors/rc/wb/table/model/Row}
       */
    }, {
      key: "$makeRow",
      value: function $makeRow(fileEntry) {
        var name = fileEntry.name,
          modified = fileEntry.modified,
          size = fileEntry.size;
        return new Row({
          fileEntry: fileEntry,
          name: name,
          modified: modified,
          size: size
        });
      }

      /**
       * Returns the usernames and passwords for the platforma and station necessary for running the
       * step
       * @private
       * @param {Object} step the current 'provisioningNiagara:InstallCleanDistStep'
       * @returns {Promise<baja:Component>}
       */
    }, {
      key: "$promptForPasswords",
      value: function $promptForPasswords(step) {
        var platformCredentials = step.getDefaultPlatformCredentials().newCopy();
        var stationCredentials = step.getDefaultStationCredentials().newCopy();
        var comp = baja.$('baja:Component', {
          platformCredentials: platformCredentials,
          stationCredentials: stationCredentials,
          displayNames: baja.NameMap.make({
            platformCredentials: PROVISIONING_NIAGARA_LEX.get('InstallCleanDistCredentialsDialog.defaultPlatform'),
            stationCredentials: PROVISIONING_NIAGARA_LEX.get('InstallCleanDistCredentialsDialog.defaultStation')
          })
        });
        comp.setFlags({
          slot: 'displayNames',
          flags: baja.Flags.HIDDEN
        });
        return feDialogs.showFor({
          dom: $('<div class="-t-InstallCleanDist-Credentials"/>'),
          title: PROVISIONING_NIAGARA_LEX.get('InstallCleanDistCredentialsDialog.title'),
          summary: PROVISIONING_NIAGARA_LEX.get('InstallCleanDistCredentialsDialog.description'),
          value: comp,
          type: PropertySheet,
          properties: {
            showHeader: false,
            showControls: false
          },
          buttons: {
            ok: function ok(dialog, event, editor) {
              return editor.save().then(function () {
                return comp;
              });
            },
            cancel: {}
          }
        });
      }

      /**
       * Shows the warning prior to saving the job
       * @private
       * @param {String} fileName the next of the installation file
       * @returns {Promise}
       */
    }, {
      key: "$showWarning",
      value: function $showWarning(fileName) {
        var warning = PROVISIONING_NIAGARA_LEX.get('InstallCleanDistFactory.deployWarning') + '\n\n' + PROVISIONING_NIAGARA_LEX.get('InstallCleanDistFactory.distFileWarning', fileName) + '\n\n' + PROVISIONING_NIAGARA_LEX.get('InstallCleanDistFactory.backupWarning') + '\n\n' + PROVISIONING_NIAGARA_LEX.get('InstallCleanDistFactory.bootstrapWarning') + '\n\n' + PROVISIONING_NIAGARA_LEX.get('InstallCleanDistFactory.credentialsWarning') + '\n\n';
        return dialogs.showOkCancel({
          title: PROVISIONING_NIAGARA_LEX.get('InstallCleanDistFactory.warningTitle'),
          text: warning
        }).promise();
      }

      /**
       * Builds the new 'provisioningNiagara:InstallCleanDistStep' step from the supplied values
       * @private
       * @param status
       * @param installTo
       * @param platformCredentials
       * @param stationCredentials
       * @returns {baja.Component|undefined}
       */
    }, {
      key: "$buildStep",
      value: function $buildStep(status, installTo, platformCredentials, stationCredentials) {
        if (status) {
          var step = baja.$('provisioningNiagara:InstallCleanDistStep');
          step.setFactoryType(baja.$('baja:TypeSpec', 'provisioningNiagara:InstallCleanDistFactory'));
          step.setToInstall(installTo);
          step.setDefaultPlatformCredentials(platformCredentials);
          step.setDefaultStationCredentials(stationCredentials);
          return step;
        }
      }

      /**
       * Retrieves the selected file table inner class
       * @private
       * @returns {SelectedInstallFilesTable}
       */
    }, {
      key: "$getSelectedInstallFilesTable",
      value: function $getSelectedInstallFilesTable() {
        /**
         * @inner
         * @class
         * @extends {module:nmodule/webEditors/rc/wb/table/Table}
         */
        var SelectedInstallFilesTable = /*#__PURE__*/function (_Table) {
          function SelectedInstallFilesTable() {
            var _this4;
            _classCallCheck(this, SelectedInstallFilesTable);
            _this4 = _callSuper(this, SelectedInstallFilesTable, arguments);
            //Dialog can be submitted only if a row is selected.
            _this4.validators().add(function (readRows) {
              if (readRows.length !== 1) {
                throw new Error(PROVISIONING_NIAGARA_LEX.get('InstallCleanDistCredentailsDialog.fileSelection.error'));
              }
            });
            return _this4;
          }

          /**
           * @param {JQuery} dom
           * @returns {Promise}
           */
          _inherits(SelectedInstallFilesTable, _Table);
          return _createClass(SelectedInstallFilesTable, [{
            key: "doInitialize",
            value: function doInitialize(dom) {
              var _this5 = this;
              //Double-click on a row will validate the row length and trigger value_ready_event,
              //which will submit dialog that has this table and resolves to JobStepFactory.
              dom.on('dblclick', function () {
                _this5.validate().then(function (result) {
                  return dom.trigger(BaseWidget.VALUE_READY_EVENT, [result]);
                })["catch"](function (ignore) {});
              });
              //When user selects on the row, table will be set to modified,
              //and in turn that calls validate(), which will throw error and disables OK button
              //if more than one row was selected at any point.
              dom.on(Table.ROW_SELECTION_CHANGED_EVENT, function () {
                return _this5.setModified(true);
              });
              return _superPropGet(SelectedInstallFilesTable, "doInitialize", this, 3)(arguments);
            }

            /**
             * @returns {Array.<baja.Component>}
             */
          }, {
            key: "doRead",
            value: function doRead() {
              return this.getSelectedRows().map(function (row) {
                return row.getSubject().fileEntry;
              });
            }
          }]);
        }(Table);
        return SelectedInstallFilesTable;
      }
    }]);
  }(UxJobStepFactory);
});
