function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/baja/SetPropertyMultiTargetEditor
 */

define(['baja!', 'bajaux/spandrel', 'underscore', 'nmodule/webEditors/rc/fe/ValueWithPopoutWidget', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/provisioningNiagara/rc/util/provisioningNiagaraUtils', 'css!nmodule/provisioningNiagara/rc/provisioningNiagara'], function (baja, spandrel, _, ValueWithPopoutWidget, compUtils, provisioningNiagaraUtils) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-SetPropertyMultiTargetEditor'
      }
    };
  };
  var isParentLegal = provisioningNiagaraUtils.isParentLegal,
    getCompatibleValueForSetProperty = provisioningNiagaraUtils.getCompatibleValueForSetProperty;
  var toObject = function toObject(object) {
    return compUtils.toObject(object, {
      copy: true
    });
  };
  var pick = _.pick;

  /**
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/baja/SetPropertyMultiTargetEditor
   * @extends {module:bajaux/spandrel}
   */
  var SetPropertyMultiTargetEditor = /*#__PURE__*/function (_spandrel) {
    function SetPropertyMultiTargetEditor(params) {
      _classCallCheck(this, SetPropertyMultiTargetEditor);
      return _callSuper(this, SetPropertyMultiTargetEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * @private
     * @param {String} deviceName
     * @param {Object} state
     * @returns {Object}
     */
    _inherits(SetPropertyMultiTargetEditor, _spandrel);
    return _createClass(SetPropertyMultiTargetEditor, [{
      key: "$createRow",
      value: function $createRow(deviceName, state) {
        var key = "deviceValues-" + deviceName;
        var value = state[key];
        return spandrel.jsx("tr", {
          className: "ux-table-row"
        }, spandrel.jsx("td", {
          className: "-t-label"
        }, " ", deviceName, " "), spandrel.jsx("td", null, spandrel.jsx(ValueWithPopoutWidget, {
          lax: true,
          bind: true,
          className: "-t-value",
          formFactor: "mini",
          spandrelKey: key,
          value: value
        })));
      }

      /**
       * @param {Object} outerState
       * @returns {Promise.<Object>}
       */
    }, {
      key: "toState",
      value: function toState(outerState) {
        var deviceNames = outerState.deviceNames,
          value = outerState.value,
          propertyType = outerState.propertyType,
          targetValueList = outerState.targetValueList;
        var targetValueListObject = toObject(targetValueList);
        var state = {};
        return isParentLegal('baja:Vector', propertyType).then(function (isParentLegal) {
          var vectorArgs = {};
          deviceNames.forEach(function (deviceName) {
            var key = "deviceValues-" + deviceName;
            var currentValue = targetValueListObject[deviceName];
            if (currentValue === undefined) {
              currentValue = value.newCopy(true);
            } else {
              currentValue = currentValue.newCopy(true);
            }
            currentValue = getCompatibleValueForSetProperty(currentValue, propertyType);
            if (isParentLegal) {
              state[key] = currentValue;
            } else {
              state[key] = baja.$("baja:UnrestrictedFolder", toObject(currentValue));
            }
            vectorArgs[deviceName] = state[key];
          });
          state.targetValueList = baja.$('baja:Vector', vectorArgs);
          state.deviceNames = deviceNames;
          state.value = value;
          state.propertyType = propertyType;
          return state;
        });
      }
    }, {
      key: "fromState",
      value: function fromState(state) {
        var deviceNames = state.deviceNames;
        return isParentLegal('baja:Vector', state.propertyType).then(function (isParentLegal) {
          var vectorArgs = {};
          deviceNames.forEach(function (deviceName) {
            var key = "deviceValues-" + deviceName;
            if (isParentLegal) {
              vectorArgs[deviceName] = state[key].newCopy(true);
            } else {
              vectorArgs[deviceName] = baja.$("baja:UnrestrictedFolder", toObject(state[key]));
            }
          });
          var outerState = pick(state, 'deviceNames', 'value', 'propertyType');
          outerState.targetValueList = baja.$('baja:Vector', vectorArgs);
          return outerState;
        });
      }
    }]);
  }(spandrel(function (unused, state) {
    var self = state.self,
      deviceNames = state.deviceNames;
    return spandrel.jsx("table", {
      className: "-t-SetPropertyMultiTargetEditor-inner ux-table"
    }, deviceNames.map(function (deviceName) {
      return self.$createRow(deviceName, state);
    }));
  }, {
    strategy: 'niagara'
  }));
  return SetPropertyMultiTargetEditor;
});
