function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/baja/SetupReciprocalConnectionStepEditor
 */
define(['baja!', 'baja!provisioningNiagara:SetupReciprocalConnectionStep', 'lex!provisioningNiagara', 'bajaux/spandrel', 'nmodule/webEditors/rc/util/ipAddressUtil'], function (baja, types, lexs, spandrel, ipAddressUtil) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    provisioningNiagaraLex = _lexs[0];
  var isValidHost = ipAddressUtil.isValidHost;

  /**
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/baja/SetupReciprocalConnectionStepEditor
   * @extends module:bajaux/Widget
   * @since Niagara 4.14
   */
  return /*#__PURE__*/function (_spandrel) {
    function SetupReciprocalConnectionStepEditor() {
      var _this;
      _classCallCheck(this, SetupReciprocalConnectionStepEditor);
      _this = _callSuper(this, SetupReciprocalConnectionStepEditor, arguments);
      _this.validators().add(function (step) {
        if (!step.get('username')) {
          throw new Error(fromLex('noUsername'));
        }
        if (!step.get('password').encodeToString()) {
          throw new Error(fromLex('noPassword'));
        }
        var address = step.get('address');
        if (!address.isNull() && !isValidHost(toHostBody(address))) {
          throw new Error(fromLex('invalidAddress'));
        }
      });
      return _this;
    }

    /**
     * @param {baja.Component} step a `provisioningNiagara:SetupReciprocalConnectionStep` to edit
     * @returns {{password: baja.Password, address: string, username: string}}
     */
    _inherits(SetupReciprocalConnectionStepEditor, _spandrel);
    return _createClass(SetupReciprocalConnectionStepEditor, [{
      key: "toState",
      value: function toState(step) {
        var _step$getSlots$toValu = step.getSlots().toValueMap(),
          username = _step$getSlots$toValu.username,
          password = _step$getSlots$toValu.password,
          address = _step$getSlots$toValu.address;
        return {
          username: username,
          password: password,
          address: toHostBody(address)
        };
      }

      /**
       * @param {object} state
       * @param {string} state.username
       * @param {baja.Password} state.password
       * @param {string} state.address
       * @returns {baja.Component} a new `SetupReciprocalConnectionStep` with the entered values
       */
    }, {
      key: "fromState",
      value: function fromState(_ref) {
        var username = _ref.username,
          password = _ref.password,
          address = _ref.address;
        return baja.$('provisioningNiagara:SetupReciprocalConnectionStep', {
          factoryType: baja.$('baja:TypeSpec', 'provisioningNiagara:SetupReciprocalConnectionStepFactory'),
          username: username,
          password: password,
          address: address ? baja.Ord.make('ip:' + address) : baja.Ord.DEFAULT
        });
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getUsernameEditor",
      value: function $getUsernameEditor() {
        return this.queryWidget('**/username');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getPasswordEditor",
      value: function $getPasswordEditor() {
        return this.queryWidget('**/password');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getAddressEditor",
      value: function $getAddressEditor() {
        return this.queryWidget('**/address');
      }
    }]);
  }(spandrel(function (step, _ref2) {
    var username = _ref2.username,
      password = _ref2.password,
      address = _ref2.address;
    return spandrel.jsx("table", null, spandrel.jsx("tr", null, spandrel.jsx("td", null, spandrel.jsx("label", null, fromLex('username'))), spandrel.jsx("td", null, spandrel.jsx("any", {
      bind: true,
      spandrelKey: "username",
      value: username
    })), spandrel.jsx("td", null, '(' + fromLex('required') + ')')), spandrel.jsx("tr", null, spandrel.jsx("td", null, spandrel.jsx("label", null, fromLex('password'))), spandrel.jsx("td", null, spandrel.jsx("any", {
      bind: true,
      spandrelKey: "password",
      value: password
    })), spandrel.jsx("td", null, '(' + fromLex('required') + ')')), spandrel.jsx("tr", null, spandrel.jsx("td", null, spandrel.jsx("label", null, fromLex('address'))), spandrel.jsx("td", null, spandrel.jsx("any", {
      bind: true,
      spandrelKey: "address",
      value: address
    })), spandrel.jsx("td", null)));
  }));
  function toHostBody(ord) {
    return ord.isNull() ? '' : ord.parse().get('ip').getBody();
  }
  function fromLex(suffix) {
    return provisioningNiagaraLex.get('SetupReciprocalConnectionStepDialog.' + suffix);
  }
});
