function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Sai Komaravolu
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/baja/SignCertEditor
 */

define(['baja!', 'baja!baja:CertificateAliasAndPassword,provisioningNiagara:SignCertJobStep', 'lex!provisioningNiagara,platCrypto', 'Promise', 'bajaux/Widget', 'bajaux/spandrel', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'css!nmodule/provisioningNiagara/rc/provisioningNiagara'], function (baja, types, lexs, Promise, Widget, spandrel, OrderedMapEditor) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 2),
    provisioningNiagaraLex = _lexs[0],
    platCryptoLex = _lexs[1],
    widgetDefaults = function widgetDefaults() {
      return {
        properties: {
          rootCssClass: '-t-SignCertEditor'
        }
      };
    },
    GENERATE_NEW = platCryptoLex.get('CertAlias.generateNew');

  /**
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/baja/SignCertEditor
   * @extends {module:bajaux/spandrel}
   */
  var SignCertEditor = /*#__PURE__*/function (_spandrel) {
    function SignCertEditor(params) {
      var _this;
      _classCallCheck(this, SignCertEditor);
      _this = _callSuper(this, SignCertEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$passwordStrength = _this.properties().getValue('passwordStrength');
      _this.$caCertificateArray = _this.properties().getValue('caCertificateArray');
      _this.validators().add(function () {
        return _this.$validateEditor();
      });
      return _this;
    }

    /**
     * @param {baja.Component} step
     * @returns {{serverCertAlias: string, caCertAlias: string, caPassword: {module:baja/obj/Password}, notBefore: baja.AbsTime, notAfter: baja.AbsTime}}
     */
    _inherits(SignCertEditor, _spandrel);
    return _createClass(SignCertEditor, [{
      key: "toState",
      value: function toState(step) {
        var _step$getSlots$toValu = step.getSlots().toValueMap(),
          caCertAlias = _step$getSlots$toValu.caCertAlias,
          caPassword = _step$getSlots$toValu.caPassword,
          notBefore = _step$getSlots$toValu.notBefore,
          notAfter = _step$getSlots$toValu.notAfter,
          serverCertAlias = _step$getSlots$toValu.serverCertAlias,
          serverCertAliasAndPassword = _step$getSlots$toValu.serverCertAliasAndPassword;
        caCertAlias = caCertAlias && caCertAlias.length ? caCertAlias : GENERATE_NEW;
        return {
          serverCertAlias: serverCertAlias,
          serverCertPassword: serverCertAliasAndPassword.getPassword(),
          useGlobalPassword: false,
          caCertAlias: caCertAlias,
          caPassword: caPassword,
          notBefore: notBefore,
          notAfter: notAfter
        };
      }

      /**
       * @param {string} serverCertAlias
       * @param {string} caCertAlias
       * @param {module:baja/obj/Password} serverCertPassword
       * @param {boolean} useGlobalPassword
       * @param {module:baja/obj/Password} caPassword
       * @param {baja.AbsTime} notBefore
       * @param {baja.AbsTime} notAfter
       * @returns {baja.Component}
       */
    }, {
      key: "fromState",
      value: function fromState(_ref) {
        var serverCertAlias = _ref.serverCertAlias,
          serverCertPassword = _ref.serverCertPassword,
          useGlobalPassword = _ref.useGlobalPassword,
          caCertAlias = _ref.caCertAlias,
          caPassword = _ref.caPassword,
          notBefore = _ref.notBefore,
          notAfter = _ref.notAfter;
        if (useGlobalPassword) {
          serverCertPassword = baja.$('baja:Password');
        }
        var serverCertAliasAndPassword = baja.$('baja:CertificateAliasAndPassword', {
          password: serverCertPassword,
          alias: serverCertAlias
        });
        return baja.$('provisioningNiagara:SignCertJobStep', {
          serverCertAlias: serverCertAlias,
          serverCertAliasAndPassword: serverCertAliasAndPassword,
          caCertAlias: caCertAlias,
          caPassword: caPassword,
          notBefore: notBefore,
          notAfter: notAfter
        });
      }

      /**
       * @private
       * @returns {Widget}
       */
    }, {
      key: "$getServerCertAliasEditor",
      value: function $getServerCertAliasEditor() {
        return this.queryWidget('**/serverCertAlias');
      }

      /**
       * @private
       * @returns {Widget}
       */
    }, {
      key: "$getCaAliasEditor",
      value: function $getCaAliasEditor() {
        return this.queryWidget('**/caCertAlias');
      }

      /**
       * @private
       * @returns {Widget}
       */
    }, {
      key: "$getCaPasswordEditor",
      value: function $getCaPasswordEditor() {
        return this.queryWidget('**/caPassword');
      }

      /**
       * @private
       * @returns {Widget}
       */
    }, {
      key: "$getNotBeforeEditor",
      value: function $getNotBeforeEditor() {
        return this.queryWidget('**/notBefore');
      }

      /**
       * @private
       * @returns {Widget}
       */
    }, {
      key: "$getNotAfterEditor",
      value: function $getNotAfterEditor() {
        return this.queryWidget('**/notAfter');
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$validateEditor",
      value: function $validateEditor() {
        return Promise.all([this.$validatePassword(), this.$validateServerCertAlias()]);
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$validateServerCertAlias",
      value: function $validateServerCertAlias() {
        var serverCertAlias = this.state().serverCertAlias;
        if (!serverCertAlias) {
          return Promise.reject(new Error(provisioningNiagaraLex.get('SignCertDialog.missingValues')));
        }
        return Promise.resolve();
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$validatePassword",
      value: function $validatePassword() {
        var _this2 = this;
        var _this$state = this.state(),
          caPassword = _this$state.caPassword,
          caCertAlias = _this$state.caCertAlias,
          serverCertPassword = _this$state.serverCertPassword,
          useGlobalPassword = _this$state.useGlobalPassword,
          passwordArray = [caPassword];
        if (caCertAlias === GENERATE_NEW) {
          return Promise.resolve();
        }
        if (!useGlobalPassword && serverCertPassword.encodeToString().length) {
          passwordArray.push(serverCertPassword);
        }
        return Promise.all(passwordArray.map(function (password) {
          return _this2.$passwordStrength.validatePassword(password.encodeToString());
        }));
      }
    }]);
  }(spandrel(function (comp, _ref2) {
    var self = _ref2.self,
      serverCertAlias = _ref2.serverCertAlias,
      serverCertPassword = _ref2.serverCertPassword,
      useGlobalPassword = _ref2.useGlobalPassword,
      caCertAlias = _ref2.caCertAlias,
      caPassword = _ref2.caPassword,
      notBefore = _ref2.notBefore,
      notAfter = _ref2.notAfter;
    var serverCertAliasText = provisioningNiagaraLex.get('SignCertDialog.serverAlias'),
      serverCertPasswordText = provisioningNiagaraLex.get('SignCertEditor.serverCertificatePassword.label'),
      useGlobalPasswordText = provisioningNiagaraLex.get('SignCertEditor.useGlobalPassword.label'),
      caCertAliasText = provisioningNiagaraLex.get('SignCertDialog.caAlias'),
      caCertPasswordText = provisioningNiagaraLex.get('SignCertDialog.caPasswordEditor'),
      notBeforeText = provisioningNiagaraLex.get('SignCertDialog.notBefore'),
      notAfterText = provisioningNiagaraLex.get('SignCertDialog.notAfter'),
      enabled = caCertAlias !== GENERATE_NEW;
    return spandrel.jsx("table", null, spandrel.jsx("tbody", null, spandrel.jsx("tr", null, spandrel.jsx("td", null, spandrel.jsx("span", {
      className: "-t-serverCertificateAliasLabel"
    }, serverCertAliasText)), spandrel.jsx("td", null, spandrel.jsx("any", {
      spandrelKey: "serverCertAlias",
      bind: true,
      value: serverCertAlias
    }))), spandrel.jsx("tr", null, spandrel.jsx("td", null, spandrel.jsx("span", {
      className: "-t-serverCertificatePasswordLabel"
    }, serverCertPasswordText)), spandrel.jsx("td", null, spandrel.jsx("any", {
      spandrelKey: "serverCertPassword",
      bind: true,
      value: serverCertPassword,
      enabled: !useGlobalPassword
    }))), spandrel.jsx("tr", null, spandrel.jsx("td", null, spandrel.jsx("span", {
      className: "-t-useGlobalPasswordLabel"
    }, useGlobalPasswordText)), spandrel.jsx("td", null, spandrel.jsx("any", {
      spandrelKey: "useGlobalPassword",
      bind: true,
      value: useGlobalPassword
    }))), spandrel.jsx("tr", null, spandrel.jsx("td", null, spandrel.jsx("span", {
      className: "-t-caCertificateAliasLabel"
    }, caCertAliasText)), spandrel.jsx("td", null, spandrel.jsx(OrderedMapEditor, {
      spandrelKey: "caCertAlias",
      bind: true,
      value: caCertAlias,
      properties: {
        map: self.$caCertificateArray
      }
    }))), spandrel.jsx("tr", null, spandrel.jsx("td", null, spandrel.jsx("span", {
      className: "-t-caCertificatePasswordLabel"
    }, caCertPasswordText)), spandrel.jsx("td", null, spandrel.jsx("any", {
      spandrelKey: "caPassword",
      bind: true,
      lax: true,
      value: caPassword,
      enabled: enabled
    }))), spandrel.jsx("tr", null, spandrel.jsx("td", null, spandrel.jsx("span", {
      className: "-t-notBeforeLabel"
    }, notBeforeText)), spandrel.jsx("td", null, spandrel.jsx("any", {
      spandrelKey: "notBefore",
      bind: true,
      value: notBefore,
      enabled: enabled
    }))), spandrel.jsx("tr", null, spandrel.jsx("td", null, spandrel.jsx("span", {
      className: "-t-notAfterLabel"
    }, notAfterText)), spandrel.jsx("td", null, spandrel.jsx("any", {
      spandrelKey: "notAfter",
      bind: true,
      value: notAfter,
      enabled: enabled
    })))));
  }, {
    strategy: 'niagara'
  }));
  return SignCertEditor;
});
