function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/wb/fe/SetUserPasswordEditor
 */

define(["baja!", 'baja!baja:Password', 'lex!provisioningNiagara', 'Promise', 'underscore', 'bajaux/spandrel', 'nmodule/provisioningNiagara/rc/util/provisioningNiagaraUtils', 'nmodule/webEditors/rc/baja/PasswordStrength', 'nmodule/webEditors/rc/fe/baja/ConfirmPasswordEditor'], function (baja, types, lexs, Promise, _, spandrel, provisioningNiagaraUtils, PasswordStrength, ConfirmPasswordEditor) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    provisioningNiagaraLex = _lexs[0];
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: "-t-SetUserPasswordEditor"
      }
    };
  };
  var validatePasswordStrength = provisioningNiagaraUtils.validatePasswordStrength;
  /**
   * Sets the user password for either a station or platform depending on the mode
   *
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/wb/fe/SetUserPasswordEditor
   * @extends module:bajaux/Widget
   * @since Niagara 4.14
  */
  var SetUserPasswordEditor = /*#__PURE__*/function (_spandrel) {
    /**
     * Constructor for the editor
     * @param {Object} params parameters sent to the edit to initialize it
     * @param {Object} params.properties.[mode] the mode that the editor functions in, either 'station',
     * 'platformCredentials', 'platformUser', or 'default'.  The 'station' mode shows an additional checkbox that
     * allows you to use the connection user when setting the station user and password.  All other
     * hide that field.  The 'station', 'platformUser' and 'default' both show a current password
     * field and the 'platformCredentials' hides that field.
     */
    function SetUserPasswordEditor(params) {
      var _this;
      _classCallCheck(this, SetUserPasswordEditor);
      _this = _callSuper(this, SetUserPasswordEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.validators().add(function () {
        return _this.$validateEditor();
      });
      return _this;
    }
    _inherits(SetUserPasswordEditor, _spandrel);
    return _createClass(SetUserPasswordEditor, [{
      key: "$buildEditor",
      value: function $buildEditor(state) {
        var username = state.username,
          usernameLabel = state.usernameLabel,
          useConnectionUsername = state.useConnectionUsername,
          useConnectionUsernameLabel = state.useConnectionUsernameLabel,
          hideUseConnectionUsername = state.hideUseConnectionUsername,
          currentPassword = state.currentPassword,
          currentPasswordLabel = state.currentPasswordLabel,
          newPassword = state.newPassword,
          hideCurrentPassword = state.hideCurrentPassword,
          hostLicensedForFips = state.hostLicensedForFips,
          hostFipsLabel = state.hostFipsLabel,
          hideHostLicensedFips = state.hideHostLicensedFips,
          passwordText = state.passwordText,
          confirmPasswordText = state.confirmPasswordText,
          topTitleText = state.topTitleText;
        return [spandrel.jsx("div", {
          className: "-t-SetUserPasswordEditor-layout",
          spandrelKey: "setUserPasswordEditor-layout"
        }, spandrel.jsx("div", {
          className: "-t-SetUserPasswordEditor-topText",
          spandrelKey: "topTitleText"
        }, topTitleText), spandrel.jsx("div", {
          className: "-t-SetUserPasswordEditor-useConnectionUsernameRow",
          style: {
            display: hideUseConnectionUsername && 'none'
          },
          spandrelKey: "useConnectionUsernameRow"
        }, spandrel.jsx("span", {
          className: "-t-SetUserPasswordEditor-boolean-label",
          spandrelKey: "useConnectionUsernameLabel"
        }, useConnectionUsernameLabel), spandrel.jsx("any", {
          className: "-t-SetUserPasswordEditor-useConnectionUsername",
          bindKey: "useConnectionUsername",
          value: useConnectionUsername,
          spandrelKey: "useConnectionUsername"
        })), spandrel.jsx("div", {
          className: "-t-SetUserPasswordEditor-usernameRow"
        }, spandrel.jsx("span", {
          className: "-t-SetUserPasswordEditor-label",
          spandrelKey: "usernameLabel"
        }, usernameLabel), spandrel.jsx("any", {
          className: "-t-SetUserPasswordEditor-username",
          bindKey: "username",
          value: useConnectionUsername ? "" : username,
          spandrelKey: "username",
          enabled: !useConnectionUsername
        })), spandrel.jsx("div", {
          className: "-t-SetUserPasswordEditor-currentPasswordRow",
          style: {
            display: hideCurrentPassword && 'none'
          },
          spandrelKey: "currentPasswordRow"
        }, spandrel.jsx("span", {
          className: "-t-SetUserPasswordEditor-label",
          spandrelKey: "currentPasswordLabel"
        }, currentPasswordLabel), spandrel.jsx("any", {
          className: "-t-SetUserPasswordEditor-currentPassword",
          bindKey: "currentPassword",
          value: currentPassword,
          spandrelKey: "currentPassword"
        })), spandrel.jsx("div", null, spandrel.jsx(ConfirmPasswordEditor, {
          className: "-t-SetUserPasswordEditor-confirmPassword -t-confirmPasswordEditor",
          bindKey: "newPassword",
          lax: "true",
          spandrelKey: "confirmPassword",
          value: newPassword,
          properties: {
            passwordText: passwordText,
            confirmPasswordText: confirmPasswordText
          }
        })), spandrel.jsx("div", {
          className: "-t-SetUserPasswordEditor-hostLicensedForFipsRow",
          style: {
            display: hideHostLicensedFips && 'none'
          },
          spandrelKey: "hostLicensedForFipsRow"
        }, spandrel.jsx("span", {
          className: "-t-SetUserPasswordEditor-boolean-label",
          spandrelKey: "hostLicensedForFipsLabel"
        }, hostFipsLabel), spandrel.jsx("any", {
          className: "-t-SetUserPasswordEditor-hostLicensedForFips",
          bindKey: "hostLicensedForFips",
          value: hostLicensedForFips,
          spandrelKey: "hostLicensedForFips"
        })))];
      }

      /**
       * Writes the values passed into the state
       * @param {Object} value the values from the step passwed into this editor
       * @returns {Object} the current state value
       */
    }, {
      key: "toState",
      value: function toState(value) {
        var mode = this.properties().getValue("mode");
        var useConnectionUsername = !value.username && mode === 'station';
        var username = value.username;
        var currentPassword = value.currentPassword || baja.$('baja:Password');
        var newPassword = value.newPassword || baja.$('baja:Password');
        var hostLicensedForFips = value.hostLicensedForFips || false;
        var useConnectionUsernameLabel = provisioningNiagaraLex.get('SetStationUserPasswordStepDialog.useConnectionUsername');
        var hostFipsLabel = provisioningNiagaraLex.get('SetSystemPassphraseStepDialog.label.fipsMode');
        var usernameLabel;
        var currentPasswordLabel;
        var passwordText;
        var confirmPasswordText;
        var noUserNameErr;
        var topTitleText;
        var hideCurrentPassword = false;
        var hideUseConnectionUsername = true;
        var hideHostLicensedFips = false;
        switch (mode) {
          case 'station':
            usernameLabel = provisioningNiagaraLex.get("SetStationUserPasswordStepDialog.username");
            currentPasswordLabel = provisioningNiagaraLex.get("SetStationUserPasswordStepDialog.current");
            passwordText = provisioningNiagaraLex.get('SetStationUserPasswordStepDialog.new');
            confirmPasswordText = provisioningNiagaraLex.get('SetStationUserPasswordStepDialog.confirm');
            noUserNameErr = provisioningNiagaraLex.get("SetStationUserPasswordStepDialog.usernameRequired");
            hideHostLicensedFips = true;
            hideUseConnectionUsername = false;
            break;
          case 'platformCredentials':
            usernameLabel = provisioningNiagaraLex.get("SetPlatformCredentialsStepDialog.newUsername");
            currentPasswordLabel = "";
            passwordText = provisioningNiagaraLex.get('SetPlatformCredentialsStepDialog.newPassword');
            confirmPasswordText = provisioningNiagaraLex.get('SetPlatformCredentialsStepDialog.newConfirm');
            noUserNameErr = provisioningNiagaraLex.get("SetPlatformCredentialsStepDialog.noUserName");
            topTitleText = provisioningNiagaraLex.get("SetPlatformCredentialsStepDialog.topText");
            hideCurrentPassword = true;
            break;
          case 'platformUser':
            usernameLabel = provisioningNiagaraLex.get("SetPlatformUserPasswordStepDialog.currentUsername");
            currentPasswordLabel = provisioningNiagaraLex.get("SetPlatformUserPasswordStepDialog.currentPassword");
            passwordText = provisioningNiagaraLex.get('SetPlatformUserPasswordStepDialog.newPassword');
            confirmPasswordText = provisioningNiagaraLex.get('SetPlatformUserPasswordStepDialog.newConfirm');
            noUserNameErr = provisioningNiagaraLex.get("SetPlatformUserPasswordStepDialog.noUserName");
            topTitleText = provisioningNiagaraLex.get("SetPlatformUserPasswordStepDialog.topText");
            break;
          default:
            usernameLabel = provisioningNiagaraLex.get("SetStationUserPasswordStepDialog.username");
            currentPasswordLabel = provisioningNiagaraLex.get("SetStationUserPasswordStepDialog.current");
            passwordText = provisioningNiagaraLex.get('SetStationUserPasswordStepDialog.new');
            confirmPasswordText = provisioningNiagaraLex.get('SetStationUserPasswordStepDialog.confirm');
            noUserNameErr = provisioningNiagaraLex.get("SetStationUserPasswordStepDialog.usernameRequired");
            hideUseConnectionUsername = false;
            break;
        }
        return {
          username: username,
          usernameLabel: usernameLabel,
          noUserNameErr: noUserNameErr,
          useConnectionUsername: useConnectionUsername,
          useConnectionUsernameLabel: useConnectionUsernameLabel,
          hideUseConnectionUsername: hideUseConnectionUsername,
          currentPassword: currentPassword,
          currentPasswordLabel: currentPasswordLabel,
          newPassword: newPassword,
          hideCurrentPassword: hideCurrentPassword,
          hostLicensedForFips: hostLicensedForFips,
          hostFipsLabel: hostFipsLabel,
          hideHostLicensedFips: hideHostLicensedFips,
          passwordText: passwordText,
          confirmPasswordText: confirmPasswordText,
          topTitleText: topTitleText
        };
      }

      /**
       * take the state and returns it in the expected format
       * @param {Object} state the current state of the editor
       * @returns {Object} the expected output value of the editor
       */
    }, {
      key: "fromState",
      value: function fromState(state) {
        var outValue = {};
        outValue.username = state.useConnectionUsername ? "" : state.username;
        outValue.currentPassword = state.currentPassword;
        outValue.newPassword = state.newPassword;
        outValue.useConnectionUsername = state.useConnectionUsername;
        outValue.hostLicensedForFips = state.hostLicensedForFips;
        return outValue;
      }

      /**
       * @private
       * @returns {Promise} promise to be resolved if password is valid.
       * If rejected, it will be rejected with an array of error strings describing
       * the `PasswordStrength` configuration. Join the array, map to divs,
       * whatever your app needs.
       */
    }, {
      key: "$validateEditor",
      value: function $validateEditor() {
        var _this2 = this;
        var _this$state = this.state(),
          username = _this$state.username,
          noUserNameErr = _this$state.noUserNameErr,
          useConnectionUsername = _this$state.useConnectionUsername,
          hostLicensedForFips = _this$state.hostLicensedForFips,
          newPassword = _this$state.newPassword;
        if (!useConnectionUsername && !username) {
          throw new Error(noUserNameErr);
        }
        return validatePasswordStrength(newPassword, hostLicensedForFips).then(function () {
          return _this2.$getConfirmPassword().validate();
        });
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getUseConnectionUsernameRow",
      value: function $getUseConnectionUsernameRow() {
        return this.queryWidget('setUserPasswordEditor-layout/**/useConnectionUsernameRow');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getTopText",
      value: function $getTopText() {
        return this.queryWidget('setUserPasswordEditor-layout/**/topTitleText');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getCurrentPasswordRow",
      value: function $getCurrentPasswordRow() {
        return this.queryWidget('setUserPasswordEditor-layout/**/currentPasswordRow');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getUseConnectionUsernameLabel",
      value: function $getUseConnectionUsernameLabel() {
        return this.queryWidget('setUserPasswordEditor-layout/**/useConnectionUsernameLabel');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getUseConnectionUsername",
      value: function $getUseConnectionUsername() {
        return this.queryWidget('setUserPasswordEditor-layout/**/useConnectionUsername');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getUsername",
      value: function $getUsername() {
        return this.queryWidget('setUserPasswordEditor-layout/**/username');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getCurrentPassword",
      value: function $getCurrentPassword() {
        return this.queryWidget('setUserPasswordEditor-layout/**/currentPassword');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getConfirmPassword",
      value: function $getConfirmPassword() {
        return this.queryWidget('setUserPasswordEditor-layout/**/confirmPassword');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getUsernameLabel",
      value: function $getUsernameLabel() {
        return this.queryWidget('setUserPasswordEditor-layout/**/usernameLabel');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getCurrentPasswordLabel",
      value: function $getCurrentPasswordLabel() {
        return this.queryWidget('setUserPasswordEditor-layout/**/currentPasswordLabel');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getHostLicensedForFips",
      value: function $getHostLicensedForFips() {
        return this.queryWidget('setUserPasswordEditor-layout/**/hostLicensedForFips');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getHostLicensedForFipsRow",
      value: function $getHostLicensedForFipsRow() {
        return this.queryWidget('setUserPasswordEditor-layout/**/hostLicensedForFipsRow');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getHostLicensedForFipsLabel",
      value: function $getHostLicensedForFipsLabel() {
        return this.queryWidget('setUserPasswordEditor-layout/**/hostLicensedForFipsLabel');
      }
    }]);
  }(spandrel(function (value, state) {
    var self = state.self;
    return self.$buildEditor(state);
  }, {
    strategy: 'niagara'
  }));
  return SetUserPasswordEditor;
});
