function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/* eslint-env browser */
/*global niagara */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/wb/jobBuilder/NiagaraNetworkUxPrototypeView
 * @since Niagara 4.14
 */

define(['baja!', 'dialogs', 'Promise', 'bajaux/mixin/subscriberMixIn', 'bajaux/util/SaveCommand', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/provisioningNiagara/rc/wb/jobBuilder/NiagaraNetworkJobEditor', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber'], function (baja, dialogs, Promise, subscriberMixIn, SaveCommand, asyncUtils, NiagaraNetworkJobEditor, DepthSubscriber) {
  'use strict';

  var waitInterval = asyncUtils.waitInterval;
  /*
  please don't look at this and think inserting an arbitrary delay is a good practice.
  it's not.
  see the corresponding magic number in BNiagaraNetworkPrototypeView.
  i don't have the necessary context to go back and change how this works so 2sec delay it is.
   */
  var SCREEN_HYPERLINK_DELAY = 2000;
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-NiagaraNetworkUxPrototypeView'
      }
    };
  };

  /**
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/wb/jobBuilder/NiagaraNetworkUxPrototypeView
   * @extends {module:nmodule/provisioningNiagara/rc/wb/jobBuilder/NiagaraNetworkJobEditor}
   */
  return /*#__PURE__*/function (_NiagaraNetworkJobEdi) {
    function NiagaraNetworkUxPrototypeView(params) {
      var _this;
      _classCallCheck(this, NiagaraNetworkUxPrototypeView);
      _this = _callSuper(this, NiagaraNetworkUxPrototypeView, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$subscriber = new DepthSubscriber(Number.MAX_VALUE);
      subscriberMixIn(_this);
      _this.getCommandGroup().add(new SaveCommand());
      return _this;
    }

    /**
     * @param {baja.Component} prototypeComp the `provisioningNiagara:NiagaraNetworkJobPrototype` being loaded
     * @returns {Promise.<object>}
     */
    _inherits(NiagaraNetworkUxPrototypeView, _NiagaraNetworkJobEdi);
    return _createClass(NiagaraNetworkUxPrototypeView, [{
      key: "toState",
      value: function toState(prototypeComp) {
        var job = prototypeComp.get('jobPrototype'),
          nwOrd = job.get('networkOrd');
        return Promise.all([this.$loadJobSteps(job), this.$getDevicesToProcess(job), nwOrd.get({
          subscriber: this.$deviceContainerSubscriber
        })]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 3),
            steps = _ref2[0],
            stations = _ref2[1],
            deviceContainer = _ref2[2];
          return {
            alertOnStepFailure: job.get('alertOnStepFailure'),
            alertOnJobSuccess: job.get('alertOnJobSuccess'),
            steps: steps,
            stations: stations,
            deviceContainer: deviceContainer
          };
        });
      }

      /**
       * @returns {Promise}
       */
    }, {
      key: "doSave",
      value: function doSave() {
        return this.$saveJob(this.value().get('jobPrototype'));
      }

      /**
       * <ol>
       *  <li>Save the current state of the job prototype.</li>
       *  <li>Create a new job instance from the prototype.</li>
       *  <li>Submit the new job to the job service.</li>
       *  <li>Navigate to the newly submitted job to check its status.</li>
       * </ol> 
       * @returns {Promise}
       */
    }, {
      key: "doRunNow",
      value: function doRunNow() {
        var _this2 = this;
        return this.save().then(function () {
          return _this2.value().invoke({
            slot: 'submitJob'
          });
        }).then(function (jobOrd) {
          var hyperlinkOrd = baja.Ord.make({
            base: 'station:',
            child: jobOrd
          }).normalize();
          var prom = waitInterval(SCREEN_HYPERLINK_DELAY).then(function () {
            return niagara.env.hyperlink(hyperlinkOrd);
          });
          dialogs.showLoading(500, prom);
          return prom;
        });
      }

      /**
       * @private
       * @param {baja.Component} job
       * @returns {Promise.<Array.<object>>} job
       */
    }, {
      key: "$getDevicesToProcess",
      value: function $getDevicesToProcess(job) {
        return baja.rpc({
          typeSpec: "provisioningNiagara:ProvisioningNiagaraRpcUtil",
          method: "getDevices",
          args: [String(job.getNavOrd())]
        }).then(function (devices) {
          return Promise.all(devices.map(function (_ref3) {
            var deviceId = _ref3.deviceId,
              iconEnc = _ref3.iconEnc,
              navOrdStr = _ref3.navOrdStr;
            return {
              displayName: deviceId,
              icon: baja.Icon.DEFAULT.decodeFromString(iconEnc),
              value: {
                navOrdStr: navOrdStr,
                deviceId: deviceId
              }
            };
          }));
        });
      }
    }]);
  }(NiagaraNetworkJobEditor);
});
