function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _wrapNativeSuper(t) { var r = "function" == typeof Map ? new Map() : void 0; return _wrapNativeSuper = function _wrapNativeSuper(t) { if (null === t || !_isNativeFunction(t)) return t; if ("function" != typeof t) throw new TypeError("Super expression must either be null or a function"); if (void 0 !== r) { if (r.has(t)) return r.get(t); r.set(t, Wrapper); } function Wrapper() { return _construct(t, arguments, _getPrototypeOf(this).constructor); } return Wrapper.prototype = Object.create(t.prototype, { constructor: { value: Wrapper, enumerable: !1, writable: !0, configurable: !0 } }), _setPrototypeOf(Wrapper, t); }, _wrapNativeSuper(t); }
function _construct(t, e, r) { if (_isNativeReflectConstruct()) return Reflect.construct.apply(null, arguments); var o = [null]; o.push.apply(o, e); var p = new (t.bind.apply(t, o))(); return r && _setPrototypeOf(p, r.prototype), p; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _isNativeFunction(t) { try { return -1 !== Function.toString.call(t).indexOf("[native code]"); } catch (n) { return "function" == typeof t; } }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Developer**
 * @module nmodule/js/rc/errors/LocalizableError
 */

define(['baja!', 'lex!', 'underscore', 'Promise'], function (baja, lex, _, Promise) {
  'use strict';

  /**
   * Makes sure the params are an array and also escapes them correctly if they are a string
   * @param {Array.<*>|*} params the parameters that need to be processed
   * @returns {String} the parameters as a String with each entry escaped and separted by a ":"
   */
  function convertParams(params) {
    params = Array.isArray(params) ? params : [params];
    return params.map(function (param) {
      return _.isString(param) ? baja.SlotPath.escape(param) : param;
    }).join(':');
  }

  /**
   * Provides a simple means of throwing, or rejecting with, an Error that is intended to be
   * displayed to the user.
   *
   * (Previously, in order to both throw an error and display an error dialog to the user, you
   * would have to do it in two steps: display the error dialog with `feDialogs.error` or similar,
   * and then throw the actual error so the Promise itself would reject.)
   *
   * To use `LocalizableError`, simply create and throw an instance of it. Many places in the
   * framework are capable of handling `LocalizableError` and displaying it to the user:
   *
   * - The `log!` plugin
   * - `baja.error()`
   * - `feDialogs.error()`
   * - And transitively, any functionality in the UI that is configured to log/display Errors
   *   through these APIs, including:
   *   - `Command` instances that are invoked through `CommandButtons` (via the HTML5 Hx Profile,
   *    Manager views, etc.)
   *   - Hyperlinking between views
   *
   * It follows that if you display the error yourself, and _also_ throw it:
   *
   * ```
   * this.validators().add((value) => {
   *   if (value > max) {
   *     const err = new LocalizableError('%lexicon(myModule:valueTooBig)%');
   *     return feDialogs.error(err)
   *       .then(() => { throw err; });
   *   }
   * });
   * ```
   *
   * the framework will not know that you already displayed the error, and will display it a second
   * time. `LocalizableError` is intended to simply be thrown by your code, not displayed _and_
   * thrown.
   *
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/js/rc/errors/LocalizableError
   * @extends Error
   */
  var LocalizableError = /*#__PURE__*/function (_Error) {
    /**
     * Creates a LocalizableError
     * @param {String|Object} params either an error message as a string or an object that contains
     * the values for a formatted error
     * @param {String} [params.module] the module name to use for looking up the lexicon entries
     * @param {String} [params.lex] the lexicon key to look up the error message components
     * @param {String} [params.title] the title for the error.  If both lexicon information and title
     * is supplied the title overrides any title found in the lexicon. This can be in the format of
     * a Lexicon format. For instance, `%lexicon(moduleName:keyName)%`.
     * @param {Array<*>} [params.titleArgs] an array of value to be passed to the 'lex.format' command
     * to complete the title.  Only works with module and lex.
     * @param {String} [params.summaryMessage] the summaryMessage for the error that is prepended to
     * the error message.  If both lexicon information and summaryMessage is supplied the summaryMessage
     * overrides any summaryMessage found in the lexicon This can be in the format of * a Lexicon
     * format. For instance, `%lexicon(moduleName:keyName)%`.
     * @param {Array<*>} [params.summaryArgs] an array of value to be passed to the 'lex.format'
     * command to complete the summary message.  Only works with module and lex.
     * @param {String} [params.message] the error message for the error.  If both lexicon
     * information and message is supplied the message overrides any message found in the lexicon
     * This can be in the format of a Lexicon format. For instance, `%lexicon(moduleName:keyName)%`.
     * @param {Array<*>} [params.messageArgs] an array of value to be passed to the 'lex.format' command
     * to complete the message.  Only works with module and lex.
     */
    function LocalizableError() {
      var _this;
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      _classCallCheck(this, LocalizableError);
      var module = params.module,
        lex = params.lex,
        title = params.title,
        titleArgs = params.titleArgs,
        summaryMessage = params.summaryMessage,
        summaryArgs = params.summaryArgs,
        message = params.message,
        messageArgs = params.messageArgs;
      if (!(params instanceof Object)) {
        message = params;
      }
      if (module && lex) {
        if (!title) {
          title = '%lexicon(' + module + ':' + lex + '.title';
          if (titleArgs) {
            title = title + ':' + convertParams(titleArgs);
          }
          title = title + ')%';
        }
        if (!summaryMessage) {
          summaryMessage = '%lexicon(' + module + ':' + lex + '.summaryMessage';
          if (summaryArgs) {
            summaryMessage = summaryMessage + ':' + convertParams(summaryArgs);
          }
          summaryMessage = summaryMessage + ')%';
        }
        if (!message) {
          message = '%lexicon(' + module + ':' + lex + '.message';
          if (messageArgs) {
            message = message + ':' + convertParams(messageArgs);
          }
          message = message + ')%';
        }
      }
      _this = _callSuper(this, LocalizableError, [message]);
      _this.name = "LocalizableError";
      _this.$title = title;
      _this.$summaryMessage = summaryMessage;
      return _this;
    }

    /**
     * Resolves the title for the error
     * @returns {Promise.<String>}
     */
    _inherits(LocalizableError, _Error);
    return _createClass(LocalizableError, [{
      key: "toTitle",
      value: function toTitle() {
        return this.$doFormat(this.$title);
      }

      /**
       * Resolves the message summary for the error
       * @returns {Promise.<String>}
       */
    }, {
      key: "toSummaryMessage",
      value: function toSummaryMessage() {
        return this.$doFormat(this.$summaryMessage);
      }

      /**
       * Resolves the message for the error
       * @returns {Promise.<String>}
       */
    }, {
      key: "toMessage",
      value: function toMessage() {
        return this.$doFormat(this.message);
      }

      /**
       * Resolves to a formatted string that holds the error stack
       * @returns {Promise.<string>}
       */
    }, {
      key: "toStack",
      value: function toStack() {
        var _this2 = this;
        var stack = this.stack;
        if (stack && typeof stack === 'string') {
          return Promise.all([this.toSummaryMessage(), this.toMessage()]).then(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
              summary = _ref2[0],
              message = _ref2[1];
            var name = _this2.name;
            message = name + ": " + (summary ? summary + ": " + message : message);
            if (_this2.message) {
              var stackArray = stack.split('\n');
              if (stackArray[0].indexOf(name + ": " + _this2.message) !== 0) {
                stackArray.unshift(message);
              } else {
                stackArray[0] = message;
              }
              stack = stackArray.join('\n');
            }
            return stack;
          });
        }
        return Promise.resolve(stack);
      }
      /**
       * Checks to see if the string to be formatted and if undefined returns undefined.
       * @private
       * @param {String} str the string rot formatted
       * @returns {Promise<String|undefined>}
       */
    }, {
      key: "$doFormat",
      value: function $doFormat(str) {
        if (str === undefined) {
          return Promise.resolve(undefined);
        }
        return lex.format.apply(lex, arguments);
      }
    }]);
  }(/*#__PURE__*/_wrapNativeSuper(Error));
  return LocalizableError;
});
