/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/* eslint-env browser */

/**
 * A JavaScript library used for translating HTML5 web applications into 
 * different languages.
 *
 * This is a plug-in for RequireJS. The plug-in will be used whenever a 
 * requirement for `lex!moduleName` is used in RequireJS. This plug-in
 * is used for importing Lexicons.
 * 
 * For extra network efficiency, it's recommended to provide a comma separated list of
 * of Lexicons to import. For example, `lex!foo,goo`.
 *
 * See {@link module:nmodule/js/rc/lex/lex} for more information and some examples.
 * 
 * @module lex
 * @see {@link module:nmodule/js/rc/lex/lex}
 */
define([], function () {
  "use strict";

  function load(name, req, onLoad, config) {
    var webdev = !!config && config.config && config.config.lex && config.config.lex.webdev;
    function requireLex() {
      req(["nmodule/js/rc/lex/lex", "Promise"], function (lex, Promise) {
        var lexicons, i, promises;
        if (name.length === 0) {
          // If no arguments are supplied simply supply the lexicon API as an argument.   
          onLoad(lex);
        } else {
          lexicons = name.split(",");
          promises = [];
          for (i = 0; i < lexicons.length; ++i) {
            promises.push(lex.module(lexicons[i]));
          }
          Promise.all(promises).then(onLoad, onLoad.error);
        }
      });
    }
    if (webdev) {
      requireLex();
    } else {
      req(["nmodule/js/rc/js.built.min"], requireLex);
    }
  }
  return {
    load: load,
    pluginBuilder: "buildLex"
  };
});
