function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* global module: false */
/* eslint-env browser */

(function (root, factory) {
  'use strict';

  if (typeof define === 'function' && define.amd) {
    //AMD requirejs
    define([], factory);
  } else if ((typeof module === "undefined" ? "undefined" : _typeof(module)) === 'object' && module.exports) {
    //node
    module.exports = factory();
  } else {
    //native browser
    if (typeof root.BroadcastChannel !== 'function') {
      root.BroadcastChannel = factory();
    }
  }
})(this, function () {
  'use strict';

  var reg = {},
    tabId = randomString(),
    idCounter = 0,
    listener,
    KEY_PREFIX = '_BroadcastChannelImpl_';

  ////////////////////////////////////////////////////////////////
  // BroadcastChannel polyfill
  ////////////////////////////////////////////////////////////////

  /**
   * Polyfilled BrowserChannel support that works via localStorage events.
   *
   * @class
   * @param {string} name
   */
  var BroadcastChannel = function BroadcastChannel(name) {
    this.$channelName = name;
    this.$tabId = tabId;
    this.$channelId = tabId + ':' + (+new Date()).toString(16) + ':' + idCounter++;
    (reg[name] || (reg[name] = [])).push(this);
    if (!listener) {
      listener = handleStorageEvent;
      window.addEventListener('storage', listener);
    }
  };
  BroadcastChannel.prototype.postMessage = function (data) {
    if (this.$closed) {
      throw alreadyClosedError();
    }
    var key = toLocalStorageKey(this),
      channel = this.$channelName;

    //communicate with other channels in same tab
    reg[channel].filter(isNot(this)).forEach(triggerEvent(data));

    //communicate with channels in different tabs
    localStorage.setItem(key, JSON.stringify({
      tabId: this.$tabId,
      channel: channel,
      data: data
    }));
    localStorage.removeItem(key);
  };
  BroadcastChannel.prototype.onmessage = function (event) {};
  BroadcastChannel.prototype.close = function () {
    this.$closed = true;
    var channelName = this.$channelName;
    reg[channelName] = reg[channelName].filter(isNot(this));
  };

  ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////

  function handleStorageEvent(event) {
    var key = event.key,
      newValue = event.newValue;
    if (key.match('^' + KEY_PREFIX)) {
      // a polyfilled BroadcastChannel in another tab is communicating with
      // us via localStorage, so parse the event and trigger all
      // BroadcastChannels in this tab.
      if (newValue) {
        var obj = JSON.parse(newValue),
          channels = reg[obj.channel];

        //IE wrongly fires storage events on the same tab
        if (channels && obj.tabId !== tabId) {
          channels.forEach(function (ch) {
            ch.onmessage(toEvent(obj.data));
          });
        }
      }
      localStorage.removeItem(key);
    }
  }
  function toLocalStorageKey(ch) {
    return KEY_PREFIX + ':' + randomString() + ':' + ch.$channelId;
  }
  function toEvent(data) {
    return {
      data: data
    };
  }
  function triggerEvent(data) {
    return function (ch) {
      ch.onmessage(toEvent(data));
    };
  }
  function isNot(o) {
    return function (o2) {
      return o2 !== o;
    };
  }
  function randomString(length) {
    var s = '';
    for (var i = 0, len = length || 10; i < len; i++) {
      s += Math.floor(Math.random() * 16).toString(16);
    }
    return s;
  }
  function alreadyClosedError() {
    var e = new Error('Already closed');
    e.name = 'InvalidStateError';
    return e;
  }
  return BroadcastChannel;
});
