function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define(['Promise'], function (Promise) {
  'use strict';

  var REG = Symbol('events');
  var RESOLVE_HANDLERS = Symbol('resolveHandlers');
  function getHandlers(obj, name) {
    if (!name) {
      throw new Error('event name required');
    }
    var e = obj[REG];
    return e[name] || (e[name] = []);
  }
  function callHandlersAsync(obj, name, args) {
    return getHandlers(obj, name).map(function (handler) {
      try {
        return handler.apply(obj, args);
      } catch (err) {
        return Promise.reject(err);
      }
    });
  }
  function getAllEventNames(obj) {
    var events = obj[REG];
    return events ? Object.keys(events) : [];
  }
  function clear(arr) {
    arr.splice(0, arr.length);
  }

  /**
   * @mixin tinyevents
   */
  var fns = {
    /**
     * Emit an event.
     * @param {string} name
     * @param {...*} args any additional arguments are passed to the handler functions
     * @returns {Thenable} resolves to the results of all the handler calls, or an empty
     * array if there are no handlers defined. If `resolveHandlers` is set to true, this will wait
     * for any asynchronous event handlers to complete before resolving (the resolved array will
     * include the resolved values from any Promises returned by event handlers). If it is set to
     * false, it will not wait for any asynchronous event handlers (the resolved array may contain
     * unresolved Promises).
     */
    emit: function emit(name) {
      var _this = this;
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      var resolveHandlers = this[RESOLVE_HANDLERS];
      var results;
      if (resolveHandlers) {
        results = callHandlersAsync(this, name, args);
        Object.defineProperty(results, 'then', {
          enumerable: false,
          value: function value(onResolve, onReject) {
            return Promise.all(results.slice()).then(onResolve, onReject);
          }
        });
      } else {
        results = getHandlers(this, name).map(function (handler) {
          return handler.apply(_this, args);
        });
        Object.defineProperty(results, 'then', {
          enumerable: false,
          value: function value(onResolve) {
            return Promise.resolve(results.slice()).then(onResolve);
          }
        });
      }
      return results;
    },
    /**
     * Emit an event. If `resolveHandlers` is set to true, this will wait for any asynchronous event
     * handlers to complete before resolving (the resolved array will include the resolved values
     * from any Promises returned by event handlers). If it is set to false, it will not wait for
     * any asynchronous event handlers (the resolved array may contain unresolved Promises).
     *
     * @param {string} name
     * @param {...*} args
     * @returns {Promise.<Array.<*>>}
     */
    emitAndWait: function emitAndWait(name) {
      for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
        args[_key2 - 1] = arguments[_key2];
      }
      return Promise.all(callHandlersAsync(this, name, args));
    },
    on: function on(name, func) {
      if (!func) {
        throw new Error('handler required');
      }
      var handlers = getHandlers(this, name);
      if (!handlers.includes(func)) {
        handlers.push(func);
      }
      return this;
    },
    //TODO: how about an afterTriggered method
    //for example, i want to do something but only after an editor is initialized
    //editor does trigger an initialized event, but only once
    //therefore on('initialized') won't work if initialization is already complete
    //hold onto triggered status for certain events and trigger immediately from on()
    //after implementing this, revisit all calls to .on('initialized'), .on('loaded')

    once: function once(name, func) {
      return this.on(name, function f() {
        func.apply(this, arguments);
        this.removeListener(name, f);
      });
    },
    removeListener: function removeListener(name, func) {
      var handlers = getHandlers(this, name);
      var i = handlers.indexOf(func);
      if (i !== -1) {
        handlers.splice(i, 1);
      }
      if (!handlers.length) {
        delete this[REG][name];
      }
      return this;
    },
    removeAllListeners: function removeAllListeners(name) {
      var _this2 = this;
      if (name) {
        clear(getHandlers(this, name));
        delete this[REG][name];
      } else {
        getAllEventNames(this).forEach(function (name) {
          clear(getHandlers(_this2, name));
        });
      }
      return this;
    }
  };

  /**
   * @param {object} obj
   * @param {object} [params]
   * @param {boolean} [params.resolveHandlers] `emit()` returns an array of results. as of 4.13: if
   * `resolveHandlers` is true, then the results array will be thenable, so if any handlers are async,
   * you can resolve the array as a promise (call .then() or return from a promise chain) to wait
   * for any async handlers to resolve.
   * @returns {tinyevents}
   */
  function TinyEvents(obj, params) {
    if (!obj && this instanceof TinyEvents) {
      obj = this;
    }
    obj[RESOLVE_HANDLERS] = params && params.resolveHandlers;
    if (TinyEvents.isOn(obj)) {
      return obj;
    }
    obj[REG] = {};
    obj.emit = fns.emit;
    obj.emitAndWait = fns.emitAndWait;
    obj.on = obj.addListener = fns.on;
    obj.once = fns.once;
    obj.removeListener = obj.off = fns.removeListener;
    obj.removeAllListeners = fns.removeAllListeners;
    return obj;
  }

  /**
   * @param obj
   * @returns {boolean} if object has tinyevents on it already
   */
  TinyEvents.isOn = function (obj) {
    return !!(obj && _typeof(obj) === 'object' && obj[REG]);
  };
  return TinyEvents;
});
