function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/fe/ExtensionEditor
 */
define(['lex!platCrypto', 'bajaux/events', 'bajaux/spandrel', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'Promise', 'nmodule/platCrypto/rc/CertConstants', 'nmodule/platCrypto/rc/fe/certificateEditorUtils', 'nmodule/platCrypto/rc/fe/extensions/KeyUsageEditor', 'nmodule/platCrypto/rc/fe/extensions/SubjectAlternativeNameEditor', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/wb/commands/HelpCommand', 'css!nmodule/platCrypto/rc/platCrypto'], function (lexs, events, spandrel, Command, CommandButton, Promise, CertConstants, certificateEditorUtils, KeyUsageEditor, SubjectAlternativeNameEditor, feDialogs, OrderedMapEditor, HelpCommand) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT;
  var extensionTypes = certificateEditorUtils.extensionTypes,
    getExtensionWidget = certificateEditorUtils.getExtensionWidget,
    getExtensionHelpKey = certificateEditorUtils.getExtensionHelpKey,
    getExtensionLabel = certificateEditorUtils.getExtensionLabel,
    getDefaultEkuPurpose = certificateEditorUtils.getDefaultEkuPurpose;
  var _CertConstants$EXTENS = CertConstants.EXTENSION_OID,
    SUBJECT_ALTERNATIVE_NAME_OID = _CertConstants$EXTENS.SUBJECT_ALTERNATIVE_NAME_OID,
    KEY_USAGE_OID = _CertConstants$EXTENS.KEY_USAGE_OID,
    EXTENDED_KEY_USAGE_OID = _CertConstants$EXTENS.EXTENDED_KEY_USAGE_OID,
    BASIC_CONSTRAINT_OID = _CertConstants$EXTENS.BASIC_CONSTRAINT_OID;
  var _CertConstants$EXTEND = _slicedToArray(CertConstants.EXTENDED_KEY_USAGE_COMMON_IDS, 2),
    TLS_WEB_SERVER_AUTH = _CertConstants$EXTEND[0],
    TLS_WEB_CLIENT_AUTH = _CertConstants$EXTEND[1];
  var DIGITAL_SIGNATURE = KeyUsageEditor.DIGITAL_SIGNATURE,
    KEY_ENCIPHERMENT = KeyUsageEditor.KEY_ENCIPHERMENT,
    DEFAULT_SAN = SubjectAlternativeNameEditor.DEFAULT_SAN;
  var DEFAULT = [{
    oid: KEY_USAGE_OID,
    isCritical: true,
    value: {
      flags: DIGITAL_SIGNATURE | KEY_ENCIPHERMENT
    },
    props: {
      isDefault: true
    }
  }];
  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-ExtensionEditor'
      }
    };
  };

  /**
   * Compact editor for editing a new certificates extensions
   *
   * @class
   * @alias module:nmodule/platCrypto/rc/fe/ExtensionEditor
   * @extends module:bajaux/Widget
   */
  var ExtensionEditor = /*#__PURE__*/function (_spandrel) {
    function ExtensionEditor(params) {
      var _this;
      _classCallCheck(this, ExtensionEditor);
      _this = _callSuper(this, ExtensionEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$addCmd = new Command({
        module: 'platCrypto',
        lex: 'NewCertForm.extension.commands.add',
        func: function func() {
          return _this.$promptForNewExtension().then(function (newExtension) {
            return newExtension && _this.$addExtensions(newExtension);
          });
        }
      });
      return _this;
    }

    /**
     *
     * @param {Array<module:nmodule/platCrypto/rc/fe/ExtensionEditor~ExtensionEntry>} extensions
     * @returns {object}
     */
    _inherits(ExtensionEditor, _spandrel);
    return _createClass(ExtensionEditor, [{
      key: "toState",
      value: function toState() {
        var extensions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
        var SERVER_CERT_DEFAULT_EXTS = DEFAULT.concat({
          oid: SUBJECT_ALTERNATIVE_NAME_OID,
          isCritical: false,
          value: DEFAULT_SAN,
          props: {
            isDefault: true
          }
        }, {
          oid: EXTENDED_KEY_USAGE_OID,
          isCritical: false,
          value: {
            purposes: [TLS_WEB_SERVER_AUTH, TLS_WEB_CLIENT_AUTH]
          }
        });
        if (extensions.length > 0) {
          var union = function union(ext1, ext2) {
            var diff = ext1.filter(function (e1) {
              return !ext2.some(function (e2) {
                return e1.oid === e2.oid;
              });
            });
            return [].concat(_toConsumableArray(diff), _toConsumableArray(ext2));
          };
          return {
            certUsage: 'server',
            extensions: union(SERVER_CERT_DEFAULT_EXTS, extensions)
          };
        }
        return {
          certUsage: 'server',
          extensions: SERVER_CERT_DEFAULT_EXTS
        };
      }

      /**
       *
       * @param {object}
       * @returns {Array<module:nmodule/platCrypto/rc/fe/ExtensionEditor~ExtensionEntry>}
       */
    }, {
      key: "fromState",
      value: function fromState(_ref) {
        var _ref$extensions = _ref.extensions,
          extensions = _ref$extensions === void 0 ? [] : _ref$extensions;
        return extensions;
      }

      /**
      * @private
      * @param {object} sanValue
      * @returns {Promise}
      */
    }, {
      key: "$setSan",
      value: function $setSan(sanValue) {
        // This is a hack to not set the SAN editor to modified state when it is auto-populated
        // via fieldChanged form event but trigger a modify event so that validation goes through.
        // I set down the path of setting the state (hence the $setSan method name) of the extensions editor
        // with the new SAN value but that seems to call for more changes to this module which is not worth it
        // at the moment.  
        var sanEditor = this.$getDataEditorForOid(SUBJECT_ALTERNATIVE_NAME_OID);
        return sanEditor.load(sanValue).then(function () {
          return sanEditor.trigger(MODIFY_EVENT);
        });
      }

      /**
       * @private
       * @param {object} params
       * @param {Array<module:nmodule/platCrypto/rc/fe/ExtensionEditor~ExtensionEntry>} [params.extensions] the extension for certificate
       * @param {String} [params.certUsage]
       * @returns {JSX.Element[]}
       */
    }, {
      key: "$buildEditor",
      value: function $buildEditor(_ref2) {
        var _this2 = this;
        var _ref2$extensions = _ref2.extensions,
          extensions = _ref2$extensions === void 0 ? [] : _ref2$extensions,
          certUsage = _ref2.certUsage;
        return [spandrel.jsx(ExtensionRows, {
          tagName: "table",
          className: "-t-ExtensionEditor-Table ux-table",
          value: extensions,
          lax: true,
          spandrelKey: "extensions",
          bind: true,
          onUxModify: function onUxModify() {
            return _this2.rerender();
          },
          properties: {
            certUsage: certUsage
          },
          validate: function validate(extensions) {
            return _this2.$validate(extensions);
          }
        }), spandrel.jsx(CommandButton, {
          tagName: "button",
          type: "button",
          className: "ux-btn",
          value: this.$addCmd,
          enabled: extensions.length < Object.keys(extensionTypes).length,
          spandrelKey: "addButton"
        })];
      }

      /**
       * @private
       * @param {Array<module:nmodule/platCrypto/rc/fe/ExtensionEditor~ExtensionEntry>} extensions
       * @throws {Error} if extensions are invalid
       */
    }, {
      key: "$validate",
      value: function $validate(extensions) {
        var sanEditor = this.$getDataEditorForOid(SUBJECT_ALTERNATIVE_NAME_OID);
        if (!sanEditor) {
          return;
        }
        var sanExt = extensions.find(function (_ref4) {
            var oid = _ref4.oid;
            return oid === SUBJECT_ALTERNATIVE_NAME_OID;
          }),
          _ref3 = sanExt || {},
          value = _ref3.value;
        sanEditor.$validateSAN(value);
      }

      /**
       * @private
       * @param {string} certUsage
       * @param {Array<module:nmodule/platCrypto/rc/fe/ExtensionEditor~ExtensionEntry>} extensions
       * @returns {Array<module:nmodule/platCrypto/rc/fe/ExtensionEditor~ExtensionEntry>}
       */
    }, {
      key: "$normalizeExtensions",
      value: function $normalizeExtensions(certUsage, extensions) {
        var newExtensions;
        extensions = extensions.slice(); // Copy to avoid putting the widget in an inconsistent state
        switch (certUsage) {
          case 'server':
            {
              if (!extensions.some(function (ext) {
                return ext.oid === SUBJECT_ALTERNATIVE_NAME_OID;
              })) {
                extensions.push({
                  oid: SUBJECT_ALTERNATIVE_NAME_OID,
                  isCritical: false,
                  value: DEFAULT_SAN
                });
              }
              if (!extensions.some(function (ext) {
                return ext.oid === EXTENDED_KEY_USAGE_OID;
              })) {
                extensions.push({
                  oid: EXTENDED_KEY_USAGE_OID,
                  isCritical: false,
                  value: {
                    purposes: getDefaultEkuPurpose(certUsage)
                  }
                });
              }
              newExtensions = extensions.filter(function (_ref5) {
                var oid = _ref5.oid,
                  _ref5$props = _ref5.props,
                  props = _ref5$props === void 0 ? {} : _ref5$props;
                return props.isAdded || props.isDefault || oid === SUBJECT_ALTERNATIVE_NAME_OID || oid === EXTENDED_KEY_USAGE_OID;
              });
              break;
            }
          case 'ca':
            {
              var existing = extensions.find(function (ext) {
                return ext.oid === BASIC_CONSTRAINT_OID;
              });
              if (!existing) {
                extensions.push({
                  oid: BASIC_CONSTRAINT_OID,
                  isCritical: true,
                  value: {
                    isCA: true
                  }
                });
              } else {
                // If you find one just reset it to defaults and preserve any other property already set
                var value = existing.value,
                  newValue = Object.assign({}, value, {
                    isCA: true
                  });
                Object.assign(existing, {
                  isCritical: true,
                  value: newValue
                });
              }
              newExtensions = extensions.filter(function (_ref6) {
                var oid = _ref6.oid,
                  _ref6$props = _ref6.props,
                  props = _ref6$props === void 0 ? {} : _ref6$props;
                return props.isAdded || props.isDefault || oid === BASIC_CONSTRAINT_OID;
              });
              break;
            }
          case 'codeSigning':
            {
              if (!extensions.some(function (ext) {
                return ext.oid === EXTENDED_KEY_USAGE_OID;
              })) {
                extensions.push({
                  oid: EXTENDED_KEY_USAGE_OID,
                  isCritical: false,
                  value: {
                    purposes: getDefaultEkuPurpose(certUsage)
                  }
                });
              }
              newExtensions = extensions.filter(function (_ref7) {
                var oid = _ref7.oid,
                  _ref7$props = _ref7.props,
                  props = _ref7$props === void 0 ? {} : _ref7$props;
                return props.isAdded || props.isDefault || oid === EXTENDED_KEY_USAGE_OID;
              });
              break;
            }
          case 'client':
            {
              if (!extensions.some(function (ext) {
                return ext.oid === EXTENDED_KEY_USAGE_OID;
              })) {
                extensions.push({
                  oid: EXTENDED_KEY_USAGE_OID,
                  isCritical: false,
                  value: {
                    purposes: getDefaultEkuPurpose(certUsage)
                  }
                });
              }
              newExtensions = extensions.filter(function (_ref8) {
                var oid = _ref8.oid,
                  _ref8$props = _ref8.props,
                  props = _ref8$props === void 0 ? {} : _ref8$props;
                return props.isAdded || props.isDefault || oid === EXTENDED_KEY_USAGE_OID;
              });
              break;
            }
          case 'custom':
            {
              newExtensions = extensions;
            }
        }
        return newExtensions || [];
      }

      /**
       * @private
       * @returns {Promise.<module:nmodule/platCrypto/rc/fe/ExtensionEditor~ExtensionEntry>} resolves to a new extension
       */
    }, {
      key: "$promptForNewExtension",
      value: function $promptForNewExtension() {
        return feDialogs.showFor({
          value: {
            oid: "",
            isCritical: false,
            value: null
          },
          type: AddRowPrompt,
          properties: {
            map: this.$getExtensionTypeList()
          }
        });
      }

      /**
       * @private
       * @param {String} certUsage
       * @returns {Promise}
       */
    }, {
      key: "$certificateChanged",
      value: function $certificateChanged(certUsage) {
        var _this3 = this;
        var _this$state = this.state(),
          extensions = _this$state.extensions;
        return this.state({
          certUsage: certUsage,
          extensions: this.$normalizeExtensions(certUsage, extensions)
        }).then(function () {
          return _this3.setModified(true);
        });
      }

      /**
       * @private
       * @param {module:nmodule/platCrypto/rc/fe/ExtensionEditor~ExtensionEntry} newExtension new extension to add
       * @returns {Promise}
       */
    }, {
      key: "$addExtensions",
      value: function $addExtensions(newExtension) {
        var _this4 = this;
        if (!newExtension || !newExtension.oid) {
          return Promise.resolve();
        }
        var _this$state2 = this.state(),
          _this$state2$extensio = _this$state2.extensions,
          extensions = _this$state2$extensio === void 0 ? [] : _this$state2$extensio,
          newExtensions = extensions.slice();
        newExtension.props = {
          isAdded: true
        };
        newExtensions.push(newExtension);
        return this.state({
          extensions: newExtensions
        }).then(function () {
          return _this4.setModified(true);
        });
      }

      /**
       * @private
       * @returns {Array.<module:nmodule/platCrypto/rc/fe/ExtensionEditor~ExtensionTypes>} the extension types, their lexKeys, and their editor
       */
    }, {
      key: "$getExtensionTypes",
      value: function $getExtensionTypes() {
        return extensionTypes;
      }

      /**
       * @private
       * @returns {Object}
       */
    }, {
      key: "$getExtensionTypeList",
      value: function $getExtensionTypeList() {
        var map = {};
        var used = [];
        var keys = Object.keys(extensionTypes);

        //we need to build a list of already used extension type keys, because they can only be used
        // once on a certificate
        var _this$state3 = this.state(),
          _this$state3$extensio = _this$state3.extensions,
          extensions = _this$state3$extensio === void 0 ? [] : _this$state3$extensio;
        extensions.forEach(function (extension) {
          used.push(extension.oid);
        });
        keys.forEach(function (key) {
          var desc = getExtensionLabel(key);
          if (!used.includes(key)) {
            map[desc] = key;
          }
        });
        return map;
      }

      /**
       * @private
       * @param {string} key
       * @returns {string}
       */
    }, {
      key: "$getExtensionLabel",
      value: function $getExtensionLabel(key) {
        return getExtensionLabel(key);
      }

      /**
       * @param {string} key
       * @returns {bajaux/Widget} a friendly display for this extension key
       */
    }, {
      key: "$getExtensionWidget",
      value: function $getExtensionWidget(key) {
        return getExtensionWidget(key);
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getExtensionSection",
      value: function $getExtensionSection() {
        return this.queryWidget('extensions');
      }

      /**
       * @private
       * @param {string} oid
       * @returns {module:bajaux/Widget|null} the editor containing the current entered value for the
       * given extension OID
       */
    }, {
      key: "$getDataEditorForOid",
      value: function $getDataEditorForOid(oid) {
        var extensionEditor = this.$getExtensionSection().queryWidget(oid);
        return extensionEditor ? extensionEditor.$getDataEditor() : null;
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getAddButton",
      value: function $getAddButton() {
        return this.queryWidget('addButton');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getEditButton",
      value: function $getEditButton() {
        return this.queryWidget('edit');
      }
    }]);
  }(spandrel(function () {
    var value = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    var state = arguments.length > 1 ? arguments[1] : undefined;
    var self = state.self;
    return self.$buildEditor(state);
  }, {
    strategy: 'niagara'
  }));
  /**
   * Builds the rows for the extension table.
   * @class
   * @extends module:bajaux/Widget
   */
  var ExtensionRows = /*#__PURE__*/function (_spandrel2) {
    function ExtensionRows() {
      _classCallCheck(this, ExtensionRows);
      return _callSuper(this, ExtensionRows, arguments);
    }
    _inherits(ExtensionRows, _spandrel2);
    return _createClass(ExtensionRows, [{
      key: "doRead",
      value:
      /**
       * @returns {Promise.<Array<module:nmodule/platCrypto/rc/fe/ExtensionEditor~ExtensionEntry>>} the current extensions in the certificate
       */
      function doRead() {
        return Promise.all(this.$getExtensionRows().map(function (row) {
          return row.read();
        }));
      }

      /**
       * @private
       * @param {number} i the index to delete
       * @returns {Promise}
       */
    }, {
      key: "$deleteRow",
      value: function $deleteRow(i) {
        var _this5 = this;
        return this.read().then(function (extensions) {
          extensions.splice(i, 1);
          return _this5.load(extensions);
        }).then(function () {
          return _this5.setModified(true);
        });
      }

      /**
       * @private
       * @param {number} i the index to edit
       * @returns {Promise}
       */
    }, {
      key: "$editRow",
      value: function $editRow(i) {
        var _this6 = this;
        return this.read().then(function (extensions) {
          var extension = extensions[i];
          var editor = _this6.$getExtensionRows()[i].queryWidget('**/data');
          return feDialogs.showFor({
            type: getExtensionWidget(extension.oid),
            value: extension.value,
            formFactor: 'compact',
            title: getExtensionLabel(extension.oid),
            properties: editor.properties().toObject()
          }).then(function (modified) {
            if (modified === null) {
              return; //user pressed cancel
            }
            return editor.loadAndModify(modified);
          });
        });
      }

      /**
       * @private
       * @param {number} i the index for requesting help
       * @returns {Promise}
       */
    }, {
      key: "$helpRow",
      value: function $helpRow(i) {
        return this.read().then(function (extensions) {
          var extension = extensions[i];
          return new HelpCommand({
            module: 'platCrypto',
            lex: getExtensionHelpKey(extension.oid),
            title: getExtensionLabel(extension.oid)
          }).invoke();
        });
      }

      /**
       * @private
       * @returns {Array.<ExtensionRow>}
       */
    }, {
      key: "$getExtensionRows",
      value: function $getExtensionRows() {
        var rows = this.queryWidgets('*');
        // This is to remove the table header
        rows.shift();
        return rows;
      }
    }]);
  }(spandrel(function (extensions, _ref9) {
    var self = _ref9.self,
      properties = _ref9.properties;
    var certUsage = properties.certUsage;
    var header = spandrel.jsx("thead", {
      className: "ux-table-head"
    }, spandrel.jsx("th", null, platCryptoLex.get('NewCertForm.extension.tableHeader.type')), spandrel.jsx("th", null, platCryptoLex.get('NewCertForm.extension.tableHeader.critical')), spandrel.jsx("th", null, platCryptoLex.get('NewCertForm.extension.tableHeader.value')), spandrel.jsx("th", null));
    var x = [];
    if (extensions.length > 0) {
      extensions.forEach(function (extension, i) {
        var row = spandrel.jsx(ExtensionRow, {
          className: "-t-ExtensionEditor-TableRow ux-table-row",
          spandrelKey: extension.oid,
          lax: true,
          tagName: "tr",
          value: extension,
          properties: {
            certUsage: certUsage,
            deleteMe: function deleteMe() {
              return self.$deleteRow(i);
            },
            editMe: function editMe() {
              return self.$editRow(i);
            },
            helpMe: function helpMe() {
              return self.$helpRow(i);
            }
          }
        });
        x.push(row);
      });

      //Adding in the table header at the top
      x.unshift(header);
      return x;
    }
    return [header];
  }));
  /**
   * Widget for editing one extension row
   * @class
   * @extends module:bajaux/Widget
   */
  var ExtensionRow = /*#__PURE__*/function (_spandrel3) {
    function ExtensionRow() {
      var _this7;
      _classCallCheck(this, ExtensionRow);
      _this7 = _callSuper(this, ExtensionRow, arguments);
      _this7.$deleteCmd = new Command({
        module: 'platCrypto',
        lex: 'NewCertForm.extension.commands.remove',
        func: function func() {
          var deleteMe = _this7.properties().getValue('deleteMe');
          return deleteMe();
        }
      });
      _this7.$editCmd = new Command({
        module: 'platCrypto',
        lex: 'NewCertForm.extension.commands.edit',
        func: function func() {
          var editMe = _this7.properties().getValue('editMe');
          return editMe();
        }
      });
      _this7.$helpCmd = new Command({
        module: 'webEditors',
        lex: 'commands.help',
        func: function func() {
          var helpMe = _this7.properties().getValue('helpMe');
          return helpMe();
        }
      });
      return _this7;
    }
    _inherits(ExtensionRow, _spandrel3);
    return _createClass(ExtensionRow, [{
      key: "toState",
      value: function toState(extension) {
        var oid = extension.oid,
          isCritical = extension.isCritical,
          value = extension.value,
          props = extension.props;
        return {
          oid: oid,
          isCritical: isCritical,
          data: value,
          extProps: props
        };
      }
    }, {
      key: "fromState",
      value: function fromState(_ref10) {
        var oid = _ref10.oid,
          isCritical = _ref10.isCritical,
          extProps = _ref10.extProps;
        // the extra read is not usually needed but individual data editors provide their own default
        // values for the case when data is null.
        // TODO put default values in one place.
        return this.$getDataEditor().read().then(function (data) {
          return {
            oid: oid,
            isCritical: isCritical,
            value: data,
            props: extProps
          };
        });
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getLabel",
      value: function $getLabel() {
        return this.queryWidget('**/label').jq();
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getCriticalEditor",
      value: function $getCriticalEditor() {
        return this.queryWidget('**/isCritical');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget} the string editor for the extension value
       */
    }, {
      key: "$getDataEditor",
      value: function $getDataEditor() {
        return this.queryWidget('**/data');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getDeleteButton",
      value: function $getDeleteButton() {
        return this.queryWidget('**/deleteButton');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getEditButton",
      value: function $getEditButton() {
        return this.queryWidget('**/editButton');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getHelpButton",
      value: function $getHelpButton() {
        return this.queryWidget('**/helpButton');
      }
    }]);
  }(spandrel(function (extension, _ref11) {
    var oid = _ref11.oid,
      isCritical = _ref11.isCritical,
      data = _ref11.data,
      self = _ref11.self,
      properties = _ref11.properties,
      extProps = _ref11.extProps;
    var certUsage = properties.certUsage;
    var ExtensionWidget = getExtensionWidget(oid);
    var formFactor = 'mini';
    var required = oid === KEY_USAGE_OID || oid === SUBJECT_ALTERNATIVE_NAME_OID && certUsage === 'server';
    var requiredText = required ? platCryptoLex.get('cert.field.required') : '';
    return [spandrel.jsx("td", null, spandrel.jsx("div", {
      className: "-t-wrapper"
    }, spandrel.jsx("label", {
      spandrelKey: "label"
    }, getExtensionLabel(oid)), spandrel.jsx(CommandButton, {
      className: "-t-HelpCommand",
      spandrelKey: "helpButton",
      tagName: "span",
      value: self.$helpCmd
    }))), spandrel.jsx("td", null, spandrel.jsx("any", {
      bind: true,
      spandrelKey: "isCritical",
      lax: true,
      value: isCritical
    })), spandrel.jsx("td", null, spandrel.jsx(ExtensionWidget, {
      bind: true,
      spandrelKey: "data",
      lax: true,
      formFactor: formFactor,
      value: data
    })), spandrel.jsx("td", null, spandrel.jsx(CommandButton, {
      tagName: "button",
      type: "button",
      className: "ux-btn-tb",
      spandrelKey: "editButton",
      value: self.$editCmd
    }), spandrel.jsx(CommandButton, {
      tagName: "button",
      type: "button",
      className: "ux-btn-tb -t-deleteButton",
      spandrelKey: "deleteButton",
      enabled: !required,
      value: self.$deleteCmd
    }), spandrel.jsx("span", {
      className: "-t-requiredText"
    }, requiredText))];
  }, {
    strategy: 'niagara'
  }));
  /**
   * The widget that is shown in a dialog to prompt the user for a new extension when the Add button is clicked.
   * @class
   * @extends module:bajaux/Widget
   */
  var AddRowPrompt = /*#__PURE__*/function (_spandrel4) {
    function AddRowPrompt(params) {
      var _this8;
      _classCallCheck(this, AddRowPrompt);
      _this8 = _callSuper(this, AddRowPrompt, [{
        params: params,
        defaults: {
          properties: {
            rootCssClass: '-t-ExtensionEditor-AddPrompt'
          }
        }
      }]);
      _this8.$helpCmd = new Command({
        module: 'webEditors',
        lex: 'commands.help',
        func: function func() {
          return _this8.read().then(function (_ref12) {
            var oid = _ref12.oid;
            return new HelpCommand({
              module: 'platCrypto',
              lex: getExtensionHelpKey(oid),
              title: getExtensionLabel(oid)
            }).invoke();
          });
        }
      });
      return _this8;
    }

    /**
     * @private
     * @returns {module:bajaux/Widget}
     */
    _inherits(AddRowPrompt, _spandrel4);
    return _createClass(AddRowPrompt, [{
      key: "$getTypeEditor",
      value: function $getTypeEditor() {
        return this.queryWidget('oid');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getHelpButton",
      value: function $getHelpButton() {
        return this.queryWidget('**/helpButton');
      }

      /**
       * @returns {Promise.<module:nmodule/platCrypto/rc/fe/ExtensionEditor~ExtensionEntry>} the new extension to add
       */
    }, {
      key: "doRead",
      value: function doRead() {
        return this.$getTypeEditor().read().then(function (oid) {
          return {
            oid: oid,
            isCritical: false,
            value: null
          };
        });
      }
    }]);
  }(spandrel(function (extension, _ref13) {
    var self = _ref13.self,
      properties = _ref13.properties;
    var map = properties.map;
    var oid = extension.oid;
    return [spandrel.jsx("label", null, platCryptoLex.get('NewCertForm.extension.commands.add.type')), spandrel.jsx(OrderedMapEditor, {
      spandrelKey: "oid",
      tagName: "span",
      value: oid,
      lax: true,
      onUxModify: function onUxModify() {
        return self.rerender();
      },
      properties: {
        map: map
      },
      validate: true
    }), spandrel.jsx(CommandButton, {
      className: "-t-HelpCommand",
      spandrelKey: "helpButton",
      tagName: "span",
      value: self.$helpCmd
    })];
  }, {
    strategy: 'niagara'
  }));
  ExtensionEditor.DEFAULT = DEFAULT;
  return ExtensionEditor;
});

/**
 * An object defining certificate extensions
 *
 * @typedef module:nmodule/platCrypto/rc/fe/ExtensionEditor~Extensions
 * @property {Array.<module:nmodule/platCrypto/rc/fe/ExtensionEditor~ExtensionEntry>} extensions an array of the extension to be added to a certificate
 */

/**
 * An object defining a certificate extension entry.
 *
 * @typedef module:nmodule/platCrypto/rc/fe/ExtensionEditor~ExtensionEntry
 * @property {string} oid what type of certificate extension is this
 * @property {boolean} isCritical is this an extension that must be verified when the certificate is read
 * @property {Object} value the value for this extension, will vary based on the type
 * @property {Object} props extension properties specific to this editor
 */

/**
 * A list of valid certificate extension types
 *
 * @typedef module:nmodule/platCrypto/rc/fe/ExtensionEditor~ExtensionTypes
 * @property {Object<string,{module:nmodule/platCrypto/rc/fe/ExtensionEditor~ExtensionType}>} types a list of the valid types
 */

/**
 * An extension type type
 *
 * @typedef module:nmodule/platCrypto/rc/fe/ExtensionEditor~ExtensionType
 * @property {string} lexKey the lexicon suffix to find the correct label for this entry
 * @property {Function} editor the editor to be used for this entry
 */
