function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Nick Dodd
 */

/* eslint-env browser */

define(['baja!', 'lex!platCrypto', 'Promise', 'underscore', 'nmodule/platCrypto/rc/CertConstants', 'nmodule/platCrypto/rc/fe/extensions/BasicConstraintEditor', 'nmodule/platCrypto/rc/fe/extensions/CrlDistributionPointsEditor', 'nmodule/platCrypto/rc/fe/extensions/ExtendedKeyUsageEditor', 'nmodule/platCrypto/rc/fe/extensions/KeyUsageEditor', 'nmodule/platCrypto/rc/fe/extensions/SubjectAlternativeNameEditor', 'nmodule/webEditors/rc/fe/baja/StringEditor'], function (baja, lexs, Promise, _, CertConstants, BasicConstraintEditor, CrlDistributionPointsEditor, ExtendedKeyUsageEditor, KeyUsageEditor, SubjectAlternativeNameEditor, StringEditor) {
  'use strict';

  /**
   * API Status: **Private**
   * @exports nmodule/platCrypto/rc/fe/certificateEditorUtils
   */
  var exports = {};
  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];
  var _CertConstants$EXTENS = CertConstants.EXTENSION_OID,
    SUBJECT_ALTERNATIVE_NAME_OID = _CertConstants$EXTENS.SUBJECT_ALTERNATIVE_NAME_OID,
    KEY_USAGE_OID = _CertConstants$EXTENS.KEY_USAGE_OID,
    EXTENDED_KEY_USAGE_OID = _CertConstants$EXTENS.EXTENDED_KEY_USAGE_OID,
    BASIC_CONSTRAINT_OID = _CertConstants$EXTENS.BASIC_CONSTRAINT_OID,
    CRL_DISTRIBUTION_POINTS_OID = _CertConstants$EXTENS.CRL_DISTRIBUTION_POINTS_OID;

  /**
   * Certificate extension types which have editors. The OID of the extension is mapped to the an
   * object containing the lexKey used to lookup the relevant help lexicon, and the editor itself.
   * @see nre:OidMap
   * @type {Object}
   */
  exports.extensionTypes = _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty({}, SUBJECT_ALTERNATIVE_NAME_OID, {
    lexKey: 'san',
    editor: SubjectAlternativeNameEditor
  }), KEY_USAGE_OID, {
    lexKey: 'ku',
    editor: KeyUsageEditor
  }), EXTENDED_KEY_USAGE_OID, {
    lexKey: 'eku',
    editor: ExtendedKeyUsageEditor
  }), BASIC_CONSTRAINT_OID, {
    lexKey: 'bc',
    editor: BasicConstraintEditor
  }), CRL_DISTRIBUTION_POINTS_OID, {
    lexKey: 'crl',
    editor: CrlDistributionPointsEditor
  });
  var _CertConstants$EXTEND = _slicedToArray(CertConstants.EXTENDED_KEY_USAGE_COMMON_IDS, 3),
    TLS_WEB_SERVER_AUTH = _CertConstants$EXTEND[0],
    TLS_WEB_CLIENT_AUTH = _CertConstants$EXTEND[1],
    CODE_SIGNING = _CertConstants$EXTEND[2];
  var DIGITAL_SIGNATURE = KeyUsageEditor.DIGITAL_SIGNATURE,
    KEY_ENCIPHERMENT = KeyUsageEditor.KEY_ENCIPHERMENT,
    CERTIFICATE_SIGNING = KeyUsageEditor.CERTIFICATE_SIGNING,
    CRL_SIGNING = KeyUsageEditor.CRL_SIGNING;
  var extensionTypes = exports.extensionTypes;

  /**
   * @param {string} oid the oid string to use as the key to lookup the ext label
   * @returns {string} a friendly display for this extension oid
   */
  exports.getExtensionLabel = function (oid) {
    var obj = extensionTypes[oid];
    return obj ? platCryptoLex.get('NewCertForm.extension.type.' + obj.lexKey) : oid;
  };

  /**
   * @param {string} oid the oid string to use as the key to lookup the lex key
   * @returns {string} the lexicon key for the context-sensitive help
   */
  exports.getExtensionHelpKey = function (oid) {
    var obj = extensionTypes[oid];
    return obj ? 'NewCertForm.extension.type.' + obj.lexKey + '.help' : '';
  };

  /**
   * @param {string} oid the oid string to use as the key to lookup key the widget
   * @returns {bajaux/Widget} a widget for editing this extension oid
   */
  exports.getExtensionWidget = function (oid) {
    var obj = extensionTypes[oid];
    return obj ? obj.editor : StringEditor;
  };

  /**
   * @param {string} keyPurpose the known key purpose
   * @returns {Array} array of default Extended Key Usage OID values for the Key Purpose
   */
  exports.getDefaultEkuPurpose = function (keyPurpose) {
    switch (keyPurpose) {
      case 'server':
        {
          return [TLS_WEB_SERVER_AUTH, TLS_WEB_CLIENT_AUTH];
        }
      case 'client':
        {
          return [TLS_WEB_CLIENT_AUTH];
        }
      case 'codeSigning':
        {
          return [CODE_SIGNING];
        }
    }
    return [];
  };

  /**
   * @param {string} keyPurpose the known key purpose
   * @returns {int} Key Usage flags for the Key Purpose
   */
  exports.getDefaultKeyUsageFlags = function (keyPurpose) {
    switch (keyPurpose) {
      case 'server':
        {
          return DIGITAL_SIGNATURE | KEY_ENCIPHERMENT;
        }
      case 'client':
        {
          return DIGITAL_SIGNATURE;
        }
      case 'ca':
        {
          return CERTIFICATE_SIGNING | CRL_SIGNING;
        }
      case 'codeSigning':
        {
          return DIGITAL_SIGNATURE;
        }
    }
    return [];
  };
  return exports;
});
