function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

define(['Promise', 'underscore', 'lex!platCrypto', 'bajaux/spandrel', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'bajaux/Widget', 'nmodule/platCrypto/rc/fe/extensions/SubjectAlternativeNameEditor', 'nmodule/webEditors/rc/fe/baja/BooleanPicker', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/commands/HelpCommand', 'css!nmodule/platCrypto/rc/platCrypto'], function (Promise, _, lexs, spandrel, Command, CommandButton, Widget, SubjectAlternativeNameEditor, BooleanPicker, feDialogs, HelpCommand) {
  'use strict';

  var CA_COMPROMISED = 1 << 5,
    AA_COMPROMISED = 1 << 15,
    KEY_COMPROMISED = 1 << 6,
    AFFILIATION_CHANGED = 1 << 4,
    CERTIFICATE_HOLD = 1 << 1,
    CESSATION_OF_OPERATION = 1 << 2,
    PRIVILEGED_WITHDRAWN = 1 << 0,
    SUPERSEDED = 1 << 3,
    UNUSED = 1 << 7;
  var indexToBitMask = [UNUSED, KEY_COMPROMISED, CA_COMPROMISED, AFFILIATION_CHANGED, SUPERSEDED, CESSATION_OF_OPERATION, CERTIFICATE_HOLD, PRIVILEGED_WITHDRAWN, AA_COMPROMISED];
  var miniFormFactor = Widget.formFactor.mini;
  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];
  var each = _.each,
    map = _.map;
  var FULL_NAME = platCryptoLex.get('CrlDistributionPoints.fullName');
  var CRL_REASONS = platCryptoLex.get('CrlDistributionPoints.reasons');
  var CRL_ISSUER = platCryptoLex.get('CrlDistributionPoints.crlIssuer');
  var POINT_LABEL = platCryptoLex.get('CrlDistributionPoints.pointLabel');
  var POINT_TITLE = platCryptoLex.get('CrlDistributionPoints.pointTitle');
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: "-t-CrlDistributionPointsEditor"
      }
    };
  };
  var choices = [];

  /**
   * @returns {Array.<module:nmodule/webEditors/rc/fe/baja/BooleanPicker~Choice>}
   */
  function loadChoices() {
    if (choices.length === 0) {
      for (var i = 0; i < indexToBitMask.length; i++) {
        choices.push({
          value: i,
          display: platCryptoLex.get('cert.field.crlDistributionReason.' + i),
          readonly: false
        });
      }
    }
  }

  /**
   * @param {Number} flags
   * @returns{Array.<Number>}
   */
  function getSelectedReasons(flags) {
    var selectedReasons = [];
    each(choices, function (choice, index) {
      if ((flags & indexToBitMask[index]) !== 0) {
        selectedReasons.push(index);
      }
    });
    return selectedReasons;
  }

  /**
   * @param {Number} reasons the number that represents the reasons bit flags
   * @return {String}
   */
  function getReasonsDesc(reasons) {
    var selectedReasons = getSelectedReasons(reasons);
    return map(selectedReasons, function (reason) {
      return choices[reason].display;
    }).join(', ');
  }

  /**
   * @param {Array.<Object>} distributionPoints
   * @return {String}
   */
  function getPreviewText(distributionPoints) {
    return distributionPoints.map(function (point) {
      return getPointDesc(point);
    }).join("\n\n");
  }

  /**
   * @param {Object} distributionPoint a single entry in the distributionPoints array
   * @return {String}
   */
  function getPointDesc(distributionPoint) {
    var lines = [];
    var fullNameArray = distributionPoint.fullName || [];
    var crlIssuersArray = distributionPoint.crlIssuers || [];
    var fullName = fullNameArray[0];
    var crlIssuers = crlIssuersArray[0];
    var reasonStr = getReasonsDesc(distributionPoint.reasons);
    lines.push(POINT_LABEL + ":");
    if (fullName && fullName.value) {
      var fullNameDesc = platCryptoLex.get('cert.field.san.' + fullName.tagNo) + ":" + fullName.value + (fullNameArray.length > 1 ? " ..." : "");
      lines.push("    " + platCryptoLex.get("CrlDistributionPoints.fullNameDesc", fullNameDesc));
    }
    if (reasonStr) {
      lines.push("    " + platCryptoLex.get("CrlDistributionPoints.reasonsDesc", reasonStr));
    }
    if (crlIssuers && crlIssuers.value) {
      var crlIssuersDesc = platCryptoLex.get('cert.field.san.' + crlIssuers.tagNo) + ":" + crlIssuers.value + (crlIssuersArray.length > 1 ? " ..." : "");
      lines.push("    " + platCryptoLex.get("CrlDistributionPoints.crlIssuerDesc", crlIssuersDesc));
    }
    return lines.join("\n");
  }

  /**
   * An editor to add CRL DistributionPoints to a certificate
   *
   * @class
   * @alias module:nmodule/platCrypto/rc/fe/extensions/CrlDistributionPointsEditor
   * @extends module:bajaux/Widget
   * @since Niagara 4.13
  */
  var CrlDistributionPointsEditor = /*#__PURE__*/function (_spandrel) {
    function CrlDistributionPointsEditor(params) {
      var _this;
      _classCallCheck(this, CrlDistributionPointsEditor);
      _this = _callSuper(this, CrlDistributionPointsEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$addCmd = new Command({
        module: 'platCrypto',
        lex: 'CrlDistributionPoints.commands.addPoint',
        func: function func() {
          return _this.$promptForNewPoint().then(function (newPoint) {
            return newPoint && _this.$addNewPoint(newPoint);
          });
        }
      });
      _this.$helpAddPoint = new HelpCommand({
        module: 'platCrypto',
        lex: 'CrlDistributionPoints.pointLabel.help',
        title: platCryptoLex.get('CrlDistributionPoints.pointTitle')
      });
      return _this;
    }

    /**
     * @private
     * @param {Object} value
     * @param {Object} state
     * @returns {module:bajaux/spandrel~SpandrelData}
     */
    _inherits(CrlDistributionPointsEditor, _spandrel);
    return _createClass(CrlDistributionPointsEditor, [{
      key: "$buildEditor",
      value: function $buildEditor(value, state) {
        var _this2 = this;
        var self = state.self,
          formFactor = state.formFactor,
          writable = state.writable;
        var distributionPoints = value && value.distributionPoints || [];
        if (!writable || formFactor === miniFormFactor) {
          var _toString = getPreviewText(distributionPoints);
          return [spandrel.jsx("textarea", {
            rows: "4",
            cols: "35",
            readOnly: true
          }, _toString)];
        }
        return [spandrel.jsx(CrlDistributionPointRows, {
          tagName: "table",
          lax: true,
          className: "-t-CrlDistributionPointsEditor-table",
          value: distributionPoints,
          spandrelKey: "pointsTable",
          onUxModify: function onUxModify() {
            return _this2.rerender();
          }
        }), spandrel.jsx("div", {
          className: "-t-wrapper"
        }, spandrel.jsx(CommandButton, {
          tagName: "button",
          type: "button",
          className: "ux-btn",
          value: self.$addCmd,
          spandrelKey: "addButton"
        }), spandrel.jsx(CommandButton, {
          className: "-t-HelpCommand",
          spandrelKey: "helpButton",
          tagName: "span",
          value: self.$helpAddPoint
        }))];
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$promptForNewPoint",
      value: function $promptForNewPoint() {
        return feDialogs.showFor({
          type: CrlDistributionPointEditor,
          value: {
            fullName: [],
            reasons: 0,
            crlIssuers: []
          },
          formFactor: 'compact',
          title: POINT_TITLE
        });
      }

      /**
       * @private
       * @param {Object} newPoint new point to add
       * @returns {Promise}
       */
    }, {
      key: "$addNewPoint",
      value: function $addNewPoint(newPoint) {
        if (!newPoint) {
          return Promise.resolve();
        }
        var value = this.value();
        var distributionPoints = value && value.distributionPoints && value.distributionPoints.slice() || [];
        distributionPoints.push(newPoint);
        return this.loadAndModify({
          distributionPoints: distributionPoints
        });
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getPointsTable",
      value: function $getPointsTable() {
        return this.queryWidget('pointsTable');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getTextArea",
      value: function $getTextArea() {
        return this.jq().find('textarea');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getAddButton",
      value: function $getAddButton() {
        return this.queryWidget('**/addButton');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getHelpButton",
      value: function $getHelpButton() {
        return this.queryWidget('**/helpButton');
      }

      /**
       * @returns {Promise.<Object>} an object that contains an array of distribution points
       */
    }, {
      key: "doRead",
      value: function doRead() {
        if (this.getFormFactor() === 'mini') {
          return Promise.resolve(this.value());
        }
        var table = this.$getPointsTable();
        return (table ? table.read() : Promise.resolve()).then(function (readPoints) {
          return {
            distributionPoints: readPoints
          };
        });
      }
    }]);
  }(spandrel(function (value, state) {
    var self = state.self;
    loadChoices();
    return self.$buildEditor(value, state);
  }, {
    strategy: 'niagara'
  }));
  /**
   * Builds the rows for each point in the CrlDistributionPoint Extension
   *
   * @class
   * @extends module:bajaux/Widget
  */
  var CrlDistributionPointRows = /*#__PURE__*/function (_spandrel2) {
    function CrlDistributionPointRows() {
      _classCallCheck(this, CrlDistributionPointRows);
      return _callSuper(this, CrlDistributionPointRows, arguments);
    }
    _inherits(CrlDistributionPointRows, _spandrel2);
    return _createClass(CrlDistributionPointRows, [{
      key: "doRead",
      value:
      /**
       * @returns {Promise.<Array<Object>>} an array of CRL Distribution Points
       */
      function doRead() {
        return Promise.all(this.$getPoints().map(function (row) {
          return row.read();
        }));
      }

      /**
       * @private
       * @param {number} i the index to delete
       * @returns {Promise}
       */
    }, {
      key: "$deleteRow",
      value: function $deleteRow(i) {
        var _this3 = this;
        return this.read().then(function (points) {
          points.splice(i, 1);
          return _this3.load(points);
        }).then(function () {
          return _this3.setModified(true);
        });
      }

      /**
       * @private
       * @param {number} i the index to edit
       * @returns {Promise}
       */
    }, {
      key: "$editRow",
      value: function $editRow(i) {
        var _this4 = this;
        return this.read().then(function (points) {
          var point = points[i];
          var editor = _this4.$getPoints()[i];
          return feDialogs.showFor({
            type: CrlDistributionPointEditor,
            value: point,
            formFactor: 'compact',
            title: POINT_TITLE
          }).then(function (modified) {
            if (modified === null) {
              return; //user pressed cancel
            }
            return editor.loadAndModify(modified);
          });
        });
      }

      /**
       * @private
       * @returns {Array.<CrlDistributionPointRow>}
       */
    }, {
      key: "$getPoints",
      value: function $getPoints() {
        return this.queryWidgets('*');
      }
    }]);
  }(spandrel(function (points, _ref) {
    var self = _ref.self;
    return points.map(function (point, i) {
      return spandrel.jsx(CrlDistributionPointRow, {
        tagName: "tr",
        className: "-t-CrlDistributionPointsEditor-row",
        value: point,
        properties: {
          deleteMe: function deleteMe() {
            return self.$deleteRow(i);
          },
          editMe: function editMe() {
            return self.$editRow(i);
          }
        }
      });
    });
  }));
  /**
   * Widget for displaying one point in the CRL Distribution Points extension
   * @class
   * @extends module:bajaux/Widget
   */
  var CrlDistributionPointRow = /*#__PURE__*/function (_spandrel3) {
    function CrlDistributionPointRow(params) {
      var _this5;
      _classCallCheck(this, CrlDistributionPointRow);
      _this5 = _callSuper(this, CrlDistributionPointRow, arguments);
      _this5.$deleteCmd = new Command({
        module: 'platCrypto',
        lex: 'CrlDistributionPoints.commands.remove',
        func: function func() {
          var deleteMe = _this5.properties().getValue('deleteMe');
          return deleteMe();
        }
      });
      _this5.$editCmd = new Command({
        module: 'platCrypto',
        lex: 'CrlDistributionPoints.commands.edit',
        func: function func() {
          var editMe = _this5.properties().getValue('editMe');
          return editMe();
        }
      });
      return _this5;
    }

    /**
     * @private
     * @returns {JQuery}
     */
    _inherits(CrlDistributionPointRow, _spandrel3);
    return _createClass(CrlDistributionPointRow, [{
      key: "$getTextArea",
      value: function $getTextArea() {
        return this.jq().find('textarea');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getDeleteButton",
      value: function $getDeleteButton() {
        return this.queryWidget('**/deleteButton');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getEditButton",
      value: function $getEditButton() {
        return this.queryWidget('**/editButton');
      }
    }]);
  }(spandrel(function (point, _ref2) {
    var self = _ref2.self;
    var toString = getPointDesc(point);
    return [spandrel.jsx("td", null, spandrel.jsx("textarea", {
      rows: "4",
      cols: "35",
      readOnly: true,
      spandrelKey: "pointTextArea"
    }, toString)), spandrel.jsx("td", null, spandrel.jsx(CommandButton, {
      tagName: "button",
      type: "button",
      className: "ux-btn-tb",
      spandrelKey: "editButton",
      value: self.$editCmd
    }), spandrel.jsx(CommandButton, {
      tagName: "button",
      type: "button",
      className: "ux-btn-tb",
      spandrelKey: "deleteButton",
      value: self.$deleteCmd
    }))];
  }, {
    strategy: 'niagara'
  }));
  /**
   * Widget for editing one point in the CRL Distribution Points extension
   * @class
   * @extends module:bajaux/Widget
   */
  var CrlDistributionPointEditor = /*#__PURE__*/function (_spandrel4) {
    function CrlDistributionPointEditor(params) {
      var _this6;
      _classCallCheck(this, CrlDistributionPointEditor);
      _this6 = _callSuper(this, CrlDistributionPointEditor, [{
        params: params,
        defaults: {
          properties: {
            rootCssClass: '-t-CrlDistributionPointsEditor-PointEditor'
          }
        }
      }]);
      _this6.$fullNamePopOut = new Command({
        module: 'platCrypto',
        lex: 'CrlDistributionPoints.commands.editFullNameSan',
        func: function func() {
          return _this6.$editSan(_this6.$getFullName(), platCryptoLex.get('CrlDistributionPoints.commands.editFullNameSan.title'));
        }
      });
      _this6.$crlIssuersPopOut = new Command({
        module: 'platCrypto',
        lex: 'CrlDistributionPoints.commands.editCrlIssuerSan',
        func: function func() {
          return _this6.$editSan(_this6.$getCrlIssuers(), platCryptoLex.get('CrlDistributionPoints.commands.editCrlIssuerSan.title'));
        }
      });
      _this6.$helpReasonsCommand = new HelpCommand({
        module: 'platCrypto',
        lex: 'CrlDistributionPoints.reasons.help',
        title: CRL_REASONS
      });
      _this6.$helpCrlIssuerCommand = new HelpCommand({
        module: 'platCrypto',
        lex: 'CrlDistributionPoints.crlIssuer.help',
        title: CRL_ISSUER
      });
      _this6.validators().add(function () {
        return Promise.all([_this6.$getFullName().read(), _this6.$getCrlIssuers().read()]).then(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2),
            fullName = _ref4[0],
            crlIssuers = _ref4[1];
          var fullNameVal = fullName && fullName.names && fullName.names.length > 0 ? fullName.names[0] : undefined;
          var crlIssuersVal = crlIssuers && crlIssuers.names && crlIssuers.names.length > 0 ? crlIssuers.names[0] : undefined;
          if (!(_this6.$validSan(fullNameVal) || _this6.$validSan(crlIssuersVal))) {
            throw new Error(platCryptoLex.get('CrlDistributionPoints.error.noFullNameCrlIssuer'));
          }
        });
      });
      return _this6;
    }

    /**
     * @private
     * @param {Object} entry a name object to see if is holding valid values
     * @returns {Boolean}
     */
    _inherits(CrlDistributionPointEditor, _spandrel4);
    return _createClass(CrlDistributionPointEditor, [{
      key: "$validSan",
      value: function $validSan(entry) {
        if (!entry) {
          return false;
        }
        var tagNo = entry.tagNo,
          value = entry.value;
        return !!tagNo && !!value;
      }

      /**
       * @private
       * @param {SubjectAlternativeNameEditor} sanEditor
       * @param {String} title the title for the dialog
       */
    }, {
      key: "$editSan",
      value: function $editSan(sanEditor, title) {
        return sanEditor.read().then(function (value) {
          return feDialogs.showFor({
            type: SubjectAlternativeNameEditor,
            value: value,
            formFactor: 'compact',
            properties: {
              enforceValidation: false
            },
            title: title
          });
        }).then(function (newValue) {
          if (!newValue) {
            return;
          }
          return sanEditor.loadAndModify(newValue);
        });
      }

      /**
       * @private
       * @returns {module:nmodule/platCrypto/rc/fe/extensions/SubjectAlternativeNameEditor}
       */
    }, {
      key: "$getFullName",
      value: function $getFullName() {
        return this.queryWidget('**/fullName');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getFullNameCmdBtn",
      value: function $getFullNameCmdBtn() {
        return this.queryWidget('**/fullNameCmdBtn');
      }

      /**
       * @private
       * @returns {module:nmodule/platCrypto/rc/fe/extensions/SubjectAlternativeNameEditor}
       */
    }, {
      key: "$getCrlIssuers",
      value: function $getCrlIssuers() {
        return this.queryWidget('**/crlIssuers');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getCrlIssuersCmdBtn",
      value: function $getCrlIssuersCmdBtn() {
        return this.queryWidget('**/crlIssuersCmdBtn');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getCrlIssuersHelpCommand",
      value: function $getCrlIssuersHelpCommand() {
        return this.queryWidget('**/crlIssuersHelpButton');
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/fe/baja/BooleanPicker}
       */
    }, {
      key: "$getReason",
      value: function $getReason() {
        return this.queryWidget('**/reasons');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getReasonHelpCommand",
      value: function $getReasonHelpCommand() {
        return this.queryWidget('**/reasonsHelpButton');
      }

      /**
       * @returns {Promise.<Object>} a CRL Distribution Point that has been updated or will be added
       */
    }, {
      key: "doRead",
      value: function doRead() {
        return Promise.all([this.$getFullName().read(), this.$getCrlIssuers().read(), this.$getReason().read()]).then(function (_ref5) {
          var _ref6 = _slicedToArray(_ref5, 3),
            fullNameVal = _ref6[0],
            crlIssuersVal = _ref6[1],
            reasonsArray = _ref6[2];
          var reasonsVal = 0;
          each(reasonsArray, function (reason) {
            reasonsVal |= indexToBitMask[reason];
          });
          return {
            fullName: fullNameVal.names,
            reasons: reasonsVal,
            crlIssuers: crlIssuersVal.names
          };
        });
      }
    }]);
  }(spandrel(function (point, _ref7) {
    var self = _ref7.self;
    var fullName = point.fullName,
      reasons = point.reasons,
      crlIssuers = point.crlIssuers;
    var selectedReasons = getSelectedReasons(reasons);
    return [spandrel.jsx("table", null, spandrel.jsx("tr", {
      className: "-t-fullNameRow"
    }, spandrel.jsx("td", {
      className: "-t-label"
    }, FULL_NAME), spandrel.jsx("td", null, spandrel.jsx(SubjectAlternativeNameEditor, {
      spandrelKey: "fullName",
      properties: {
        enforceValidation: false
      },
      value: {
        names: fullName
      },
      lax: true
    })), spandrel.jsx("td", {
      className: "-t-editButton"
    }, spandrel.jsx(CommandButton, {
      tagName: "button",
      type: "button",
      className: "ux-btn-tb",
      value: self.$fullNamePopOut,
      spandrelKey: "fullNameCmdBtn"
    }))), spandrel.jsx("tr", {
      className: "-t-reasonsRow"
    }, spandrel.jsx("td", {
      className: "-t-label"
    }, spandrel.jsx("div", {
      className: "-t-wrapper"
    }, spandrel.jsx("label", null, CRL_REASONS), spandrel.jsx(CommandButton, {
      className: "-t-HelpCommand",
      spandrelKey: "reasonsHelpButton",
      tagName: "span",
      value: self.$helpReasonsCommand
    }))), spandrel.jsx("td", {
      colSpan: "2"
    }, spandrel.jsx(BooleanPicker, {
      className: "-t-Reasons",
      spandrelKey: "reasons",
      value: selectedReasons,
      properties: {
        choices: choices
      }
    }))), spandrel.jsx("tr", {
      className: "-t-crlIssuersRow"
    }, spandrel.jsx("td", {
      className: "-t-label"
    }, spandrel.jsx("div", {
      className: "-t-wrapper"
    }, spandrel.jsx("label", null, CRL_ISSUER), spandrel.jsx(CommandButton, {
      className: "-t-HelpCommand",
      spandrelKey: "crlIssuersHelpButton",
      tagName: "span",
      value: self.$helpCrlIssuerCommand
    }))), spandrel.jsx("td", null, spandrel.jsx(SubjectAlternativeNameEditor, {
      spandrelKey: "crlIssuers",
      value: {
        names: crlIssuers
      },
      lax: true
    })), spandrel.jsx("td", {
      className: "-t-editButton"
    }, spandrel.jsx(CommandButton, {
      tagName: "button",
      type: "button",
      className: "ux-btn-tb",
      value: self.$crlIssuersPopOut,
      spandrelKey: "crlIssuersCmdBtn"
    }))))];
  }, {
    strategy: 'niagara'
  }));
  /**
   * Used to export the CrlDistributionPointEditor, mainly for testing
   * @type {CrlDistributionPointEditor}
   */
  CrlDistributionPointsEditor.$pointEditor = CrlDistributionPointEditor;
  return CrlDistributionPointsEditor;
});
