function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/fe/extensions/ExtendedKeyUsageEditor
 */
define(['bajaux/spandrel', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'bajaux/Widget', 'bajaux/widgets/ToStringWidget', 'lex!platCrypto', 'log!nmodule.platCrypto.rc.fe.extensions.ExtendedKeyUsageEditor', 'Promise', 'nmodule/platCrypto/rc/CertConstants', 'nmodule/webEditors/rc/fe/baja/BooleanPicker', 'nmodule/webEditors/rc/fe/baja/StringEditor', 'nmodule/webEditors/rc/wb/commands/HelpCommand'], function (spandrel, Command, CommandButton, Widget, ToStringWidget, lexs, log, Promise, CertConstants, BooleanPicker, StringEditor, HelpCommand) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];
  var EXTENDED_KEY_USAGE_COMMON_IDS = CertConstants.EXTENDED_KEY_USAGE_COMMON_IDS,
    _EXTENDED_KEY_USAGE_C = _slicedToArray(EXTENDED_KEY_USAGE_COMMON_IDS, 3),
    TLS_WEB_SERVER_AUTH = _EXTENDED_KEY_USAGE_C[0],
    TLS_WEB_CLIENT_AUTH = _EXTENDED_KEY_USAGE_C[1],
    CODE_SIGNING = _EXTENDED_KEY_USAGE_C[2];
  var logError = log.severe.bind(log);
  var miniFormFactor = Widget.formfactor.mini;
  var LEX_KEY = 'cert.field.ExtendedKeyUsage';
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-ExtendedKeyUsageEditor'
      }
    };
  };
  function getChoices() {
    return EXTENDED_KEY_USAGE_COMMON_IDS.map(function (keyPurposeId) {
      var display = platCryptoLex.get(LEX_KEY + '.' + keyPurposeId);
      return {
        display: display,
        value: keyPurposeId
      };
    });
  }
  function extractIds(keyPurposeIds) {
    var commonIds = [],
      customIds = [];
    keyPurposeIds.forEach(function (id) {
      if (EXTENDED_KEY_USAGE_COMMON_IDS.includes(id)) {
        commonIds.push(id);
      } else {
        customIds.push(id);
      }
    });
    return {
      commonIds: commonIds,
      customIds: customIds
    };
  }

  /**
   * CustomIds' container
   * 
   * @class
   * @extends module:bajaux/Widget
   */
  var CustomIds = /*#__PURE__*/function (_spandrel) {
    function CustomIds() {
      _classCallCheck(this, CustomIds);
      return _callSuper(this, CustomIds, arguments);
    }
    _inherits(CustomIds, _spandrel);
    return _createClass(CustomIds, [{
      key: "doRead",
      value:
      /**
       * @returns {Promise.<Array.<string>>} the current custom Ids
       */
      function doRead() {
        return Promise.all(this.$getCustomIdRows().map(function (row) {
          return row.read();
        }));
      }

      /**
       * @private
       * @returns {Array.<CustomIdRow>}
       */
    }, {
      key: "$getCustomIdRows",
      value: function $getCustomIdRows() {
        return this.queryWidgets('*');
      }

      /**
       * @private
       * @param {Number} i 
       * @returns {Promise}
       */
    }, {
      key: "$deleteCustomCmd",
      value: function $deleteCustomCmd(i) {
        var _this = this;
        return this.read().then(function (ids) {
          ids.splice(i, 1);
          return _this.load(ids);
        }).then(function () {
          return _this.setModified(true);
        });
      }
    }]);
  }(spandrel(function (ids, _ref) {
    var self = _ref.self;
    return ids.map(function (id, i) {
      return spandrel.jsx(CustomIdRow, {
        tagName: "tr",
        value: id,
        properties: {
          deleteMe: function deleteMe() {
            return self.$deleteCustomCmd(i);
          }
        }
      });
    });
  }));
  /**
   * Represents a single CustomId
   * 
   * @class
   * @extends module:bajaux/Widget
   */
  var CustomIdRow = /*#__PURE__*/function (_spandrel2) {
    function CustomIdRow() {
      var _this2;
      _classCallCheck(this, CustomIdRow);
      _this2 = _callSuper(this, CustomIdRow, arguments);
      _this2.$deleteCustomCmd = new Command({
        module: 'platCrypto',
        lex: 'NewCertForm.extension.commands.remove',
        func: function func() {
          var deleteMe = _this2.properties().getValue('deleteMe');
          return deleteMe();
        }
      });
      return _this2;
    }

    /**
     * @returns {String} custom Id value of this row
     */
    _inherits(CustomIdRow, _spandrel2);
    return _createClass(CustomIdRow, [{
      key: "doRead",
      value: function doRead() {
        return this.$getCustomIdWidget().read();
      }

      /**
       * @private
       * @returns {module:bajaux/Widget} the readonly string editor for custom id
       */
    }, {
      key: "$getCustomIdWidget",
      value: function $getCustomIdWidget() {
        return this.queryWidget('**/customId');
      }

      /**
      * @private
      * @returns {module:bajaux/util/CommandButton}
      */
    }, {
      key: "$getDeleteButton",
      value: function $getDeleteButton() {
        return this.queryWidget('**/deleteButton');
      }
    }]);
  }(spandrel(function (id, _ref2) {
    var self = _ref2.self;
    return [spandrel.jsx("td", null, spandrel.jsx(ToStringWidget, {
      value: id,
      spandrelKey: "customId"
    })), spandrel.jsx("td", null, spandrel.jsx(CommandButton, {
      className: "ux-btn-tb",
      spandrelKey: "deleteButton",
      value: self.$deleteCustomCmd
    }))];
  }));
  /**
   * Compact editor for editing a new certificates extensions
   *
   * @class
   * @alias module:nmodule/platCrypto/rc/fe/extensions/ExtendedKeyUsageEditor
   * @extends module:bajaux/spandrel/SpandrelWidget
   */
  return /*#__PURE__*/function (_spandrel3) {
    function ExtendedKeyUsageEditor(params) {
      var _this3;
      _classCallCheck(this, ExtendedKeyUsageEditor);
      _this3 = _callSuper(this, ExtendedKeyUsageEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this3.$addCustomCmd = new Command({
        module: 'platCrypto',
        lex: 'cert.extendedKeyUsage.commands.addCustom',
        enabled: false,
        func: function func() {
          return Promise.all([_this3.$getCustomIdsEditor().read(), _this3.$getCustomIdInput().read()]).then(function (_ref3) {
            var _ref4 = _slicedToArray(_ref3, 2),
              existingCustomIds = _ref4[0],
              newCustomId = _ref4[1];
            return _this3.$getCustomIdsEditor().render([].concat(_toConsumableArray(existingCustomIds), [newCustomId]))["catch"](logError);
          }).then(function () {
            return _this3.$getCustomIdInput().loadAndModify('');
          });
        }
      });
      _this3.$helpCmd = new HelpCommand({
        module: 'platCrypto',
        lex: 'cert.extendedKeyUsage.commands.addCustom.help',
        title: platCryptoLex.get('cert.extendedKeyUsage.commands.addCustom.displayName')
      });
      return _this3;
    }
    _inherits(ExtendedKeyUsageEditor, _spandrel3);
    return _createClass(ExtendedKeyUsageEditor, [{
      key: "doRead",
      value: function doRead() {
        if (!this.$getCustomIdsEditor()) {
          return Promise.resolve(this.value());
        }
        return Promise.all([this.$getPicker().read(), this.$getCustomIdsEditor().read()]).then(function (_ref5) {
          var _ref6 = _slicedToArray(_ref5, 2),
            commonIds = _ref6[0],
            customIds = _ref6[1];
          return {
            'purposes': [].concat(_toConsumableArray(commonIds), _toConsumableArray(customIds))
          };
        });
      }

      /**
       * @private
       * @param {Array.<String>} ids 
       * @returns{String}
       */
    }, {
      key: "$getPreviewText",
      value: function $getPreviewText(ids) {
        return ids.map(function (id) {
          return EXTENDED_KEY_USAGE_COMMON_IDS.includes(id) ? platCryptoLex.get(LEX_KEY + '.' + id) : id;
        }).join(', ');
      }

      /**
       * @private
       * @param {String} currentValue 
       */
    }, {
      key: "$validateCustomId",
      value: function $validateCustomId(currentValue) {
        var customIdRegex = /^\d+(\.\d+)+$/g;
        var addCmd = this.$getAddCustomButton().value();
        addCmd.setEnabled(customIdRegex.test(currentValue));
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/fe/baja/BooleanPicker}
       */
    }, {
      key: "$getPicker",
      value: function $getPicker() {
        return this.queryWidget('0');
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/fe/baja/StringEditor}
       */
    }, {
      key: "$getCustomIdInput",
      value: function $getCustomIdInput() {
        return this.queryWidget('**/customIdInput');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getCustomIdsEditor",
      value: function $getCustomIdsEditor() {
        return this.queryWidget('**/customIds');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getAddCustomButton",
      value: function $getAddCustomButton() {
        return this.queryWidget('**/addButton');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getHelpButton",
      value: function $getHelpButton() {
        return this.queryWidget('**/helpButton');
      }

      /**
       * @private
       * @param {String} certUsage
       * @returns {Promise}
       */
    }, {
      key: "$certificateChanged",
      value: function $certificateChanged(certUsage) {
        var certUsageToDefault = {
          server: [TLS_WEB_SERVER_AUTH, TLS_WEB_CLIENT_AUTH],
          client: [TLS_WEB_CLIENT_AUTH],
          codeSigning: [CODE_SIGNING]
        };
        var purposes = certUsageToDefault[certUsage];
        if (purposes) {
          return this.loadAndModify({
            purposes: purposes
          });
        }
        return Promise.resolve();
      }
    }]);
  }(spandrel(function (value, _ref7) {
    var self = _ref7.self,
      formFactor = _ref7.formFactor,
      writable = _ref7.writable;
    var choices = getChoices();
    var purposes = value && value.purposes || [];
    var _ref8 = extractIds(purposes) || {},
      commonIds = _ref8.commonIds,
      customIds = _ref8.customIds;
    var isMini = formFactor === miniFormFactor;
    if (!writable || isMini) {
      var _toString = self.$getPreviewText([].concat(_toConsumableArray(commonIds), _toConsumableArray(customIds)));
      return [spandrel.jsx("textarea", {
        rows: "4",
        cols: "35",
        readOnly: true
      }, _toString)];
    }
    return [spandrel.jsx(BooleanPicker, {
      value: commonIds,
      properties: {
        choices: choices
      }
    }), spandrel.jsx("table", {
      "class": "ux-table"
    }, spandrel.jsx("tr", null, spandrel.jsx("td", null, spandrel.jsx(StringEditor, {
      spandrelKey: "customIdInput",
      onUxModifiedValue: function onUxModifiedValue(newString) {
        return self.$validateCustomId(newString);
      }
    })), spandrel.jsx("td", null, spandrel.jsx("div", {
      className: "-t-wrapper"
    }, spandrel.jsx(CommandButton, {
      tagName: "button",
      type: "button",
      className: "ux-btn",
      value: self.$addCustomCmd,
      spandrelKey: "addButton"
    }), spandrel.jsx(CommandButton, {
      className: "-t-HelpCommand",
      spandrelKey: "helpButton",
      tagName: "span",
      value: self.$helpCmd
    }))))), spandrel.jsx(CustomIds, {
      value: customIds,
      spandrelKey: "customIds"
    })];
  }));
});
