function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/fe/extensions/SubjectAlternativeNameEditor
 */
define(['lex!platCrypto', 'underscore', 'bajaux/spandrel', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'Promise', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/wb/commands/HelpCommand', 'css!nmodule/platCrypto/rc/platCrypto'], function (lexs, _, spandrel, Command, CommandButton, Promise, Widget, feDialogs, OrderedMapEditor, HelpCommand) {
  'use strict';

  var miniFormFactor = Widget.formfactor.mini;
  var DEFAULT_SAN = {
    names: [{
      "tagNo": 2,
      "value": ""
    }]
  };
  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];

  //NCCB-57326 Other Cert Products remove these, so we will too: 0-OtherName, 3-X400Address, 5-EDIPartyName
  var tags = [1, 2, 4, 6, 7, 8];
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-SubjectAlternativeNameEditor',
        enforceValidation: true
      }
    };
  };
  var isArray = _.isArray,
    isEmpty = _.isEmpty;
  function getHelpCommand(tagId) {
    return new HelpCommand({
      module: 'platCrypto',
      lex: 'cert.field.san.' + tagId + '.help',
      title: platCryptoLex.get('cert.field.san.' + tagId)
    });
  }

  /**
   * Compact editor for editing the fields of a Subject Alternative Name.
   *
   * It supports the following bajaux Properties:
   *
   * - `enforceValidation`: defaults to true, can be set to false to skip validation.
   *
   * @class
   * @alias module:nmodule/platCrypto/rc/fe/SubjectAlternativeNameEditor
   * @extends module:bajaux/Widget
   * @since Niagara 4.13
   */
  var SubjectAlternativeNameEditor = /*#__PURE__*/function (_spandrel) {
    function SubjectAlternativeNameEditor(params) {
      var _this;
      _classCallCheck(this, SubjectAlternativeNameEditor);
      _this = _callSuper(this, SubjectAlternativeNameEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$addCmd = new Command({
        module: 'platCrypto',
        lex: 'SubjectAlternativeName.commands.addIdentity',
        func: function func() {
          return _this.$promptForNewSAN().then(function (newTuple) {
            return newTuple && _this.$addSAN(newTuple);
          });
        }
      });
      return _this;
    }

    /**
     * @returns {Promise.<string>}
     */
    _inherits(SubjectAlternativeNameEditor, _spandrel);
    return _createClass(SubjectAlternativeNameEditor, [{
      key: "doRead",
      value: function doRead() {
        var _this2 = this;
        if (this.getFormFactor() === 'mini') {
          return Promise.resolve(this.value());
        }
        return this.$getTuplesSection().read().then(function (tuples) {
          return _this2.$convertToObj(tuples);
        });
      }

      /**
       * @private
       * @param {object|Tuples} value
       * @throws {Error} if SAN extension is invalid
       */
    }, {
      key: "$validateSAN",
      value: function $validateSAN(value) {
        var _value = value,
          names = _value.names;
        if (names && isArray(names)) {
          value = this.$getTuples(names);
        }
        // Validate if SAN extension has no identity or has an empty DNS Name
        if (isEmpty(value)) {
          throw new Error(platCryptoLex.get("NewCertForm.extension.type.san.identity.required"));
        } else {
          var _ref = value.find(function (_ref3) {
              var _ref4 = _slicedToArray(_ref3, 1),
                tagNo = _ref4[0];
              return String(tagNo) === '2';
            }) || [],
            _ref2 = _slicedToArray(_ref, 2),
            dnsTag = _ref2[0],
            dnsVal = _ref2[1];
          if (dnsTag && isEmpty(dnsVal)) {
            throw new Error(platCryptoLex.get("NewCertForm.extension.type.san.dnsName.required"));
          }
        }
      }

      /**
       * @private
       * @returns {Promise.<Array.<string>>} resolves to a new tuple
       */
    }, {
      key: "$promptForNewSAN",
      value: function $promptForNewSAN() {
        return feDialogs.showFor({
          value: ['', ''],
          type: AddRowPrompt
        });
      }

      /**
       * @private
       * @param {Array.<string>} newTuple new tuple to add
       * @returns {Promise}
       */
    }, {
      key: "$addSAN",
      value: function $addSAN(newTuple) {
        var _this3 = this;
        if (!newTuple.join('')) {
          return Promise.resolve();
        }
        return this.$getTuplesSection().read().then(function (tuples) {
          return _this3.render(_this3.$convertToObj([].concat(_toConsumableArray(tuples), [newTuple])));
        }).then(function () {
          return _this3.setModified(true);
        });
      }

      /**
       * @private
       * @param {Array.<string>} tuples to convert to object
       * @returns {Object}
       */
    }, {
      key: "$convertToObj",
      value: function $convertToObj(tuples) {
        tuples = tuples.map(function (tuple) {
          return {
            "tagNo": tuple[0],
            value: tuple[1]
          };
        });
        return {
          "names": tuples
        };
      }

      /**
       * @private
       * @param {Array} namesArr array to convert to Preview Text
       * @returns {string}
       */
    }, {
      key: "$getPreviewText",
      value: function $getPreviewText(namesArr) {
        return namesArr.map(function (name) {
          return tags.contains(parseInt(name.tagNo)) ? platCryptoLex.get('cert.field.san.' + name.tagNo) + ":" + name.value : "";
        }).join(", ");
      }

      /**
       * @private
       * @param {Array} namesArr array to convert to tuples
       * @returns {Array} key value pair tuples
       */
    }, {
      key: "$getTuples",
      value: function $getTuples(namesArr) {
        return namesArr.map(function (name) {
          var _ref5 = [name.tagNo, name.value],
            key = _ref5[0],
            value = _ref5[1];
          return [unescape(key), unescape(value)];
        });
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getTuplesSection",
      value: function $getTuplesSection() {
        return this.queryWidget('tuples');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getAddButton",
      value: function $getAddButton() {
        return this.queryWidget('addButton');
      }
    }]);
  }(spandrel(function (value, _ref6) {
    var self = _ref6.self,
      formFactor = _ref6.formFactor,
      writable = _ref6.writable,
      properties = _ref6.properties;
    value = value && value.names ? value : DEFAULT_SAN;
    var isMini = formFactor === miniFormFactor;
    var enforceValidation = properties.enforceValidation;
    if (!writable || isMini) {
      var _toString = self.$getPreviewText(value.names);
      return [spandrel.jsx("textarea", {
        rows: "4",
        cols: "35",
        readOnly: true
      }, _toString)];
    }
    return [spandrel.jsx(Tuples, {
      tagName: "table",
      className: "-t-SubjectAlternativeNameEditor-Tuples",
      value: self.$getTuples(value.names),
      lax: true,
      spandrelKey: "tuples",
      onUxModify: function onUxModify() {
        return self.rerender();
      },
      validate: function validate(value) {
        return enforceValidation && self.$validateSAN(value);
      }
    }), spandrel.jsx(CommandButton, {
      tagName: "button",
      type: "button",
      className: "ux-btn",
      value: self.$addCmd,
      spandrelKey: "addButton"
    })];
  }, {
    strategy: 'niagara'
  }));
  /**
   * Widget that holds the rows for the individual fields of the SAN.
   * @class
   * @extends module:bajaux/Widget
   */
  var Tuples = /*#__PURE__*/function (_spandrel2) {
    function Tuples() {
      _classCallCheck(this, Tuples);
      return _callSuper(this, Tuples, arguments);
    }
    _inherits(Tuples, _spandrel2);
    return _createClass(Tuples, [{
      key: "doRead",
      value:
      /**
       * @returns {Promise.<Array.<string>>} the current tuples in the SAN
       */
      function doRead() {
        return Promise.all(this.$getTupleRows().map(function (row) {
          return row.read();
        }));
      }

      /**
       * @private
       * @param {number} i the index to delete
       * @returns {Promise}
       */
    }, {
      key: "$deleteRow",
      value: function $deleteRow(i) {
        var _this4 = this;
        return this.read().then(function (tuples) {
          tuples.splice(i, 1);
          return _this4.load(tuples);
        }).then(function () {
          return _this4.setModified(true);
        });
      }

      /**
       * @private
       * @returns {Array.<TupleRow>}
       */
    }, {
      key: "$getTupleRows",
      value: function $getTupleRows() {
        return this.queryWidgets('*');
      }
    }]);
  }(spandrel(function (tuples, _ref7) {
    var self = _ref7.self;
    return tuples.map(function (tuple, i) {
      return spandrel.jsx(TupleRow, {
        tagName: "tr",
        value: tuple,
        properties: {
          deleteMe: function deleteMe() {
            return self.$deleteRow(i);
          }
        }
      });
    });
  }));
  /**
   * Widget for editing one SAN tuple in the SAN tuples.
   * @class
   * @extends module:bajaux/Widget
   */
  var TupleRow = /*#__PURE__*/function (_spandrel3) {
    function TupleRow() {
      var _this5;
      _classCallCheck(this, TupleRow);
      _this5 = _callSuper(this, TupleRow, arguments);
      _this5.$deleteCmd = new Command({
        module: 'platCrypto',
        lex: 'SubjectAlternativeName.commands.removeIdentity',
        func: function func() {
          var deleteMe = _this5.properties().getValue('deleteMe');
          return deleteMe();
        }
      });
      var editor = _this5;
      _this5.$helpCmd = new Command({
        module: 'webEditors',
        lex: 'commands.help',
        func: function func() {
          return editor.read().then(function (_ref8) {
            var _ref9 = _slicedToArray(_ref8, 1),
              tagId = _ref9[0];
            return getHelpCommand(tagId).invoke();
          });
        }
      });
      return _this5;
    }

    /**
     * @returns {Promise.<Array.<string>>} the tuple entered in this row
     */
    _inherits(TupleRow, _spandrel3);
    return _createClass(TupleRow, [{
      key: "doRead",
      value: function doRead() {
        var _this$value = this.value(),
          _this$value2 = _slicedToArray(_this$value, 1),
          key = _this$value2[0];
        return this.$getValueEditor().read().then(function (value) {
          return [key, value];
        });
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getLabel",
      value: function $getLabel() {
        return this.queryWidget('**/label').jq();
      }

      /**
       * @private
       * @returns {module:bajaux/Widget} the string editor for the tuple value
       */
    }, {
      key: "$getValueEditor",
      value: function $getValueEditor() {
        return this.queryWidget('**/input');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getDeleteButton",
      value: function $getDeleteButton() {
        return this.queryWidget('**/deleteButton');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getHelpButton",
      value: function $getHelpButton() {
        return this.queryWidget('**/helpButton');
      }
    }]);
  }(spandrel(function (tuple, _ref10) {
    var self = _ref10.self;
    var _tuple = _slicedToArray(tuple, 2),
      key = _tuple[0],
      value = _tuple[1];
    return [spandrel.jsx("td", null, spandrel.jsx("div", {
      className: "-t-wrapper"
    }, spandrel.jsx("label", {
      spandrelKey: "label"
    }, platCryptoLex.get('cert.field.san.' + key)), spandrel.jsx(CommandButton, {
      className: "-t-HelpCommand",
      spandrelKey: "helpButton",
      tagName: "span",
      value: self.$helpCmd
    }))), spandrel.jsx("td", null, spandrel.jsx("any", {
      spandrelKey: "input",
      value: value
    })), spandrel.jsx("td", null, spandrel.jsx(CommandButton, {
      tagName: "button",
      type: "button",
      className: "ux-btn-tb",
      spandrelKey: "deleteButton",
      value: self.$deleteCmd
    }))];
  }, {
    strategy: 'niagara'
  }));
  /**
   * The widget that is shown in a dialog to prompt the user for a new tuple when the Add button is clicked.
   * @class
   * @extends module:bajaux/Widget
   */
  var AddRowPrompt = /*#__PURE__*/function (_spandrel4) {
    function AddRowPrompt(params) {
      var _this6;
      _classCallCheck(this, AddRowPrompt);
      _this6 = _callSuper(this, AddRowPrompt, [{
        params: params,
        defaults: {
          properties: {
            rootCssClass: '-t-SubjectAlternativeNameEditor-AddPrompt'
          }
        }
      }]);
      var editor = _this6;
      editor.$helpCmd = new Command({
        module: 'webEditors',
        lex: 'commands.help',
        func: function func() {
          return editor.read().then(function (_ref11) {
            var _ref12 = _slicedToArray(_ref11, 1),
              tagId = _ref12[0];
            return getHelpCommand(tagId).invoke();
          });
        }
      });
      return _this6;
    }

    /**
     * @private
     * @returns {module:bajaux/Widget}
     */
    _inherits(AddRowPrompt, _spandrel4);
    return _createClass(AddRowPrompt, [{
      key: "$getKeyEditor",
      value: function $getKeyEditor() {
        return this.queryWidget('**/key');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getValueEditor",
      value: function $getValueEditor() {
        return this.queryWidget('value');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getHelpButton",
      value: function $getHelpButton() {
        return this.queryWidget('**/helpButton');
      }

      /**
       * @returns {Promise.<Array.<string>>} the new tuple to add
       */
    }, {
      key: "doRead",
      value: function doRead() {
        return Promise.all([this.$getKeyEditor().read(), this.$getValueEditor().read()]);
      }
    }]);
  }(spandrel(function (tuple, _ref13) {
    var self = _ref13.self;
    var _tuple2 = _slicedToArray(tuple, 2),
      key = _tuple2[0],
      value = _tuple2[1];
    var map = {};
    tags.forEach(function (tag, index) {
      map[platCryptoLex.get('cert.field.san.' + tag)] = tag;
    });
    return [spandrel.jsx("label", null, platCryptoLex.get('SubjectAlternativeName.commands.add.type')), spandrel.jsx("span", {
      className: "-t-wrapper"
    }, spandrel.jsx(OrderedMapEditor, {
      tagName: "span",
      spandrelKey: "key",
      value: key,
      validate: true,
      onUxModify: function onUxModify() {
        return self.rerender();
      },
      properties: {
        map: map
      }
    }), spandrel.jsx(CommandButton, {
      spandrelKey: "helpButton",
      className: "-t-HelpCommand",
      tagName: "span",
      value: self.$helpCmd
    })), spandrel.jsx("label", null, platCryptoLex.get('SubjectAlternativeName.commands.add.value')), spandrel.jsx("any", {
      spandrelKey: "value",
      value: value
    })];
  }, {
    strategy: 'niagara'
  }));
  SubjectAlternativeNameEditor.DEFAULT_SAN = DEFAULT_SAN;
  return SubjectAlternativeNameEditor;
});
