function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/*eslint-env browser */
/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/wb/cert/CertManager
 */
define(['baja!', 'lex!platCrypto', 'log!nmodule.platCrypto.rc.wb.cert.CertManager', 'bajaux/spandrel', 'bajaux/commands/ToggleCommandGroup', 'bajaux/util/CommandButtonGroup', 'Promise', 'underscore', 'nmodule/platCrypto/rc/rpc/certManagement', 'nmodule/platCrypto/rc/wb/cert/certManagerEvents', 'nmodule/platCrypto/rc/wb/cert/tabs/SystemTrustStoreTab', 'nmodule/platCrypto/rc/wb/cert/tabs/UserExemptionStoreTab', 'nmodule/platCrypto/rc/wb/cert/tabs/UserKeyStoreTab', 'nmodule/platCrypto/rc/wb/cert/tabs/UserTrustStoreTab', 'nmodule/webEditors/rc/wb/profile/profileUtils', 'css!nmodule/platCrypto/rc/platCrypto'], function (baja, lexs, log, spandrel, ToggleCommandGroup, CommandButtonGroup, Promise, _, certManagement, certManagerEvents, SystemTrustStoreTab, UserExemptionStoreTab, UserKeyStoreTab, UserTrustStoreTab, profileUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-CertManager'
      }
    };
  };
  var headerText = function headerText() {
    if (baja.isOffline()) {
      return profileUtils.resolveBrandTitle().then(function (brandTitle) {
        //existing lexicon entry, otherwise this should pass the brandTitle as an argument
        return platCryptoLex.get('CertManagerView.longTitle') + " " + brandTitle;
      });
    } else {
      return platCryptoLex.get('CertManagerView.longTitle') + " \"" + window.location.hostname + "\"";
    }
  };
  var headerTextOnce = _.once(headerText);
  var logSevere = log.severe.bind(log);

  /**
   * @class
   * @extends module:bajaux/Widget
   * @alias module:nmodule/platCrypto/rc/wb/cert/CertManager
   */
  var CertManager = /*#__PURE__*/function (_spandrel) {
    function CertManager(params) {
      var _this;
      _classCallCheck(this, CertManager);
      _this = _callSuper(this, CertManager, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$tabSwitchCommands = new ToggleCommandGroup({
        commands: [{
          displayName: platCryptoLex.get('cert.view.tab.title'),
          value: 'userKeyStore',
          selected: true
        }, {
          displayName: platCryptoLex.get('systemcacert.view.tab.title'),
          value: 'systemTrustStore'
        }, {
          displayName: platCryptoLex.get('usercacert.view.tab.title'),
          value: 'userTrustStore'
        }, {
          displayName: platCryptoLex.get('exempt.view.tab.title'),
          value: 'userExemptionStore'
        }],
        onChange: function onChange(cryptoStoreId) {
          return _this.state({
            visibleStoreId: cryptoStoreId
          });
        }
      });
      return _this;
    }
    _inherits(CertManager, _spandrel);
    return _createClass(CertManager, [{
      key: "toState",
      value: function toState() {
        return {
          visibleStoreId: 'userKeyStore'
        };
      }
    }, {
      key: "doLoad",
      value: function doLoad() {
        var _this2 = this;
        return _superPropGet(CertManager, "doLoad", this, 3)(arguments).then(function () {
          if (!_this2.$isSecure()) {
            return;
          }
          registerRefreshOnTab(_this2, 'userKeyStore');
          registerRefreshOnTab(_this2, 'systemTrustStore');
          registerRefreshOnTab(_this2, 'userTrustStore');
          registerRefreshOnTab(_this2, 'userExemptionStore');
        });
      }

      /**
       * @private
       * @returns {Promise.<String>}
       */
    }, {
      key: "$headerTextOnce",
      value: function $headerTextOnce() {
        return headerTextOnce();
      }

      /**
       * @private
       * @returns {Promise.<String>}
       */
    }, {
      key: "$headerText",
      value: function $headerText() {
        return headerText();
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getHeader",
      value: function $getHeader() {
        return this.queryWidget('wrapper/header');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButtonGroup}
       */
    }, {
      key: "$getTabSwitcher",
      value: function $getTabSwitcher() {
        return this.queryWidget('wrapper/tabSwitcher');
      }

      /**
       * @private
       * @returns {Array.<module:nmodule/platCrypto/rc/wb/cert/CertManagerTab>}
       */
    }, {
      key: "$getTabs",
      value: function $getTabs() {
        return this.queryWidgets('wrapper/tabs/*');
      }

      /**
       * @private
       * @returns {boolean}
       */
    }, {
      key: "$isSecure",
      value: function $isSecure() {
        return this.$isProtocolSecure() || baja.isOffline();
      }

      /**
       * @private
       * @returns {boolean}
       */
    }, {
      key: "$isProtocolSecure",
      value: function $isProtocolSecure() {
        var HTTPS = /^https:$/i;
        return !!HTTPS.exec(location.protocol);
      }
    }]);
  }(spandrel(function (certManagerService, _ref) {
    var self = _ref.self,
      visibleStoreId = _ref.visibleStoreId;
    function hideIfNot(storeId) {
      return {
        display: storeId !== visibleStoreId && 'none'
      };
    }
    if (!self.$isSecure()) {
      return spandrel.jsx("span", {
        "class": "-t-CertManager-error"
      }, platCryptoLex.get('UxCertManager.error.insecure'));
    } else {
      return Promise.all([certManagement.getCertStoreData('userKeyStore'), certManagement.getCertStoreData('systemTrustStore'), certManagement.getCertStoreData('userTrustStore'), certManagement.getCertStoreData('userExemptionStore'), self.$headerTextOnce()]).then(function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 5),
          userKeyStoreData = _ref3[0],
          systemTrustStoreData = _ref3[1],
          userTrustStoreData = _ref3[2],
          userExemptionStoreData = _ref3[3],
          headerText = _ref3[4];
        return [spandrel.jsx("div", {
          spandrelKey: "wrapper",
          className: "-t-CertManager-wrapper"
        }, spandrel.jsx("div", {
          spandrelKey: "header",
          className: "-t-CertManager-header"
        }, headerText), spandrel.jsx(CommandButtonGroup, {
          value: self.$tabSwitchCommands,
          spandrelKey: "tabSwitcher",
          className: "-t-CertManager-tabSwitcher ux-toggle-btn-group"
        }), spandrel.jsx("div", {
          spandrelKey: "tabs",
          className: "-t-CertManager-tabContainer ux-select-none"
        }, spandrel.jsx(UserKeyStoreTab, {
          className: "-t-CertManager-tab",
          spandrelKey: "userKeyStore",
          value: userKeyStoreData,
          style: hideIfNot('userKeyStore')
        }), spandrel.jsx(SystemTrustStoreTab, {
          className: "-t-CertManager-tab",
          spandrelKey: "systemTrustStore",
          value: systemTrustStoreData,
          style: hideIfNot('systemTrustStore')
        }), spandrel.jsx(UserTrustStoreTab, {
          className: "-t-CertManager-tab",
          spandrelKey: "userTrustStore",
          value: userTrustStoreData,
          style: hideIfNot('userTrustStore')
        }), spandrel.jsx(UserExemptionStoreTab, {
          className: "-t-CertManager-tab",
          spandrelKey: "userExemptionStore",
          value: userExemptionStoreData,
          style: hideIfNot('userExemptionStore')
        })))];
      });
    }
  }));
  function registerRefreshOnTab(mgr, storeKey) {
    var tab = mgr.queryWidget("**/tabs/".concat(storeKey));
    tab.on(certManagerEvents.REFRESH_EVENT, function () {
      certManagement.getCertStoreData(storeKey).then(function (data) {
        return tab.load(data);
      })["catch"](logSevere);
    });
  }
  return CertManager;
});
