function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

define(['baja!', 'dialogs', 'lex!platCrypto', 'Promise', 'underscore', 'bajaux/commands/Command', 'nmodule/platCrypto/rc/CertConstants', 'nmodule/platCrypto/rc/rpc/certManagement', 'nmodule/platCrypto/rc/wb/cert/certManagerEvents', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/util/userUtils'], function (baja, dialogs, lexs, Promise, _, Command, CertConstants, certManagement, certManagerEvents, feDialogs, userUtils) {
  'use strict';

  var Password = require('bajaScript/baja/obj/Password');
  var REFRESH_EVENT = certManagerEvents.REFRESH_EVENT;
  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];
  var DEFAULT_ALIAS = CertConstants.DEFAULT_ALIAS;
  function deleteCert(tab, storeType, alias, password) {
    var selection = tab.getTable().$getSelection();
    return certManagement.deleteCertStoreData(storeType, [alias], password)["catch"](feDialogs.error)["finally"](function () {
      tab.emit(REFRESH_EVENT);
      selection.clear();
    });
  }

  /**
   * A command for deleting a certificate.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/platCrypto/rc/wb/cert/commands/CertDeleteCommand
   */
  var DeleteCertCommand = /*#__PURE__*/function (_Command) {
    /**
     * @param {module:nmodule/platCrypto/rc/wb/cert/CertManagerTab} tab the tab
     * to arm this command against
     * @param {Object} params
     * @param {String} params.storeType the store type to delete from
     * @param {Object} params.dialogParams params to be passed to the confirmation dialog @see dialogs.showOkCancel
     */
    function DeleteCertCommand(tab, _ref) {
      var _this;
      var storeType = _ref.storeType,
        _ref$dialogParams = _ref.dialogParams,
        dialogParams = _ref$dialogParams === void 0 ? {} : _ref$dialogParams;
      _classCallCheck(this, DeleteCertCommand);
      _this = _callSuper(this, DeleteCertCommand, [{
        module: 'platCrypto',
        lex: 'cert.button.delete',
        enabled: false,
        func: function func() {
          // Only one row can be selected for delete
          var selectedRow = tab.getTable().getSelectedRows()[0];
          var isDefaultCert = false;
          if (selectedRow.getSubject().alias.toLowerCase() === DEFAULT_ALIAS) {
            isDefaultCert = true;
          }
          if (isDefaultCert) {
            return dialogs.showOk({
              title: platCryptoLex.get('cert.delete.default.title'),
              text: platCryptoLex.get('cert.delete.default.info')
            });
          } else {
            return dialogs.showOkCancel(dialogParams).promise().then(function (_ref2) {
              var _ref3 = _slicedToArray(_ref2, 2),
                dlg = _ref3[0],
                buttonClicked = _ref3[1];
              if (buttonClicked === 'ok') {
                var selectedAlias = selectedRow.getSubject().alias;
                return _this.$promptForPassword(selectedAlias, storeType).then(function (password) {
                  if (password === null) {
                    return; //password required, but user pressed cancel
                  }
                  return deleteCert(tab, storeType, selectedAlias, password ? password.encodeToString() : '');
                });
              }
            });
          }
        }
      }]);
      var table;
      var selectionChanged = function selectionChanged() {
        _this.setEnabled(_this.$defaultEnabled && table.getSelectedRows().length === 1);
      };
      /**
       * Resolves to true if offline or if online and the current user is a super user.
       * @returns {Promise.<Boolean>}
       */
      _this.isSuperUserOrOffline = _.once(function () {
        return userUtils.isSuperUserOrOffline();
      });
      tab.on('loaded', function () {
        if (table) {
          table.$getSelection().off('changed', selectionChanged);
        }
        table = tab.getTable();
        table.$getSelection().on('changed', selectionChanged);
        return _this.$setDefaultEnabled(tab);
      });
      return _this;
    }

    /**
     * Check the tab to see if it provides the superuser and sets defaultEnabled if it has not been previously set
     * @private
     * @param {module:nmodule/platCrypto/rc/wb/cert/CertManagerTab} tab the tab this is a child of
     * @return {Promise.<boolean>}
     */
    _inherits(DeleteCertCommand, _Command);
    return _createClass(DeleteCertCommand, [{
      key: "$setDefaultEnabled",
      value: function $setDefaultEnabled(tab) {
        var _this2 = this;
        if (this.$defaultEnabled === undefined) {
          if (typeof tab.isCertDeleteEnabled === 'function') {
            return tab.isCertDeleteEnabled().then(function (returnVal) {
              _this2.$defaultEnabled = returnVal;
              return _this2.$defaultEnabled;
            });
          }

          // if the wb is in offline mode / if the tab does not have a isSuperUserOrOffline function, we want the default to be enabled
          this.$defaultEnabled = true;
        }
        return Promise.resolve(this.$defaultEnabled);
      }

      /**
       * @private
       * @param {String} alias
       * @param {String} storeType
       * @return {Promise}
       */
    }, {
      key: "$promptForPassword",
      value: function $promptForPassword(alias, storeType) {
        return this.isSuperUserOrOffline().then(function (isSuper) {
          if (storeType !== "userKeyStore" || isSuper) {
            return;
          }
          return certManagement.isPasswordRequired(alias).then(function (passwordRequired) {
            if (passwordRequired) {
              return feDialogs.showFor({
                value: Password.DEFAULT,
                formFactor: 'mini',
                title: platCryptoLex.get('cert.password.required.dialog.title'),
                summary: platCryptoLex.get('cert.password.required.dialog.message', alias),
                properties: {
                  prelabel: platCryptoLex.get('cert.password.prelabel'),
                  rootCssClass: '-t-CertPasswordDialog'
                }
              });
            }
          });
        });
      }
    }]);
  }(Command);
  return DeleteCertCommand;
});
