function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/wb/cert/commands/CertExportCommand
 */
define(['baja!', 'lex!platCrypto', 'Promise', 'bajaux/commands/Command', 'nmodule/platCrypto/rc/rpc/certManagement', 'nmodule/platCrypto/rc/wb/cert/commands/CertExportWidget', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/util/fileUtils'], function (baja, lexs, Promise, Command, certManagement, CertExportWidget, feDialogs, fileUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];

  /**
   * A command for exporting a certificate.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/platCrypto/rc/wb/cert/commands/CertExportCommand
   */
  return /*#__PURE__*/function (_Command) {
    /**
     * @param {module:nmodule/platCrypto/rc/wb/cert/CertManagerTab} tab the tab
     * to arm this command against
     * @param {string} keyStoreName the name of the keystore that is being referenced
     * @param {boolean} [hidePassword=false] should the password section of widget be hidden
     */
    function CertExportCommand(tab, keyStoreName) {
      var _this;
      var hidePassword = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      _classCallCheck(this, CertExportCommand);
      if (!keyStoreName) {
        throw new Error("Key Store name required");
      }
      _this = _callSuper(this, CertExportCommand, [{
        module: "platCrypto",
        lex: 'cert.button.export',
        enabled: false,
        func: function func() {
          var _tab$getTable$getSele = tab.getTable().getSelectedRows(),
            _tab$getTable$getSele2 = _slicedToArray(_tab$getTable$getSele, 1),
            row = _tab$getTable$getSele2[0];
          var exportRequest = {
            cert: row.getSubject(),
            exportPublic: true,
            exportPrivate: false,
            encryptPrivate: true,
            encryptPassword: baja.$('baja:Password'),
            decryptPassword: baja.$('baja:Password'),
            reusePassword: true
          };
          return _this.$isDecryptPasswordReqd(exportRequest.cert.alias).then(function (decryptPasswordReqd) {
            exportRequest.decryptPasswordReqd = decryptPasswordReqd;
            return row && feDialogs.showFor({
              value: exportRequest,
              type: CertExportWidget,
              title: platCryptoLex.get('cert.export.dialog.title'),
              properties: {
                hidePassword: hidePassword
              }
            });
          }).then(function (result) {
            if (!result) {
              return;
            }
            var fileName = result.fileName,
              mimeType = result.mimeType;
            result.storeType = _this.$keyStoreName;
            return certManagement.exportCertificate(result).then(function (contents) {
              return fileUtils.download(contents, fileName, mimeType);
            });
          });
        }
      }]);
      _this.$keyStoreName = keyStoreName;
      var table;
      var selectionChanged = function selectionChanged() {
        _this.setEnabled(table.getSelectedRows().length === 1);
      };
      tab.on('loaded', function () {
        if (table) {
          table.$getSelection().off('changed', selectionChanged);
        }
        table = tab.getTable();
        table.$getSelection().on('changed', selectionChanged);
      });
      return _this;
    }

    /**
     * @private
     * @param alias
     * @returns {Promise.<boolean>}
     */
    _inherits(CertExportCommand, _Command);
    return _createClass(CertExportCommand, [{
      key: "$isDecryptPasswordReqd",
      value: function $isDecryptPasswordReqd(alias) {
        if (this.$keyStoreName === 'userKeyStore') {
          return certManagement.isPasswordRequired(alias);
        }
        return Promise.resolve(false);
      }
    }]);
  }(Command);
});
