function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/wb/cert/commands/CertImportCommand
 */
define(['baja!', 'lex!platCrypto', 'bajaux/commands/Command', 'dialogs', 'Promise', 'underscore', 'nmodule/platCrypto/rc/CertConstants', 'nmodule/platCrypto/rc/rpc/certManagement', 'nmodule/platCrypto/rc/wb/cert/certManagerEvents', 'nmodule/platCrypto/rc/wb/cert/commands/CertImportFileMgr', 'nmodule/platCrypto/rc/wb/cert/commands/CertImportWidget', 'nmodule/platCrypto/rc/wb/cert/util/certUtils', 'nmodule/webEditors/rc/fe/baja/ConfirmPasswordEditor', 'nmodule/webEditors/rc/fe/baja/DefaultConfirmPasswordEditor', 'nmodule/webEditors/rc/fe/baja/util/userUtils', 'nmodule/webEditors/rc/fe/feDialogs'], function (baja, lexs, Command, dialogs, Promise, _, CertConstants, certManagement, certManagerEvents, CertImportFileMgr, CertImportWidget, certUtils, ConfirmPasswordEditor, DefaultConfirmPasswordEditor, userUtils, feDialogs) {
  'use strict';

  var once = _.once;
  var Password = require('bajaScript/baja/obj/Password');
  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];
  var REFRESH_EVENT = certManagerEvents.REFRESH_EVENT;
  var DEFAULT_ALIAS = CertConstants.DEFAULT_ALIAS;
  var isCACertificate = certUtils.isCACertificate,
    isCodeSigningCertificate = certUtils.isCodeSigningCertificate;
  var isSuperUserOrOffline = userUtils.isSuperUserOrOffline;

  /**
   * A command for importing a certificate
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/platCrypto/rc/wb/cert/commands/CertImportCommand
   */
  return /*#__PURE__*/function (_Command) {
    /**
     * @param {module:nmodule/platCrypto/rc/wb/cert/CertManagerTab} tab the tab
     * @param {string} keyStoreName the name of the keystore to be used
     * to arm this command against
     */
    function CertImportCommand(tab, keyStoreName) {
      var _this;
      _classCallCheck(this, CertImportCommand);
      //This is a developer error to let them know that they did not supply something that was required
      if (!keyStoreName) {
        throw new Error("Key Store name required");
      }
      _this = _callSuper(this, CertImportCommand, [{
        module: "platCrypto",
        lex: 'cert.button.import',
        enabled: true,
        func: function func() {
          return _this.$openFile().then(function (results) {
            var _ref = results || [],
              _ref2 = _slicedToArray(_ref, 2),
              fileName = _ref2[0],
              fileContents = _ref2[1];
            if (!fileContents) {
              return;
            }
            return _this.$uploadFile(fileName, fileContents, _this.$keyStoreName); //This will be or will make an RPC call;
          }).then(function (importMsg) {
            if (_this.$isUserTrustStore()) {
              return _this.$promptForCerts(importMsg).then(function (importMsg) {
                return importMsg && _this.$saveCerts(importMsg);
              }); //This will be an RPC call
            } else {
              return importMsg && _this.$promptForDecryptPemPassword(importMsg).then(function (importMsg) {
                return importMsg && _this.$promptForCerts(importMsg);
              }).then(function (importMsg) {
                return importMsg && _this.$promptForKeyStorePassword(importMsg);
              }).then(function (importMsg) {
                return importMsg && _this.$promptForEncryptPassword(importMsg);
              }).then(function (importMsg) {
                return importMsg && _this.$saveCerts(importMsg);
              }); //This will be an RPC call;
            }
          });
        }
      }]);
      _this.$keyStoreName = keyStoreName;
      var table;
      _this.$tab = tab;
      _this.$isSuperUserOrOffline = once(function () {
        return isSuperUserOrOffline();
      });
      tab.on('loaded', function () {
        table = tab.getTable();
        _this.$table = table;
        return _this.$setDefaultEnabled(tab).then(function () {
          return _this.setEnabled(_this.$defaultEnabled);
        });
      });
      return _this;
    }

    /**
     * Check the tab to see if it provides the superuser and sets defaultEnabled if it has not been previously set
     * @private
     * @param {module:nmodule/platCrypto/rc/wb/cert/CertManagerTab} tab the tab this is a child of
     * @return {Promise.<boolean>}
     */
    _inherits(CertImportCommand, _Command);
    return _createClass(CertImportCommand, [{
      key: "$setDefaultEnabled",
      value: function $setDefaultEnabled(tab) {
        var _this2 = this;
        if (this.$defaultEnabled === undefined) {
          if (typeof tab.isCertImportEnabled === 'function') {
            return tab.isCertImportEnabled().then(function (returnVal) {
              _this2.$defaultEnabled = returnVal;
              return _this2.$defaultEnabled;
            });
          }

          // if the wb is in offline mode / if the tab does not have a isSuperUserOrOffline function, we want the default to be enabled
          this.$defaultEnabled = true;
        }
        return Promise.resolve(this.$defaultEnabled);
      }

      /**
       * @private
       * @return {Promise.<Array>}
       */
    }, {
      key: "$openFile",
      value: function $openFile() {
        return feDialogs.showFor({
          value: "",
          type: CertImportFileMgr,
          title: platCryptoLex.get('cert.import.dialog.title')
        });
      }

      /**
       * @private
       * @param {String} fileName the name of the file that was loaded in
       * @param {Object} certFile PEM file contents
       * @param {String} storeName the name of the key store
       * @returns {Promise.<module:nmodule/platCrypto/rc/rpc/certManagement~ParsedPem>}
       */
    }, {
      key: "$uploadFile",
      value: function $uploadFile(fileName, certFile, storeName) {
        return certManagement.decodePemFile(fileName, certFile, storeName);
      }

      /**
       * @private
       * @param {module:nmodule/platCrypto/rc/wb/cert/commands/CertImportCommand~CertImportMessage} importMsg
       * @return {Promise.<module:nmodule/platCrypto/rc/wb/cert/commands/CertImportCommand~CertImportMessage>}
       */
    }, {
      key: "$promptForCerts",
      value: function $promptForCerts(importMsg) {
        var _this3 = this;
        return feDialogs.showFor({
          value: importMsg,
          type: CertImportWidget,
          title: platCryptoLex.get('cert.import.dialog.title'),
          buttons: [{
            name: "ok",
            handler: function handler(dlg, evt, ed) {
              return ed.read().then(function (importMsg) {
                var importCerts = importMsg.parsedData.certificates;
                var existingCerts = _this3.$table.getModel().getRows().map(function (row) {
                  return row.getSubject();
                });
                var matchingAliases = [];
                var hasMatchCertificateInUserKeyStore = false;
                var _loop = function _loop(iCert) {
                    var importCert = importCerts[iCert];
                    var importAlias = importCert.alias;
                    if (importAlias.toLowerCase() === DEFAULT_ALIAS) {
                      dialogs.showOk({
                        title: platCryptoLex.get('cert.generate.warning.defaultAlias'),
                        text: platCryptoLex.get('cert.generate.warning.defaultAlias.description')
                      });
                      return {
                        v: dlg.keepOpen()
                      };
                    }
                    if (importCert.hasMatchCertificateInUserKeyStore) {
                      hasMatchCertificateInUserKeyStore = true;
                    }
                    if (importCert.selected) {
                      existingCerts.forEach(function (existingCert) {
                        var existingAlias = existingCert.alias;
                        if (existingAlias.toLowerCase() === importAlias.toLowerCase() && (iCert === 0 || _this3.$keyStoreName !== "userKeyStore")) {
                          matchingAliases.push(importAlias);
                        }
                      });
                    }
                  },
                  _ret;
                for (var iCert = 0; iCert < importCerts.length; iCert++) {
                  _ret = _loop(iCert);
                  if (_ret) return _ret.v;
                }

                // don't prompt for overwrite if cert matches on private key
                if (hasMatchCertificateInUserKeyStore) {
                  matchingAliases = [];
                }
                return _this3.$confirmOverwrite(matchingAliases).then(function (confirmed) {
                  return confirmed ? importMsg : dlg.keepOpen();
                });
              });
            }
          }, {
            name: "cancel"
          }]
        });
      }

      /**
       * @private
       * @param {string[]} matchingAliases the matching aliases
       * @returns {Promise.<boolean>} resolves to true if user consents to overwrite
       */
    }, {
      key: "$confirmOverwrite",
      value: function $confirmOverwrite(matchingAliases) {
        if (!matchingAliases.length) {
          return Promise.resolve(true);
        }
        var title;
        var text;
        var match = matchingAliases.join(', ');
        if (matchingAliases.length > 1) {
          title = platCryptoLex.get("cert.generate.warning.matchingAliases");
          text = platCryptoLex.get("cert.generate.warning.matchingAliases.description", match);
        } else {
          title = platCryptoLex.get("cert.generate.warning.matchingAlias");
          text = platCryptoLex.get("cert.generate.warning.matchingAlias.description", match);
        }
        return dialogs.showYesNo({
          title: title,
          text: text
        }).promise().then(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2),
            buttonClicked = _ref4[1];
          return buttonClicked === 'yes';
        });
      }

      /**
       * @private
       * @param {String} password the password to be validated
       * @returns {Promise.<Boolean>} true if the password is valid, false if it is not.
       */
    }, {
      key: "$validatePasswordStrength",
      value: function $validatePasswordStrength(password) {
        return certManagement.passwordStrength().then(function (passwordStrength) {
          return passwordStrength.validatePassword(password);
        });
      }

      /**
       * @private
       * @param {String} title the dialog title for the password prompt dialog
       * @param {String} info the prelabel for the password prompt dialog
       * @param {String} errTitle the dialog title if the password is not valid
       * @param {String} errMsg the dialog message if the password is not valid
       * @param {Function} passwordCheckFunc the function used to receive the password as a string, and
       * return a `Promise.<boolean>` indicating if it is valid
       * @return {Promise.<String>} password string, if it is valid
       */
    }, {
      key: "$passwordPrompt",
      value: function $passwordPrompt(title, info, errTitle, errMsg, passwordCheckFunc) {
        var password;
        var done = false;
        return feDialogs.showFor({
          value: Password.DEFAULT,
          title: title,
          buttons: [{
            name: "ok",
            handler: function handler(dlg, evt, ed) {
              return ed.read().then(function (rtnPassword) {
                password = rtnPassword;
                if (done) {
                  return password;
                }
                dlg.keepOpen();
                return passwordCheckFunc(password.encodeToString()).then(function (isValidPassword) {
                  if (!isValidPassword) {
                    dialogs.showOk({
                      title: errTitle,
                      text: errMsg
                    });
                  } else {
                    dlg.click("ok");
                    done = true;
                    return password;
                  }
                })["catch"](function (error) {
                  feDialogs.error(error, {
                    messageSummary: platCryptoLex.get('cert.import.RPC.failed')
                  });
                });
              });
            }
          }, {
            name: "cancel"
          }],
          properties: {
            prelabel: platCryptoLex.get('cert.password.prelabel'),
            rootCssClass: '-t-CertPasswordDialog'
          },
          summary: info
        });
      }

      /**
       * Prompt for the password to decrypt the private key in the imported PEM.
       * @private
       * @param {Object} importMsg the message that contains the data for importing a password
       * @return {Promise.<Object>} the updated message object with the password value
       */
    }, {
      key: "$promptForDecryptPemPassword",
      value: function $promptForDecryptPemPassword(importMsg) {
        var _this4 = this;
        var privateKey;
        var parsedData = importMsg.parsedData;
        if (parsedData) {
          privateKey = parsedData.privateKey;
        }
        if (privateKey && privateKey.pemPrivateKeyPasswordNeeded) {
          var title = platCryptoLex.get('cert.import.privatekey.dialog.title');
          var info = platCryptoLex.get('cert.import.privatekey.dialog.info');
          var errTitle = platCryptoLex.get('cert.import.privatekey.errDialog.title');
          var errInfo = platCryptoLex.get('cert.import.privatekey.errDialog.info');
          return this.$passwordPrompt(title, info, errTitle, errInfo, function (pw) {
            return _this4.$canDecryptPrivateKeyWithPassword(parsedData, pw);
          }).then(function (password) {
            if (password) {
              privateKey.password = password.encodeToString();
              return importMsg;
            }
          });
        }
        return Promise.resolve(importMsg);
      }

      /**
       * @private
       * @param {module:nmodule/platCrypto/rc/rpc/certManagement~ParsedPem} parsedPem
       * @param {string} password
       * @returns {Promise.<boolean>}
       */
    }, {
      key: "$canDecryptPrivateKeyWithPassword",
      value: function $canDecryptPrivateKeyWithPassword(parsedPem, password) {
        return certManagement.isParsedPemPasswordValid(parsedPem, password);
      }

      /**
       * Prompt for the password to overwrite an existing private key in the key store.
       * @private
       * @param {module:nmodule/platCrypto/rc/wb/cert/commands/CertImportCommand~CertImportMessage} importMsg the message that contains the data for importing a password
       * @return {Promise.<module:nmodule/platCrypto/rc/wb/cert/commands/CertImportCommand~CertImportMessage>} the updated message object with the password value
       */
    }, {
      key: "$promptForKeyStorePassword",
      value: function $promptForKeyStorePassword(importMsg) {
        var _this5 = this;
        var parsedData = importMsg.parsedData;
        var existingKeyStoreAlias = parsedData.existingKeyStoreAlias,
          keyStorePrivateKeyPasswordNeeded = parsedData.keyStorePrivateKeyPasswordNeeded,
          privateKey = parsedData.privateKey,
          suggestedKeyStoreAlias = parsedData.suggestedKeyStoreAlias;
        return this.$isSuperUserOrOffline().then(function (isSuperUser) {
          // if i'm superuser, overwriting an existing PK with a new one,
          // i don't need a password but i do need confirmation.
          if (isSuperUser && privateKey && existingKeyStoreAlias) {
            return dialogs.showYesNo({
              title: platCryptoLex.get('cert.import.confirmKeyOverwrite.dialog.title'),
              text: platCryptoLex.get('cert.import.confirmKeyOverwrite.dialog.info', existingKeyStoreAlias)
            }).yes(function () {
              return importMsg;
            }).promise().then(function (_ref5) {
              var _ref6 = _slicedToArray(_ref5, 3),
                importMsg = _ref6[2];
              return importMsg;
            });
          }
          if (keyStorePrivateKeyPasswordNeeded) {
            var title = platCryptoLex.get('cert.import.keyStoreKey.dialog.title');
            var info = platCryptoLex.get('cert.import.keyStoreKey.dialog.info', suggestedKeyStoreAlias);
            var errTitle = platCryptoLex.get('cert.import.keyStoreKey.errDialog.title');
            var errInfo = platCryptoLex.get('cert.import.keyStoreKey.errDialog.info');
            return _this5.$passwordPrompt(title, info, errTitle, errInfo, function (pw) {
              return _this5.$canDecryptEntryFromKeyStoreWithPassword(suggestedKeyStoreAlias, pw);
            }).then(function (password) {
              if (password) {
                parsedData.keyStorePassword = password.encodeToString();
                return importMsg;
              }
            });
          }
          return importMsg;
        });
      }

      /**
       * @private
       * @param {string} alias
       * @param {string} password
       * @returns {Promise.<boolean>}
       */
    }, {
      key: "$canDecryptEntryFromKeyStoreWithPassword",
      value: function $canDecryptEntryFromKeyStoreWithPassword(alias, password) {
        return certManagement.isKeyStorePasswordValid(alias, password);
      }

      /**
       * Prompt for the password to encrypt the private key from the PEM into the key store.
       * @private
       * @param {module:nmodule/platCrypto/rc/wb/cert/commands/CertImportCommand~CertImportMessage} importMsg
       * @returns {Promise.<module:nmodule/platCrypto/rc/wb/cert/commands/CertImportCommand~CertImportMessage>} the updated message object with the password value
       */
    }, {
      key: "$promptForEncryptPassword",
      value: function $promptForEncryptPassword(importMsg) {
        var _this6 = this;
        var parsedData = importMsg.parsedData;
        var globalAllowed = this.$isGlobalPasswordAllowed(parsedData);
        if (parsedData) {
          return feDialogs.showFor({
            value: Password.DEFAULT,
            type: "nmodule/webEditors/rc/fe/baja/".concat(globalAllowed ? 'DefaultConfirmPasswordEditor' : 'ConfirmPasswordEditor'),
            title: platCryptoLex.get('cert.import.encryptKey.dialog.title'),
            summary: platCryptoLex.get('cert.import.encryptKey.dialog.info'),
            validate: function validate(password) {
              if (globalAllowed && password === Password.DEFAULT) {
                return;
              }
              return _this6.$validatePasswordStrength(password.encodeToString());
            },
            progressCallback: function progressCallback(msg, ed) {
              switch (msg) {
                case 'initialized':
                  ed.jq().addClass('-t-CertManager-confirm-password');
              }
            }
          }).then(function (password) {
            if (!password) {
              return;
            }
            if (password === Password.DEFAULT) {
              parsedData.useGlobalPassword = true;
            } else {
              parsedData.encryptPassword = password.encodeToString();
            }
            return importMsg;
          });
        }
        return Promise.resolve(importMsg);
      }

      /**
       * @private
       * @param {module:nmodule/platCrypto/rc/rpc/certManagement~ParsedPem} parsedData
       * @return {boolean} a prompt for the encrypt password will always be shown, but return true if
       * that prompt should allow the user to select the global password, and return false if that
       * password prompt must force the user to enter their own password.
       * @throws {Error} if there is not at least one certificate.
       */
    }, {
      key: "$isGlobalPasswordAllowed",
      value: function $isGlobalPasswordAllowed(parsedData) {
        if (parsedData.certificates.length === 0) {
          throw new Error(platCryptoLex.get('CertImportCommand.error.certificateMissing'));
        }
        var certificate = parsedData.certificates[0].certificate;
        return !(isCACertificate(certificate) || isCodeSigningCertificate(certificate));
      }

      /**
       * @private
       * @param {module:nmodule/platCrypto/rc/wb/cert/commands/CertImportCommand~CertImportMessage} importMsg
       * @return {Promise}
       */
    }, {
      key: "$saveCerts",
      value: function $saveCerts(importMsg) {
        var _this7 = this;
        var selection = this.$table.$selection;
        return certManagement.importCertStoreData(importMsg.storeName, importMsg.parsedData)["finally"](function () {
          _this7.$tab.emit(REFRESH_EVENT);
          selection.clear();
        });
      }

      /**
       * @private
       * @returns {boolean} true if the underlying store is the "User Trust Store" 
       */
    }, {
      key: "$isUserTrustStore",
      value: function $isUserTrustStore() {
        return this.$keyStoreName === "userTrustStore";
      }
    }]);
  }(Command);
});

/**
 * @typedef module:nmodule/platCrypto/rc/wb/cert/commands/CertImportCommand~CertImportMessage
 * @property {string} storeName
 * @property {module:nmodule/platCrypto/rc/rpc/certManagement~ParsedPem} parsedData
 */
