function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/wb/cert/commands/CertRequestCommand
 */
define(['lex!platCrypto', 'bajaux/commands/Command', 'Promise', 'nmodule/platCrypto/rc/rpc/certManagement', 'nmodule/platCrypto/rc/wb/cert/commands/CertRequestWidget', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/util/fileUtils'], function (lexs, Command, Promise, certManagement, CertRequestWidget, feDialogs, fileUtils) {
  'use strict';

  var Password = require('bajaScript/baja/obj/Password');
  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0],
    isPasswordRequired = certManagement.isPasswordRequired,
    generateCSR = certManagement.generateCSR;

  /**
   * A command for setting up a Certificate Signing Request.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/platCrypto/rc/wb/cert/commands/CertRequestCommand
   */
  var CertRequestCommand = /*#__PURE__*/function (_Command) {
    /**
     * @param {module:nmodule/platCrypto/rc/wb/cert/CertManagerTab} tab the tab
     * to arm this command against
     */
    function CertRequestCommand(tab) {
      var _this;
      _classCallCheck(this, CertRequestCommand);
      _this = _callSuper(this, CertRequestCommand, [{
        module: "platCrypto",
        lex: 'cert.button.csr',
        enabled: false,
        func: function func() {
          var _tab$getTable$getSele = tab.getTable().getSelectedRows(),
            _tab$getTable$getSele2 = _slicedToArray(_tab$getTable$getSele, 1),
            row = _tab$getTable$getSele2[0];
          return row && feDialogs.showFor({
            value: row.getSubject(),
            type: CertRequestWidget,
            title: platCryptoLex.get('csr.view.dialog.title')
          }).then(function (result) {
            if (!result) {
              return;
            }
            var fileName = result.fileName,
              cert = result.cert;
            return _this.$promptForPassword(cert).then(function (password) {
              if (password === null) {
                return; //password required, but user pressed cancel
              }
              var mimeType = 'text/csr';
              return generateCSR(cert.alias, password ? password.encodeToString() : '').then(function (contents) {
                return fileUtils.download(contents, fileName, mimeType);
              });
            });
          });
        }
      }]);
      var table;
      var selectionChanged = function selectionChanged() {
        _this.setEnabled(table.getSelectedRows().length === 1);
      };
      tab.on('loaded', function () {
        if (table) {
          table.$getSelection().off('changed', selectionChanged);
        }
        table = tab.getTable();
        table.$getSelection().on('changed', selectionChanged);
      });
      return _this;
    }

    /**
     * @param {Object} cert
     * @return {Promise}
     */
    _inherits(CertRequestCommand, _Command);
    return _createClass(CertRequestCommand, [{
      key: "$promptForPassword",
      value: function $promptForPassword(cert) {
        return isPasswordRequired(cert.alias).then(function (passwordRequired) {
          if (passwordRequired) {
            return feDialogs.showFor({
              value: Password.DEFAULT,
              formFactor: 'mini',
              title: platCryptoLex.get('cert.import.privatekey.dialog.title'),
              summary: platCryptoLex.get('cert.import.privatekey.dialog.info'),
              properties: {
                prelabel: platCryptoLex.get('cert.password.prelabel'),
                rootCssClass: '-t-CertPasswordDialog'
              }
            });
          }
        });
      }
    }]);
  }(Command);
  return CertRequestCommand;
});
