function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/wb/cert/forms/GeneralAttributes
 */
define(['baja!', 'bajaux/spandrel', 'Promise', 'lex!platCrypto', 'nmodule/platCrypto/rc/CertConstants', 'nmodule/platCrypto/rc/fe/extensions/SubjectAlternativeNameEditor', 'nmodule/platCrypto/rc/wb/cert/forms/Form', 'nmodule/platCrypto/rc/wb/cert/util/DN', 'nmodule/platCrypto/rc/wb/cert/util/certUtils', 'nmodule/webEditors/rc/util/ipAddressUtil'], function (baja, spandrel, Promise, lexs, CertConstants, SubjectAlternativeNameEditor, Form, DN, certUtils, ipAddressUtil) {
  'use strict';

  var isCountryCodeValid = certUtils.isCountryCodeValid;
  var _lexs = _slicedToArray(lexs, 1),
    PLAT_CRYPTO_LEX = _lexs[0];
  var PLAT_CRYPTO = 'platCrypto';
  var getLex = function getLex(keyPart) {
    return PLAT_CRYPTO_LEX.get('cert.field.' + keyPart);
  };
  var dateTimeUtil = require('bajaScript/baja/obj/dateTimeUtil');
  var isIpv6 = ipAddressUtil.isIpv6;
  var _CertConstants$SAN_EX = CertConstants.SAN_EXT_TAGS,
    TAG_NO_DNS_NAME = _CertConstants$SAN_EX.TAG_NO_DNS_NAME,
    TAG_NO_IP_ADDRESS = _CertConstants$SAN_EX.TAG_NO_IP_ADDRESS;
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-GeneralAttributes'
      },
      keySize: '',
      keyType: '',
      supportedKeySizes: [],
      spec: '',
      supportedKeySpecs: []
    };
  };
  var _CertConstants$EXTENS = CertConstants.EXTENSION_OID,
    KEY_USAGE_OID = _CertConstants$EXTENS.KEY_USAGE_OID,
    EXTENDED_KEY_USAGE_OID = _CertConstants$EXTENS.EXTENDED_KEY_USAGE_OID,
    SUBJECT_ALTERNATIVE_NAME_OID = _CertConstants$EXTENS.SUBJECT_ALTERNATIVE_NAME_OID;
  var DEFAULT_SAN = SubjectAlternativeNameEditor.DEFAULT_SAN;

  /**
   * API Status: **Development**
   *
   * General Attributes.
   *
   * Following properties when provided will help create form fields for bajaux Certificate views.
   * - `keySize`: (number) Size of the key in bits. Example: 1024, 2048, 3072 and 4096.
   * - `supportedKeySizes`: (Array.<number>) Key sizes array.
   * - `spec`: (string) Key spec. Example: 'P-256', 'P-384', 'P-521' etc...
   * - `supportedKeySpecs`: (Array.<string>) Key specs array.
   * - `keyType`: (string) Algorithm of the key contained in the certificate. Example: RSA, EC.
   * - `supportedKeyAlgorithms`: (Array.<string>) Supported algorithm array.
   * - `certificateUsages`: (Array.<Object>) Specifies the certificate usage is for Server, Client, CA, Code Signing or Custom.
   *    Example: Certificate Usage "server" is specified as {certificateUsages: [{value: 'server', selected: true}]}
   * - `readonlyProperties`: (Object) Specifies the readonly behavior of the form fields.
   *    Example: To disable the certificateUsage for field provide {'certificateUsage': {readonly: true, enabled: false}}
   *
   * @class
   * @alias module:nmodule/platCrypto/rc/wb/cert/forms/GeneralAttributes
   * @extends {module:bajaux/spandrel}
   */
  var GeneralAttributes = /*#__PURE__*/function (_spandrel) {
    function GeneralAttributes(params) {
      _classCallCheck(this, GeneralAttributes);
      return _callSuper(this, GeneralAttributes, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }
    _inherits(GeneralAttributes, _spandrel);
    return _createClass(GeneralAttributes, [{
      key: "doRead",
      value: function doRead() {
        return this.$getForm().read().then(function (formValues) {
          var subjectDn = formValues.subjectDn;
          return Object.assign(formValues, {
            subjectDn: filterEmptyAttributes(subjectDn).toString()
          });
        });
      }

      /**
       * Saves the attributes form.
       * @returns {Promise}
       */
    }, {
      key: "doSave",
      value: function doSave() {
        return this.$getForm().save();
      }

      /**
       * @private
       * @returns {Array.<object>}
       */
    }, {
      key: "$getCertGAData",
      value: function $getCertGAData() {
        var _this = this;
        var properties = this.properties(),
          keyType = properties.getValue('keyType'),
          keySize = properties.getValue('keySize'),
          spec = properties.getValue('spec');
        var supportedKeySizes = properties.getValue('supportedKeySizes') || [];
        supportedKeySizes = supportedKeySizes.map(function (size) {
          return {
            displayName: getLex(size + 'bits'),
            value: size.toString()
          };
        });
        var supportedKeySpecs = properties.getValue('supportedKeySpecs') || [];
        var supportedKeySpecsMap = {};
        supportedKeySpecs.forEach(function (spec) {
          supportedKeySpecsMap[getLex("spec." + spec)] = spec;
        });
        var supportedKeyAlgorithms = properties.getValue('supportedKeyAlgorithms') || [];
        supportedKeyAlgorithms = supportedKeyAlgorithms.map(function (spec) {
          return {
            displayName: getLex("keyType." + spec),
            value: spec
          };
        });
        var notBefore = baja.AbsTime.now(),
          notAfter = notBefore.nextYear(),
          certificateUsages = properties.getValue('certificateUsages') || [],
          readonlyProperties = properties.getValue('readonlyProperties') || {},
          certUsageReadonlyProperties = readonlyProperties.certificateUsages || {},
          certReadOnly = !!certUsageReadonlyProperties.readonly,
          certEnabled = certUsageReadonlyProperties.enabled !== false,
          certificateUsage = certificateUsages.find(function (usage) {
            return usage.selected;
          }) || {
            value: 'server'
          };
        return [{
          name: 'alias',
          displayName: getLex('alias'),
          properties: {
            required: true,
            helpModule: PLAT_CRYPTO,
            helpKey: 'alias.help'
          }
        }, {
          name: 'subjectDn',
          value: 'CN=, OU=, O=, L=, ST=, C=',
          displayName: PLAT_CRYPTO_LEX.get('NewCertForm.field.subjectDn'),
          properties: {
            required: true,
            uxFieldEditor: 'nmodule/platCrypto/rc/fe/DistinguishedNameEditor',
            helpModule: PLAT_CRYPTO,
            helpKey: 'subjectDn.help'
          },
          validate: function validate(dnString) {
            return _this.$validateDN(dnString);
          }
        }, {
          name: 'notBefore',
          displayName: getLex('notBefore'),
          value: notBefore,
          properties: {
            helpModule: PLAT_CRYPTO,
            helpKey: 'notBefore.help',
            timeFormat: dateTimeUtil.getTimeFormatPatternWithLongYear()
          }
        }, {
          name: 'notAfter',
          displayName: getLex('notAfter'),
          value: notAfter,
          properties: {
            helpModule: PLAT_CRYPTO,
            helpKey: 'notAfter.help',
            timeFormat: dateTimeUtil.getTimeFormatPatternWithLongYear()
          }
        }, {
          name: 'keyType',
          displayName: PLAT_CRYPTO_LEX.get('NewCertForm.field.keyType'),
          value: keyType,
          properties: {
            helpModule: PLAT_CRYPTO,
            options: supportedKeyAlgorithms,
            uxFieldEditor: 'nmodule/platCrypto/rc/wb/cert/util/RadioButtonGroup'
          }
        }, {
          name: 'keySize',
          displayName: getLex('keySize'),
          value: keySize && keySize.toString() || '',
          properties: {
            helpKey: 'keySize.help',
            helpModule: PLAT_CRYPTO,
            options: supportedKeySizes,
            uxFieldEditor: 'nmodule/platCrypto/rc/wb/cert/util/RadioButtonGroup'
          }
        }, {
          name: 'spec',
          displayName: getLex('spec'),
          value: spec || '',
          properties: {
            helpKey: 'spec.help',
            helpModule: PLAT_CRYPTO,
            map: supportedKeySpecsMap,
            uxFieldEditor: 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor'
          }
        }, {
          name: 'certUsage',
          displayName: getLex('certUsage'),
          value: certificateUsage.value,
          enabled: certEnabled,
          readonly: certReadOnly,
          properties: {
            options: certificateUsages,
            uxFieldEditor: 'nmodule/platCrypto/rc/wb/cert/util/RadioButtonGroup'
          }
        }, {
          name: 'extensions',
          value: [],
          displayName: PLAT_CRYPTO_LEX.get('NewCertForm.field.extensions'),
          properties: {
            uxFieldEditor: 'nmodule/platCrypto/rc/fe/ExtensionEditor'
          },
          validate: function validate(extensions) {
            return _this.$validateExtensions(extensions);
          }
        }];
      }

      /**
       * @private
       * @returns {module:nmodule/platCrypto/rc/wb/cert/forms/Form}
       */
    }, {
      key: "$getForm",
      value: function $getForm() {
        return this.queryWidget('0');
      }

      /**
       * @private
       * @param {string} dnString
       * @throws {Error} if DN is invalid
       */
    }, {
      key: "$validateDN",
      value: function $validateDN(dnString) {
        var dn = filterEmptyAttributes(dnString);
        if (!dn.getTuples().length) {
          throw new Error(getFieldRequiredMessage(PLAT_CRYPTO_LEX.get('NewCertForm.field.subjectDn')));
        }
        var countryCode = dn.getValues('C')[0];
        if (countryCode && !this.$countryCodeValid(countryCode)) {
          throw new Error(PLAT_CRYPTO_LEX.get('cert.generate.error.invalidCountryCode'));
        }
      }

      /**
       * @private
       * @param {Array<module:nmodule/platCrypto/rc/fe/ExtensionEditor~ExtensionEntry>} extensions
       * @throws {Error} if extensions are invalid
       */
    }, {
      key: "$validateExtensions",
      value: function $validateExtensions(extensions) {
        this.$getForm().$getExtensionEditor().$validate(extensions);
      }

      /**
       * @private
       * @param {string} countryCode
       * @returns {boolean} true if country code is valid
       */
    }, {
      key: "$countryCodeValid",
      value: function $countryCodeValid(countryCode) {
        return isCountryCodeValid(countryCode);
      }
    }]);
  }(spandrel(function (value, _ref) {
    var self = _ref.self;
    return [spandrel.jsx(GeneralAttributesForm, {
      value: self.$getCertGAData(),
      validate: true,
      properties: {
        header: PLAT_CRYPTO_LEX.get('NewCertForm.section.generalAttributes.displayName')
      }
    })];
  }));
  var GeneralAttributesForm = /*#__PURE__*/function (_Form) {
    function GeneralAttributesForm() {
      _classCallCheck(this, GeneralAttributesForm);
      return _callSuper(this, GeneralAttributesForm, arguments);
    }
    _inherits(GeneralAttributesForm, _Form);
    return _createClass(GeneralAttributesForm, [{
      key: "doLoad",
      value: function doLoad() {
        var _this2 = this;
        return _superPropGet(GeneralAttributesForm, "doLoad", this, 3)(arguments).then(function () {
          return Promise.all([_this2.fieldChanged(_this2, 'keyType'), _this2.fieldChanged(_this2, 'certUsage')]);
        });
      }

      /**
       * @param {module:nmodule/platCrypto/rc/wb/cert/forms/Form} form
       * @param {String} name
       * @returns {Promise}
       */
    }, {
      key: "fieldChanged",
      value: function fieldChanged(form, name) {
        var _this3 = this;
        if (name === "certUsage") {
          return this.getFormField('certUsage').read().then(function (value) {
            var ekuEditor = _this3.$getExtendedKeyUsageEditor();
            return _this3.$getExtensionEditor().$certificateChanged(value).then(function () {
              return Promise.all([_this3.$getKeyUsageEditor().$certificateChanged(value), ekuEditor && ekuEditor.$certificateChanged(value)]);
            });
          });
        }
        if (name === "keyType") {
          return this.getFormField('keyType').read().then(function (value) {
            var isRSA = value === 'RSA';
            _this3.$getFormRow('keySize').jq().toggle(isRSA);
            _this3.$getFormRow('spec').jq().toggle(!isRSA);
          });
        }

        // Auto populate SAN extension when DN's CN is updated
        if (name === 'subjectDn') {
          return this.getFormField('subjectDn').read().then(function (dnString) {
            // If the existing SAN already has a manual change then keep it
            var sanEditor = _this3.$getSANEditor();
            if (!sanEditor || sanEditor.isModified()) {
              return;
            }
            var cn = getCN(dnString);
            var sanValue = DEFAULT_SAN;
            if (cn) {
              var _cn = _slicedToArray(cn, 2),
                value = _cn[1];
              var tagNo = TAG_NO_DNS_NAME; // for DNS Name
              // Any arbitrary text is considered a DNS Name unless it is a valid Ip address
              if (isIpAddress(value)) {
                tagNo = TAG_NO_IP_ADDRESS;
              }
              sanValue = {
                names: [{
                  tagNo: tagNo,
                  value: value
                }]
              };
            }
            return _this3.$getExtensionEditor().$setSan(sanValue);
          });
        }
        return Promise.resolve();
      }

      /**
       * @private
       * @returns {module:nmodule/platCrypto/rc/fe/extensions/KeyUsageEditor}
       */
    }, {
      key: "$getKeyUsageEditor",
      value: function $getKeyUsageEditor() {
        return this.$getExtensionEditor().$getDataEditorForOid(KEY_USAGE_OID);
      }

      /**
       * @private
       * @returns {module:nmodule/platCrypto/rc/fe/extensions/SubjectAlternativeNameEditor}
       */
    }, {
      key: "$getSANEditor",
      value: function $getSANEditor() {
        return this.$getExtensionEditor().$getDataEditorForOid(SUBJECT_ALTERNATIVE_NAME_OID);
      }

      /**
       * @private
       * @returns {module:nmodule/platCrypto/rc/fe/extensions/ExtendedKeyUsageEditor}
       */
    }, {
      key: "$getExtendedKeyUsageEditor",
      value: function $getExtendedKeyUsageEditor() {
        return this.$getExtensionEditor().$getDataEditorForOid(EXTENDED_KEY_USAGE_OID);
      }

      /**
       * @private
       * @returns {module:nmodule/platCrypto/rc/fe/ExtensionEditor}
       */
    }, {
      key: "$getExtensionEditor",
      value: function $getExtensionEditor() {
        return this.getFormField('extensions');
      }
    }]);
  }(Form);
  /**
   * @param {string} dnString
   * @returns {module:nmodule/platCrypto/rc/wb/cert/util/DN} DN with all empty values filtered out
   */
  function filterEmptyAttributes(dnString) {
    var dn = DN.parse(dnString);
    var nonEmptyTuples = dn.getTuples().filter(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
        v = _ref3[1];
      return v;
    });
    return new DN(nonEmptyTuples);
  }
  function getFieldRequiredMessage(columnDisplayName) {
    return PLAT_CRYPTO_LEX.get('NewCertForm.validationErrors.required', columnDisplayName);
  }

  /**
   * Extract the CN tuple from a subjectDn string
   * @param {String} dnString
   * @returns {Array.<String>|undefined}
   */
  function getCN(dnString) {
    var dn = filterEmptyAttributes(dnString);
    var tuples = dn.getTuples();
    return tuples.find(function (_ref4) {
      var _ref5 = _slicedToArray(_ref4, 2),
        k = _ref5[0],
        v = _ref5[1];
      return k === 'CN';
    });
  }

  /**
   *
   * @param {String} value
   * @returns {boolean}
   */
  function isIpAddress(value) {
    if (!value) {
      return false;
    }
    return isIpv4(value) || isIpv6(value);
  }

  /**
   *
   * @param {String} address
   * @returns {boolean}
   */
  function isIpv4(address) {
    var IPV4_REGEX = /^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$/;
    return IPV4_REGEX.test(address);
  }
  return GeneralAttributes;
});
