function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/wb/cert/tabs/UserKeyStoreTab
 */
define(['lex!platCrypto', 'bajaux/spandrel', 'Promise', 'underscore', 'bajaux/util/CommandButtonGroup', 'nmodule/platCrypto/rc/CertConstants', 'nmodule/platCrypto/rc/wb/cert/commands/CertDeleteCommand', 'nmodule/platCrypto/rc/wb/cert/commands/CertExportCommand', 'nmodule/platCrypto/rc/wb/cert/commands/CertImportCommand', 'nmodule/platCrypto/rc/wb/cert/commands/ViewCertDetailsCommand', 'nmodule/platCrypto/rc/wb/cert/util/certColumns', 'nmodule/platCrypto/rc/wb/cert/util/CertTabContextMenuSupport', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/menu/DefaultTableContextMenu', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'nmodule/webEditors/rc/fe/baja/util/userUtils'], function (lexs, spandrel, Promise, _, CommandButtonGroup, CertConstants, CertDeleteCommand, CertExportCommand, CertImportCommand, ViewCertDetailsCommand, certColumns, addCertTabContextMenuSupport, Table, DefaultTableContextMenu, Row, TableModel, userUtils) {
  'use strict';

  var once = _.once;
  var getStoreColumns = certColumns.getStoreColumns;
  var TableWithMenu = DefaultTableContextMenu.mixin(Table);
  var CELL_ACTIVATED_EVENT = Table.CELL_ACTIVATED_EVENT;
  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];
  var CONFIRM_TITLE = platCryptoLex.get('cert.delete.dialog.title');
  var CONFIRM_TEXT = platCryptoLex.get('cert.delete.dialog.info');
  var ICON_SECURITY_LOW = CertConstants.ICON_SECURITY_LOW,
    ICON_SECURITY_HIGH = CertConstants.ICON_SECURITY_HIGH;
  var getCertIcon = function getCertIcon(_ref) {
    var valid = _ref.valid;
    if (!valid) {
      return ICON_SECURITY_LOW;
    }
    return ICON_SECURITY_HIGH;
  };

  /**
   * Cert Manager tab for the user trust store.
   *
   * @class
   * @extends module:bajaux/Widget
   * @alias module:nmodule/platCrypto/rc/wb/cert/tabs/UserTrustStoreTab
   * @implements module:nmodule/platCrypto/rc/wb/cert/CertManagerTab
   */
  return /*#__PURE__*/function (_spandrel) {
    function UserTrustStoreTab() {
      var _this;
      _classCallCheck(this, UserTrustStoreTab);
      _this = _callSuper(this, UserTrustStoreTab, arguments);
      addCertTabContextMenuSupport(_this);
      var deleteParams = {
        storeType: 'userTrustStore',
        dialogParams: {
          title: CONFIRM_TITLE,
          text: CONFIRM_TEXT
        }
      };
      var isSuperUser = once(function () {
        return userUtils.isSuperUserOrOffline();
      });

      /**
       * Resolves to true if offline or if online and the current user is a super user.
       * @returns {Promise.<Boolean>}
       */
      _this.isCertImportEnabled = isSuperUser;
      _this.isCertDeleteEnabled = isSuperUser;
      _this.getCommandGroup().add(new ViewCertDetailsCommand(_this), new CertDeleteCommand(_this, deleteParams), new CertImportCommand(_this, "userTrustStore"), new CertExportCommand(_this, 'userTrustStore', true));
      return _this;
    }

    /**
     * @returns {module:nmodule/webEditors/rc/wb/table/Table}
     */
    _inherits(UserTrustStoreTab, _spandrel);
    return _createClass(UserTrustStoreTab, [{
      key: "getTable",
      value: function getTable() {
        return this.queryWidget('table');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButtonGroup}
       */
    }, {
      key: "$getCommandButtonGroup",
      value: function $getCommandButtonGroup() {
        return this.queryWidget('commands');
      }

      /**
       * @private
       * @returns {module:nmodule/platCrypto/rc/wb/cert/commands/ViewCertDetailsCommand}
       */
    }, {
      key: "$getViewCertDetailsCommand",
      value: function $getViewCertDetailsCommand() {
        return this.getCommandGroup().findCommand(ViewCertDetailsCommand);
      }

      /**
       * @private
       * @returns {module:nmodule/platCrypto/rc/wb/cert/commands/CertDeleteCommand}
       */
    }, {
      key: "$getCertDeleteCommand",
      value: function $getCertDeleteCommand() {
        return this.getCommandGroup().findCommand(CertDeleteCommand);
      }

      /**
       * @private
       * @returns {module:nmodule/platCrypto/rc/wb/cert/commands/CertImportCommand}
       */
    }, {
      key: "$getCertImportCommand",
      value: function $getCertImportCommand() {
        return this.getCommandGroup().findCommand(CertImportCommand);
      }

      /**
       * @private
       * @returns {module:nmodule/platCrypto/rc/wb/cert/commands/CertExportCommand}
       */
    }, {
      key: "$getCertExportCommand",
      value: function $getCertExportCommand() {
        return this.getCommandGroup().findCommand(CertExportCommand);
      }
    }]);
  }(spandrel(function (_ref2, _ref3) {
    var _ref2$certs = _ref2.certs,
      certs = _ref2$certs === void 0 ? [] : _ref2$certs;
    var self = _ref3.self;
    var tableModel = new TableModel({
      columns: getStoreColumns(),
      rows: certs.map(function (cert) {
        return new Row(cert, getCertIcon(cert));
      })
    });
    return [spandrel.jsx(TableWithMenu, {
      spandrelKey: "table",
      value: tableModel,
      on: _defineProperty({}, CELL_ACTIVATED_EVENT, function () {
        return self.$getViewCertDetailsCommand().invoke();
      })
    }), spandrel.jsx(CommandButtonGroup, {
      spandrelKey: "commands",
      value: self.getCommandGroup()
    })];
  }));
});
