/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

define(['baja!', 'baja!nrio:UIPointEntry,nrio:NrioIoTypeEnum', 'nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn', 'nmodule/webEditors/rc/wb/table/model/columns/PropertyColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/table/tree/TreeTableModel'], function (baja, types, IconMgrColumn, PropertyColumn, NameMgrColumn, TreeTableModel) {
  'use strict';

  var BOOLEAN_ICON = baja.Icon.make("module://icons/x16/statusBoolean.png"),
    FLOAT_ICON = baja.Icon.make("module://icons/x16/statusNumeric.png"),
    MIX_ICON = baja.Icon.make("module://icons/x16/statusMixed.png");
  var NRIO_IO_ENUM = baja.lt('nrio:NrioIoTypeEnum');
  var UNIVERSAL_INPUT = NRIO_IO_ENUM.tagToOrdinal('universalInput');
  var ANALOG_OUTPUT = NRIO_IO_ENUM.tagToOrdinal('analogOutput');
  var icon = new IconMgrColumn();
  icon.getValueFor = function (row) {
    var ioType = row.getSubject().getIoType().getOrdinal();
    if (ioType === UNIVERSAL_INPUT) {
      return MIX_ICON;
    } else if (ioType === ANALOG_OUTPUT) {
      return FLOAT_ICON;
    } else {
      return BOOLEAN_ICON;
    }
  };
  var POINT_TYPE = baja.lt('nrio:UIPointEntry');
  var COLUMNS = [icon, new NameMgrColumn(), new PropertyColumn('ioType', {
    type: POINT_TYPE
  }), new PropertyColumn('instance', {
    type: POINT_TYPE
  }), new PropertyColumn('usedByPoint', {
    type: POINT_TYPE
  })];

  /**
   * API Status: **Private**
   * @since Niagara 4.14
   * @exports nmodule/nrio/rc/wb/mgr/model/NrioPointLearnModel
   */
  var exports = {};

  /**
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/table/tree/TreeTableModel>}
   */
  exports.make = function () {
    return TreeTableModel.make({
      columns: COLUMNS
    });
  };
  return exports;
});
