function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Scott Hoye
 * @since Niagara 4.0
 */

/* eslint-env browser */
/*global niagara */

/**
 * API Status: **Private**
 * @module nmodule/search/rc/SearchWidget
 */
define(['bajaux/Widget', 'jquery', 'Promise', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'nmodule/bql/rc/builder/BqlQueryBuilder', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/search/rc/SearchScope', 'nmodule/search/rc/command/SettingsCommand', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/util/storageUtil', 'bajaux/util/CommandButtonGroup', 'hbs!nmodule/search/rc/template/SearchWidget-structure', 'hbs!nmodule/search/rc/template/SearchWidget-progress', 'baja!', 'baja!search:SearchParams,baja:JobState', 'lex!search', 'log!nmodule.search.rc.SearchWidget', 'css!nmodule/search/rc/search'], function (Widget, $, Promise, Command, CommandGroup, BqlQueryBuilder, asyncUtils, SearchScope, SettingsCommand, fe, feDialogs, storageUtil, CommandButtonGroup, tplSearchWidgetStructure, tplSearchWidgetProgress, baja, types, lexs, log) {
  'use strict';

  var doRequire = asyncUtils.doRequire;
  var logSevere = log.severe.bind(log);
  var _lexs = _slicedToArray(lexs, 1),
    lex = _lexs[0];
  var LOADING_TXT = lex.getSafe('SearchWidget.loading'),
    LOCALIZABLE_EXCEPTION = 'javax.baja.sys.LocalizableRuntimeException: ',
    RESULTS_LKEY = 'SearchWidget.page.resultsDisplayed',
    COMPACT_RESULTS_LKEY = 'SearchWidget.page.resultsDisplayed.compact',
    CONFIG_CLASS = '.n4-search-widget-config',
    ERROR_CLASS = '.n4-search-widget-error-display',
    PROGRESS_IMG_CLASS = '.n4-search-widget-loading-img',
    PROGRESS_CLASS = '.n4-search-widget-progress',
    PROGRESS_CONTAINER_CLASS = '.n4-search-widget-progress-container',
    CONTENT_CLASS = '.n4-search-widget-content',
    QUERY_CLASS = '.n4-search-widget-query',
    SEARCH_CLASS = '.n4-search-widget-submit',
    COMMAND_GROUP_CLASS = '.n4-search-widget-command-group',
    PAGE_CMD_CLASS = '.n4-search-widget-page-commands',
    NEXT_CLASS = '.n4-search-widget-next',
    PREV_CLASS = '.n4-search-widget-prev',
    DISPLAYED_RESULTS_CLASS = '.n4-search-widget-displayed-results',
    PAGE_CLASS = '.n4-search-widget-page',
    STORAGE_SCOPE = 'niagara.search.scope',
    // key for local storage
    STORAGE_QUERY = 'niagara.search.query',
    // key for session storage
    STORAGE_SUBSCRIBE = 'niagara.search.subscribe',
    // key for local storage
    STORAGE_PAGE = 'niagara.search.page',
    // key for session storage
    STORAGE_PAGE_SIZE = 'niagara.search.pageSize',
    // key for local storage
    STORAGE_TASK_ORD = 'niagara.search.taskOrd',
    // key for session storage
    STORAGE_TASK_NAV_ORD = 'niagara.search.taskNavOrd',
    // key for session storage

    _localStorage,
    _sessionStorage;
  function widgetDefaults() {
    return {
      properties: {
        hideCommandBar: {
          value: true,
          hidden: true,
          "transient": true,
          readonly: true
        },
        newQuickSearchSubmission: {
          value: false,
          parameter: true,
          hidden: true,
          "transient": true,
          readonly: true
        },
        query: {
          value: '',
          parameter: true,
          hidden: true,
          "transient": true
        },
        scope: {
          value: '',
          parameter: true,
          hidden: true,
          "transient": true
        },
        sub: {
          value: '',
          parameter: true,
          hidden: true,
          "transient": true
        },
        pageSize: {
          value: '',
          parameter: true,
          hidden: true,
          "transient": true
        },
        hyperlinkOnSearch: {
          value: true,
          hidden: true
        }
      }
    };
  }

  /**
   * The Search Widget.
   *
   * @class
   * @extends module:bajaux/Widget
   * @alias module:nmodule/search/rc/SearchWidget
   */
  var SearchWidget = function SearchWidget(params) {
    var cachedScope = readFromStorage(this, getLocalStorage(), STORAGE_SCOPE),
      cachedSubscribe = readFromStorage(this, getLocalStorage(), STORAGE_SUBSCRIBE);

    //see Widget.js default constructor
    var args = arguments;
    if (!params || _typeof(params) !== 'object') {
      params = {
        moduleName: args[0],
        keyName: args[1],
        formFactor: args[2]
      };
    }
    Widget.call(this, {
      params: params,
      defaults: widgetDefaults()
    });

    /**
     * The search scope filter as a baja.EnumSet
     * @type {baja.EnumSet}
     */
    this.$searchScopes = cachedScope ? baja.EnumSet.DEFAULT.decodeFromString(cachedScope) : null;

    /**
     * Whether or not to subscribe to results
     * @type {boolean}
     */
    this.$subscribeResults = !cachedSubscribe || cachedSubscribe === 'true';

    /**
     * The positive integer page size as a string
     * @type {String}
     */
    setCurrentPageSize(this, readFromStorage(this, getLocalStorage(), STORAGE_PAGE_SIZE, '20'));
  };

  //extend and set up prototype chain
  SearchWidget.prototype = Object.create(Widget.prototype);
  SearchWidget.prototype.constructor = SearchWidget;

  /**
   * Do initial setup of the DOM for the Widget. This will set up the DOM's
   * structure and create a space where the commands and table will go.
   *
   * @param {jQuery} element the DOM element into which to load this Widget
   */
  SearchWidget.prototype.doInitialize = function (dom) {
    var that = this;
    dom.html(tplSearchWidgetStructure({
      defaultQueryText: lex.get('SearchWidget.query.defaultText'),
      searchText: lex.get('SearchWidget.displayName'),
      currentPage: lex.get('SearchWidget.currentPage'),
      prevText: lex.get('SearchWidget.commands.prev.label'),
      nextText: lex.get('SearchWidget.commands.next.label'),
      compact: that.getFormFactor() === Widget.formfactor.compact
    }));

    // TODO: This is a temporary hack to remove the background color on the search
    // bar as the rounded borders of the enclosing JavaFx pane cause a noticeable
    // white gap to appear, so making the background white hides this.
    if (isWorkbench()) {
      dom.find(CONFIG_CLASS).first().css('background-color', 'transparent');
    }

    // Initially these fields are disabled and/or hidden until a search query is submitted
    dom.find(PAGE_CLASS).first().prop('disabled', true);
    dom.find(NEXT_CLASS).first().prop('disabled', true);
    dom.find(PREV_CLASS).first().prop('disabled', true);
    dom.find(PAGE_CMD_CLASS).hide();
    dom.find(PROGRESS_IMG_CLASS).first().hide();
    updateErrorDisplay(that);

    // Query text field handler (submit search on enter key press)
    dom.on('keypress', QUERY_CLASS, function (event) {
      if (event.which === 13) {
        searchHyperlink(that);
      }
    });

    // Query text field handler (submit search on speech change)
    dom.on('webkitspeechchange speechchange', QUERY_CLASS, function () {
      searchHyperlink(that);
    });

    // Search button handler
    dom.on('click', SEARCH_CLASS, function () {
      searchHyperlink(that);
    });

    // Page selection handler
    dom.on('change', PAGE_CLASS, function () {
      enforcePageLimits(that);
      saveToSessionStorage(that, STORAGE_PAGE, PAGE_CLASS);
      submitSearch(that, /*newQuery*/false);
    });

    // Next Page button handler
    dom.on('click', NEXT_CLASS, function () {
      var page = dom.find(PAGE_CLASS).first(),
        newPage = parseInt(page.val(), 10) + 1;
      page.val(newPage);
      page.change();
    });

    // Previous Page button handler
    dom.on('click', PREV_CLASS, function () {
      var page = dom.find(PAGE_CLASS).first(),
        newPage = parseInt(page.val(), 10) - 1;
      if (newPage < 1) {
        newPage = 1;
        return;
      }
      page.val(newPage);
      page.change();
    });
  };

  /**
   * Loads in a BSearchService value and kicks off a search if it finds
   * a query view parameter.  It can also load cached search results from
   * a previous search.
   */
  SearchWidget.prototype.doLoad = function (searchService) {
    var that = this,
      dom = that.jq(),
      cachedTask = readFromStorage(that, window.sessionStorage, STORAGE_TASK_ORD),
      quickSearch = baja.SlotPath.unescape(that.properties().getValue('query')),
      queryField,
      newQuickSearch = that.properties().getValue('newQuickSearchSubmission', false),
      subscribe = baja.SlotPath.unescape(that.properties().getValue('sub')),
      cachedScope = SearchScope.decodeSelectedScopes(baja.SlotPath.unescape(that.properties().getValue('scope'))),
      pageSize = baja.SlotPath.unescape(that.properties().getValue('pageSize'));

    // Loads the SearchResultsWidget to use for displaying search results
    function loadResultsWidget() {
      if (that.$searchResultsWidget) {
        loadSearch();
      } else {
        return getSearchResultsWidget(that).then(function (widgetTemplate) {
          return fe.buildFor({
            dom: dom.find(CONTENT_CLASS).first(),
            value: searchService,
            type: widgetTemplate
          });
        }).then(function (ed) {
          // TODO: Do I need to listen for modification events on this widget and propogate them up?
          that.$searchResultsWidget = ed;
          that.$searchResultsWidget.properties().add("formFactor", that.getFormFactor());
          loadSearch();
        });
      }
    }
    function loadSearch() {
      var cachedSubscribe;
      if (subscribe) {
        that.$subscribeResults = subscribe === 'true';
        writeToStorage(that, getLocalStorage(), STORAGE_SUBSCRIBE, subscribe);
      } else {
        // TODO: I think this can go away if we load it in the constructor?
        cachedSubscribe = readFromStorage(that, getLocalStorage(), STORAGE_SUBSCRIBE);
        that.$subscribeResults = !cachedSubscribe || cachedSubscribe === 'true';
      }
      if (pageSize) {
        setCurrentPageSize(that, pageSize);
        writeToStorage(that, getLocalStorage(), STORAGE_PAGE_SIZE, that.$resultsPageSize);
      } else {
        // TODO: I think this can go away if we load it in the constructor?
        setCurrentPageSize(that, readFromStorage(that, getLocalStorage(), STORAGE_PAGE_SIZE, '20'));
      }
      if (newQuickSearch || quickSearch && !(cachedTask && quickSearch === readFromStorage(that, getSessionStorage(), STORAGE_QUERY))) {
        // In the case of a quick search, perform the search based on the query
        // passed in as a view parameter

        that.properties().setValue('newQuickSearchSubmission', false);
        removeCachedTask(cachedTask);
        saveToSessionStorage(that, STORAGE_QUERY, QUERY_CLASS);
        submitSearch(that, /*newQuery*/true);
      } else {
        // If the search query is not specified in the view parameters,
        // check local storage for the last known search and use cached results
        loadFromSessionStorage(that, STORAGE_QUERY, QUERY_CLASS);
        loadFromSessionStorage(that, STORAGE_PAGE, PAGE_CLASS);
        if (cachedTask) {
          submitSearch(that, /*newQuery*/true, cachedTask);
        }
      }
    }
    if (quickSearch) {
      queryField = dom.find(QUERY_CLASS).first();
      queryField.val(quickSearch);
    }
    initSubscriber(that);
    if (!cachedScope) {
      cachedScope = readFromStorage(that, getLocalStorage(), STORAGE_SCOPE);
      if (cachedScope) {
        cachedScope = baja.EnumSet.DEFAULT.decodeFromString(cachedScope, baja.Simple.$unsafeDecode);
      }
    }
    return SearchScope.getScopesAsEnumSet(searchService, cachedScope).then(function (serverScopes) {
      that.$searchScopes = serverScopes;
      writeToStorage(that, getLocalStorage(), STORAGE_SCOPE, serverScopes.encodeToString());
      if (that.$settingsButton) {
        return loadResultsWidget();
      } else {
        var isCompact = that.getFormFactor() === Widget.formfactor.compact;
        var commands = [new SettingsCommand(that)];
        if (isCompact) {
          commands.push(new GoToSearchService(that));
        } else {
          commands.splice(0, 0, new BqlBuilderCommand(that));
        }
        return fe.buildFor({
          dom: dom.find(COMMAND_GROUP_CLASS).first(),
          value: new CommandGroup({
            commands: commands
          }),
          type: CommandButtonGroup,
          properties: {
            toolbar: true
          }
        }).then(function (ed) {
          that.$settingsButton = ed;
          return loadResultsWidget();
        });
      }
    });
  };

  /**
   * Called by `destroy` so a developer has a chance to clean up
   * before the DOM is destroyed.
   *
   * @see module:bajaux/Widget#destroy
   *
   * @param {Object} [params] Optional params object passed to
   * `destroy()`
   * @param {$.Promise} An optional promise that's resolved once the widget has been destroyed.
   */
  SearchWidget.prototype.doDestroy = function (params) {
    $(window).off('resize', this.$resizeHandler);
    cleanupSubscriber(this);
    if (this.$searchResultsWidget && this.$settingsButton) {
      return Promise.all([this.$searchResultsWidget.destroy(params), this.$settingsButton.destroy(params)]);
    } else if (this.$searchResultsWidget) {
      return this.$searchResultsWidget.destroy(params);
    } else if (this.$settingsButton) {
      return this.$settingsButton.destroy(params);
    }
  };

  /**
   * Called when the widget is enabled/disabled.
   *
   * @param {Boolean} enabled the new enabled state.
   * @returns {$.Promise} An optional Promise that can be returned if
   * the state change is asynchronous.
   */
  SearchWidget.prototype.doEnabled = function (enabled) {
    if (this.$searchResultsWidget) {
      return this.$searchResultsWidget.setEnabled(enabled);
    }
  };

  /**
   * Called when the widget is set to readonly or made writable.
   *
   * @param {Boolean} readonly the new readonly state.
   * @returns {$.Promise} An optional Promise that can be returned if
   * the state change is asynchronous.
   */
  SearchWidget.prototype.doReadonly = function (readonly) {
    if (this.$searchResultsWidget) {
      return this.$searchResultsWidget.setReadonly(readonly);
    }
  };

  // TODO: Do I need to worry about propogating doSave(), doRead(), and modify to the searchResultsWidget?

  /**
   * Sets the search scope filter and optionally updates the search results.
   *
   * @param {baja.EnumSet} scopeFilter is the new search scope filter to use
   * @param {Boolean} updateResults is an optional flag that when true triggers
   * the search results to immediately update using the new search scope filter
   */
  SearchWidget.prototype.setScopeFilter = function (scopeFilter, updateResults) {
    var that = this;
    function setSearchScopes(scopes) {
      that.$searchScopes = scopes;
      writeToStorage(that, getLocalStorage(), STORAGE_SCOPE, scopes.encodeToString());
      if (updateResults) {
        // TODO: Instead of hyperlinking in the non-WB case, it could change the URL and just call submitSearch
        //submitSearch(that, /*newQuery*/true);
        searchHyperlink(that);
      }
    }
    if (!that.$searchScopes.equals(scopeFilter)) {
      if (scopeFilter.getOrdinals().length < 1) {
        // Don't allow an empty scope selection. Instead revert back to the default scope selection
        SearchScope.getScopesAsEnumSet(that.value(), /*use default*/null).then(function (serverScopes) {
          setSearchScopes(serverScopes);
        })["catch"](logSevere);
      } else {
        setSearchScopes(scopeFilter);
      }
    }
  };

  /**
   * Enables or Disables subscription to search results.
   *
   * @param {Boolean} subscribe enables subscription of search results when true, or
   * disables subscription of search results when false.
   * @param {Boolean} updateResults is an optional flag that when true triggers
   * the search results to immediately update with the new subscription state.
   */
  SearchWidget.prototype.setSubscribeToResults = function (subscribe, updateResults) {
    if (this.$subscribeResults !== subscribe) {
      this.$subscribeResults = subscribe;
      writeToStorage(this, getLocalStorage(), STORAGE_SUBSCRIBE, subscribe.toString());
      if (updateResults && this.$searchResultsWidget) {
        // TODO: If we decide the subscribe state should always be persisted as a view parameter
        // this is where we could modify the URL and/or search hyperlink if needed
        this.$searchResultsWidget.updateSubscription(subscribe);
      }
    }
  };

  /**
   * Sets the page size to use when displaying search results.  The enforced
   * pageSize limits are in the range of 1 to 100.
   *
   * @param {String} pageSize is a numeric value in String form that defines
   * the new page size to use when displaying search results.  It should be a positive
   * Integer value greater than zero but less than or equal to 100.
   * @param {Boolean} updateResults is an optional flag that when true triggers
   * the search results to immediately update using the new page size.
   */
  SearchWidget.prototype.setPageSize = function (pageSize, updateResults) {
    if (this.$resultsPageSize !== pageSize) {
      setCurrentPageSize(this, pageSize);
      enforcePageLimits(this);
      writeToStorage(this, getLocalStorage(), STORAGE_PAGE_SIZE, this.$resultsPageSize);
      if (updateResults) {
        // TODO: If we decide the page size should always be persisted as a view parameter
        // this is where we could modify the URL and/or search hyperlink if needed
        submitSearch(this, /*newQuery*/false);
      }
    }
  };

  ////////////////////////////////////////////////////////////////
  // Private functions
  ////////////////////////////////////////////////////////////////

  /**
   * Private function to asynchronously retrieve the Search Results Widget to
   * use for displaying search results.
   *
   * @inner
   * @param widget - The search widget
   * @returns {Promise}
   */
  function getSearchResultsWidget(widget) {
    // TODO: Eventually this widget is selectable/looked up from registry instead of being hardcoded here
    if (widget.getFormFactor() === Widget.formfactor.compact) {
      return doRequire('nmodule/search/rc/DefaultSearchResultsCompactWidget');
    } else {
      return doRequire('nmodule/search/rc/DefaultSearchResultsWidget');
    }
  }

  /**
   * Private function to return the {baja:Ord} to the search
   * task for the current search, or null if it cannot be found.
   *
   * @inner
   * @param widget - The search widget
   */
  function getSearchTaskOrd(widget) {
    var dom = widget.jq(),
      taskOrdStr = dom.find(PROGRESS_CONTAINER_CLASS).first().data('task');
    if (taskOrdStr) {
      return baja.Ord.make(taskOrdStr);
    } else {
      return null;
    }
  }

  /**
   * Private function to asynchronously remove an old cached search task on the server
   * when we no longer need it.
   *
   * @inner
   * @param cachedTaskOrd - A string ORD to the cached task that can be removed on the server
   */
  function removeCachedTask(cachedTaskOrd) {
    if (cachedTaskOrd) {
      baja.Ord.make(cachedTaskOrd).get().then(function (task) {
        if (task) {
          if (task.getSlot('expire')) {
            // First attempt to use the expire action
            return task.expire();
          } else if (task.getParent()) {
            // Otherwise try to manually remove it
            return task.getParent().remove(task);
          }
        }
      })["catch"](logSevere);
    }
  }

  /**
   * Private function to return the (zero-based) index for the
   * current page being displayed.
   *
   * @inner
   * @param widget - The search widget
   */
  function getCurrentPageIndex(widget) {
    // TODO: This function may become obsolete with infinite scrolling
    var dom = widget.jq(),
      page = dom.find(PAGE_CLASS).first();
    return parseInt(page.val(), 10) - 1;
  }

  /**
   * Private function to return the current page size
   * as an integer value.
   *
   * @inner
   * @param widget - The search widget
   */
  function getCurrentPageSize(widget) {
    // TODO: This function may become obsolete with infinite scrolling
    return parseInt(widget.$resultsPageSize, 10);
  }

  /**
   * Private function to set the current page size
   * while enforcing page size limits (1 - 100).
   *
   * @inner
   * @param widget - The search widget
   * @param {String} pageSize is a numeric value in String form that defines
   * the new page size to use when displaying search results.  It should be a positive
   * Integer value greater than zero but less than or equal to 100.
   */
  function setCurrentPageSize(widget, pageSize) {
    // TODO: This function may become obsolete with infinite scrolling
    var newSize = parseInt(pageSize, 10);

    // Enforce page size limits
    if (isNaN(newSize)) {
      pageSize = '20'; // Revert to default
    } else if (newSize < 1) {
      pageSize = '1';
    } else if (newSize > 100) {
      pageSize = '100';
    }
    if (widget.$resultsPageSize !== pageSize) {
      widget.$resultsPageSize = pageSize;
    }
  }

  /**
   * Private function to update the summary display for the current results
   * displayed.
   *
   * @inner
   * @param widget - The search widget
   */
  function updateDisplayedResults(widget) {
    var dom = widget.jq(),
      pageIndex = getCurrentPageIndex(widget),
      pageSize = getCurrentPageSize(widget),
      startIndex = pageIndex * pageSize + 1,
      endIndex = startIndex + widget.$searchResultsWidget.getDisplayedResultsCount() - 1,
      displayedResults = dom.find(DISPLAYED_RESULTS_CLASS).first(),
      lexKey = widget.getFormFactor() === Widget.formfactor.compact ? COMPACT_RESULTS_LKEY : RESULTS_LKEY;
    if (endIndex < startIndex) {
      displayedResults.text('');
    } else {
      displayedResults.text(lex.get({
        key: lexKey,
        args: [startIndex, endIndex]
      }));
    }
  }
  function shouldHyperlinkOnSearch(widget) {
    if (typeof niagara === 'undefined' || !niagara.env || !niagara.env.hyperlink) {
      return false;
    }
    if (widget.getFormFactor() !== Widget.formfactor.max) {
      return false;
    }
    return widget.properties().getValue('hyperlinkOnSearch');
  }

  /**
   * Private function to create the ORD for the search widget with the
   * view parameters read from the DOM and hyperlink to the generated ORD.
   *
   * @inner
   * @param widget - The search widget
   * @param {Object} [params] the Object Literal for the method's arguments.
   * @param {boolean} [params.forceHyperlink=false] force the search to hyperlink to the main search service view
   *
   */
  function searchHyperlink(widget) {
    var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
      forceHyperlink: false
    };
    // Build the ORD with view parameters and hyperlink
    var dom = widget.jq(),
      query = dom.find(QUERY_CLASS).first().val(),
      // TODO: If subscribe state needs to be persisted in the ORD, re-enable the following line
      //subscribe = widget.$subscribeResults.toString(),
      cachedTask = readFromStorage(widget, getSessionStorage(), STORAGE_TASK_ORD),
      searchOrd;
    saveToSessionStorage(widget, STORAGE_QUERY, QUERY_CLASS);

    // For a new search, we can also asynchronously attempt to remove the old
    // (cached) search task.  We'll just do this behind the scenes, because if
    // it fails to remove it, not a big deal since the SearchService's
    // cleanup policy will eventually remove it.  This is just an attempt to
    // optimize the cleanup when we can detect that an old search task is no
    // longer needed.
    removeCachedTask(cachedTask);

    // Must empty the cached task reference so it won't try to use it on the upcoming doLoad()
    writeToStorage(widget, getSessionStorage(), STORAGE_TASK_ORD, '');
    writeToStorage(widget, getSessionStorage(), STORAGE_TASK_NAV_ORD, '');
    searchOrd = 'service:search:SearchService|view:search:SearchWidget?query=' + baja.SlotPath.escape(query);
    //searchOrd += ';sub=' + baja.SlotPath.escape(subscribe);  // TODO: See TODO above
    if (widget.$searchScopes.getOrdinals().length > 0) {
      searchOrd += ';scope=' + baja.SlotPath.escape(SearchScope.encodeSelectedScopes(widget.$searchScopes));
    }
    searchOrd = baja.Ord.make(searchOrd);
    if (shouldHyperlinkOnSearch(widget) || params.forceHyperlink) {
      niagara.env.hyperlink(searchOrd);
    } else {
      submitSearch(widget, /*newQuery*/true);
    }
  }

  /**
   * Private function to asynchronously submit a search query, subscribe to the search task,
   * and notify the SearchResultsWidget that it can load search results.
   *
   * @inner
   * @param widget - The search widget
   * @param newQuery - when this boolean value is true, the query text field
   * will be read and a new search submitted to the station.  When false,
   * a previously submitted search will be used (usually means a new page of
   * results needs to be displayed for an existing search).
   * @param cachedTaskOrd - this optional parameter specifies an ORD to a
   * previously submitted search task that should be reused to build the current
   * page in the table of results
   */
  function submitSearch(widget, newQuery, cachedTaskOrd) {
    var dom = widget.jq();
    function performSearch() {
      var scopeOrds = SearchScope.getScopeOrds(widget.$searchScopes),
        searchParams = baja.$("search:SearchParams"),
        i;
      dom.find(PAGE_CLASS).first().val(1); // Always reset current page to 1 on a new query submission
      saveToSessionStorage(widget, STORAGE_PAGE, PAGE_CLASS);
      searchParams.setQuery(dom.find(QUERY_CLASS).first().val());
      for (i = 0; i < scopeOrds.length; i++) {
        searchParams.getScopeVector().add({
          slot: 'scope?',
          value: scopeOrds[i]
          // TODO: Use batch?  Probably not necessary since this comp is not mounted
        });
      }

      // Invoke an action on the station's SearchService to kick off a search task
      widget.value().search(searchParams).then(function (jOrd) {
        return subscribeSearchTask(widget, jOrd, /*cachedTask*/false)["catch"](function (ignore) {});
      })["catch"](function (err) {
        // TODO: In case of a failure to submit the search, should we unsubscribe/detach/cleanup
        // the old search task/results?
        var failureMessage = extractErrorMessage(err);
        if (!failureMessage) {
          failureMessage = lex.get('SearchWidget.error.submitSearch');
        }
        dom.find(PROGRESS_CLASS).first().html(tplSearchWidgetProgress({
          totalResults: 0,
          ord: 'null',
          searchProgress: lex.get({
            key: "SearchWidget.searchProgress",
            args: ['0', '']
          })
        }));
        updateErrorDisplay(widget, failureMessage);
        dom.find(CONTENT_CLASS).first().html('');
        dom.find(DISPLAYED_RESULTS_CLASS).first().html('');
        enforcePageLimits(widget);
      });
    }

    // Clear any old results displayed before displaying the new
    updateErrorDisplay(widget);
    dom.find(CONTENT_CLASS).first().html('');
    dom.find(DISPLAYED_RESULTS_CLASS).first().html(LOADING_TXT);
    if (newQuery) {
      dom.find(PAGE_CMD_CLASS).hide();
      dom.find(PROGRESS_CLASS).first().html('');
      if (cachedTaskOrd) {
        subscribeSearchTask(widget, baja.Ord.make(cachedTaskOrd), /*cachedTask*/true)["catch"](function (ignore) {
          var quickSearch = baja.SlotPath.unescape(widget.properties().getValue('query'));
          if (quickSearch) {
            // If the query was submitted as a view parameter, resubmit it
            dom.find(QUERY_CLASS).first().val(quickSearch);
            removeCachedTask(cachedTaskOrd);
            saveToSessionStorage(widget, STORAGE_QUERY, QUERY_CLASS);
            performSearch();
          } else {
            // We couldn't find the cached search task, so display an appropriate error message
            updateErrorDisplay(widget, lex.get('SearchWidget.cache.unavailable'));
          }
        });
      } else {
        performSearch();
      }
    } else {
      if (widget.$loadInProgress) {
        widget.$loadInQueue = true;
      } else {
        widget.$loadInProgress = true;
        widget.$searchResultsWidget.loadSearchResults(widget.value(), getSearchTaskOrd(widget), widget.$subscribeResults, getCurrentPageIndex(widget), getCurrentPageSize(widget)).then(function () {
          updateDisplayedResults(widget);
        })["catch"](function (err) {
          var failureMessage = extractErrorMessage(err),
            progress = dom.find(PROGRESS_CONTAINER_CLASS).first(),
            totalResults = progress ? parseInt(progress.data('totalresults'), 10) : 0,
            progressMsg = progress ? progress.text() : lex.get({
              key: "SearchWidget.searchProgress",
              args: [totalResults, '']
            });
          if (!failureMessage) {
            failureMessage = lex.get('SearchWidget.cache.unavailable');
          }
          dom.find(PROGRESS_CLASS).first().html(tplSearchWidgetProgress({
            totalResults: totalResults,
            ord: getSearchTaskOrd(widget).toString(),
            searchProgress: progressMsg
          }));
          updateErrorDisplay(widget, failureMessage);
          dom.find(DISPLAYED_RESULTS_CLASS).first().html('');
        })["finally"](function () {
          enforcePageLimits(widget);
          widget.$loadInProgress = false;
          if (widget.$loadInQueue) {
            widget.$loadInQueue = false;
            submitSearch(widget, /*newQuery*/false);
          }
        });
      }
    }
  }

  /**
   * This private function is called when the subscriber detects that a property
   * changed on the search task.  It gives the opportunity to check for new search
   * results that have come in and processes them as necessary.  It also updates the
   * result statistics.
   *
   * @inner
   * @param widget - The search widget
   * @param obj A Niagara object (ie. the search task) whose state has changed.
   * @param prop (Optional) The property on the Niagara object (component)
   * that changed.
   * @param cx (Optional) The context associated with the property change.
   * @returns {Promise}
   */
  function checkForNewResults(widget, obj, prop, cx) {
    var ord = obj.getOrdInSession(),
      ordInSession = ord.toString(),
      dom = widget.jq(),
      resultCount,
      resultsExceedLimit,
      currentPageCount,
      pageSize,
      pageIndex,
      endIdx;

    // If the changed component is the search task itself, update the result statistics
    if (ordInSession === dom.find(PROGRESS_CONTAINER_CLASS).first().data('task')) {
      resultCount = obj.getResultCount();
      resultsExceedLimit = obj.getResultsExceedLimit() ? lex.get('SearchWidget.resultsExceedLimit') : '';
      currentPageCount = widget.$searchResultsWidget.getDisplayedResultsCount();
      pageSize = parseInt(widget.$resultsPageSize, 10);
      pageIndex = parseInt(dom.find(PAGE_CLASS).first().val(), 10) - 1;
      endIdx = pageIndex * pageSize + currentPageCount;
      updateLoadingIndicator(widget, false, obj);
      dom.find(PROGRESS_CLASS).first().html(tplSearchWidgetProgress({
        totalResults: resultCount,
        ord: ordInSession,
        searchProgress: lex.get({
          key: "SearchWidget.searchProgress",
          args: [resultCount, resultsExceedLimit]
        })
      }));

      // If the current results shown on the current page needs updating
      // based on detecting more results have been added to the search task,
      // then rebuild the page of results
      // The conditions under which the page needs updating are:
      //   - The current page has less results than the page size AND
      //   - the index of the last page result shown is less than the total resultCount
      if (currentPageCount < pageSize && endIdx < resultCount) {
        return widget.$searchResultsWidget.appendNewResults(widget.value(), ord, widget.$subscribeResults, /*startIndex*/endIdx, /*maxResults*/pageSize - currentPageCount)["catch"](function (err) {
          var failureMessage = extractErrorMessage(err);
          if (!failureMessage) {
            failureMessage = lex.get('SearchWidget.error.appendResults');
          }
          dom.find(PROGRESS_CLASS).first().html(tplSearchWidgetProgress({
            totalResults: resultCount,
            ord: ordInSession,
            searchProgress: lex.get({
              key: "SearchWidget.searchProgress",
              args: [resultCount, resultsExceedLimit]
            })
          }));
          updateErrorDisplay(widget, failureMessage);
        })["finally"](function () {
          updateDisplayedResults(widget);
          enforcePageLimits(widget);
        });
      } else {
        enforcePageLimits(widget);
      }
    }
    return Promise.resolve();
  }

  /**
   * After a search is submitted to the station, this private function is called
   * with the ORD to the search task for further processing (ie. subscribe for updates
   * on the search task and notify the SearchResultsWidget to load initial results).
   *
   * @inner
   * @param widget - The search widget
   * @param jOrd The ORD to the search task
   * @param cachedTask true if this task is for a cached search, false if it is for a new search
   * @returns {Promise}
   */
  function subscribeSearchTask(widget, jOrd, cachedTask) {
    var dom = widget.jq(),
      taskOrd = jOrd.relativizeToSession();
    updateLoadingIndicator(widget, true);
    updateErrorDisplay(widget);
    initSubscriber(widget);

    // Stop subscribing to events on any old search tasks/results, and
    // when that completes, resolve and subscribe to the new search task
    // after syncing the component space
    return tryToSyncComponentSpace(widget.value().getComponentSpace()).then(function () {
      // Resolve and subscribe the BSearchTask...
      return taskOrd.get({
        subscriber: widget.$taskSubscriber
      });
    }).then(function (task) {
      if (cachedTask) {
        // We observed a rare error condition in which an old handle ORD to an expired search
        // task was being reused by another station component at a later time.  This could lead
        // to resolving the wrong ORD, so we added a check for the search task's Nav Ord as a
        // second check for the cached task's proper identity
        var cachedNavOrd = readFromStorage(widget, getSessionStorage(), STORAGE_TASK_NAV_ORD),
          taskNavOrd = task.getNavOrd();
        if (!taskNavOrd || taskNavOrd.relativizeToSession().toString() !== cachedNavOrd) {
          throw new Error('Cached search task cannot be resolved');
        }
      }
      dom.find(QUERY_CLASS).first().val(task.getQuery());
      saveToSessionStorage(widget, STORAGE_QUERY, QUERY_CLASS);

      // Write the task's handle ord to local storage, since the slot
      // ORD is not safe (the SearchService could reuse the slot path for
      // a different task)
      writeToStorage(widget, getSessionStorage(), STORAGE_TASK_ORD, task.getOrdInSession().toString());
      writeToStorage(widget, getSessionStorage(), STORAGE_TASK_NAV_ORD, task.getNavOrd().relativizeToSession().toString());
      var resultsExceedLimit = task.getResultsExceedLimit() ? lex.get('SearchWidget.resultsExceedLimit') : '';
      dom.find(PROGRESS_CLASS).first().html(tplSearchWidgetProgress({
        totalResults: task.getResultCount(),
        ord: task.getOrdInSession().toString(),
        searchProgress: lex.get({
          key: "SearchWidget.searchProgress",
          args: [task.getResultCount(), resultsExceedLimit]
        })
      }));
      widget.$searchResultsWidget.loadSearchResults(widget.value(), task.getOrdInSession(), widget.$subscribeResults, getCurrentPageIndex(widget), getCurrentPageSize(widget)).then(function () {
        var resultCount = task.getResultCount(),
          displayedResultCount = widget.$searchResultsWidget.getDisplayedResultsCount();
        if (displayedResultCount > resultCount) {
          resultCount = displayedResultCount;
        }
        resultsExceedLimit = task.getResultsExceedLimit() ? lex.get('SearchWidget.resultsExceedLimit') : '';
        dom.find(PROGRESS_CLASS).first().html(tplSearchWidgetProgress({
          totalResults: resultCount,
          ord: task.getOrdInSession().toString(),
          searchProgress: lex.get({
            key: "SearchWidget.searchProgress",
            args: [resultCount, resultsExceedLimit]
          })
        }));
        updateLoadingIndicator(widget, true, task);
        updateDisplayedResults(widget);
        enforcePageLimits(widget, task);
      })["catch"](function (err) {
        var failureMessage = extractErrorMessage(err);
        if (!failureMessage) {
          failureMessage = lex.get('SearchWidget.error.retrieveResults');
        }
        dom.find(PROGRESS_CLASS).first().html(tplSearchWidgetProgress({
          totalResults: 0,
          ord: 'null',
          searchProgress: lex.get({
            key: "SearchWidget.searchProgress",
            args: ['0', '']
          })
        }));
        dom.find(DISPLAYED_RESULTS_CLASS).first().html('');
        updateLoadingIndicator(widget, true, task);
        updateErrorDisplay(widget, failureMessage);
        enforcePageLimits(widget);
        throw err;
      });
    })["catch"](function (err) {
      var failureMessage = extractErrorMessage(err);
      if (!failureMessage) {
        failureMessage = lex.get('SearchWidget.cache.unavailable');
      }
      if (!cachedTask) {
        failureMessage = lex.get('SearchWidget.task.resolveFail');
        baja.outln('Failed to resolve search task ' + taskOrd);
        baja.error(err);
      }
      dom.find(PROGRESS_CLASS).first().html(tplSearchWidgetProgress({
        totalResults: 0,
        ord: 'null',
        searchProgress: lex.get({
          key: "SearchWidget.searchProgress",
          args: ['0', '']
        })
      }));
      if (!cachedTask) {
        updateErrorDisplay(widget, failureMessage);
      }
      dom.find(CONTENT_CLASS).first().html('');
      dom.find(DISPLAYED_RESULTS_CLASS).first().html('');
      updateLoadingIndicator(widget, false);
      enforcePageLimits(widget);
      throw err;
    });
  }

  /**
   * This private function initializes a new task subscriber for the given
   * SearchWidget after cleaning up the old one.
   *
   * @inner
   * @param widget - The Search Widget
   */
  function initSubscriber(widget) {
    cleanupSubscriber(widget);

    // Attach the subscriber to listen for events on the search task
    widget.$taskSubscriber = new baja.Subscriber();
    widget.$taskSubscriber.attach("changed", function (prop, cx) {
      checkForNewResults(widget, this, prop, cx);
    });
  }

  /**
   * This private function cleans up the old task subscriber for the given
   * Search Widget by asynchronously unsubscribing from everything. It also
   * resets the subscriber on the SearchResultsWidget.
   *
   * @inner
   * @param widget - The Search Widget
   */
  function cleanupSubscriber(widget) {
    if (widget.$taskSubscriber) {
      widget.$taskSubscriber.unsubscribeAll();
      widget.$taskSubscriber = null;
    }
    if (widget.$searchResultsWidget) {
      widget.$searchResultsWidget.updateSubscription(false);
    }
  }

  /**
   * This private function attempts to sync the component space.
   * It returns a Promise that will resolve no matter
   * whether the sync is successful or not.
   *
   * @inner
   * @param space - The component space
   */
  function tryToSyncComponentSpace(space) {
    return space.sync()["catch"](function (err) {
      baja.outln('Failed to sync component space');
      baja.error(err);
    });
  }

  /**
   * This private function ensures that the state of the loading (progress)
   * image next to the search submit button is displayed when appropriate
   * for the given search task
   *
   * @inner
   * @param widget - The search widget
   * @param defaultState - a {boolean} indicating the default state to use for
   * the visibility of the loading image
   * @param task - The search task if it exists
   */
  function updateLoadingIndicator(widget, defaultState, task) {
    var dom = widget.jq(),
      taskState;
    if (task) {
      taskState = task.getJobState();
      defaultState = taskState.is('running') || taskState.is('canceling');
      if (!defaultState && task.getResultCount() < 1) {
        // If the search task is complete and we have no results, give the user
        // a clear indication that there are no results for the search query submitted
        updateErrorDisplay(widget, lex.get('SearchWidget.error.noResults'));
      }
    }
    if (defaultState) {
      dom.find(PROGRESS_IMG_CLASS).first().show();
    } else {
      dom.find(PROGRESS_IMG_CLASS).first().hide(250);
    }
  }

  /**
   * This private function ensures that the state of the error display
   * below the search bar is displayed or hidden when appropriate.
   *
   * @inner
   * @param widget - The search widget
   * @param errorMessage - an optional {String} that when supplied, causes the
   * error display to be shown with the message.  If this parameter is not supplied (or
   * if it is undefined or null or empty), the error display will be hidden.
   */
  function updateErrorDisplay(widget, errorMessage) {
    var errorDiv = widget.jq().find(ERROR_CLASS).first();
    if (errorMessage) {
      errorDiv.text(errorMessage);
      errorDiv.show();
    } else {
      errorDiv.hide();
    }
  }

  /**
   * This private function ensures the state of the page, next button,
   * and previous button are valid for the current search results.
   *
   * @inner
   * @param widget - The search widget
   * @param searchTask is the optional parameter containing the search task from which
   * to retrieve the result count
   */
  function enforcePageLimits(widget, searchTask) {
    var dom = widget.jq(),
      pageCmds = dom.find(PAGE_CMD_CLASS),
      page = dom.find(PAGE_CLASS).first(),
      nextButton = dom.find(NEXT_CLASS).first(),
      prevButton = dom.find(PREV_CLASS).first(),
      pageStr = page.val(),
      pageSizeStr = widget.$resultsPageSize,
      p = stringToPositiveInteger(pageStr, 1),
      size = stringToPositiveInteger(pageSizeStr, 10),
      progress = dom.find(PROGRESS_CONTAINER_CLASS).first(),
      totalResults = progress ? parseInt(progress.data('totalresults'), 10) : 0,
      maxPage;
    if (searchTask && progress) {
      totalResults = searchTask.getResultCount();
    }
    maxPage = Math.ceil(totalResults / size);
    if (isNaN(maxPage) || maxPage < 1) {
      maxPage = 1;
    }
    if (p > maxPage) {
      p = maxPage;
    }
    if (maxPage === 1) {
      page.prop('disabled', true);
      pageCmds.hide();
    } else {
      page.prop('disabled', false);
      pageCmds.show();
    }
    if (p === maxPage) {
      nextButton.prop('disabled', true);
    } else {
      nextButton.prop('disabled', false);
    }
    if (p === 1) {
      prevButton.prop('disabled', true);
    } else {
      prevButton.prop('disabled', false);
    }
    if (pageStr !== String(p)) {
      page.val(p);
      saveToSessionStorage(widget, STORAGE_PAGE, PAGE_CLASS);
    }
    if (pageSizeStr !== String(size)) {
      setCurrentPageSize(widget, String(size));
      writeToStorage(widget, getLocalStorage(), STORAGE_PAGE_SIZE, widget.$resultsPageSize);
    }
  }

  ////////////////////////////////////////////////////////////////
  // Convenience functions
  ////////////////////////////////////////////////////////////////

  /**
   * Convenience method to look for a LocalizableRuntimeException
   * in the given error parameter.  Otherwise it returns null.
   *
   * @inner
   */
  function extractErrorMessage(err) {
    // Before returning the BoxError's message, let's first make sure a
    // Java LocalizableRuntimeException was actually the cause of the error.
    // Otherwise, return null.
    if (err instanceof baja.comm.BoxError && err.message && err.javaStackTrace && err.javaStackTrace.indexOf(LOCALIZABLE_EXCEPTION) > -1) {
      return err.message;
    }
    return null;
  }

  /**
   * Convenience method to parse the given string and return a positive integer
   * value for it.  If any problems are encountered, the defaultValue is returned.
   * If the parsed integer value is negative or zero, a value of 1 will be returned
   * as this is the minimum acceptable value.
   *
   * @inner
   */
  function stringToPositiveInteger(str, defaultValue) {
    var i = parseInt(str, 10);
    if (isNaN(i)) {
      return defaultValue;
    } else if (i < 1) {
      return 1;
    }
    return i;
  }

  /**
   * Returns true if the environment is the Workbench WebView
   *
   * @inner
   */
  function isWorkbench() {
    return typeof niagara !== 'undefined' && niagara.env && niagara.env.type === 'wb';
  }

  /**
   * Generate a local/session storage key given a base key name
   *
   * @inner
   */
  function getStorageKey(widget, key) {
    var formFactor = widget.getFormFactor() + '.';

    // For the Workbench user, we only add the form factor to the key
    if (isWorkbench()) {
      return formFactor + key;
    }

    // For the browser user, we add the user and form factor to the key
    return baja.getUserName() + '.' + formFactor + key;
  }

  /**
   * Read an element's value from the widget's dom (by domClass) and save
   * it in session storage using the supplied key
   *
   * @inner
   */
  function saveToSessionStorage(widget, key, domClass) {
    writeToStorage(widget, getSessionStorage(), key, widget.jq().find(domClass).first().val());
  }

  /**
   * Load an element in the widget's dom (by domClass) using a value
   * previously saved in session storage with the supplied key
   *
   * @inner
   */
  function loadFromSessionStorage(widget, key, domClass) {
    var storedVal = readFromStorage(widget, getSessionStorage(), key);
    if (storedVal) {
      widget.jq().find(domClass).first().val(storedVal);
    }
  }

  /**
   * Write a generic string value to local or session storage with the given key
   *
   * @inner
   */
  function writeToStorage(widget, storage, key, value) {
    try {
      storage.setItem(getStorageKey(widget, key), value);
    } catch (ignore) {}
  }

  /**
   * Read a generic string value from local or session storage with the given key,
   * or return the optional defaultValue if not found (returns null if
   * not found and no defaultValue provided).
   *
   * @inner
   */
  function readFromStorage(widget, storage, key, defaultValue) {
    var storedVal = null;
    try {
      storedVal = storage.getItem(getStorageKey(widget, key));
    } catch (ignore) {
      storedVal = null;
    }
    if (!storedVal && defaultValue) {
      storedVal = defaultValue;
    }
    return storedVal;
  }
  function getLocalStorage() {
    return _localStorage || (_localStorage = storageUtil.getLocalStorage());
  }
  function getSessionStorage() {
    // Workbench's JavaFx WebView currently only supports localStorage, but not
    // sessionStorage. Using localStorage in lieu of sessionStorage is ONLY
    // safe in Workbench.
    if (!_sessionStorage) {
      _sessionStorage = isWorkbench() && !storageUtil.hasSessionStorage() ? getLocalStorage() : storageUtil.getSessionStorage();
    }
    return _sessionStorage;
  }

  //  /**
  //   * Read a generic string value from local storage with the given key,
  //   * or return null if not found.
  //   *
  //   * @inner
  //   */
  //  function removeFromStorage(key) {
  //    try {
  //      var storage = window.localStorage;
  //      storage.setItem(key, ''); // Temporary workaround is to set the item to an empty string
  //      // TODO: key removal doesn't appear to be working between page reloads!!
  //      // TODO: Reproduce and create a defect issue for it
  //      //storage.removeItem(key);
  //    }
  //    catch (ignore) {
  //    }
  //  }//
  var BqlBuilderCommand = /*#__PURE__*/function (_Command) {
    function BqlBuilderCommand(widget) {
      _classCallCheck(this, BqlBuilderCommand);
      return _callSuper(this, BqlBuilderCommand, [{
        module: 'search',
        lex: 'SearchWidget.commands.bqlBuilder',
        func: function func() {
          var query = widget.jq().find(QUERY_CLASS).first().val();
          return feDialogs.showFor({
            type: BqlQueryBuilder,
            value: query,
            properties: {
              hideProjection: true,
              hideRootNode: true
            },
            formFactor: 'compact',
            title: lex.get('SearchWidget.commands.bqlBuilder.displayName')
          }).then(function (savedOrd) {
            if (!savedOrd) {
              return;
            }
            var bqlOnly = getBqlOrdPart(savedOrd);
            widget.jq().find(QUERY_CLASS).first().val(bqlOnly);
            searchHyperlink(widget);
          });
        }
      }]);
    }
    _inherits(BqlBuilderCommand, _Command);
    return _createClass(BqlBuilderCommand);
  }(Command);
  var GoToSearchService = /*#__PURE__*/function (_Command2) {
    function GoToSearchService(widget) {
      _classCallCheck(this, GoToSearchService);
      return _callSuper(this, GoToSearchService, [{
        module: 'search',
        lex: 'SearchWidget.commands.goto',
        func: function func() {
          searchHyperlink(widget, {
            forceHyperlink: true
          });
        }
      }]);
    }
    _inherits(GoToSearchService, _Command2);
    return _createClass(GoToSearchService);
  }(Command);
  /**
   * @param {baja.Ord} ord
   * @returns {string}
   */
  function getBqlOrdPart(ord) {
    var queries = ord.parse();
    var i, schemeName, query;
    for (i = queries.size() - 1; i >= 0; i--) {
      query = queries.get(i);
      schemeName = query.getSchemeName();
      if (schemeName === 'bql') {
        return query.toString();
      }
    }
    return '';
  }
  return SearchWidget;
});
