function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/rdb/rc/mgr/RdbmsHistoryImportUxManager
 * @since Niagara 4.14
 */

define(['baja!', 'baja!driver:ArchiveFolder,rdb:RdbmsHistoryImport,rdb:RdbmsHistoryDeviceExt,' + 'rdb:RdbmsColumnSelection,rdb:RdbmsOptionalColumnSelection', 'log!nmodule.rdb.rc.mgr.RdbmsHistoryImportUxManager', 'Promise', 'underscore', 'nmodule/driver/rc/wb/mgr/history/HistoryImportManager', 'nmodule/history/rc/baja/HistoryId', 'nmodule/rdb/rc/model/RdbmsHistoryImportModel', 'nmodule/rdb/rc/model/RdbmsHistoryLearnModel', 'nmodule/webEditors/rc/wb/mgr/MgrLearn', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/wb/tree/TreeNode'], function (baja, types, log, Promise, _, HistoryImportManager, HistoryId, RdbmsHistoryImportModel, RdbmsHistoryLearnModel, MgrLearn, MgrTypeInfo, compUtils, TreeNode) {
  'use strict';

  var constant = _.constant;
  var logSevere = log.severe.bind(log);
  var _types = _slicedToArray(types, 3),
    ARCHIVE_FOLDER_TYPE = _types[0],
    RDBMS_HISTORY_IMPORT = _types[1],
    RDBMS_HISTORY_EXT = _types[2];
  var DISCOVERY_ICON = baja.Icon.make('module://icons/x16/widgets/table.png');
  function makeDiscoveryTableNode(discovery) {
    var name = discovery.getTableName();
    var node = new TreeNode(name, name);
    node.getIcon = constant(DISCOVERY_ICON);
    node.mayHaveKids = constant(false);
    node.value = constant(discovery);
    return node;
  }

  /**
   * @class
   * @alias module:nmodule/rdb/rc/mgr/RdbmsHistoryImportUxManager
   * @extends module:nmodule/driver/rc/wb/mgr/history/HistoryImportManager
   */
  return /*#__PURE__*/function (_HistoryImportManager) {
    function RdbmsHistoryImportUxManager(params) {
      var _this;
      _classCallCheck(this, RdbmsHistoryImportUxManager);
      _this = _callSuper(this, RdbmsHistoryImportUxManager, [Object.assign({
        moduleName: 'rdb',
        keyName: 'RdbHistoryImportManager',
        folderType: ARCHIVE_FOLDER_TYPE,
        subscriptionDepth: 4,
        editableTypes: [RDBMS_HISTORY_IMPORT],
        getComponentStatus: function getComponentStatus(c) {
          return baja.Status.getStatusFromIStatus(c);
        }
      }, params)]);
      MgrLearn(_this);
      return _this;
    }

    /**
     *
     * @param {JQuery} dom
     * @return {Promise}
     */
    _inherits(RdbmsHistoryImportUxManager, _HistoryImportManager);
    return _createClass(RdbmsHistoryImportUxManager, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        this.on('jobcomplete', function (job) {
          _this2.$doDiscoveryJobComplete(job)["catch"](logSevere);
        });
        return _superPropGet(RdbmsHistoryImportUxManager, "doInitialize", this, 3)(arguments);
      }

      /**
       * @param {baja.Component} historyContainer
       * @returns {Promise.<module:nmodule/rdb/rc/model/RdbmsHistoryImportModel>}
       */
    }, {
      key: "makeModel",
      value: function makeModel(historyContainer) {
        return RdbmsHistoryImportModel.make(historyContainer);
      }

      /**
       * @returns {Promise.<module:nmodule/rdb/rc/model/RdbmsHistoryLearnModel>}
       */
    }, {
      key: "makeLearnModel",
      value: function makeLearnModel() {
        return RdbmsHistoryLearnModel.make();
      }

      /**
       * @returns {Promise}
       */
    }, {
      key: "doDiscover",
      value: function doDiscover() {
        var _this3 = this;
        var rdbHistoryDeviceExt = this.getDeviceExt();
        return rdbHistoryDeviceExt.submitRdbTableDiscoveryJob().then(function (ord) {
          ord = baja.Ord.make({
            base: baja.Ord.make('station:'),
            child: ord.relativizeToSession()
          });
          return _this3.setJob(ord);
        });
      }

      /**
       * Return the device from the current component's history ext.
       *
       * @returns {baja.Component}
       */
    }, {
      key: "getDevice",
      value: function getDevice() {
        return this.getDeviceExt().getParent();
      }

      /**
       * @returns {baja.Component}
       */
    }, {
      key: "getDeviceExt",
      value: function getDeviceExt() {
        return compUtils.closest(this.value(), RDBMS_HISTORY_EXT);
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doDiscoveryJobComplete",
      value: function $doDiscoveryJobComplete(job) {
        this.$discoveredHistories = job.getSlots().is('rdb:RdbmsDiscoveredTable').toValueArray();
        return this.$updateLearnTableModel();
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$updateLearnTableModel",
      value: function $updateLearnTableModel() {
        var learnModel = this.getLearnModel();
        var nodes = this.$discoveredHistories.map(makeDiscoveryTableNode);
        return learnModel.clearRows().then(function () {
          return learnModel.insertRows(nodes, 0);
        });
      }

      /**
       * Returns an object with the proposed subject for the manager AddCommand & MatchCommand
       * @param {baja.Struct} discovery
       * @param {baja.Component} subject when a match is done, it is the database point that we are matching to
       * @returns {Promise.<Object>}
       */
    }, {
      key: "getProposedValuesFromDiscovery",
      value: function getProposedValuesFromDiscovery(discovery, subject) {
        var timeStampColumn = baja.$('rdb:RdbmsColumnSelection');
        timeStampColumn.setColumn(discovery.getTimestampColumn());
        var valueColumn = baja.$('rdb:RdbmsColumnSelection');
        valueColumn.setColumn(discovery.getValueColumn());
        var statusColumn = baja.$('rdb:RdbmsOptionalColumnSelection');
        statusColumn.setUnspecified(true);
        statusColumn.setColumn(discovery.getStatusColumn());
        return Promise.resolve({
          name: discovery.getTableName(),
          values: {
            "rdbTableName": discovery.getTableName(),
            "rdbCatalogName": discovery.getCatalogName(),
            "rdbSchemaName": discovery.getSchemaName(),
            "timestampColumn": timeStampColumn,
            "valueColumn": valueColumn,
            "statusColumn": statusColumn,
            "historyId": HistoryId.make(this.getDevice().getName(), discovery.getTableName())
          }
        });
      }

      /**
       * Return the types available to be created from a given discovery item.
       *
       * @returns {Promise.<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>}
       */
    }, {
      key: "getTypesForDiscoverySubject",
      value: function getTypesForDiscoverySubject() {
        return MgrTypeInfo.make(RDBMS_HISTORY_IMPORT);
      }

      /**
       *
       * @param {baja.Struct} discovery
       * @param {baja.Component} historyObj
       * @returns {boolean}
       */
    }, {
      key: "isExisting",
      value: function isExisting(discovery, historyObj) {
        if (!baja.hasType(historyObj, RDBMS_HISTORY_IMPORT)) {
          return false;
        }
        return discovery.get('tableName').equals(historyObj.get('rdbTableName')) && discovery.get('catalogName').equals(historyObj.get('rdbCatalogName')) && discovery.get('schemaName').equals(historyObj.get('rdbSchemaName'));
      }

      /**
       *
       * @returns {object}
       */
    }, {
      key: "saveStateForOrd",
      value: function saveStateForOrd() {
        var obj = {};
        if (this.$discoveredHistories) {
          obj.discoveredHistories = this.$discoveredHistories.map(function (history) {
            return baja.bson.encodeValue(history);
          });
          obj.deviceOrd = this.getDevice().getNavOrd().toString();
        }
        return obj;
      }

      /**
       * @param {object} param
       * @param {Array} param.discoveredSchedules
       * @param {String} param.deviceOrd
       * @returns {Promise}
       */
    }, {
      key: "restoreStateForOrd",
      value: function restoreStateForOrd(_ref) {
        var _this4 = this;
        var discoveredHistories = _ref.discoveredHistories,
          deviceOrd = _ref.deviceOrd;
        if (discoveredHistories) {
          if (deviceOrd === this.getDevice().getNavOrd().toString()) {
            return Promise.all(discoveredHistories.map(function (history) {
              return baja.bson.decodeAsync(history);
            })).then(function (decodedHistories) {
              _this4.$discoveredHistories = decodedHistories;
              return _this4.$updateLearnTableModel();
            });
          }
        }
        return Promise.resolve();
      }

      /**
       * @param {*} learnSelection the subject selected in the learn table
       * @param {baja.Component} mainSelection the subject from the main table that the learnSelection\
       * subject is being matched to
       * @returns {boolean}
       */
    }, {
      key: "isMatchable",
      value: function isMatchable(learnSelection, mainSelection) {
        return !mainSelection.getType().is('driver:IArchiveFolder') && learnSelection.getType().getTypeSpec() === "rdb:RdbmsDiscoveredTable";
      }
    }]);
  }(HistoryImportManager);
});
