function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/WbLayoutStrategy
 */
define(['log!nmodule.wiresheet.rc.wb.WbLayoutStrategy', 'Promise', 'underscore', 'nmodule/wiresheet/rc/wb/layout/ComponentGlyphLayoutStrategy', 'nmodule/wiresheet/rc/wb/layout/SnakeGlyphLayoutStrategy', 'nmodule/wiresheet/rc/wb/layout/StubGlyphLayoutStrategy', 'nmodule/wiresheet/rc/wb/layout/Mask', 'nmodule/wiresheet/rc/wb/layout/TextBlockGlyphLayoutStrategy', 'nmodule/wiresheet/rc/wb/util/wsUtils'], function (log, Promise, _, ComponentGlyphLayoutStrategy, SnakeGlyphLayoutStrategy, StubGlyphLayoutStrategy, Mask, TextBlockGlyphLayoutStrategy, wsUtils) {
  'use strict';

  var isVertex = wsUtils.isVertex;

  ////////////////////////////////////////////////////////////////
  // WbLayoutStrategy
  ////////////////////////////////////////////////////////////////

  var nullStrat = {
    update: function update(obj, vm) {
      return Promise.resolve();
    }
  };

  /**
   * Layout strategy for determining the positions of Workbench wiresheet
   * glyphs.
   *
   * @class
   * @param {Object} params
   * @param {module:nmodule/wiresheet/rc/wb/layout/Mask} params.mask
   * @alias module:nmodule/wiresheet/rc/wb/WbLayoutStrategy
   */
  var WbLayoutStrategy = function WbLayoutStrategy() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      mask = _ref.mask;
    if (!mask) {
      throw new Error('mask required for WbLayoutStrategy');
    }
    this.$mask = mask;
    this.$strats = {
      ComponentGlyph: new ComponentGlyphLayoutStrategy(),
      PlaceholderGlyph: nullStrat,
      SnakeGlyph: new SnakeGlyphLayoutStrategy(),
      StubGlyph: new StubGlyphLayoutStrategy(),
      TextBlockGlyph: new TextBlockGlyphLayoutStrategy()
    };
  };

  /**
   * Do a one-time layout of all glyphs in the view model.
   *
   * @param {module:nmodule/wiresheet/rc/wb/WbViewModel} vm
   * @returns {Promise} promise to be resolved when the initial layout has been
   * completed.
   */
  WbLayoutStrategy.prototype.initialize = function (vm) {
    var _this = this;
    this.$viewModel = vm;
    this.$mask.clear();
    return Promise.all([vm.getVertices(), vm.getEdges()]).then(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
        vertices = _ref3[0],
        triples = _ref3[1];
      _this.updateAll(vertices.concat(triples));
    });
  };

  /**
   * Updates layout information of the given entity.
   *
   * @param {Object} entity a vertex (has a `glyph` property) or an edge (has
   * `predicate` property)
   */
  WbLayoutStrategy.prototype.update = function (entity) {
    var mask = this.$mask;
    return entity.predicate ? this.$updateEdge(entity, mask) : this.$updateVertex(entity, mask);
  };

  /**
   * Updates layout information of all the given entities.
   *
   * @param {Object[]} entities
   */
  WbLayoutStrategy.prototype.updateAll = function (entities) {
    var update = this.update.bind(this);
    return workbenchSort(entities, this.$viewModel).filter(update);
  };

  /**
   * After an entity is added to the database, we update its layout and 
   * all other layouts of impacted entities and emit an updated event for each 
   * of the changed entities.
   * @private
   * @returns {Promise}
   */
  WbLayoutStrategy.prototype.$updateLayout = function () {
    var _this2 = this;
    var vm = this.$viewModel;
    return log.timing(function () {
      return Promise.all([vm.getVertices(), vm.getEdges()]).then(function (_ref4) {
        var _ref5 = _slicedToArray(_ref4, 2),
          vertices = _ref5[0],
          triples = _ref5[1];
        _this2.$mask.clear();
        var updatedEntities = _this2.updateAll(vertices.filter(isVertex).concat(triples));
        updatedEntities.forEach(function (e) {
          return isVertex(e) ? _this2.$viewModel.emit('vertexUpdated', e) : _this2.$viewModel.emit('edgeUpdated', e);
        });
      });
    }, 'FINE', 'performed layout of all entities and fired updated events in {}ms');
  };
  WbLayoutStrategy.prototype.$updateVertex = function (vertex, mask) {
    var strat = this.$strats[vertex.glyph.type];
    var vertexUpdated = false;
    if (strat) {
      vertexUpdated = strat.update(vertex, mask);
      // TODO: clear old vertex data from mask as it can goof up layouts - workbench has this problem too
      mask.addEntity(vertex);
    }
    return vertexUpdated;
  };
  WbLayoutStrategy.prototype.$updateEdge = function (triple, mask) {
    var predicate = triple.predicate,
      strat = this.$strats[predicate.glyph.type];
    var edgeUpdated = false;
    if (strat) {
      edgeUpdated = strat.update(triple, mask);
      mask.addEntity(predicate);
    }
    return edgeUpdated;
  };

  ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////

  /**
   * Match Workbench ordering, where links are laid out ordered first by
   * parent component, then by source component, then by source slot index.
   * @param {Array.<Object>} entities
   * @param {module:nmodule/wiresheet/rc/wb/WbViewModel} vm
   * @returns {Array.<Object>} sorted triples
   */
  function workbenchSort(entities, vm) {
    if (!vm.getContainer) {
      return entities; //not actually a workbench view model
    }
    var slots = vm.getContainer().getSlots().toArray().map(String),
      copy = entities.slice();
    function linkOrder(e1, e2) {
      // always do vertices first
      if (isVertex(e1)) {
        if (isVertex(e2)) {
          return copy.indexOf(e1) - copy.indexOf(e2);
        } else {
          return -1;
        }
      } else if (isVertex(e2)) {
        return 1;
      }
      var subject1 = e1.subject.glyph,
        predicate1 = e1.predicate.glyph,
        object1 = e1.object.glyph;
      var subject2 = e2.subject.glyph,
        predicate2 = e2.predicate.glyph,
        object2 = e2.object.glyph;
      //stubs last
      if (subject2.type !== 'ComponentGlyph') {
        return -1;
      }
      if (object2.type !== 'ComponentGlyph') {
        return -1;
      }
      if (subject1.type !== 'ComponentGlyph') {
        return 1;
      }
      if (object1.type !== 'ComponentGlyph') {
        return 1;
      }
      var type1 = predicate1.connectorType;
      var type2 = predicate2.connectorType;
      if (type1 !== type2) {
        return type1 - type2;
      } // links before relations

      if (object1.name === object2.name) {
        if (subject1.name === subject2.name) {
          var ids = _.pluck(subject1.bars, 'id');
          return _.indexOf(ids, predicate1.sourceConnector) - _.indexOf(ids, predicate2.sourceConnector);
        } else {
          return subject1.name < subject2.name ? -1 : 1;
        }
      } else {
        return _.indexOf(slots, object1.name) - _.indexOf(slots, object2.name);
      }
    }
    copy.sort(linkOrder);
    return copy;
  }
  return WbLayoutStrategy;
});
