function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/WbViewModel
 */
define(['baja!', 'log!nmodule.wiresheet.rc.wb.WbViewModel', 'Promise', 'underscore', 'nmodule/wiresheet/rc/core/ViewModel', 'nmodule/wiresheet/rc/wb/baja/bajaUtils', 'nmodule/wiresheet/rc/wb/baja/EntityFactory', 'nmodule/wiresheet/rc/wb/util/wsUtils'], function (baja, log, Promise, _, ViewModel, bajaUtils, EntityFactory, wsUtils) {
  'use strict';

  var logFine = log.fine.bind(log);
  var extend = _.extend,
    flatten = _.flatten,
    map = _.map;
  var getLink = bajaUtils.getLink,
    isComponent = bajaUtils.isComponent,
    isLink = bajaUtils.isLink,
    isRelation = bajaUtils.isRelation,
    isTextBlock = bajaUtils.isTextBlock,
    ordToComponentId = bajaUtils.ordToComponentId;
  var validateSchema = wsUtils.validateSchema;

  ////////////////////////////////////////////////////////////////
  // WbViewModel
  ////////////////////////////////////////////////////////////////

  /**
   * WbViewModel maintains the structure of a Workbench wiresheet.
   *
   * Rather than using auto-generated IDs for entities, it will use IDs derived
   * from the components, knobs, and links stored within the ViewModel.
   *
   * @class
   * @extends module:nmodule/wiresheet/rc/core/ViewModel
   * @alias module:nmodule/wiresheet/rc/wb/WbViewModel
   * @param {Object} params
   * @param {module:nmodule/wiresheet/rc/wb/baja/GlyphFactory} params.glyphFactory an
   * GlyphFactory for converting Baja values to JSON
   * @param {baja.Component} params.container the container component we're
   * viewing as a wiresheet
   * @param {Function} [params.validateSchema] An optional function to validate the 
   * schema or use default schema validation if not passed. Must return a Promise.
   * @param {Object} [params.options] 
   * @param {boolean} [params.options.showLinks=true] 
   * @param {boolean} [params.options.showRelations=true]
   */
  var WbViewModel = function WbViewModel(_ref) {
    var _this = this;
    var glyphFactory = _ref.glyphFactory,
      container = _ref.container,
      validateSchema = _ref.validateSchema,
      _ref$options = _ref.options,
      options = _ref$options === void 0 ? {
        showLinks: true,
        showRelations: true
      } : _ref$options;
    ViewModel.apply(this);
    var containsId = function containsId(id) {
      return _this.get(id).then(function (entity) {
        return entity && entity.glyph.type !== 'PlaceholderGlyph';
      });
    };
    this.$options = options;
    this.$containsId = containsId;
    this.$factory = new EntityFactory({
      container: container,
      containsId: containsId,
      glyphFactory: glyphFactory
    });
    this.$container = container;
    this.$validateSchema = validateSchema;
    this.initialize = function () {
      return initialize(_this);
    };
  };
  WbViewModel.prototype = Object.create(ViewModel.prototype);
  WbViewModel.prototype.constructor = WbViewModel;

  /**
   * When adding to the internal map, always use the unique component/link/knob
   * ID instead of auto-generating one.
   * @private
   * @param {Object} entity
   * @param {string} type
   * @param {String} [id]
   */
  WbViewModel.prototype.$putEntity = function (entity, type, id) {
    var idProp = this.$getIdProperty(),
      myId = id || entity[idProp],
      existing = this.$entities[myId];
    if (existing) {
      extend(existing.entity, entity);
      entity[idProp] = myId;
      return entity;
    } else {
      return ViewModel.prototype.$putEntity.call(this, entity, type, myId);
    }
  };

  /**
   * Get the object in the view model represented by this ID.
   *
   * Can also receive a `Component`, `Link`, `Relation`, link knob, or relation
   * knob in order to retrieve the object previously stored via `WbViewModel`'s
   * various `put` functions.
   *
   * @param {string|Object|baja.Value} id
   * @returns {Promise.<Object>}
   */
  WbViewModel.prototype.get = function (id) {
    var _this2 = this;
    return this.toId(id).then(function (id) {
      return ViewModel.prototype.get.call(_this2, id);
    });
  };

  /**
   * Get vertices for all components contained in this wiresheet. Any
   * placeholders for components outside the wiresheet (on the other ends of
   * links/knobs) will _not_ be included.
   *
   * @returns {Promise.<object>}
   */
  WbViewModel.prototype.getVertices = function () {
    return ViewModel.prototype.getVertices.apply(this, arguments).then(function (vs) {
      return vs.filter(function (v) {
        return v.glyph.type !== 'PlaceholderGlyph';
      });
    });
  };

  /**
   * Delete the object in the view model represented by this ID.
   *
   * Can also receive a `Component`, `Link`, `Relation`, link knob, or relation
   * knob in order to retrieve the object previously stored via `WbViewModel`'s
   * various `put` functions.
   *
   * @param {string|Object|baja.Value} id
   * @returns {Promise} resolves when the entity has been removed.
   */
  WbViewModel.prototype.del = function (id) {
    var _this3 = this;
    return this.toId(id).then(function (id) {
      return ViewModel.prototype.del.call(_this3, id);
    });
  };
  WbViewModel.prototype.put = function (obj) {
    var _this4 = this;
    var args = arguments;
    if (this.$validateSchema) {
      return validateSchema(obj.glyph, obj.glyph.type).then(function () {
        return ViewModel.prototype.put.apply(_this4, args);
      });
    }
    return ViewModel.prototype.put.apply(this, args);
  };

  /**
   * Ensures that current UI and layout status is not lost when overwriting an
   * existing component or link entity.
   *
   * @private
   * @param {object} existing
   * @param {object} newObject
   * @returns {object}
   */
  WbViewModel.prototype.$overwrite = function (existing, newObject) {
    var glyph = newObject.glyph;
    var oldGlyph = existing.glyph;
    switch (glyph && glyph.type) {
      case 'ComponentGlyph':
      case 'TextBlockGlyph':
        glyph.uiStatus = oldGlyph.uiStatus;
        break;
      case 'SnakeGlyph':
        glyph.uiStatus = oldGlyph.uiStatus;
        glyph.segments = oldGlyph.segments;
        glyph.stubs = oldGlyph.stubs;
        break;
    }
    return newObject;
  };

  /**
   * Get the container component housing this wiresheet.
   * @returns {baja.Component}
   */
  WbViewModel.prototype.getContainer = function () {
    return this.$container;
  };

  /**
   * Gets the configured options for this wiresheet.
   * @returns {baja.Component}
   */
  WbViewModel.prototype.getOptions = function () {
    return this.$options;
  };

  /**
   * Convert a baja value into an ID to be used within this view model.
   *
   * In the case of a child slot of a component, pass in a direct reference to
   * that component and slot as well. This is because you may need the ID of,
   * say, a `Link` even after it has been removed from the station, therefore
   * `getParent()` and `getPropertyInParent()` would return `null`.
   *
   * A non-baja value such as a string will just be resolved directly.
   *
   * @param {string|object|baja.Value} value - component, link, relation, etc.
   * @param {baja.Component} [parent] - the component that owns/owned the given
   * value
   * @param {baja.Property} [prop] - in the case of a link or relation, the slot
   * in which it is/was stored
   * @returns {Promise.<string>}
   */
  WbViewModel.prototype.toId = function (value, parent, prop) {
    if (baja.hasType(value, 'baja:Ord')) {
      return ordToComponentId(value, {
        base: this.$container
      });
    }
    return this.$factory.toId(value, parent, prop);
  };

  /**
   * Add a component to the view model.
   * Components that are hidden will not be added.
   * Components that are also a `baja:Vector` will not be added as Components, but
   * these slots can be seen on the parent Wiresheet as a slot.
   *
   * @param {baja.Component} comp
   * @returns {Promise.<String|null>} promise to be resolved with the ID of the added
   * glyph.
   */
  WbViewModel.prototype.putComponent = function (comp) {
    var _this5 = this;
    return this.$toEntity(comp).then(function (entity) {
      return _this5.put(entity);
    });
  };

  /**
   * A link or knob may point at a component that is outside of the current
   * wiresheet and therefore not displayed. But because a link is a predicate,
   * the view model still needs to know what the subject/object is, even if it's
   * not part of the wiresheet itself. This function puts a dummy node in the
   * wiresheet for the given external ord, so it can be tracked. Only call this
   * if you're certain the ord points outside the wiresheet.
   * @param {baja.Ord|baja.Component} value an ORD that points outside the
   * wiresheet, or a component that is known to live outside the wiresheet
   * @returns {Promise.<String>} promise to be resolved with the ID of the added
   * placeholder.
   */
  WbViewModel.prototype.putPlaceholder = function (value) {
    var _this6 = this;
    return Promise.resolve(isComponent(value) ? this.toId(value) : ordToComponentId(value, {
      base: this.$container
    })).then(function (id) {
      return _this6.put(_defineProperty(_defineProperty({}, _this6.$getIdProperty(), id), "glyph", {
        type: 'PlaceholderGlyph',
        uiStatus: {}
      }));
    });
  };

  /**
   * Add a link to the view model. The source/target components must already
   * exist in the model.
   *
   * @param {baja.Struct} link
   * @returns {Promise.<String|undefined>} promise to be resolved with the ID of the added
   * glyph. Resolves to null if no glyph was added or the existing glyph was removed.
   */
  WbViewModel.prototype.putLink = function (link) {
    var _ref2 = this.$options || {},
      showLinks = _ref2.showLinks;
    if (!showLinks) {
      return Promise.resolve();
    }
    var parent = link.getParent();
    return this.$linkVertices({
      subject: link.get('sourceOrd'),
      object: parent,
      predicate: link,
      validate: function validate(source, target) {
        if (isComponent(parent) && !isVisible(parent, link.getPropertyInParent())) {
          return false;
        }
        if (isComponent(source) && !isVisible(source, link.get('sourceSlotName'))) {
          return false;
        }
        if (isComponent(target) && !isVisible(target, link.get('targetSlotName'))) {
          return false;
        }
        if (isTextBlock(source) || isTextBlock(target)) {
          return false;
        }
        return true;
      }
    });
  };

  /**
   * Add a knob to the model. The source/target components must already exist in
   * the model.
   *
   * @param {Object} knob
   * @returns {Promise.<String|undefined>} promise to be resolved with the ID of the added
   * glyph. Resolves to null if no glyph was added or the existing glyph was removed
   */
  WbViewModel.prototype.putKnob = function (knob) {
    var _ref3 = this.$options || {},
      showLinks = _ref3.showLinks;
    if (!showLinks) {
      return Promise.resolve();
    }
    var sourceSlotName = knob.getSourceSlotName();
    var targetSlotName = knob.getTargetSlotName();
    var sourceComp = knob.getSourceComponent();
    return this.$linkVertices({
      subject: sourceComp,
      object: knob.getTargetOrd(),
      predicate: knob,
      validate: function validate(source, target) {
        return Promise.resolve(isComponent(target) && getLink(target, knob, {
          base: sourceComp
        })).then(function (link) {
          if (isComponent(source) && !isVisible(source, sourceSlotName)) {
            return false;
          }
          if (isComponent(target) && !isVisible(target, targetSlotName)) {
            return false;
          }
          if (isTextBlock(source) || isTextBlock(target)) {
            return false;
          }
          if (link && !isVisible(target, link.getPropertyInParent())) {
            return false;
          }
          return true;
        });
      }
    });
  };

  /**
   * Add a Relation to the model. The source/target components must already
   * exist in the model.
   *
   * @param {baja.Struct} relation a `baja:Relation`
   * @returns {Promise.<String|undefined>} promise to be resolved with the ID of the added
   * glyph
   */
  WbViewModel.prototype.putRelation = function (relation) {
    var _ref4 = this.$options || {},
      showRelations = _ref4.showRelations;
    if (!showRelations) {
      return Promise.resolve();
    }
    return this.$linkVertices({
      subject: relation.getParent(),
      object: relation.getSourceOrd(),
      predicate: relation
    });
  };

  /**
   * Add a relation knob to the model. The source/target components must already
   * exist in the model.
   *
   * @param {Object} relationKnob
   * @returns {Promise.<String|undefined>} promise to be resolved with the ID of the added
   * glyph
   */
  WbViewModel.prototype.putRelationKnob = function (relationKnob) {
    var _ref5 = this.$options || {},
      showRelations = _ref5.showRelations;
    if (!showRelations) {
      return Promise.resolve();
    }
    return this.$linkVertices({
      subject: relationKnob.getRelationOrd(),
      object: relationKnob.getEndpointComponent(),
      predicate: relationKnob
    });
  };

  /**
   * Sets the configured options and reinitializes the vm
   * @param {nmodule/wiresheet/rc/wb/WsOptions} options 
   * @returns {Promise}
   */
  WbViewModel.prototype.setOptions = function (options) {
    var _this7 = this;
    if (!options) {
      return Promise.resolve();
    }
    this.$options = options;
    this.$factory.$glyphFactory.setOptions(options);
    return this.$clear().then(function () {
      return _this7.initialize();
    });
  };

  /**
   * @private
   * @param {object} params
   * @param {baja.Ord|baja.Component} params.subject the source component of the
   * link or relation, or an ORD pointing to it
   * @param {baja.Ord|baja.Component} params.object the target component of the
   * link or relation, or an ORD pointing to it
   * @param {baja.Value|object} params.predicate the link, knob, relation, or
   * relation knob that connects the subject and object
   * @param {function} [params.validate] return truthy if the given predicate
   * can legitimately connect the subject and object. Will receive two
   * parameters, `source` and `target` - either the actual Components on the
   * wiresheet, or JSON placeholders if they live outside the wiresheet.
   * @returns {Promise.<string|null>} to be resolved with the string ID of the entity
   * added to the view model that represents the new predicate or null if the predicate is removed
   */
  WbViewModel.prototype.$linkVertices = function (_ref6) {
    var _this8 = this;
    var subject = _ref6.subject,
      object = _ref6.object,
      predicate = _ref6.predicate,
      _ref6$validate = _ref6.validate,
      validate = _ref6$validate === void 0 ? function () {
        return true;
      } : _ref6$validate;
    var containsId = this.$containsId;
    var base = this.$container;
    function toComponent(ordOrComp) {
      return Promise.resolve(isComponent(ordOrComp) ? ordOrComp : ordOrComp.get({
        base: base
      }));
    }
    return Promise.all([this.toId(subject), this.toId(object)]).then(function (_ref7) {
      var _ref8 = _slicedToArray(_ref7, 2),
        sourceId = _ref8[0],
        targetId = _ref8[1];
      return Promise.all([containsId(sourceId), containsId(targetId)]).then(function (_ref9) {
        var _ref10 = _slicedToArray(_ref9, 2),
          sourceOnThisWiresheet = _ref10[0],
          targetOnThisWiresheet = _ref10[1];
        return Promise.all([sourceOnThisWiresheet ? toComponent(subject) : _this8.putPlaceholder(subject), targetOnThisWiresheet ? toComponent(object) : _this8.putPlaceholder(object), sourceOnThisWiresheet || targetOnThisWiresheet]);
      }).then(function (_ref11) {
        var _ref12 = _slicedToArray(_ref11, 3),
          sourceComp = _ref12[0],
          targetComp = _ref12[1],
          isOnWiresheet = _ref12[2];
        return isOnWiresheet && validate(sourceComp, targetComp);
      }).then(function (valid) {
        if (!valid) {
          return _this8.del(predicate).then(function () {
            return null;
          });
        }
        return _this8.$toEntity(predicate).then(function (linkEntity) {
          return _this8.link({
            subject: sourceId,
            object: targetId,
            predicate: linkEntity
          });
        });
      });
    });
  };

  /**
   * Convert an entity into an object to be stored in the ViewModel.
   *
   * @private
   * @param {baja.Component|baja.Struct|Object} bajaObj a Component, Relation,
   * or Knob
   * @returns {Promise.<module:nmodule/wiresheet/rc/typedefs~WiresheetEntity>} an object suitable for adding into the view
   * model via `put()`
   */
  WbViewModel.prototype.$toEntity = function (bajaObj) {
    var _this9 = this;
    return this.$factory.toEntity(bajaObj).then(function (_ref13) {
      var id = _ref13.id,
        glyph = _ref13.glyph;
      return _defineProperty(_defineProperty({}, _this9.$getIdProperty(), id), "glyph", glyph);
    });
  };

  ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////

  function isVisible(comp, slot) {
    if (!comp) {
      return false;
    }
    if (!comp.has(slot)) {
      logFine("Misconfigured link: slot ".concat(slot, " does not exist on component at ").concat(comp.getNavOrd()));
      return false;
    }
    return !(comp.getFlags(slot) & baja.Flags.HIDDEN);
  }
  function initialize(vm) {
    var container = vm.getContainer(),
      _ref15 = vm.getOptions() || {},
      showLinks = _ref15.showLinks,
      showRelations = _ref15.showRelations,
      allComponents = container.getSlots().is('baja:Component').toValueArray(),
      allLinksAndRelations = flatten(map(allComponents, function (comp) {
        return comp.getSlots().is('baja:Relation').toValueArray();
      })),
      allLinks = allLinksAndRelations.filter(function (r) {
        return showLinks && isLink(r);
      }),
      allRelations = allLinksAndRelations.filter(function (r) {
        return showRelations && isRelation(r);
      }),
      allKnobs = flatten(map(allComponents, function (comp) {
        return showLinks ? comp.getKnobs() : [];
      })),
      allRelationKnobs = flatten(map(allComponents, function (comp) {
        return showRelations ? comp.getRelationKnobs() : [];
      }));

    // ensure putComponent calls are in slot order, not how-long-it-takes-to-render order
    return allComponents.reduce(function (prom, comp) {
      return prom.then(function () {
        return vm.putComponent(comp);
      });
    }, Promise.resolve()).then(function () {
      return Promise.all(flatten([map(allLinks, vm.putLink.bind(vm)), map(allKnobs, vm.putKnob.bind(vm)), map(allRelations, vm.putRelation.bind(vm)), map(allRelationKnobs, vm.putRelationKnob.bind(vm))]));
    });
  }
  return WbViewModel;
});
