function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/WbWiresheetEnv
 */
define(['baja!', 'jquery', 'underscore', 'Promise', 'nmodule/wiresheet/rc/core/controller/Selection', 'nmodule/wiresheet/rc/wb/WbLayoutStrategy', 'nmodule/wiresheet/rc/wb/WbViewModel', 'nmodule/wiresheet/rc/wb/baja/BajaEventHandler', 'nmodule/wiresheet/rc/wb/baja/GlyphFactory', 'nmodule/wiresheet/rc/wb/controller/ThumbnailController', 'nmodule/wiresheet/rc/wb/controller/WbInteractionController', 'nmodule/wiresheet/rc/wb/layout/Mask', 'nmodule/wiresheet/rc/wb/render/canvas/CanvasRenderer', 'nmodule/wiresheet/rc/wb/render/canvas/CanvasInteractionController', 'nmodule/wiresheet/rc/wb/render/canvas/RenderMediator', 'nmodule/wiresheet/rc/wb/render/themes/WiresheetCssTheme', 'nmodule/wiresheet/rc/wb/util/edgeScrollUtil', 'nmodule/wiresheet/rc/wb/util/wsUtils', 'nmodule/wiresheet/rc/wb/WsOptions'], function (baja, $, _, Promise, Selection, WbLayoutStrategy, WbViewModel, BajaEventHandler, GlyphFactory, ThumbnailController, WbInteractionController, Mask, CanvasRenderer, CanvasInteractionController, RenderMediator, WiresheetCssTheme, edgeScrollUtil, wsUtils, WsOptions) {
  'use strict';

  var extend = _.extend;
  var scrollToEntity = wsUtils.scrollToEntity;

  /**
   * This module sets up a whole environment for a WB-style wiresheet. It
   * instantiates the view model, layout strategy, renderer, etc. (or uses the
   * values passed to the constructor, if present).
   *
   * @alias module:nmodule/wiresheet/rc/wb/WbWiresheetEnv
   */
  var WbWiresheetEnv = /*#__PURE__*/function () {
    /**
     * @param {module:nmodule/wiresheet/rc/core/controller/Selection} [params.selection]
     * @param {module:nmodule/wiresheet/rc/wb/WbLayoutStrategy} [params.layoutStrategy]
     * @param {module:nmodule/wiresheet/rc/wb/WbViewModel} [params.viewModel]
     * @param {module:nmodule/wiresheet/rc/wb/WbWiresheetEnv~EnvParams} params
     * @param {module:nmodule/wiresheet/rc/wb/baja/BajaEventHandler} [params.bajaEventHandler]
     * @param {module:nmodule/wiresheet/rc/wb/controller/ThumbnailController} [params.thumbnailController]
     * @param {module:nmodule/wiresheet/rc/wb/controller/WbInteractionController} [params.interactionController]
     * @param {module:nmodule/wiresheet/rc/wb/layout/Mask} [params.mask]
     * @param {module:nmodule/wiresheet/rc/wb/render/canvas/CanvasInteractionController} [params.rendererController]
     * @param {module:nmodule/wiresheet/rc/wb/render/canvas/CanvasRenderer} [params.renderer]
     */
    function WbWiresheetEnv() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      _classCallCheck(this, WbWiresheetEnv);
      var component = params.component,
        contextMenu = params.contextMenu,
        _params$renderType = params.renderType,
        renderType = _params$renderType === void 0 ? 'canvas' : _params$renderType,
        _params$zoom = params.zoom,
        zoom = _params$zoom === void 0 ? 1 : _params$zoom,
        _params$options = params.options,
        options = _params$options === void 0 ? {} : _params$options;
      var maxHeight = options.maxHeight,
        maxWidth = options.maxWidth;
      if (!component) {
        throw new Error('component required');
      }
      var viewModel = params.viewModel || this.$makeViewModel({
        component: component,
        options: options
      });
      var selection = params.selection || this.$makeSelection({
        viewModel: viewModel
      });
      var mask = params.mask || this.$makeMask({
        maxWidth: maxWidth,
        maxHeight: maxHeight
      });
      var layoutStrategy = params.layoutStrategy || this.$makeLayoutStrategy({
        mask: mask
      });
      var interactionController = params.interactionController || this.$makeInteractionController({
        viewModel: viewModel,
        selection: selection,
        mask: mask,
        options: options
      });
      var bajaEventHandler = params.bajaEventHandler || this.$makeBajaEventHandler({
        component: component,
        viewModel: viewModel
      });
      var renderer = params.renderer || this.$makeRenderer({
        layoutStrategy: layoutStrategy,
        renderType: renderType,
        viewModel: viewModel,
        mask: mask,
        zoom: zoom,
        options: options
      });
      var rendererController = params.rendererController || this.$makeRendererController({
        interactionController: interactionController,
        layoutStrategy: layoutStrategy,
        contextMenu: contextMenu,
        renderType: renderType,
        selection: selection,
        viewModel: viewModel,
        zoom: zoom,
        options: options
      });
      var thumbnailController = params.thumbnailController || this.$makeThumbnailController();
      var renderMediator = new RenderMediator({
        viewModel: viewModel,
        layoutStrategy: layoutStrategy,
        renderer: renderer
      });

      // TODO: no
      if (contextMenu) {
        contextMenu.$viewModel = viewModel;
        contextMenu.$rendererController = rendererController;
      }
      this.$interactionController = interactionController;
      this.$layoutStrategy = layoutStrategy;
      this.$selection = selection;
      this.$mask = mask;
      this.$viewModel = viewModel;
      this.$bajaEventHandler = bajaEventHandler;
      this.$renderer = renderer;
      this.$rendererController = rendererController;
      this.$thumbnailController = thumbnailController;
      this.$renderMediator = renderMediator;
      this.$zoom = zoom;
      this.$options = options;
    }
    /**
     * @param {module:nmodule/wiresheet/rc/wb/WbWiresheetEnv~EnvParams} params
     * @returns {Promise.<module:nmodule/wiresheet/rc/wb/WbWiresheetEnv>}
     */
    return _createClass(WbWiresheetEnv, [{
      key: "initialize",
      value:
      /**
       * @param {object} params
       * @param {JQuery} params.dom DOM element where the wiresheet is being
       * initialized
       * @param {module:nmodule/wiresheet/rc/wb/baja/bajaUtils~SelectionParams} params.selectionParams info
       * about which component to preselect when initializing the wiresheet
       * @returns {Promise} to be resolved when the environment is initialized
       */
      function initialize(_ref) {
        var _this = this;
        var dom = _ref.dom,
          selectionParams = _ref.selectionParams;
        var renderContext = $(dom).find('.ws-render-context');
        var thumbContainer = $(dom).find('.ws-thumb-container');
        var outerContent = $(dom).find('.ws-content-outer');
        if (!renderContext.length) {
          return die('render context required');
        }
        if (!thumbContainer.length) {
          return die('thumb container required');
        }
        if (!outerContent.length) {
          return die('outer content required');
        }
        this.$dom = dom;
        this.$releaseEdgeScroll = edgeScrollUtil.initialize(outerContent[0]);
        var interactionController = this.$interactionController;
        var thumbnailController = this.$thumbnailController;
        var renderer = this.$renderer;
        var rendererController = this.$rendererController;
        var renderMediator = this.$renderMediator;
        var viewModel = this.$viewModel;
        return viewModel.initialize().then(function () {
          return _this.$initializeLayoutStrategy();
        }).then(function () {
          return thumbnailController.initialize(thumbContainer, outerContent);
        }).then(function () {
          return renderer.initialize(renderContext, thumbContainer);
        }).then(function () {
          return Promise.all([renderMediator.initialize(), interactionController.initialize({
            selectionParams: selectionParams
          }), rendererController.initialize(dom.find('.ws-render-context')[0])]);
        }).then(function () {
          return _this.$scrollToSelection();
        });
      }

      /**
       * @returns {Promise} resolved after all event handlers have been removed
       */
    }, {
      key: "release",
      value: function release() {
        this.$releaseEdgeScroll();
        this.$dom = undefined;
        return Promise.all([this.$bajaEventHandler.release(), this.$interactionController.release(), this.$renderer.release(), this.$rendererController.release(), this.$renderMediator.release(), this.$thumbnailController.release()]);
      }

      /**
       * @param {number} [zoom=1]
       * @returns {Promise}
       */
    }, {
      key: "zoom",
      value: function zoom() {
        var _zoom = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
        var zoomLevel = this.$zoom = _zoom;
        return Promise.all([this.$renderer.zoom(zoomLevel), this.$rendererController.zoom(zoomLevel)]);
      }

      /**
       * @param {object} options
       * @returns {Promise}
       */
    }, {
      key: "options",
      value: function options() {
        var _options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var newOptions = this.$options = extend(this.$options, _options);
        this.$renderer.options(newOptions);
        this.$rendererController.options(newOptions);
        this.$interactionController.options(newOptions);
        return this.$selection.setSelectedEntities([]);
      }

      /**
       * Called when a scroll occurs. Triggers the renderer to update the thumbnail
       * overlay. 
       */
    }, {
      key: "scroll",
      value: function scroll() {
        this.$renderer.paintThumbnailOverlay();
      }

      /**
       * Called when the visible viewport is changed. Triggers the render to do
       * any required painting based upon the changes.
       *
       * @param {object} params
       * @param {number} params.width the width of the viewport in wixels
       * @param {number} params.height the height of the viewport in wixels
       */
    }, {
      key: "viewportChanged",
      value: function viewportChanged(params) {
        this.$renderer.viewportChanged(params);
      }

      /**
       * Saves user configurable options to userData and applies them
       * 
       * @param {module:nmodule/wiresheet/rc/wb/WsOptions|Object} params 
       * @returns {Promise}
       */
    }, {
      key: "applyUserOptions",
      value: function applyUserOptions(params) {
        var wsOptions = new WsOptions(params);
        return Promise.all([this.options(wsOptions), this.$viewModel.setOptions(wsOptions), wsOptions.saveToUserData()]);
      }

      /**
       * Scrolls to the selected entity
       * @private
       */
    }, {
      key: "$scrollToSelection",
      value: function $scrollToSelection() {
        var selectedEntities = this.$selection.getSelectedEntities();
        selectedEntities.length > 0 && scrollToEntity(selectedEntities[0], this.$thumbnailController);
      }

      /**
       * @private
       * @return {Promise}
       */
    }, {
      key: "$initializeLayoutStrategy",
      value: function $initializeLayoutStrategy() {
        var layoutStrategy = this.$layoutStrategy;
        return layoutStrategy.initialize(this.$viewModel);
      }

      /** @private */
    }, {
      key: "$makeBajaEventHandler",
      value: function $makeBajaEventHandler(_ref2) {
        var component = _ref2.component,
          viewModel = _ref2.viewModel;
        return new BajaEventHandler({
          component: component,
          viewModel: viewModel
        });
      }

      /** @private */
    }, {
      key: "$makeInteractionController",
      value: function $makeInteractionController(_ref3) {
        var viewModel = _ref3.viewModel,
          selection = _ref3.selection,
          mask = _ref3.mask,
          options = _ref3.options;
        return new WbInteractionController({
          viewModel: viewModel,
          selection: selection,
          mask: mask,
          options: options
        });
      }

      /** @private */
    }, {
      key: "$makeLayoutStrategy",
      value: function $makeLayoutStrategy(_ref4) {
        var mask = _ref4.mask;
        return new WbLayoutStrategy({
          mask: mask
        });
      }

      /** @private */
    }, {
      key: "$makeMask",
      value: function $makeMask(_ref5) {
        var maxWidth = _ref5.maxWidth,
          maxHeight = _ref5.maxHeight;
        return new Mask({
          maxWidth: maxWidth,
          maxHeight: maxHeight
        });
      }

      /** @private */
    }, {
      key: "$makeRenderer",
      value: function $makeRenderer(_ref6) {
        var renderType = _ref6.renderType,
          mask = _ref6.mask,
          viewModel = _ref6.viewModel,
          zoom = _ref6.zoom,
          options = _ref6.options;
        if (renderType === 'canvas') {
          var theme = new WiresheetCssTheme();
          return new CanvasRenderer({
            mask: mask,
            viewModel: viewModel,
            theme: theme,
            zoom: zoom,
            options: options
          });
        }
      }

      /** @private */
    }, {
      key: "$makeThumbnailController",
      value: function $makeThumbnailController() {
        return new ThumbnailController();
      }

      /** @private */
    }, {
      key: "$makeRendererController",
      value: function $makeRendererController(_ref7) {
        var controller = _ref7.interactionController,
          renderType = _ref7.renderType,
          layoutStrategy = _ref7.layoutStrategy,
          selection = _ref7.selection,
          viewModel = _ref7.viewModel,
          zoom = _ref7.zoom,
          options = _ref7.options;
        if (renderType === 'canvas') {
          return new CanvasInteractionController({
            controller: controller,
            layoutStrategy: layoutStrategy,
            selection: selection,
            viewModel: viewModel,
            zoom: zoom,
            options: options
          });
        }
      }

      /** @private */
    }, {
      key: "$makeSelection",
      value: function $makeSelection(_ref8) {
        var viewModel = _ref8.viewModel;
        return new Selection(viewModel);
      }

      /** @private */
    }, {
      key: "$makeViewModel",
      value: function $makeViewModel(_ref9) {
        var component = _ref9.component,
          options = _ref9.options;
        return new WbViewModel({
          glyphFactory: new GlyphFactory({
            base: component,
            showRelations: options.showRelations,
            showLinks: options.showLinks
          }),
          container: component,
          validateSchema: false,
          options: options
        });
      }
    }], [{
      key: "initialize",
      value: function initialize(params) {
        var env = new WbWiresheetEnv(params);
        return env.initialize(params).then(function () {
          return env;
        });
      }
    }]);
  }();
  /**
   * All the parameters required to build out a WB-style wiresheet environment.
   *
   * @typedef module:nmodule/wiresheet/rc/wb/WbWiresheetEnv~EnvParams
   * @property {baja.Component} component the component loaded into the wiresheet
   * @property {module:nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu} [contextMenu] the
   * context menu instance to initialize
   * @property {JQuery} dom the DOM element the wiresheet lives in
   * @property {string} [renderType='canvas'] defaults to 'canvas' but allows plugging in 
   * a different rendering mechanism/technology, say 'svg'
   * @property {Number} zoom the zoom level of the canvas
   * @property {Object} options the various user configurable wiresheet options
   * @property {Number} options.maxWidth the maximum width of the wiresheet canvas
   * @property {Number} options.minWidth the minimum width of the wiresheet canvas
   * @property {Number} width wiresheet width in wixels
   * @property {Number} height wiresheet height in wixels
   */
  function die(err) {
    return Promise.reject(new Error(err));
  }
  return WbWiresheetEnv;
});
