function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/baja/BajaEventHandler
 */
define(['baja!', 'log!nmodule.wiresheet.rc.wb.baja.BajaEventHandler', 'Promise', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/webEditors/rc/fe/baja/util/Attachable', 'nmodule/wiresheet/rc/wb/baja/bajaUtils'], function (baja, log, Promise, _, asyncUtils, switchboard, Attachable, bajaUtils) {
  'use strict';

  var waitInterval = asyncUtils.waitInterval;
  var isComponent = bajaUtils.isComponent,
    isLink = bajaUtils.isLink,
    isRelation = bajaUtils.isRelation;
  var logFine = log.fine.bind(log);

  /**
   * This module's job is to listen for Baja nav events from the given
   * component, and keep the given `WbViewModel` accordingly up to date at all
   * times.
   *
   * @class
   * @alias module:nmodule/wiresheet/rc/wb/baja/BajaEventHandler
   * @param {Object} params
   * @param {baja.Component} params.component
   * @param {module:nmodule/wiresheet/rc/wb/WbViewModel} params.viewModel
   */
  var BajaEventHandler = /*#__PURE__*/function () {
    function BajaEventHandler(_ref) {
      var component = _ref.component,
        viewModel = _ref.viewModel;
      _classCallCheck(this, BajaEventHandler);
      var eventHandler = this;
      if (!isComponent(component)) {
        throw new Error('Component required');
      }
      if (!viewModel) {
        throw new Error('WbViewModel required');
      }
      switchboard(this, {
        $addComponent: {
          allow: 'oneAtATime',
          notWhile: '$removeComponent'
        }
      });

      //TODO: what happens if the linked component is removed before i get the removed event for the link itself?
      var bajaEventListeners = {
        'added': function added(prop) {
          var val = this.get(prop);
          if (isComponent(val)) {
            return eventHandler.$addComponent(viewModel, val);
          }
        },
        'removed': function removed(prop, component) {
          if (isComponent(component)) {
            return eventHandler.$removeComponent(viewModel, component);
          }
        },
        'renamed': function renamed(prop, oldName) {
          var component = this.get(prop);
          if (isComponent(component)) {
            var base = viewModel.getContainer();
            return Promise.all([resolveKnobComponents(component, base), resolveRelationKnobComponents(component, base)]).then(function (_ref2) {
              var _ref3 = _slicedToArray(_ref2, 2),
                knobComponents = _ref3[0],
                relationKnobComponents = _ref3[1];
              var components = knobComponents.concat(relationKnobComponents).concat(component);
              return eventHandler.$addComponents(viewModel, components);
            });
          }
        },
        'flagsChanged': function flagsChanged(slot) {
          var comp = slot.isProperty() && this.get(slot);
          if (isComponent(comp)) {
            return eventHandler.$addComponent(viewModel, comp);
          }
        },
        '.+/added': function _added(prop) {
          var component = this,
            val = component.get(prop);
          return Promise.all([viewModel.putComponent(component), isEdge(val) && addRelation(viewModel, val)]);
        },
        '.+/removed': function _removed(prop, val) {
          var component = this;
          return Promise.all([viewModel.putComponent(component), isEdge(val) && deleteEntity(viewModel, val, component, prop)]);
        },
        '.+/changed': function _changed(prop) {
          var component = this;
          var propValue = component.get(prop);
          if (String(prop) === 'wsAnnotation') {
            return eventHandler.$addComponent(viewModel, component);
          } else if (isLink(propValue)) {
            return viewModel.putLink(propValue);
          } else if (isRelation(propValue)) {
            return viewModel.putRelation(propValue);
          } else {
            return viewModel.putComponent(component);
          }
        },
        '.+/flagsChanged': function _flagsChanged(slot) {
          var component = this;
          var slotValue = slot.isProperty() && component.get(slot);
          if (isLink(slotValue)) {
            return viewModel.putLink(slotValue);
          } else {
            return eventHandler.$addComponent(viewModel, component);
          }
        },
        '.+/addKnob': function _addKnob() {
          var component = this;
          return eventHandler.$addComponent(viewModel, component);
        },
        '.+/removeKnob': function _removeKnob(slot, knob) {
          var component = this;
          return Promise.all([viewModel.putComponent(component), deleteEntity(viewModel, knob)]);
        },
        '.+/addRelationKnob': function _addRelationKnob() {
          var component = this;
          return eventHandler.$addComponent(viewModel, component);
        },
        '.+/removeRelationKnob': function _removeRelationKnob(relationKnob) {
          var component = this;
          return Promise.all([viewModel.putComponent(component), deleteEntity(viewModel, relationKnob)]);
        }
      };

      //ensure baja event listener rejections get logged
      _.each(bajaEventListeners, function (listener, name) {
        bajaEventListeners[name] = function () {
          var _this = this;
          var args = arguments;
          return ifStillMounted(this, function () {
            return listener.apply(_this, args);
          })["catch"](logFine);
        };
      });
      var att = new Attachable(component);
      att.attach(bajaEventListeners);
      this.release = function () {
        return att.detach();
      };
    }

    /**
     * @private
     * @param {module:nmodule/wiresheet/rc/wb/WbViewModel} viewModel
     * @param {baja.Component} component
     * @return {Promise}
     */
    return _createClass(BajaEventHandler, [{
      key: "$addComponent",
      value: function $addComponent(viewModel, component) {
        var relations = component.getSlots().is('baja:Relation').toValueArray(),
          relationKnobs = component.getRelationKnobs(),
          knobs = component.getKnobs();
        return viewModel.putComponent(component).then(function () {
          return Promise.all([Promise.all(relations.map(function (relation) {
            return addRelation(viewModel, relation);
          })), Promise.all(relationKnobs.map(function (rk) {
            return viewModel.putRelationKnob(rk);
          })), Promise.all(knobs.map(function (k) {
            return viewModel.putKnob(k);
          }))]);
        });
      }

      /**
       * @private
       * @param {module:nmodule/wiresheet/rc/wb/WbViewModel} viewModel
       * @param {Array.<baja.Component>} components
       * @return {Promise}
       */
    }, {
      key: "$addComponents",
      value: function $addComponents(viewModel, components) {
        var _this2 = this;
        return Promise.all(components.map(function (component) {
          return _this2.$addComponent(viewModel, component);
        }));
      }

      /**
       * @private
       * @param {module:nmodule/wiresheet/rc/wb/WbViewModel} viewModel
       * @param {baja.Component} component
       * @return {Promise}
       */
    }, {
      key: "$removeComponent",
      value: function $removeComponent(viewModel, component) {
        return viewModel.toId(component).then(function (id) {
          return Promise.all([viewModel.getEdges({
            subject: id
          }), viewModel.getEdges({
            object: id
          })]).then(function (_ref4) {
            var _ref5 = _slicedToArray(_ref4, 2),
              subjectTriples = _ref5[0],
              objectTriples = _ref5[1];
            var toRemove = [id].concat(_.pluck(subjectTriples.concat(objectTriples), 'predicate'));
            return Promise.all(toRemove.map(viewModel.del.bind(viewModel)));
          });
        });
      }
    }]);
  }();
  function deleteEntity(viewModel, value, component, slot) {
    return viewModel.toId(value, component, slot).then(function (id) {
      return viewModel.del(id);
    });
  }
  function isEdge(value) {
    return isLink(value) || isRelation(value);
  }
  function addRelation(viewModel, value) {
    if (isLink(value)) {
      return viewModel.putLink(value);
    } else if (isRelation(value)) {
      return viewModel.putRelation(value);
    }
  }
  function resolveKnobComponents(component, base) {
    return Promise.all(component.getKnobs().map(function (knob) {
      return knob.getTargetOrd().get({
        base: base
      })["catch"](logFine);
    })).then(function (comps) {
      return _.compact(comps);
    });
  }
  function resolveRelationKnobComponents(component, base) {
    return Promise.all(component.getRelationKnobs().map(function (knob) {
      return knob.getRelationOrd().get({
        base: base
      })["catch"](logFine);
    })).then(function (comps) {
      return _.compact(comps);
    });
  }

  // TODO: remove this hack.
  // when a component with an active link is deleted, the flagsChanged/changed
  // events for its slots come through *before* the removed event for the
  // component itself. if we process the flagsChanged/changed events, they may
  // trigger a repaint of the now-unmounted component later, after the remove
  // event processes through.
  function ifStillMounted(component, func) {
    //return func();
    return waitInterval(1).then(function () {
      return component.isMounted() && func();
    });
  }
  return BajaEventHandler;
});
