function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/baja/commands/DeleteRelationsCommand
 */
define(['baja!', 'lex!bajaui,webEditors', 'bajaux/commands/Command', 'dialogs', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/wiresheet/rc/wb/baja/bajaUtils'], function (baja, lexs, Command, dialogs, Promise, _, compUtils, bajaUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 2),
    bajauiLex = _lexs[0],
    webEditorsLex = _lexs[1];
  var formatDisplayNames = compUtils.formatDisplayNames;
  var all = _.all,
    uniq = _.uniq;
  var isLink = bajaUtils.isLink,
    isRelation = bajaUtils.isRelation,
    isKnob = bajaUtils.isKnob,
    isRelationKnob = bajaUtils.isRelationKnob,
    getLink = bajaUtils.getLink,
    getRelation = bajaUtils.getRelation;

  /**
   * @class
   * @alias module:nmodule/wiresheet/rc/wb/baja/commands/DeleteRelationsCommand
   * @extends module:bajaux/commands/Command
   */
  return /*#__PURE__*/function (_Command) {
    /**
     * @param {Array.<baja.Value>|baja.Value} subject relations to delete
     */
    function DeleteRelationsCommand(subject, displayName) {
      var _this;
      _classCallCheck(this, DeleteRelationsCommand);
      subject = [].concat(subject);
      var relations = subject.filter(filterRelations);
      var module = displayName ? '' : 'bajaui',
        lex = displayName ? '' : 'commands.deleteRelations';
      return _this = _callSuper(this, DeleteRelationsCommand, [{
        module: module,
        lex: lex,
        displayName: displayName,
        enabled: !!relations.length,
        undoable: function undoable() {
          return _this.$confirmDelete(function () {
            return Promise.all(relations.map(function (r) {
              return _this.$getParent(r);
            })).then(function (parents) {
              var names = formatDisplayNames(uniq(parents.map(function (p) {
                return p.getDisplayName();
              })));
              var pref = 'commands.deleteRelations.' + (all(relations, isLinkOrKnob) ? 'linksOnly' : all(relations, isRelationOrRelationKnob) ? 'relationsOnly' : 'relationsAndLinks');
              return {
                redo: function redo() {
                  return Promise.all(relations.map(function (r, i) {
                    if (isLink(r) || isRelation(r)) {
                      return parents[i].remove(r);
                    }
                    if (isKnob(r)) {
                      return getLink(parents[i], r).then(function (link) {
                        return parents[i].remove(link).then(function () {
                          relations[i] = link;
                        });
                      });
                    }
                    if (isRelationKnob(r)) {
                      return getRelation(parents[i], r).then(function (relation) {
                        return parents[i].remove(relation).then(function () {
                          relations[i] = relation;
                        });
                      });
                    }
                    throw new Error("Unknown subject: cannot remove.");
                  }));
                },
                undo: function undo() {
                  return Promise.all(relations.map(function (r, i) {
                    var parent = parents[i];
                    return parent.add(r).then(function (p) {
                      relations[i] = parent.get(p);
                    });
                  }));
                },
                redoText: function redoText() {
                  return bajauiLex.get({
                    key: pref + '.redoText',
                    args: [names]
                  });
                },
                undoText: function undoText() {
                  return bajauiLex.get({
                    key: pref + '.undoText',
                    args: [names]
                  });
                }
              };
            });
          });
        }
      }]);
    }

    /**
     * @private
     * @param {function} func function to run if user confirms deletion
     * @returns {Promise.<*>} to be resolved with result of `func`
     */
    _inherits(DeleteRelationsCommand, _Command);
    return _createClass(DeleteRelationsCommand, [{
      key: "$confirmDelete",
      value: function $confirmDelete(func) {
        // eslint-disable-next-line promise/avoid-new
        return new Promise(function (resolve) {
          dialogs.showOkCancel({
            title: webEditorsLex.get('commands.delete.confirm.title'),
            text: webEditorsLex.get('commands.delete.confirm.content')
          }).ok(function () {
            return resolve(func());
          }).cancel(function () {
            return resolve(null);
          });
        });
      }

      /**
       * @private
       * @param {*} r 
       * @returns {Promise}
       */
    }, {
      key: "$getParent",
      value: function $getParent(r) {
        if (isLink(r) || isRelation(r)) {
          return Promise.resolve(r.getParent());
        }

        // The parent maybe in another view that was never accessed 
        // so a loadSlots is required here. May cause performance issues if too many
        // such entities are multi-deleted.
        if (isKnob(r)) {
          return r.getTargetOrd().get({
            base: baja.station
          }).then(function (c) {
            return c.loadSlots().then(function () {
              return c;
            });
          });
        }
        if (isRelationKnob(r)) {
          return r.getRelationOrd().get({
            base: baja.station
          }).then(function (c) {
            return c.loadSlots().then(function () {
              return c;
            });
          });
        }
      }
    }]);
  }(Command);
  function isLinkOrKnob(r) {
    return isLink(r) || isKnob(r);
  }
  function filterRelations(r) {
    return isLinkOrKnob(r) || isRelationOrRelationKnob(r);
  }
  function isRelationOrRelationKnob(r) {
    return isRelation(r) || isRelationKnob(r);
  }
});
