function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/controller/ops/RelateOp
 */
define(['baja!', 'lex!baja', 'Promise', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/commands/RelateToCommand', 'nmodule/webEditors/rc/wb/links/RelatePad', 'nmodule/wiresheet/rc/wb/util/wsUtils'], function (baja, lexs, Promise, feDialogs, RelateToCommand, RelatePad, wsUtils) {
  'use strict';

  var toBajaId = wsUtils.toBajaId,
    boundingBox = wsUtils.boundingBox;
  var RELATE_ID = 'relate';
  var _lexs = _slicedToArray(lexs, 1),
    bajaLex = _lexs[0];
  var CANNOT_RELATE_TO_SELF = bajaLex.get('relationcheck.cannotRelateToSelf');
  var CANNOT_RELATE_TO_SLOT = bajaLex.get('relationcheck.cannotRelateToSlot');
  var getInvalidDirectionMessage = function getInvalidDirectionMessage(direction) {
    if (direction === 'out') {
      return bajaLex.get('relationcheck.cannotRelateSourceToSource');
    }
    return bajaLex.get('relationcheck.cannotRelateTargetToTarget');
  };
  var getRelateToMessage = function getRelateToMessage(startEntityText, endEntityText) {
    return bajaLex.get({
      key: 'relationcheck.relateTo',
      args: [startEntityText, endEntityText]
    });
  };

  /**
   *
   * This op allows a user to create a relation from one glyph to another.
   *
   * This op has a BajaScript dependency. It operates by creating Relation objects
   * and writing them through to the station.
   *
   * @class
   * @alias module:nmodule/wiresheet/rc/wb/controller/ops/RelateOp
   * @param {Object} params
   * @param {number} params.x starting mouse x, in wixels
   * @param {number} params.y starting mouse y, in wixels
   * @param {module:nmodule/wiresheet/rc/core/ViewModel} params.viewModel
   * @param {String} params.connectorDirection the direction the relate op was
   * started with. Either `in` or `out`.
   * @param {baja.Component} params.base a base component for resolving ORDs
   * @param {String} params.entityId the entity that is the origin the relation
   * that we are dragging from
   * @param {String} [params.connectorId] the id of the connector we are starting
   * from such as `relation:n:child`. This will only be set when dragging from
   * a preexisting relation slot with a designated relation id. Otherwise, the
   * user will be presented a dialog to select the relation id for the op.
   * @param {function} params.setCursor a function to update the visible cursor
   * as we drag around
   * @param {function} params.setToolTip a function to update the display value
   * of the tooltip
   * @param {function} params.cancelToolTip a function to cancel the ToolTip if
   * it is currently displayed
   */
  var RelateOp = function RelateOp(params) {
    var _this = this;
    var origX = params.x,
      origY = params.y,
      viewModel = params.viewModel,
      base = params.base,
      entityId = params.entityId,
      setCursor = params.setCursor,
      setToolTip = params.setToolTip,
      cancelToolTip = params.cancelToolTip,
      connectorId = params.connectorId,
      connectorDirection = params.connectorDirection;
    var startOrd = toBajaId(entityId);
    var startConnectorDirection = connectorDirection;
    var startEntityId = entityId;

    /**
     * Check if the current location is a valid drop point for a drag and drop Relate operation.
     *
     * @param {string} entityId the entity the mouse is over
     * @param {string} direction in if relating to the entity; out if relating
     * from the entity
     * @param {string} connectorType what kind of connector are we dropping on
     * @returns {Promise}
     *
     */
    this.updateDropTarget = function (entityId, direction, connectorType) {
      if (!entityId) {
        cancelToolTip();
        return setCursor('grabbing');
      }
      if (connectorType !== 'footer') {
        setToolTip(CANNOT_RELATE_TO_SLOT);
        return setCursor('grabbing');
      }
      if (entityId === startEntityId) {
        setToolTip(CANNOT_RELATE_TO_SELF);
        return setCursor('grabbing');
      }
      if (startConnectorDirection === direction) {
        setToolTip(getInvalidDirectionMessage(direction));
        return setCursor('not-allowed');
      }
      return Promise.all([resolveEntityTitleFromId(startEntityId, viewModel), resolveEntityTitleFromId(entityId, viewModel)]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
          startTitle = _ref2[0],
          endTitle = _ref2[1];
        setToolTip(getRelateToMessage(startTitle, endTitle));
        return setCursor(startConnectorDirection);
      });
    };

    /**
     * When the user drags around, move the relation "arrow" appropriately.
     * @param {module:nmodule/wiresheet/rc/typedefs~DragOpState} dragOpState
     */
    this.update = function (_ref3) {
      var x = _ref3.x,
        y = _ref3.y,
        entityId = _ref3.entityId,
        connectorDirection = _ref3.connectorDirection,
        connectorType = _ref3.connectorType;
      var end = {
        x: x,
        y: y
      };
      var start = {
        x: origX,
        y: origY
      };
      return viewModel.put(toLinkGlyph(start, end), RELATE_ID).then(function () {
        return _this.updateDropTarget(entityId, connectorDirection, connectorType);
      });
    };

    /**
     * When the user commits the op, write a new Relation slot through to the
     * station, relating the two components.
     * @param {module:nmodule/wiresheet/rc/typedefs~DragOpState} dragOpState
     * @returns {Promise|*}
     */
    this.commit = function (_ref4) {
      var entityId = _ref4.entityId,
        connectorDirection = _ref4.connectorDirection,
        connectorType = _ref4.connectorType;
      if (!entityId || connectorType !== 'footer') {
        return;
      }
      if (connectorDirection === startConnectorDirection) {
        return;
      }
      if (entityId === startEntityId) {
        return feDialogs.error(new Error(CANNOT_RELATE_TO_SELF));
      }
      var endOrd = toBajaId(entityId);
      var isOut = startConnectorDirection === 'out';
      var sourceOrd = isOut ? startOrd : endOrd;
      var targetOrd = isOut ? endOrd : startOrd;
      return baja.BatchResolve.resolve({
        ords: [sourceOrd, targetOrd],
        base: base
      }).then(function (br) {
        var _br$getTargetObjects = br.getTargetObjects(),
          _br$getTargetObjects2 = _slicedToArray(_br$getTargetObjects, 2),
          source = _br$getTargetObjects2[0],
          target = _br$getTargetObjects2[1];
        return resolveRelationInfo(connectorId, [source], [target]);
      }).then(function (result) {
        if (!result) {
          return;
        }
        var sources = result.sources,
          targets = result.targets,
          relationId = result.relationId;
        return saveNewRelation(sources, targets, base, relationId);
      });
    };
    this.destroy = function () {
      return viewModel.del(RELATE_ID);
    };
  };
  function resolveRelationInfo(connectorId, sources, targets) {
    return Promise.resolve(connectorId ? connectorIdToRelationInfo(connectorId, sources, targets) : RelatePad.doDialog({
      sources: sources,
      targets: targets
    }));
  }
  function saveNewRelation(sources, targets, base, relationId) {
    var cmd = new RelateToCommand({
      subject: sources,
      object: targets,
      relationId: relationId
    });
    return cmd.invoke();
  }
  function toLinkGlyph(start, end) {
    var layout = boundingBox([start, end]);
    return {
      glyph: {
        type: 'LinkGlyph',
        start: {
          x: start.x - layout.x,
          y: start.y - layout.y
        },
        end: {
          x: end.x - layout.x,
          y: end.y - layout.y
        }
      },
      layout: layout
    };
  }
  function connectorIdToRelationInfo(connectorId, sources, targets) {
    var relationId = connectorId.substring(connectorId.indexOf(':') + 1);
    return {
      relationId: relationId,
      sources: sources,
      targets: targets
    };
  }
  function resolveEntityTitleFromId(id, viewModel) {
    return viewModel.get(id).then(function (entity) {
      return entity && entity.glyph && entity.glyph.header && entity.glyph.header.title;
    });
  }
  return RelateOp;
});
