/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/layout/TextBlockGlyphLayoutStrategy
 */
define(['underscore'], function (_) {
  'use strict';

  var extend = _.extend,
    isEqual = _.isEqual;

  /**
   * @class
   * @alias module:nmodule/wiresheet/rc/wb/layout/TextBlockGlyphLayoutStrategy
   * @implements module:nmodule/wiresheet/rc/typedefs~VertexLayoutStrategy
   */
  var TextBlockGlyphLayoutStrategy = function TextBlockGlyphLayoutStrategy() {};

  /**
   * For a `TextBlockGlyph` always use the explicit layout from its
   * `wsAnnotation`.
   * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} obj the vertex
   * containing the `TextBlockGlyph`
   * @param {module:nmodule/wiresheet/rc/wb/layout/Mask} mask
   * @returns {boolean} true if the layout was updated
   */
  TextBlockGlyphLayoutStrategy.prototype.update = function (obj, mask) {
    var glyphLayout = obj.glyph.layout;
    var updated = !isEqual(glyphLayout, obj.layout);
    obj.layout = extend({}, glyphLayout);
    return updated;
  };
  return TextBlockGlyphLayoutStrategy;
});
