function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/canvas/CanvasContextProvider
 */
define(['nmodule/wiresheet/rc/wb/WbConstants'], function (WbConstants) {
  'use strict';

  var WIXEL = WbConstants.WIXEL;

  /**
   * This class manages the one-canvas-per-entity paradigm used in
   * CanvasRenderer.
   *
   * @class
   * @alias module:nmodule/wiresheet/rc/wb/canvas/CanvasContextProvider
   */
  var CanvasContextProvider = /*#__PURE__*/function () {
    /**
     * @param {HTMLElement} rootElement the element to contain the created
     * canvases
     * @param {module:nmodule/wiresheet/rc/core/ViewModel} viewModel the view
     * model containing the rendered entities
     */
    function CanvasContextProvider(rootElement, viewModel) {
      _classCallCheck(this, CanvasContextProvider);
      this.$rootElement = rootElement;
      this.$viewModel = viewModel;
      this.$canvases = {};
      this.$zoom = 1;
    }

    /**
     * @param {number} zoom the new zoom level
     */
    return _createClass(CanvasContextProvider, [{
      key: "zoom",
      value: function zoom(_zoom) {
        this.$zoom = _zoom;
      }

      /**
       * Create or retrieve a canvas to use to render the given entity.
       *
       * @param {object} entity
       * @returns {HTMLCanvasElement} the canvas we'll paint the entity to
       */
    }, {
      key: "getCanvas",
      value: function getCanvas(entity) {
        var id = this.$viewModel.getId(entity);
        var canvases = this.$canvases;
        var canvas = canvases[id];
        if (!canvas) {
          canvas = document.createElement('canvas');
          this.$rootElement.append(canvas);
          canvas = canvases[id] = canvas;
        }
        return canvas;
      }

      /**
       * Removes the canvas element from its DOM tree
       * 
       * @param {object} entity
       */
    }, {
      key: "removeCanvas",
      value: function removeCanvas(entity) {
        var id = this.$viewModel.getId(entity),
          canvas = this.$canvases[id];
        if (canvas) {
          canvas.remove();
          delete this.$canvases[id];
        }
      }

      /**
       * Get a canvas context to use to render the given entity.
       *
       * @param {object} entity
       * @returns {CanvasRenderingContext2D} a context ready to start painting
       */
    }, {
      key: "getContext",
      value: function getContext(entity) {
        var canvas = this.getCanvas(entity);
        var zoom = this.$zoom;
        var wixel = WIXEL * zoom;
        var layout = entity.layout;
        var _toPixels = toPixels(layout, wixel),
          x = _toPixels.x,
          y = _toPixels.y,
          width = _toPixels.width,
          height = _toPixels.height;
        canvas.width = width + wixel + wixel;
        canvas.height = height + wixel + wixel;
        canvas.style.position = 'absolute';
        canvas.style.left = x - wixel + 'px';
        canvas.style.top = y - wixel + 'px';
        canvas.style.width = width + wixel + wixel + 'px';
        canvas.style.height = height + wixel + wixel + 'px';
        var ctx = CanvasContextProvider.$getCanvasContext(canvas);
        ctx.translate(wixel + 0.5, wixel + 0.5);
        ctx.scale(zoom, zoom);
        ctx.imageSmoothingEnabled = false;
        return ctx;
      }

      /**
       * @private
       * @param {HTMLCanvasElement} canvas
       * @returns {CanvasRenderingContext2D}
       */
    }], [{
      key: "$getCanvasContext",
      value: function $getCanvasContext(canvas) {
        return canvas.getContext('2d');
      }
    }]);
  }();
  function toPixels(layout, wixel) {
    var x = layout.x,
      y = layout.y,
      width = layout.width,
      height = layout.height;
    return {
      x: x * wixel,
      y: y * wixel,
      width: width * wixel,
      height: height * wixel
    };
  }
  return CanvasContextProvider;
});
