function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.n
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/render/canvas/CanvasInteractionController
 */
define(['baja!', 'lex!baja', 'log!nmodule.wiresheet.rc.wb.render.canvas.CanvasInteractionController', 'dialogs', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/PopOutEditor', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/registry/StationRegistry', 'nmodule/webEditors/rc/util/htmlUtils', 'nmodule/webEditors/rc/wb/profile/selectionModeSettings', 'nmodule/wiresheet/rc/wb/util/wsUtils', 'nmodule/wiresheet/rc/wb/util/wsMenuUtils'], function (baja, lexs, log, dialogs, $, Promise, _, PopOutEditor, compUtils, fe, feDialogs, StationRegistry, htmlUtils, selectionModeSettings, wsUtils, wsMenuUtils) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var each = _.each,
    extend = _.extend,
    find = _.find,
    isEqual = _.isEqual;
  var contextMenuOnLongPress = htmlUtils.contextMenuOnLongPress,
    onLongPress = htmlUtils.onLongPress;
  var entityToOrd = wsUtils.entityToOrd,
    entityIdToOrd = wsUtils.entityIdToOrd,
    getRoundedWixelCoords = wsUtils.getRoundedWixelCoords,
    getWixelCoords = wsUtils.getWixelCoords,
    isEdge = wsUtils.isEdge,
    isTouch = wsUtils.isTouch,
    isMultitouch = wsUtils.isMultitouch,
    isVertex = wsUtils.isVertex,
    isWobble = wsUtils.isWobble,
    layoutContainsPoint = wsUtils.layoutContainsPoint,
    isTextBlock = wsUtils.isTextBlock,
    isStub = wsUtils.isStub,
    toBajaId = wsUtils.toBajaId;
  var toDisplayPathString = compUtils.toDisplayPathString;
  var _lexs = _slicedToArray(lexs, 1),
    bajaLex = _lexs[0];
  var getSelectionModeFromEvent = selectionModeSettings.getSelectionModeFromEvent,
    TOGGLE_MODE = selectionModeSettings.TOGGLE_MODE;
  var CURSOR_IN = 'url(\'/module/bajaui/com/tridium/ui/cursors/linkLeft.png\') 9 16, auto';
  var CURSOR_OUT = 'url(\'/module/bajaui/com/tridium/ui/cursors/linkRight.png\') 22 16, auto';
  var FOOTER_HEIGHT = 1;
  var HEADER_HEIGHT = 2;
  var MAX_CONNECTOR_WIDTH = 3;
  var RIGHT_MOUSE_BUTTON = 3;

  /**
   * This module's job is to listen for user interaction events from a `canvas`
   * tag and translate them to the standardized operations on a
   * `WbInteractionController`.
   *
   * @class
   * @alias module:nmodule/wiresheet/rc/wb/render/canvas/CanvasInteractionController
   */
  var CanvasInteractionController = /*#__PURE__*/function () {
    /**
     * @param {object} params
     * @param {module:nmodule/wiresheet/rc/wb/controller/WbInteractionController} params.controller
     * @param {module:nmodule/wiresheet/rc/core/controller/Selection} params.selection
     * @param {module:nmodule/wiresheet/rc/core/ViewModel} params.viewModel
     * @param {module:nmodule/wiresheet/rc/wb/WbLayoutStrategy} params.layoutStrategy
     * @param {number} [zoom=1] params.zoom initial zoom level
     * @param {module:nmodule/wiresheet/rc/wb/WsOptions} params.options
     */
    function CanvasInteractionController() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        controller = _ref.controller,
        selection = _ref.selection,
        viewModel = _ref.viewModel,
        layoutStrategy = _ref.layoutStrategy,
        _ref$zoom = _ref.zoom,
        zoom = _ref$zoom === void 0 ? 1 : _ref$zoom,
        _ref$options = _ref.options,
        options = _ref$options === void 0 ? {} : _ref$options;
      _classCallCheck(this, CanvasInteractionController);
      if (!controller) {
        throw new Error('InteractionController required');
      }
      if (!viewModel) {
        throw new Error('ViewModel required');
      }
      if (!layoutStrategy) {
        throw new Error('LayoutStrategy required');
      }
      if (!selection) {
        throw new Error('Selection required');
      }
      this.$controller = controller;
      //TODO: layoutStrategy is only for access to the mask.
      // add a clear() function and keep the same instance
      this.$layoutStrategy = layoutStrategy;
      this.$selection = selection;
      this.$viewModel = viewModel;
      this.$setCursor = function () {};
      this.$zoom = zoom;
      this.$options = options;
      this.$activeHighlightedEntities = [];
      this.$resolveCachedEntity = _.memoize(function (id, container) {
        return entityIdToOrd(id).get({
          base: container
        });
      }, function (id) {
        return id;
      });
    }

    /**
     * @param {Number} zoomLevel
     */
    return _createClass(CanvasInteractionController, [{
      key: "zoom",
      value: function zoom(zoomLevel) {
        this.$zoom = zoomLevel;
      }

      /**
       * 
       * @param {object} options 
       */
    }, {
      key: "options",
      value: function options(_options) {
        this.$options = _options;
      }

      /**
       * @param {HTMLElement} dom
       */
    }, {
      key: "initialize",
      value: function initialize(dom) {
        var _this = this;
        this.$dom = dom;
        var canvas = dom.querySelector('.ws-canvas-overlay');
        this.$setCursor = function (cursor) {
          switch (cursor) {
            case 'in':
              cursor = CURSOR_IN;
              break;
            case 'out':
              cursor = CURSOR_OUT;
              break;
          }
          canvas.style.cursor = cursor;
        };
        var mousedown;
        var domEvents = {
          'dblclick': function dblclick(e) {
            return _this.dblclick(e)["catch"](logSevere);
          },
          'dragstart': function dragstart(e) {
            e.preventDefault();
          },
          // handles case on iOS that prevents active op from updating
          'dragenter': function dragenter(e) {
            e.preventDefault();
          },
          'dragover': function dragover(e) {
            _this.dragover(e)["catch"](logSevere);
          },
          'dragleave': function dragleave(e) {
            _this.dragleave(e)["catch"](logSevere);
          },
          'drop': function drop(e) {
            _this.drop(e)["catch"](logSevere);
            return false;
          },
          'mousedown touchstart': function mousedown_touchstart(e) {
            mousedown = true;
            _this.mousedown(e, false)["catch"](logSevere);
          }
        };
        var releaseMousedownOnLongPress;
        var armMousedownOnLongPress = function armMousedownOnLongPress() {
          if (releaseMousedownOnLongPress) {
            return;
          }
          releaseMousedownOnLongPress = onLongPress($(dom), function (e) {
            mousedown = true;
            _this.mousedown(e, true)["catch"](logSevere);
            releaseMousedownOnLongPress();
            releaseMousedownOnLongPress = undefined;
          }).release;
        };
        var documentEvents = {
          'mousemove touchmove': function mousemove_touchmove(e) {
            _this.mousemove(e)["catch"](logSevere);
          },
          'mouseup touchend': function mouseup_touchend(e) {
            if (mousedown) {
              _this.mouseup(e)["catch"](logSevere);
            }
            mousedown = false;
            armMousedownOnLongPress();
          }
        };
        this.$armContextMenuLongPress(dom);
        var applyEventHandlers = function applyEventHandlers(onOrOff) {
          each(domEvents, function (handler, event) {
            event.split(' ').forEach(function (e) {
              return $(dom)[onOrOff](e, '.ws-canvas-overlay', handler);
            });
          });
          each(documentEvents, function (handler, event) {
            var m = onOrOff === 'on' ? 'addEventListener' : 'removeEventListener';
            //need passive: false to allow preventDefault to stop scrolling when
            //moving a glyph around.
            event.split(' ').forEach(function (e) {
              return document[m](e, handler, {
                passive: false
              });
            });
          });
          onOrOff === 'on' ? armMousedownOnLongPress() : releaseMousedownOnLongPress();
        };
        applyEventHandlers('on');
        this.release = function () {
          return applyEventHandlers('off');
        };
      }

      /**
       * @param {JQuery.Event} e a right-click/contextmenu event
       * @returns {Promise.<Array.<object>>} array of the entities we're right-clicking on.
       * If target is nothing, resolves empty array. If target is a vertex,
       * resolves all selected vertices. If target is an edge, resolves all
       * selected edges. Any entities that are under the mouse will be sorted to the first results in the array.
       */
    }, {
      key: "getSubject",
      value: function getSubject(e) {
        var _this2 = this;
        var selection = this.$selection;
        var entities = this.$getEntitiesUnderMouse(e);
        var selectPromises = [];
        var primaryEntity = entities[0];
        var modify = getSelectionModeFromEvent(e, false) === TOGGLE_MODE;
        var preferSelection = e.which === RIGHT_MOUSE_BUTTON;
        return Promise.resolve(primaryEntity && this.$controller.selectEntity(primaryEntity, modify, preferSelection)).then(function () {
          return Promise.all(entities.slice(1).map(function (entity) {
            return _this2.$controller.selectEntity(entity, true, preferSelection);
          }));
        }).then(function () {
          for (var i = 0; i < entities.length; i++) {
            var entity = entities[i];
            if (entity && !selection.contains(entity)) {
              selectPromises.push(_this2.$controller.selectEntity(entity, modify || entities.length > 1));
            }
          }
          return Promise.all(selectPromises).then(function () {
            var selected = selection.getSelectedEntities().map(function (e) {
              return e.predicate || e;
            });
            return selected.filter(isVertex(primaryEntity) ? isVertex : isEdge);
          });
        }).then(function (selected) {
          return selected.sort(function (a, b) {
            var aIsUnderMouse = entities.contains(a);
            var bIsUnderMouse = entities.contains(b);
            if (aIsUnderMouse && bIsUnderMouse) {
              return 0;
            } else if (aIsUnderMouse) {
              return -1;
            } else {
              return 1;
            }
          });
        });
      }

      /**
       * When a component is double-clicked, hyperlink to it.
       *
       * @param {JQuery.Event} e
       * @returns {Promise}
       */
    }, {
      key: "dblclick",
      value: function dblclick(e) {
        var _this3 = this;
        var entity = this.$getEntityUnderMouse(e);
        if (isVertex(entity)) {
          // If a BIWebPopoutEditor is registered on the entity's baja value
          // then pop it out on double click, otherwise hyperlink to Ord
          var ord = entityToOrd(entity, this.$viewModel);
          return this.$getPopoutInfo(ord).then(function (_ref2) {
            var editorCtr = _ref2.editorCtr,
              valueToLoad = _ref2.valueToLoad;
            if (!editorCtr) {
              return _this3.$controller.hyperlinkToOrd(ord);
            } else {
              return popout(editorCtr, valueToLoad);
            }
          })["catch"](feDialogs.error);
        }
        if (isStub(entity)) {
          var base = this.$viewModel.getContainer();
          return wsMenuUtils.stubToOrd(this.$viewModel.getId(entity), {
            base: base
          }).then(function (ord) {
            if (ord) {
              return _this3.$controller.hyperlinkToOrd(ord, true)["catch"](feDialogs.error);
            }
          })["catch"](feDialogs.error);
        }
        return Promise.resolve();
      }

      /**
       * @param {JQuery.Event} e
       * @returns {Promise}
       */
    }, {
      key: "drop",
      value: function drop(e) {
        var _this4 = this;
        var _getRoundedWixelCoord = getRoundedWixelCoords(e, this.$dom, this.$zoom),
          x = _getRoundedWixelCoord.x,
          y = _getRoundedWixelCoord.y,
          entity = this.$getEntityUnderMouse(e),
          connectorInfo = entity && getConnectorUnderMouse(entity, x, y),
          direction = entity && getConnectorDirection(x, y, entity.layout),
          horizontalPosition = getHorizontalPosition(x, entity),
          params = {
            origin: "".concat(x, ",").concat(y, ",8"),
            entity: entity,
            direction: direction,
            connectorInfo: connectorInfo,
            horizontalPosition: horizontalPosition
          };
        return this.mouseup(e).then(function () {
          return _this4.$controller.dropFromClipboard(e.originalEvent.dataTransfer, params)["catch"](feDialogs.error);
        }).then(function () {
          return _this4.$commitOp(e);
        });
      }

      /**
       * 
       * @param {JQuery.Event} e 
       * @returns {Promise}
       */
    }, {
      key: "dragover",
      value: function dragover(e) {
        var _this5 = this;
        e.preventDefault();
        this.$opEvent = e;
        var params = this.$getDragOpState(e);
        return this.$controller.startDropperOp(params).then(function () {
          return _this5.$controller.updateCurrentOp(params);
        });
      }

      /**
       *
       * @param {JQuery.Event} e
       * @returns {Promise}
       */
    }, {
      key: "dragleave",
      value: function dragleave(e) {
        var _this6 = this;
        return this.mouseup(e).then(function () {
          return _this6.$commitOp(e);
        });
      }

      /**
       * On mousedown/touchstart, start an operation (link/move/select).
       *
       * @param {JQuery.Event} e
       * @param {boolean} isLongPress specifies whether the source is a long press
       * @returns {Promise}
       */
    }, {
      key: "mousedown",
      value: function mousedown(e, isLongPress) {
        var viewModel = this.$viewModel;
        var controller = this.$controller;
        var setCursor = this.$setCursor;
        var entity = this.$getEntityUnderMouse(e);
        var _getWixelCoords = getWixelCoords(e, this.$dom, this.$zoom),
          x = _getWixelCoords.x,
          y = _getWixelCoords.y;

        // Long press is used to initiate a select on a touch to allow for scrolling
        if (!entity && isTouch(e) && !isLongPress) {
          return Promise.resolve();
        }
        if (entity && isLongPress) {
          return Promise.resolve();
        }
        if (!entity) {
          // clicking on grid, so start a selection
          this.$opEvent = e;
          e.preventDefault();
          return controller.startSelectOp({
            x: x,
            y: y
          });
        }
        var glyph = entity.glyph,
          layout = entity.layout;
        if (!isVertex(entity) || glyph.uiStatus.selectable === false) {
          return Promise.resolve(); // only handling selectable vertices
        }
        var connectorInfo = getConnectorUnderMouse(entity, x, y);
        var _ref3 = connectorInfo || {},
          connectorId = _ref3.connectorId,
          connectorDirection = _ref3.connectorDirection,
          connectorType = _ref3.connectorType;
        e.preventDefault();
        this.$opEvent = e;
        var entityId = viewModel.getId(entity);
        this.$highlightedStart = undefined;
        switch (connectorType) {
          case 'relation':
          case 'footer':
            {
              var snap = snapConnector(x, y, layout, connectorDirection);
              this.$highlightedStart = {
                entity: entity,
                highlightInfo: {
                  which: 'start',
                  connectorInfo: {
                    connectorId: connectorId,
                    connectorDirection: connectorDirection,
                    connectorType: connectorType
                  }
                }
              };
              if (!this.$options.showRelations) {
                return controller.startLinkOp({
                  x: snap.x,
                  y: snap.y,
                  entityId: entityId,
                  connectorId: connectorId,
                  connectorDirection: connectorDirection,
                  setCursor: setCursor
                });
              }
              return controller.startRelateOp({
                x: snap.x,
                y: snap.y,
                entityId: entityId,
                connectorDirection: connectorDirection,
                connectorId: connectorId,
                setCursor: setCursor
              });
            }
          case 'link':
            {
              this.$highlightedStart = {
                entity: entity,
                highlightInfo: {
                  which: 'start',
                  connectorInfo: {
                    connectorId: connectorId,
                    connectorDirection: connectorDirection,
                    connectorType: connectorType
                  }
                }
              };
              var _snap = snapConnector(x, y, layout, connectorDirection);
              return controller.startLinkOp({
                x: _snap.x,
                y: _snap.y,
                entityId: entityId,
                connectorId: connectorId,
                connectorDirection: connectorDirection,
                setCursor: setCursor
              });
            }
          default:
            var direction = getResizeDirection(entity, {
              x: x,
              y: y
            });
            if (direction) {
              return controller.startResizeOp({
                x: x,
                y: y,
                entityId: entityId,
                direction: direction
              });
            } else {
              return controller.startMoveOp({
                x: x,
                y: y,
                entityId: entityId
              });
            }
        }
      }

      /**
       * On mousemove, if an operation is underway, update it with the current
       * mouse position.
       *
       * @param {JQuery.Event} e
       * @returns {Promise}
       */
    }, {
      key: "mousemove",
      value: function mousemove(e) {
        var _this7 = this;
        var params = this.$getDragOpState(e);
        if (this.$activeOp || this.$isActiveDrag(e)) {
          this.$activeOp = true;
          e.preventDefault();
          e.stopPropagation();
          this.$disarmContextMenuLongPress();
          var entities = this.$getEntitiesUnderMouse(e);
          var entity = entities[0];
          return this.$controller.updateCurrentOp(params).then(function () {
            return _this7.$applyHighlightToEntity(entity, params);
          });
        } else {
          var _entities = this.$getEntitiesUnderMouse(e);
          var _entity = _entities[0];
          var x = params.x,
            y = params.y;
          this.$setCursor(getIdleCursor(_entity, {
            x: x,
            y: y
          }));
          return this.$clearHighlightedConnectors().then(function () {
            return Promise.all([_entity && _this7.$highlightConnector(_entity, {
              which: 'start',
              connectorInfo: getConnectorUnderMouse(_entity, x, y)
            }), _this7.$displayToolTipForEntity(e, _entity, _entities.length)]);
          });
        }
      }

      /**
       * When the mouse is released, commit whatever operation is currently
       * underway. If there is no operation going, handle as a click and add to
       * the current selection.
       *
       * @param {JQuery.Event} e
       * @returns {Promise}
       */
    }, {
      key: "mouseup",
      value: function mouseup(e) {
        var _this8 = this;
        var active = this.$activeOp;
        delete this.$opEvent;
        delete this.$activeOp;
        this.$armContextMenuLongPress();
        if (!active) {
          var entities = !this.$opEvent && this.$getEntitiesUnderMouse(e);
          if (entities.length) {
            var modify = getSelectionModeFromEvent(e, false) === TOGGLE_MODE;
            var preferSelection = e.which === RIGHT_MOUSE_BUTTON;
            return this.$clearHighlightedConnectors().then(function () {
              return _this8.$controller.selectEntity(entities[0], modify, preferSelection);
            }).then(function () {
              return Promise.all(entities.slice(1).map(function (entity) {
                return _this8.$controller.selectEntity(entity, true, preferSelection);
              }));
            });
          }
          return this.$clearHighlightedConnectors();
        }
        return this.$clearHighlightedConnectors().then(function () {
          return _this8.$commitOp(e);
        });
      }

      /**
       * @private
       * @param {JQuery.Event} e 
       * @returns {Promise}
       */
    }, {
      key: "$commitOp",
      value: function $commitOp(e) {
        var _this9 = this;
        return this.$controller.commitCurrentOp(this.$getDragOpState(e))["catch"](function (err) {
          logSevere(err);
          dialogs.showOk(err);
        })["finally"](function () {
          return _this9.$setCursor('default');
        });
      }

      /**
       * @private
       * @param {JQuery.Event} e
       * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} entity
       * @param {Number} mouseEntitiesLength
       * @returns {Promise}
       */
    }, {
      key: "$displayToolTipForEntity",
      value: function $displayToolTipForEntity(e, entity, mouseEntitiesLength) {
        var _this10 = this;
        if (this.$opEvent) {
          return Promise.resolve();
        } // Let the op handle the tooltip instead

        var _getWixelCoords2 = getWixelCoords(e, this.$dom, this.$zoom),
          x = _getWixelCoords2.x,
          y = _getWixelCoords2.y;
        return resolveToolTipUnderMouse(entity, x, y, this.$viewModel, this.$resolveCachedEntity).then(function (tooltip) {
          if (tooltip) {
            _this10.$controller.displayToolTip(tooltip + (mouseEntitiesLength > 1 ? ' ' + bajaLex.get('linkcheck.multipleSubjects', mouseEntitiesLength) : ''));
          } else {
            _this10.$controller.cancelToolTip();
          }
        });
      }

      /**
       * @private
       * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} entity
       * @returns {Promise}
       */
    }, {
      key: "$displayForStub",
      value: function $displayForStub(entity, mouseEntities) {
        if (!mouseEntities.contains(entity)) {
          return Promise.resolve('');
        }
        return resolveStubDisplay(entity, this.$viewModel, this.$resolveCachedEntity);
      }

      /**
       * @private
       * @param {JQuery.Event} e
       * @returns {Array.<module:nmodule/wiresheet/rc/typedefs~WiresheetEntity>} the entities under the mouse
       */
    }, {
      key: "$getEntitiesUnderMouse",
      value: function $getEntitiesUnderMouse(e) {
        var result = this.$getEntityUnderMouse(e, true);
        if (result) {
          return [].concat(result);
        }
        return [];
      }
      /**
       * @private
       * @param {JQuery.Event} e
       * @param [allowMultipleResults] if this is true, the results could be an Array if there are multiple Stubs
       * @returns {Array.<module:nmodule/wiresheet/rc/typedefs~WiresheetEntity>|module:nmodule/wiresheet/rc/typedefs~WiresheetEntity|undefined} the entity under the mouse
       */
    }, {
      key: "$getEntityUnderMouse",
      value: function $getEntityUnderMouse(e, allowMultipleResults) {
        var _getRoundedWixelCoord2 = getRoundedWixelCoords(e, this.$dom, this.$zoom),
          x = _getRoundedWixelCoord2.x,
          y = _getRoundedWixelCoord2.y;
        var tiles = this.$layoutStrategy.$mask.getTiles(x, y);
        var stubs = [];
        for (var i = 0, len = tiles.length; i < len; ++i) {
          if (tiles[i].entity.glyph.type === 'StubGlyph') {
            stubs.push(tiles[i].entity);
          }
        }
        if (stubs.length > 1 && allowMultipleResults) {
          return stubs;
        }
        var tile = tiles[stubs.length > 1 ? tiles.length - 1 : 0];
        if (tile) {
          return tile.entity;
        }

        // if outside an entity but inside its resize zone, consider that to be what we're pointing at.
        var selectedEntities = this.$selection.getSelectedEntities();
        var point = getWixelCoords(e, this.$dom, this.$zoom);
        for (var _i = 0, _len = selectedEntities.length; _i < _len; ++_i) {
          var entity = selectedEntities[_i];
          if (getResizeDirection(entity, point)) {
            return entity;
          }
        }
      }

      /**
       * @private
       * @param {JQuery.Event} e
       * @returns {module:nmodule/wiresheet/rc/typedefs~DragOpState} an object
       * with the mouse coordinates and information about what entity is currently
       * under the mouse
       */
    }, {
      key: "$getDragOpState",
      value: function $getDragOpState(e) {
        var _getWixelCoords3 = getWixelCoords(e, this.$dom, this.$zoom),
          x = _getWixelCoords3.x,
          y = _getWixelCoords3.y;
        var viewModel = this.$viewModel;
        var entity = this.$getEntityUnderMouse(e);
        var connectorInfo = entity && getConnectorUnderMouse(entity, x, y);
        var params = {
          x: x,
          y: y,
          setCursor: this.$setCursor
        };
        if (entity) {
          params.entityId = viewModel.getId(entity);
          params.entity = entity;
          params.horizontalPosition = getHorizontalPosition(x, entity);
        }
        if (connectorInfo) {
          extend(params, connectorInfo);
        }
        return params;
      }

      /**
       * @private
       * @param {JQuery.Event} event
       * @returns {boolean}
       */
    }, {
      key: "$isActiveDrag",
      value: function $isActiveDrag(event) {
        var opEvent = this.$opEvent;
        return !(event.which > 1 || isMultitouch(event) || !opEvent || isWobble(event, opEvent));
      }

      /**
       * @private
       */
    }, {
      key: "$armContextMenuLongPress",
      value: function $armContextMenuLongPress() {
        if (!this.$releaseContextMenu) {
          this.$releaseContextMenu = contextMenuOnLongPress($(this.$dom)).release;
        }
      }

      /**
       * Disarms the context menu on long press and hides the context menu if open.
       *
       * @private
       */
    }, {
      key: "$disarmContextMenuLongPress",
      value: function $disarmContextMenuLongPress() {
        $('.context-menu-list').trigger('contextmenu:hide');
        if (this.$releaseContextMenu) {
          this.$releaseContextMenu();
          this.$releaseContextMenu = undefined;
        }
      }

      /**
       * @private
       * @param {baja.Ord} ord 
       * @returns  {Promise.<object>} with 'editorCtr', 'valueToLoad'
       */
    }, {
      key: "$getPopoutInfo",
      value: function $getPopoutInfo(ord) {
        return baja.Ord.make({
          base: baja.Ord.make('station:'),
          child: ord.relativizeToSession()
        }).get().then(function (value) {
          return getPopoutAgent(value).then(function (agent) {
            return {
              editorCtr: agent,
              valueToLoad: value
            };
          });
        });
      }

      /**
       * @private
       * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} entity 
       * @param {object} param 
       * @param {Number} param.x
       * @param {Number} param.y
       * @returns {Promise}
       */
    }, {
      key: "$applyHighlightToEntity",
      value: function $applyHighlightToEntity(entity) {
        var _this11 = this;
        var _ref4 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          x = _ref4.x,
          y = _ref4.y;
        // If you are here a legit drag is in progress
        if (!this.$controller.canHighlightForOp()) {
          return Promise.resolve();
        }
        var highlightedStart = this.$highlightedStart,
          isSameHighlightInfo = function isSameHighlightInfo(h1, h2) {
            return isEqual(h1.entity.glyph, h2.entity.glyph) && isEqual(h1.highlightInfo.connectorInfo, h2.highlightInfo.connectorInfo);
          };
        if (highlightedStart) {
          return this.$highlightConnector(highlightedStart.entity, highlightedStart.highlightInfo).then(function () {
            if (entity) {
              var connectorInfo = getConnectorUnderMouse(entity, x, y);
              if (!_this11.$highlightedEnd && connectorInfo && !isSameHighlightInfo(highlightedStart, {
                entity: entity,
                highlightInfo: {
                  which: 'end',
                  connectorInfo: connectorInfo
                }
              })) {
                _this11.$highlightedEnd = {
                  entity: entity,
                  highlightInfo: {
                    which: 'end',
                    connectorInfo: connectorInfo
                  }
                };
                return _this11.$highlightConnector(entity, _this11.$highlightedEnd.highlightInfo);
              }
              if (_this11.$highlightedEnd) {
                var _this11$$controller;
                return (_this11$$controller = _this11.$controller).clearConnectorHighlight.apply(_this11$$controller, _toConsumableArray(Object.values(_this11.$highlightedEnd))).then(function () {
                  _this11.$highlightedEnd = {
                    entity: entity,
                    highlightInfo: {
                      which: 'end',
                      connectorInfo: connectorInfo
                    }
                  };
                  return _this11.$highlightConnector(entity, _this11.$highlightedEnd.highlightInfo);
                });
              }
            } else {
              var _this11$$controller2;
              return _this11.$highlightedEnd && (_this11$$controller2 = _this11.$controller).clearConnectorHighlight.apply(_this11$$controller2, _toConsumableArray(Object.values(_this11.$highlightedEnd)));
            }
          });
        }
      }

      /**
       * @private
       * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} entity 
       * @param {Object} highlightInfo
       * @returns {Promise}
       */
    }, {
      key: "$highlightConnector",
      value: function $highlightConnector(entity, highlightInfo) {
        if (!highlightInfo) {
          return Promise.resolve();
        }
        return this.$controller.highlightConnector(entity, highlightInfo);
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$clearHighlightedConnectors",
      value: function $clearHighlightedConnectors() {
        var _this12 = this;
        this.$highlightedEnd = undefined;
        return this.$viewModel.getAllEntities().then(function (entities) {
          var highlightedEntities = entities.filter(function (e) {
            var _ref5 = e || {},
              glyph = _ref5.glyph,
              uiStatus = glyph.uiStatus;
            return uiStatus && (uiStatus.highlightedStartConnector || uiStatus.highlightedEndConnector);
          });
          return Promise.all(highlightedEntities.map(_this12.$controller.clearConnectorHighlight.bind(_this12.$controller)));
        });
      }
    }]);
  }();
  /**
   * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} entity the
   * component glyph under the mouse
   * @param {number} x mouse x, in wixels
   * @param {number} y mouse y, in wixels
   * @returns {module:nmodule/wiresheet/rc/wb/render/canvas/CanvasInteractionController~ConnectorInfo|null}
   */
  function getConnectorUnderMouse(entity, x, y) {
    var glyph = entity.glyph,
      layout = entity.layout;
    var connectorDirection = getConnectorDirection(x, y, layout);
    if (glyph.type !== 'ComponentGlyph') {
      return null;
    }
    if (!connectorDirection) {
      return null;
    }
    var bars = glyph.bars;
    var bottom = layout.y + layout.height;
    var bar = bars[Math.floor(y - layout.y - HEADER_HEIGHT)];
    if (bar) {
      var connectorId = bar.id;
      return {
        connectorId: connectorId,
        connectorDirection: connectorDirection,
        connectorType: connectorId.startsWith('relation:') ? 'relation' : 'link'
      };
    } else if (y >= bottom - FOOTER_HEIGHT) {
      return {
        connectorDirection: connectorDirection,
        connectorType: 'footer'
      };
    }
  }

  /**
   * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity|undefined} entity the
   * component glyph under the mouse
   * @param {number} x mouse x, in wixels
   * @param {number} y mouse y, in wixels
   * @param {module:nmodule/wiresheet/rc/core/ViewModel} viewModel
   * @param {function} resolveCachedEntity a function to resolve the entity to
   * its baja Object
   * @returns {Promise.<string|undefined>} promise that resolves with the text to display
   * for what is under the mouse. Will resolve undefined if the area under the
   * mouse does not need a tooltip to be displayed.
   */
  function resolveToolTipUnderMouse(entity, x, y, viewModel, resolveCachedEntity) {
    if (!entity || isTextBlock(entity)) {
      return Promise.resolve();
    }
    var glyph = entity.glyph,
      layout = entity.layout;
    if (isStub(entity)) {
      var container = viewModel.getContainer();
      var connectorType = glyph.connectorType,
        sourceConnector = glyph.sourceConnector,
        sourceId = glyph.sourceId,
        targetConnector = glyph.targetConnector,
        targetId = glyph.targetId;
      return Promise.all([resolveCachedEntity(sourceId, container), resolveCachedEntity(targetId, container)]).then(function (_ref6) {
        var _ref7 = _slicedToArray(_ref6, 2),
          source = _ref7[0],
          target = _ref7[1];
        var sourcePath = toDisplayPathString(source);
        var targetPath = toDisplayPathString(target);
        if (connectorType === 'link') {
          var sourceSlot = sourceConnector.split(":", 2)[1];
          var sourceString = "".concat(sourcePath, ".").concat(sourceSlot);
          var targetSlot = targetConnector.split(":", 2)[1];
          var targetString = "".concat(targetPath, ".").concat(targetSlot);
          return bajaLex.get({
            key: 'linkcheck.linkDirection',
            args: [sourceString, targetString]
          });
        } else {
          var relationId = toBajaId(sourceConnector || targetConnector);
          return bajaLex.get({
            key: 'relationcheck.relationDirection',
            args: [sourcePath, relationId, targetPath]
          });
        }
      });
    }
    if (isEdge(entity)) {
      return Promise.resolve(glyph.tooltip);
    }
    var bottom = layout.y + layout.height;
    var isOverFooter = y >= bottom - FOOTER_HEIGHT;
    if (isOverFooter) {
      return Promise.resolve();
    }
    var bars = glyph.bars;
    var bar = bars[Math.floor(y - layout.y - HEADER_HEIGHT)];
    if (bar) {
      return Promise.resolve(bar.tooltip);
    }
    return Promise.resolve(glyph.header.tooltip);
  }

  /**
   * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity|undefined} entity the
   * stub glyph under the mouse
   * @param {number} x mouse x, in wixels
   * @param {number} y mouse y, in wixels
   * @param {module:nmodule/wiresheet/rc/core/ViewModel} viewModel
   * @param {function} resolveCachedEntity a function to resolve the entity to
   * its baja Object
   * @returns {Promise.<string|undefined>} promise that resolves with the text to display
   * for what is under the mouse. This displayPath is used to indicate which Stub the entity is for.
   */
  function resolveStubDisplay(entity, viewModel, resolveCachedEntity) {
    if (!entity || !isStub(entity)) {
      return Promise.resolve();
    }
    var glyph = entity.glyph;
    var container = viewModel.getContainer();
    var connectorType = glyph.connectorType,
      sourceConnector = glyph.sourceConnector,
      sourceId = glyph.sourceId,
      targetConnector = glyph.targetConnector,
      targetId = glyph.targetId,
      direction = glyph.direction;
    var idToResolve = direction === 'in' ? sourceId : targetId;
    return resolveCachedEntity(idToResolve, container).then(function (comp) {
      var compPath = toDisplayPathString(comp);
      if (connectorType === 'link') {
        var slot = (direction === 'in' ? sourceConnector : targetConnector).split(":", 2)[1];
        return "".concat(compPath, ".").concat(slot);
      } else {
        return compPath;
      }
    })["catch"](function (ignore) {
      //by catching the resolve error here, we'll still be able to show the 'Delete All' to provide a mechanism to get rid of the bad link
    });
  }

  /**
   * @param {number} x mouse x in wixels
   * @param {number} y mouse y in wixels
   * @param {module:nmodule/wiresheet/rc/typedefs~Layout} layout the layout of
   * the component glyph under the mouse
   * @returns {string} `in` if mouse over an incoming connector (left side);
   * `out` if mouse over an outgoing connector (right side)
   */
  function getConnectorDirection(x, y, layout) {
    var _getConnectorLayouts = getConnectorLayouts(y, layout),
      _getConnectorLayouts2 = _slicedToArray(_getConnectorLayouts, 2),
      left = _getConnectorLayouts2[0],
      right = _getConnectorLayouts2[1];
    var point = {
      x: x,
      y: y
    };
    if (layoutContainsPoint(left, point)) {
      return 'in';
    }
    if (layoutContainsPoint(right, point)) {
      return 'out';
    }
  }

  /**
   * @param {number} mouseY mouse y in wixels
   * @param {module:nmodule/wiresheet/rc/typedefs~Layout} layout the layout of
   * the component glyph under the mouse
   * @returns {Array.<module:nmodule/wiresheet/rc/typedefs~Layout>} the layouts
   * of the left and right connectors of the bar under the mouse
   */
  function getConnectorLayouts(mouseY, layout) {
    var x = layout.x,
      width = layout.width;
    var y = Math.floor(mouseY);
    var right = x + width;
    var connectorWidth = Math.min(layout.width / 2, MAX_CONNECTOR_WIDTH);
    return [{
      x: x,
      y: y,
      width: connectorWidth,
      height: 1
    }, {
      x: right - connectorWidth,
      y: y,
      width: connectorWidth,
      height: 1
    }];
  }

  /**
   * When starting a link or relation op, "snap" the starting point of the op to
   * the center of the edge of the connector where the op starts. This makes it
   * a bit easier for the user to see where they're linking from (otherwise the
   * starting point of the line might get lost in the connector's text).
   *
   * @param {number} x mouse x in wixels
   * @param {number} y mouse y in wixels
   * @param {module:nmodule/wiresheet/rc/typedefs~Layout} layout the layout of
   * the component glyph under the mouse
   * @param {string} connectorDirection `in` or `out`
   * @returns {{ x: number, y: number }} the point to snap the beginning of the
   * op to
   */
  function snapConnector(x, y, layout, connectorDirection) {
    var _getConnectorLayouts3 = getConnectorLayouts(y, layout),
      _getConnectorLayouts4 = _slicedToArray(_getConnectorLayouts3, 2),
      left = _getConnectorLayouts4[0],
      right = _getConnectorLayouts4[1];
    switch (connectorDirection) {
      case 'in':
        return {
          x: left.x,
          y: left.y + 0.5
        };
      case 'out':
        return {
          x: right.x + right.width,
          y: right.y + 0.5
        };
    }
  }

  /**
   * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} entity the component glyph under the mouse
   * @param {{ x: number, y: number }} point the point under the mouse, in wixels
   * @returns {string|undefined}
   */
  function getResizeDirection(entity, point) {
    var glyph = entity.glyph;
    if (!glyph) {
      return;
    }
    var uiStatus = glyph.uiStatus;
    if (!uiStatus.selected) {
      return;
    }
    var resizeZone = find(resizeZones(entity), function (zone) {
      return layoutContainsPoint(zone, point);
    });
    return resizeZone && resizeZone.direction;
  }

  /**
   * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} entity
   * @returns {Array.<module:nmodule/wiresheet/rc/wb/render/canvas/CanvasInteractionController~ResizeZone>}
   */
  function resizeZones(_ref8) {
    var glyph = _ref8.glyph,
      layout = _ref8.layout;
    var x = layout.x,
      y = layout.y,
      width = layout.width,
      height = layout.height;
    var right = x + width;
    var bottom = y + height;
    switch (glyph.type) {
      case 'ComponentGlyph':
        return [{
          direction: 'w',
          x: x - 0.5,
          y: y,
          width: 1,
          height: 2
        }, {
          direction: 'e',
          x: right - 0.5,
          y: y,
          width: 1,
          height: 2
        }];
      case 'TextBlockGlyph':
        return [{
          direction: 'nw',
          x: x - 0.5,
          y: y - 0.5,
          width: 1,
          height: 1
        }, {
          direction: 'ne',
          x: right - 0.5,
          y: y - 0.5,
          width: 1,
          height: 1
        }, {
          direction: 'se',
          x: right - 0.5,
          y: bottom - 0.5,
          width: 1,
          height: 1
        }, {
          direction: 'sw',
          x: x - 0.5,
          y: bottom - 0.5,
          width: 1,
          height: 1
        }, {
          direction: 'n',
          x: x + 0.5,
          y: y - 0.5,
          width: width - 1,
          height: 1
        }, {
          direction: 'e',
          x: right - 0.5,
          y: y + 0.5,
          width: 1,
          height: height - 1
        }, {
          direction: 's',
          x: x + 0.5,
          y: bottom - 0.5,
          width: width - 1,
          height: 1
        }, {
          direction: 'w',
          x: x - 0.5,
          y: y + 0.5,
          width: 1,
          height: height - 1
        }];
    }
  }

  /**
   * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} entity
   * @param {{ x: number, y: number }} point
   * @returns {string}
   */
  function getIdleCursor(entity, point) {
    switch (entity && getResizeDirection(entity, point)) {
      case 'n':
      case 's':
        return 'ns-resize';
      case 'e':
      case 'w':
        return 'ew-resize';
      case 'ne':
      case 'sw':
        return 'nesw-resize';
      case 'nw':
      case 'se':
        return 'nwse-resize';
    }
    var connectorInfo = entity && getConnectorUnderMouse(entity, point.x, point.y);
    if (connectorInfo) {
      return connectorInfo.connectorDirection;
    }
    return 'default';
  }

  /**
   * @param {baja.Value} value 
   * @returns {Promise}
   */
  function getPopoutAgent(value) {
    return StationRegistry.getInstance().resolveFirst(value.getType(), {
      tags: ['wiresheet:IWebWireSheetPopupEditor']
    });
  }

  /**
  * @param {module:bajaux/Widget} Ctor 
  * @param {baja.Value} value 
  * @returns {Promise}
  */
  function popout(Ctor, value) {
    return feDialogs.showFor({
      type: Ctor,
      value: value,
      formFactor: 'any',
      title: getTitle(value)
    });
  }
  function getTitle(value) {
    if (baja.hasType(value, 'baja:Complex')) {
      return value.getDisplayName();
    }
    return String(value);
  }

  /**
   * Gets the whether the mouse is over left or right side of an entity if
   * provided.
   *
   * @param {number} x x position in wixels
   * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} [entity]
   * @returns {String|undefined} `left` or `right` if entity provided
   */
  function getHorizontalPosition(x, entity) {
    if (!entity || !entity.layout) {
      return;
    }
    var offset = (x - entity.layout.x) / entity.layout.width;
    return offset < 0.5 ? 'left' : 'right';
  }

  /**
   * @typedef {object} module:nmodule/wiresheet/rc/wb/render/canvas/CanvasInteractionController~ResizeZone
   * @property {string} direction
   * @property {number} x
   * @property {number} y
   * @property {number} width
   * @property {number} height
   */

  /**
   * @typedef {object} module:nmodule/wiresheet/rc/wb/render/canvas/CanvasInteractionController~ConnectorInfo
   * @property {string} [connectorId] the id of the connector under the mouse
   * @property {string} connectorDirection `in` or `out`
   * @property {string} connectorType `link`, `relation`, or `footer`
   * depending on where the user clicks on the component
   */

  return CanvasInteractionController;
});
