function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/render/canvas/RenderMediator
 */
define(['log!nmodule.wiresheet.rc.wb.render.canvas.RenderMediator', 'Promise', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/wiresheet/rc/wb/util/wsUtils'], function (log, Promise, _, asyncUtils, switchboard, wsUtils) {
  'use strict';

  var logWarning = log.warning.bind(log);
  var values = _.values;
  var waitInterval = asyncUtils.waitInterval;
  var isVertex = wsUtils.isVertex;
  var RELAYOUT_LEADING_INTERVAL = 16; // for debouncing purposes
  var RELAYOUT_TRAILING_INTERVAL = 234; // for throttling purposes

  var REPAINT_LEADING_INTERVAL = 0; // for debouncing purposes
  var REPAINT_TRAILING_INTERVAL = 16; // for throttling purposes

  var DB_EVENTS = ['put', 'del'];
  var UPDATE_EVENTS = ['vertexAdded', 'vertexUpdated', 'edgeAdded', 'edgeUpdated'];
  var REMOVE_EVENTS = ['vertexRemoved', 'edgeRemoved'];

  /**
   * This module's job is to listen for ViewModel update events/remove, and
   * ensure that the updated entities trigger layout updates and repaints as
   * appropriate.
   *
   * Encapsulating the logic here prevents mis-ordering of updates when both the
   * LayoutStrategy and CanvasRenderer are responding to events on their own
   * time.
   *
   * @class
   * @alias module:nmodule/wiresheet/rc/wb/render/canvas/RenderMediator
   */
  return /*#__PURE__*/function () {
    /**
     * @param {object} params
     * @param {module:nmodule/wiresheet/rc/wb/WbLayoutStrategy} params.layoutStrategy
     * @param {module:nmodule/wiresheet/rc/wb/WbViewModel} params.viewModel
     * @param {module:nmodule/wiresheet/rc/wb/render/canvas/CanvasRenderer} params.renderer
     */
    function RenderMediator(_ref) {
      var _this = this;
      var layoutStrategy = _ref.layoutStrategy,
        viewModel = _ref.viewModel,
        renderer = _ref.renderer;
      _classCallCheck(this, RenderMediator);
      this.$layoutStrategy = layoutStrategy;
      this.$viewModel = viewModel;
      this.$renderer = renderer;
      this.$updateQueue = {};
      this.$removeQueue = {};
      switchboard(this, {
        '$relayout': {
          allow: 'oneAtATime',
          onRepeat: 'preempt'
        },
        '$repaint': {
          allow: 'oneAtATime',
          onRepeat: 'preempt'
        }
      });
      this.$active = true;
      this.$onDb = function (entity) {
        _this.$relayoutSoon(entity)["catch"](logWarning); // don't wait on it!
      };
      this.$onUpdate = function (entity) {
        _this.$repaintSoon(entity)["catch"](logWarning);
      };
      this.$onRemove = function (entity) {
        _this.$removeSoon(entity)["catch"](logWarning);
      };
    }
    return _createClass(RenderMediator, [{
      key: "initialize",
      value: function initialize() {
        var _this2 = this;
        var viewModel = this.$viewModel;
        DB_EVENTS.forEach(function (event) {
          return viewModel.on(event, _this2.$onDb);
        });
        UPDATE_EVENTS.forEach(function (event) {
          return viewModel.on(event, _this2.$onUpdate);
        });
        REMOVE_EVENTS.forEach(function (event) {
          return viewModel.on(event, _this2.$onRemove);
        });
      }
    }, {
      key: "release",
      value: function release() {
        var _this3 = this;
        var viewModel = this.$viewModel;
        this.$active = false;
        DB_EVENTS.forEach(function (event) {
          return viewModel.removeListener(event, _this3.$onDb);
        });
        UPDATE_EVENTS.forEach(function (event) {
          return viewModel.removeListener(event, _this3.$onUpdate);
        });
        REMOVE_EVENTS.forEach(function (event) {
          return viewModel.removeListener(event, _this3.$onRemove);
        });
      }

      /**
       * @private
       * @param {object} entity
       * @returns {Promise}
       */
    }, {
      key: "$repaintSoon",
      value: function $repaintSoon(entity) {
        var id = this.$viewModel.getId(entity.predicate || entity);
        var updateQueue = this.$updateQueue;
        var removeQueue = this.$removeQueue;
        if (removeQueue[id]) {
          return Promise.resolve();
        }

        // ensure that a repaint request that hasn't yet run through the layout
        // process doesn't wipe the existing layout from a preceding concurrent
        // relayout request.
        var existing = updateQueue[id];
        if (existing) {
          var oldGlyph = existing.predicate || existing;
          var newGlyph = entity.predicate || entity;
          newGlyph.layout = newGlyph.layout || oldGlyph.layout;
        }
        updateQueue[id] = entity;
        return this.$repaint();
      }

      /**
       * @private
       * @param {object} entity
       * @returns {Promise}
       */
    }, {
      key: "$removeSoon",
      value: function $removeSoon(entity) {
        var id = this.$viewModel.getId(entity.predicate || entity);
        this.$removeQueue[id] = entity;
        delete this.$updateQueue[id];
        return this.$relayout();
      }

      /**
       * @private
       * @param {object} entity
       * @returns {Promise}
       */
    }, {
      key: "$relayoutSoon",
      value: function $relayoutSoon(entity) {
        if (!entity.predicate && !isVertex(entity)) {
          return Promise.resolve();
        }
        return this.$relayout();
      }

      /**
       * Paints updated entities to the renderer as quickly as possible.
       *
       * This gets lightly switchboarded to provide combo debouncing/throttling
       * behavior so repaints don't happen too often.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$repaint",
      value: function $repaint() {
        var _this4 = this;
        return waitInterval(REPAINT_LEADING_INTERVAL).then(function () {
          return _this4.$doRepaint();
        })["finally"](function () {
          return waitInterval(REPAINT_TRAILING_INTERVAL);
        });
      }

      /**
       * Performs a full layout/repaint of everything. This should happen less
       * frequently because it is more CPU-intensive.
       *
       * This gets switchboarded to provide combo debouncing/throttling behavior
       * so relayouts don't happen too often.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$relayout",
      value: function $relayout() {
        var _this5 = this;
        return waitInterval(RELAYOUT_LEADING_INTERVAL).then(function () {
          return _this5.$doRelayout();
        })["finally"](function () {
          return waitInterval(RELAYOUT_TRAILING_INTERVAL);
        });
      }

      /**
       * Performs a relayout, and sends any entities whose layout has changed
       * through the repaint handler.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doRelayout",
      value: function $doRelayout() {
        var _this6 = this;
        var viewModel = this.$viewModel;
        var layoutStrategy = this.$layoutStrategy;
        return log.timing(function () {
          return Promise.all([viewModel.getVertices(), viewModel.getEdges()]).then(function (_ref2) {
            var _ref3 = _slicedToArray(_ref2, 2),
              vertices = _ref3[0],
              triples = _ref3[1];
            if (!_this6.$active) {
              return;
            }
            layoutStrategy.$mask.clear();
            var updatedEntities = layoutStrategy.updateAll(vertices.filter(isVertex).concat(triples));
            var removedEntities = values(_this6.$removeQueue);
            _this6.$removeQueue = {};
            return Promise["try"](function () {
              var removeCount = removedEntities.length;
              var renderer = _this6.$renderer;
              return removeCount && Promise.all([renderer.removeEntities(removedEntities), renderer.paintThumbnail()]);
            }).then(function () {
              return Promise.all(updatedEntities.map(function (entity) {
                return _this6.$onUpdate(entity);
              }));
            })["catch"](logWarning);
          });
        }, 'FINE', 'performed layout of all entities in {}ms');
      }

      /**
       * Does the actual repaint work.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doRepaint",
      value: function $doRepaint() {
        var updatedEntities = values(this.$updateQueue);
        var renderer = this.$renderer;
        this.$updateQueue = {};
        var updateCount = updatedEntities.length;
        if (!this.$active || !updateCount) {
          return Promise.resolve();
        }
        return log.timing(function () {
          return Promise.all([updateCount && renderer.paintEntities(updatedEntities), renderer.paintThumbnail()]);
        }, 'FINE', 'repainted updates for {} entities in {}ms', updateCount);
      }
    }]);
  }();
});
