function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/lonworks/rc/wb/mgr/UxLonDeviceManager
 */

define(['baja!', 'baja!lonworks:LonNetmgmt,' + 'lonworks:LonDeviceFolder,' + 'lonworks:LonDevice,' + 'lonworks:NeuronId,' + 'lonworks:CommissionParameter,' + 'lonworks:LonNetwork,' + 'lonworks:DeviceEntry,' + 'lonworks:LearnParameter,' + 'lonworks:LonDiscoverJob,' + 'lonworks:LocalLonDevice', 'lex!lonworks', 'log!nmodule.lonworks.rc.wb.mgr.UxLonDeviceManager', 'dialogs', 'jquery', 'Promise', 'underscore', 'bajaux/spandrel', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/commands/ToggleCommand', 'nmodule/driver/rc/wb/mgr/DeviceMgr', 'nmodule/lonworks/rc/baja/ProgramId', 'nmodule/lonworks/rc/util/AppDownloadWidget', 'nmodule/lonworks/rc/util/lonUtils', 'nmodule/lonworks/rc/util/ServicePinMonitor', 'nmodule/webEditors/rc/wb/menu/Separator', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/commands/AddCommand', 'nmodule/webEditors/rc/wb/mgr/commands/MatchCommand', 'nmodule/webEditors/rc/wb/mgr/commands/QuickMatchCommand', 'nmodule/webEditors/rc/wb/table/menu/DefaultTableContextMenu', 'nmodule/lonworks/rc/wb/mgr/model/LonDeviceLearnModel', 'nmodule/lonworks/rc/wb/mgr/model/LonDeviceManagerModel', 'nmodule/webEditors/rc/fe/baja/compat/RelevantStringEditor', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/mgr/MgrLearn', 'nmodule/webEditors/rc/wb/mgr/commands/LearnModeCommand', 'nmodule/webEditors/rc/wb/mgr/commands/MgrCommand', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/webEditors/rc/wb/tree/TreeNode'], function (baja, types, lexs, log, dialogs, $, Promise, _, spandrel, Widget, Command, ToggleCommand, DeviceMgr, ProgramId, AppDownloadWidget, lonUtils, ServicePinMonitor, Separator, MgrTypeInfo, AddCommand, MatchCommand, QuickMatchCommand, DefaultTableContextMenu, LonDeviceLearnModel, LonDeviceManagerModel, RelevantStringEditor, compUtils, feDialogs, addMgrLearnSupport, LearnModeCommand, MgrCommand, mgrUtils, TreeNode) {
  'use strict';

  var _types = _slicedToArray(types, 7),
    LON_NET_MGMT_TYPE = _types[0],
    LON_DEVICE_FOLDER_TYPE = _types[1],
    LON_DEVICE_TYPE = _types[2],
    NEURON_ID_TYPE = _types[3],
    COMMISSION_PARAMETER_TYPE = _types[4],
    LON_NETWORK_TYPE = _types[5],
    DEVICE_ENTRY_TYPE = _types[6];
  var _lexs = _slicedToArray(lexs, 1),
    LON_WORK_LEX = _lexs[0];
  var getMainTableSelectedSubjects = mgrUtils.getMainTableSelectedSubjects,
    getLearnTableSelectedSubjects = mgrUtils.getLearnTableSelectedSubjects;
  var runJob = lonUtils.runJob,
    showCommissionOrReplaceDialog = lonUtils.showCommissionOrReplaceDialog,
    subNetNodeIdsToString = lonUtils.subNetNodeIdsToString;
  var _MgrCommand$flags = MgrCommand.flags,
    ALL_BARS = _MgrCommand$flags.ALL_BARS,
    LEARN_CONTEXT_MENU = _MgrCommand$flags.LEARN_CONTEXT_MENU;
  var constant = _.constant;
  var logSevere = log.severe.bind(log);
  var BLANK_ICON = LON_WORK_LEX.get('UxLonDeviceManager.addressToggleCommandBlank.icon');
  var CHECK_ICON = LON_WORK_LEX.get('UxLonDeviceManager.addressToggleCommandChecked.icon');
  var isLocalDevice = function isLocalDevice(device) {
    return device && device.getType().is('lonworks:LocalLonDevice');
  };

  /**
   * @param {boolean} isSelected
   * @returns {string} icon path as a string.
   */
  var getIcon = function getIcon(isSelected) {
    return isSelected ? CHECK_ICON : BLANK_ICON;
  };

  /**
   * Replace command for the Lonworks Network Devices
   * @since Niagara 4.14
   * @inner
   * @class
   * @extends module:bajaux/commands/Command
   */
  var AppDownloadCommand = /*#__PURE__*/function (_Command) {
    function AppDownloadCommand(mgr) {
      _classCallCheck(this, AppDownloadCommand);
      return _callSuper(this, AppDownloadCommand, [{
        module: 'lonworks',
        lex: "commands.appDownLoad",
        enabled: false,
        func: function func() {
          return mgr.$doAppDownload();
        }
      }]);
    }
    _inherits(AppDownloadCommand, _Command);
    return _createClass(AppDownloadCommand);
  }(Command);
  /**
   * Replace command for the Lonworks Network Devices
   * @since Niagara 4.14
   * @inner
   * @class
   * @extends module:bajaux/commands/Command
   */
  var ReplaceCommand = /*#__PURE__*/function (_Command2) {
    function ReplaceCommand(mgr) {
      _classCallCheck(this, ReplaceCommand);
      return _callSuper(this, ReplaceCommand, [{
        module: 'lonworks',
        lex: "commands.replace",
        enabled: false,
        func: function func() {
          return mgr.$doReplace();
        }
      }]);
    }
    _inherits(ReplaceCommand, _Command2);
    return _createClass(ReplaceCommand);
  }(Command);
  /**
   * Commission command for the Lonworks Network Devices
   * @since Niagara 4.14
   * @inner
   * @class
   * @extends module:bajaux/commands/Command
   */
  var CommissionCommand = /*#__PURE__*/function (_Command3) {
    function CommissionCommand(mgr) {
      _classCallCheck(this, CommissionCommand);
      return _callSuper(this, CommissionCommand, [{
        module: 'lonworks',
        lex: "commands.commission",
        enabled: false,
        func: function func() {
          return mgr.$doCommission();
        }
      }]);
    }
    _inherits(CommissionCommand, _Command3);
    return _createClass(CommissionCommand);
  }(Command);
  /**
   * @since Niagara 4.14
   * @inner
   * @class
   * @extends module:bajaux/commands/Command
   */
  var ClearTableCommand = /*#__PURE__*/function (_Command4) {
    function ClearTableCommand(mgr) {
      _classCallCheck(this, ClearTableCommand);
      return _callSuper(this, ClearTableCommand, [{
        module: 'lonworks',
        lex: 'commands.clearDiscoverTable',
        flags: LEARN_CONTEXT_MENU,
        func: function func() {
          var deviceDiscoverTable = mgr.getNetmgmt().getDeviceDiscoverTable();
          var deviceEntries = deviceDiscoverTable.getSlots().is(DEVICE_ENTRY_TYPE).toValueArray();
          return Promise.all(deviceEntries.map(function (deviceEntry) {
            return deviceDiscoverTable.remove(deviceEntry);
          })).then(function () {
            return mgr.$updateLearnTableModel(mgr.getLearnModel());
          });
        }
      }]);
    }
    _inherits(ClearTableCommand, _Command4);
    return _createClass(ClearTableCommand);
  }(Command);
  /**
   * @since Niagara 4.14
   * @inner
   * @class
   * @extends module:bajaux/commands/ToggleCommand
   */
  var UseNetAddressToggleCommand = /*#__PURE__*/function (_ToggleCommand) {
    function UseNetAddressToggleCommand(mgr) {
      var _this;
      _classCallCheck(this, UseNetAddressToggleCommand);
      return _this = _callSuper(this, UseNetAddressToggleCommand, [{
        module: 'lonworks',
        lex: 'commands.useNetAddress',
        selected: true,
        icon: getIcon(true),
        func: function func() {
          _this.toggle();
          var isSelected = _this.isSelected();
          _this.setIcon(getIcon(isSelected));
          var dbAddressCommand = mgr.$getUseDbAddressToggleCommand();
          dbAddressCommand.setSelected(!isSelected);
          dbAddressCommand.setIcon(getIcon(!isSelected));
        }
      }]);
    }
    _inherits(UseNetAddressToggleCommand, _ToggleCommand);
    return _createClass(UseNetAddressToggleCommand, [{
      key: "safeToHideIcon",
      value: function safeToHideIcon() {
        return false;
      }
    }]);
  }(ToggleCommand);
  /**
   * @since Niagara 4.14
   * @inner
   * @class
   * @extends module:bajaux/commands/ToggleCommand
   */
  var UseDbAddressToggleCommand = /*#__PURE__*/function (_ToggleCommand2) {
    function UseDbAddressToggleCommand(mgr) {
      var _this2;
      _classCallCheck(this, UseDbAddressToggleCommand);
      return _this2 = _callSuper(this, UseDbAddressToggleCommand, [{
        module: 'lonworks',
        lex: 'commands.useDbAddress',
        selected: false,
        icon: getIcon(false),
        func: function func() {
          _this2.toggle();
          var isSelected = _this2.isSelected();
          _this2.setIcon(getIcon(isSelected));
          var netAddressCommand = mgr.$getNetAddressToggleCommand();
          netAddressCommand.setSelected(!isSelected);
          netAddressCommand.setIcon(getIcon(!isSelected));
        }
      }]);
    }
    _inherits(UseDbAddressToggleCommand, _ToggleCommand2);
    return _createClass(UseDbAddressToggleCommand, [{
      key: "safeToHideIcon",
      value: function safeToHideIcon() {
        return false;
      }
    }]);
  }(ToggleCommand);
  /**
   * @since Niagara 4.14
   * @inner
   * @class
   * @extends module:bajaux/commands/Command
   */
  var QuikLearnCommand = /*#__PURE__*/function (_Command5) {
    function QuikLearnCommand(mgr) {
      _classCallCheck(this, QuikLearnCommand);
      return _callSuper(this, QuikLearnCommand, [{
        module: 'lonworks',
        lex: 'commands.quikLearn',
        flags: ALL_BARS,
        func: function func() {
          return mgr.$showQuikLearnDialog();
        }
      }]);
    }
    _inherits(QuikLearnCommand, _Command5);
    return _createClass(QuikLearnCommand);
  }(Command);
  /**
   * @since Niagara 4.14
   * @inner
   * @class
   * @extends module:bajaux/spandrel
   */
  var QuikLearnDialog = /*#__PURE__*/function (_spandrel) {
    function QuikLearnDialog(params) {
      _classCallCheck(this, QuikLearnDialog);
      return _callSuper(this, QuikLearnDialog, [{
        params: params,
        defaults: {
          properties: {
            rootCssClass: "-t-QuikLearnDialog"
          }
        }
      }]);
    }
    _inherits(QuikLearnDialog, _spandrel);
    return _createClass(QuikLearnDialog, [{
      key: "toState",
      value: function toState(value) {
        return value;
      }
    }, {
      key: "fromState",
      value: function fromState(state) {
        return state;
      }
    }]);
  }(spandrel(function (value, _ref) {
    var unmanagedNetwork = _ref.unmanagedNetwork,
      learnLinks = _ref.learnLinks,
      uploadConfig = _ref.uploadConfig;
    var networkText = LON_WORK_LEX.get('learnPopup.unmanaged');
    var linksText = LON_WORK_LEX.get('learnPopup.learnLinks');
    var uploadText = LON_WORK_LEX.get('learnPopup.upload');
    return spandrel.jsx("div", {
      className: "-t-QuikLearnDialog-wrapper"
    }, spandrel.jsx("any", {
      className: "-t-QuikLearnDialog-unmanaged-checkbox",
      value: unmanagedNetwork,
      bindKey: "unmanagedNetwork",
      properties: {
        displayType: "checkbox",
        trueText: networkText,
        falseText: networkText
      },
      spandrelkey: "unmanagedNetwork"
    }), spandrel.jsx("any", {
      className: "-t-QuikLearnDialog-learnLinks-checkbox",
      value: learnLinks,
      bindKey: "learnLinks",
      properties: {
        displayType: "checkbox",
        trueText: linksText,
        falseText: linksText
      },
      spandrelkey: "learnLinks"
    }), spandrel.jsx("any", {
      className: "-t-QuikLearnDialog-uploadConfig-checkbox",
      value: uploadConfig,
      bindKey: "uploadConfig",
      properties: {
        displayType: "checkbox",
        trueText: uploadText,
        falseText: uploadText
      },
      spandrelkey: "uploadConfig"
    }));
  }, {
    strategy: 'niagara'
  }));
  /**
   * @since Niagara 4.14
   * @inner
   * @class
   * @extends module:nmodule/webEditors/rc/wb/table/menu/DefaultTableContextMenu
   */
  var LonDeviceManagerLearnContextMenu = /*#__PURE__*/function (_DefaultTableContextM) {
    function LonDeviceManagerLearnContextMenu(table, mgr) {
      var _this3;
      _classCallCheck(this, LonDeviceManagerLearnContextMenu);
      _this3 = _callSuper(this, LonDeviceManagerLearnContextMenu, arguments);
      _this3.$mgr = mgr;
      return _this3;
    }
    _inherits(LonDeviceManagerLearnContextMenu, _DefaultTableContextM);
    return _createClass(LonDeviceManagerLearnContextMenu, [{
      key: "toContextMenu",
      value: function toContextMenu() {
        var _this4 = this;
        return _superPropGet(LonDeviceManagerLearnContextMenu, "toContextMenu", this, 3)([]).then(function (grp) {
          grp.add(new Separator());
          grp.add(_this4.$mgr.$getNetAddressToggleCommand());
          grp.add(_this4.$mgr.$getUseDbAddressToggleCommand());
          return grp;
        });
      }
    }]);
  }(DefaultTableContextMenu);
  /**
   * Ux Device manager for Lonworks
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/lonworks/rc/wb/mgr/UxLonDeviceManager
   * @extends module:nmodule/driver/rc/wb/mgr/DeviceMgr
   */
  var UxLonDeviceManager = /*#__PURE__*/function (_DeviceMgr) {
    function UxLonDeviceManager(params) {
      var _this5;
      _classCallCheck(this, UxLonDeviceManager);
      _this5 = _callSuper(this, UxLonDeviceManager, [{
        moduleName: 'lonworks',
        keyName: 'UxLonDeviceManager',
        editableTypes: [LON_DEVICE_TYPE],
        subscriptionDepth: 2,
        folderType: LON_DEVICE_FOLDER_TYPE,
        subscribeCallback: function subscribeCallback(_ref2) {
          var comp = _ref2.comp,
            sub = _ref2.sub;
          if (baja.hasType(comp, LON_NET_MGMT_TYPE)) {
            return sub.subscribe(comp.getDeviceDiscoverTable());
          } else if (baja.hasType(comp, LON_DEVICE_TYPE)) {
            return sub.subscribe(comp.getDeviceData());
          }
        }
      }, params]);
      addMgrLearnSupport(_this5);
      _this5.$servicePinMonitor = new ServicePinMonitor(_this5);
      return _this5;
    }

    /**
     * @param {JQuery} dom the dom for the device manager
     * @returns {*|Promise} An optional promise to be resolved once the Widget has initialized
     */
    _inherits(UxLonDeviceManager, _DeviceMgr);
    return _createClass(UxLonDeviceManager, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this6 = this;
        this.$replaceCommand = new ReplaceCommand(this);
        this.$commissionCommand = new CommissionCommand(this);
        this.$clearTableCommand = new ClearTableCommand(this);
        this.$useDbAddressToggleCommand = new UseDbAddressToggleCommand(this);
        this.$useNetAddressToggleCommand = new UseNetAddressToggleCommand(this);
        this.$quikLearnCommand = new QuikLearnCommand(this);
        this.$appDownloadCommand = new AppDownloadCommand(this);
        this.on('jobcomplete', function (job) {
          return _this6.$finishJob(job);
        });
        return _superPropGet(UxLonDeviceManager, "doInitialize", this, 3)(arguments);
      }

      /**
       * @private
       * @param {baja.Component} job
       * @returns {Promise}
       */
    }, {
      key: "$finishJob",
      value: function $finishJob(job) {
        if (baja.hasType(job, 'lonworks:LonDiscoverJob')) {
          return this.$updateLearnTableModel(this.getLearnModel())["catch"](logSevere);
        }
        return Promise.resolve();
      }

      /**
       * Adds the ReplaceCommand to the standard commands
       * @returns {Promise<Array<module:bajaux/commands/Command>>}
       */
    }, {
      key: "makeCommands",
      value: function makeCommands() {
        var _this7 = this;
        return _superPropGet(UxLonDeviceManager, "makeCommands", this, 3)([this, arguments]).then(function (commands) {
          //TODO:Add and Match commands should grey them out in learn table when rows added to main table,
          //TODO:But lonnetwork seems to do it by deleting them from learn table.
          var addCommands = _this7.$findAddCommands(commands);
          addCommands.forEach(function (addCommand) {
            if (addCommand) {
              var addFunction = addCommand.getFunction();
              addCommand.setFunction(function () {
                return addFunction().then(function (val) {
                  return val && _this7.$updateLearnTableModel(_this7.getLearnModel());
                });
              });
            }
          });
          var matchCommands = _this7.$findMatchCommands(commands);
          matchCommands.forEach(function (matchCommand) {
            if (matchCommand) {
              var matchFunction = matchCommand.getFunction();
              if (matchCommand instanceof QuickMatchCommand) {
                matchCommand.setFunction(function () {
                  return matchFunction().then(function () {
                    return _this7.$refreshLearnTable();
                  });
                });
              } else {
                matchCommand.setFunction(function () {
                  return matchFunction().then(function (val) {
                    return val && _this7.$refreshLearnTable();
                  });
                });
              }
            }
          });
          commands.push(_this7.$commissionCommand);
          commands.push(_this7.$replaceCommand);
          commands.push(_this7.$clearTableCommand);
          commands.push(_this7.$quikLearnCommand);
          commands.push(_this7.$appDownloadCommand);
          return commands;
        });
      }

      /**
       * @private
       * @param {Array.<module:bajaux/commands/Command>} commmands
       * @returns {Array.<module:nmodule/webEditors/rc/wb/mgr/commands/AddCommand>}
       */
    }, {
      key: "$findAddCommands",
      value: function $findAddCommands(commmands) {
        return commmands.filter(function (cmd) {
          return cmd instanceof AddCommand;
        });
      }

      /**
       * @private
       * @param {Array.<module:bajaux/commands/Command>} commands
       * @returns {Array.<module:nmodule/webEditors/rc/wb/mgr/commands/MatchCommand>}
       */
    }, {
      key: "$findMatchCommands",
      value: function $findMatchCommands(commands) {
        return commands.filter(function (cmd) {
          return cmd instanceof MatchCommand;
        });
      }

      /**
       * Makes the model for the manager
       * @param {baja.Component} component - the value being loaded into the `Widget`.
       * @returns {Promise.<module:nmodule/lonworks/rc/wb/mgr/model/LonDeviceManagerModel>} the model for the main table.
       */
    }, {
      key: "makeModel",
      value: function makeModel(component) {
        return LonDeviceManagerModel.make(component);
      }

      /**
       * Makes the learn model for the manager
       * @returns  {Promise.<module:nmodule/webEditors/rc/wb/table/tree/TreeTableModel>}
       */
    }, {
      key: "makeLearnModel",
      value: function makeLearnModel() {
        return LonDeviceLearnModel.make();
      }
    }, {
      key: "doLoad",
      value: function doLoad() {
        var _this8 = this;
        return _superPropGet(UxLonDeviceManager, "doLoad", this, 3)(arguments).then(function () {
          return Promise.all([_this8.$showLearnTable(), _this8.$updateLearnTableModel(_this8.getLearnModel())]);
        });
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$refreshLearnTable",
      value: function $refreshLearnTable() {
        var _this9 = this;
        var _getLearnTableSelecte = getLearnTableSelectedSubjects(this),
          _getLearnTableSelecte2 = _slicedToArray(_getLearnTableSelecte, 1),
          learnTableSelectedSubject = _getLearnTableSelecte2[0];
        var deviceDiscoverTable = this.getNetmgmt().getDeviceDiscoverTable();
        return deviceDiscoverTable.remove(learnTableSelectedSubject.getName()).then(function () {
          return _this9.$updateLearnTableModel(_this9.getLearnModel());
        });
      }

      /**
       * Shows the learn table and job bar by invoking the learnMode command.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$showLearnTable",
      value: function $showLearnTable() {
        var learnModeCmd = this.$getLearnModeCommand();
        if (learnModeCmd && !learnModeCmd.isSelected()) {
          return learnModeCmd.invoke();
        }
        return Promise.resolve();
      }

      /**
       * @private
       * @returns {Promise<baja.Component>}
       */
    }, {
      key: "$showQuikLearnDialog",
      value: function $showQuikLearnDialog() {
        var _this10 = this;
        var dialogPromise;
        var selectedMainTableRows = mgrUtils.getMainTableSelectedSubjects(this);
        var isRowsInMainTableSelected = selectedMainTableRows.length > 0;
        if (isRowsInMainTableSelected) {
          dialogPromise = feDialogs.showFor({
            title: LON_WORK_LEX.get('UxLonDeviceManager.quickLearn.title'),
            value: LON_WORK_LEX.get('learnPopup.learnLinksSelected'),
            dom: $('<div class="-t-QuikLearnDialog"/>'),
            formFactor: 'compact'
          });
        } else {
          dialogPromise = feDialogs.showFor({
            value: {
              unmanagedNetwork: false,
              learnLinks: false,
              uploadConfig: true
            },
            type: QuikLearnDialog,
            title: LON_WORK_LEX.get('UxLonDeviceManager.quickLearn.title'),
            formFactor: 'compact'
          });
        }
        return dialogPromise.then(function (value) {
          if (!value) {
            return;
          }
          var learnParameter = _this10.$getLearnParameter(value);
          if (isRowsInMainTableSelected) {
            learnParameter.setSubnetNodeArray(selectedMainTableRows.map(function (selectedRow) {
              return selectedRow.getDeviceData().get('subnetNodeId');
            }).join('\t'));
          }
          return _this10.getNetmgmt().learn(learnParameter).then(function (ord) {
            return _this10.setJob(baja.Ord.make({
              base: baja.Ord.make('station:'),
              child: ord.relativizeToSession()
            }));
          });
        });
      }

      /**
       * @private
       * @param {boolean} unmanagedNetwork
       * @param {boolean} learnLinks
       * @param {boolean} uploadConfig
       * @returns {baja.Component}
       */
    }, {
      key: "$getLearnParameter",
      value: function $getLearnParameter(_ref3) {
        var _ref3$unmanagedNetwor = _ref3.unmanagedNetwork,
          unmanagedNetwork = _ref3$unmanagedNetwor === void 0 ? false : _ref3$unmanagedNetwor,
          _ref3$learnLinks = _ref3.learnLinks,
          learnLinks = _ref3$learnLinks === void 0 ? false : _ref3$learnLinks,
          _ref3$uploadConfig = _ref3.uploadConfig,
          uploadConfig = _ref3$uploadConfig === void 0 ? true : _ref3$uploadConfig;
        return baja.$('lonworks:LearnParameter', {
          unmanagedNetwork: unmanagedNetwork,
          learnLinks: learnLinks,
          uploadConfig: uploadConfig,
          container: this.value().getOrdInSession()
        });
      }

      /**
       *
       * @returns {Promise}
       */
    }, {
      key: "doDiscover",
      value: function doDiscover() {
        var _this11 = this;
        return this.getNetmgmt().discover().then(function (ord) {
          return _this11.$updateLearnTableModel(_this11.getLearnModel()).then(function () {
            return _this11.setJob(baja.Ord.make({
              base: baja.Ord.make('station:'),
              child: ord.relativizeToSession()
            }));
          });
        });
      }

      /**
       * @private
       * @param {module:nmodule/lonworks/rc/wb/mgr/model/LonDeviceLearnModel} learnModel
       * @returns {Promise}
       */
    }, {
      key: "$updateLearnTableModel",
      value: function $updateLearnTableModel(learnModel) {
        var _this12 = this;
        return learnModel.clearRows().then(function () {
          var deviceEntries = _this12.getNetmgmt().getDeviceDiscoverTable().getSlots().is(DEVICE_ENTRY_TYPE).toValueArray();
          return learnModel.insertRows(deviceEntries.map(function (deviceEntry) {
            var name = deviceEntry.getName();
            var node = new TreeNode(name, name);
            node.getIcon = constant(baja.Icon.make('module://icons/x16/device.png'));
            node.mayHaveKids = constant(false);
            node.value = constant(deviceEntry);
            return node;
          }));
        });
      }

      /**
       * @param {baja.Struct} discoveredDeviceEntry
       * @param {baja.Component} lonDevice
       * @returns {{values: {subnetId: baja.Value, workingDomain: baja.Value, nodeState: baja.Value, mfgId: baja.Value, neuronId: baja.Value, nodeId: baja.Value, channelId: baja.Value, programId: baja.Value}, name: String}}
       */
    }, {
      key: "getProposedValuesFromDiscovery",
      value: function getProposedValuesFromDiscovery(discoveredDeviceEntry, lonDevice) {
        var deviceData = lonDevice.getDeviceData();
        var deviceSubnetId = baja.Integer.make(deviceData.getSubnetNodeId().getSubnetId());
        var deviceNodeId = baja.Integer.make(deviceData.getSubnetNodeId().getNodeId());
        var deviceChannelId = baja.Integer.make(deviceData.getChannelId());
        var isNetAddressCommandSelected = this.$getNetAddressToggleCommand().isSelected();
        var subnetId = isNetAddressCommandSelected ? discoveredDeviceEntry.get('subnet') : deviceSubnetId;
        var nodeId = isNetAddressCommandSelected ? discoveredDeviceEntry.get('node') : deviceNodeId;
        var channelId = isNetAddressCommandSelected ? discoveredDeviceEntry.get('channelId') : deviceChannelId;
        var nodeState = isNetAddressCommandSelected ? discoveredDeviceEntry.get('state') : deviceData.getNodeState();
        return {
          name: lonDevice.getName(),
          values: {
            nodeState: nodeState,
            channelId: channelId,
            subnetId: subnetId,
            nodeId: nodeId,
            workingDomain: discoveredDeviceEntry.get('workingDomain'),
            mfgId: discoveredDeviceEntry.get('mfgId'),
            programId: discoveredDeviceEntry.get('programId'),
            neuronId: discoveredDeviceEntry.get('neuronId')
          }
        };
      }

      /**
       *
       * @param {baja.Complex} discovery
       * @returns {Promise<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>}
       */
    }, {
      key: "getTypesForDiscoverySubject",
      value: function getTypesForDiscoverySubject(discovery) {
        return MgrTypeInfo.make('lonworks:DynamicDevice');
      }

      /**
       * Returns the current 'lonworks:LonNetwork'
       * @returns {baja.Complex}
       */
    }, {
      key: "getNetwork",
      value: function getNetwork() {
        return compUtils.closest(this.value(), LON_NETWORK_TYPE);
      }

      /**
       * Returns the current 'lonworks:LonNetmgmt'
       * @returns {baja.Component}
       */
    }, {
      key: "getNetmgmt",
      value: function getNetmgmt() {
        return this.getNetwork().getLonNetmgmt();
      }

      /**
       * Will perform extra checks to set the enabling of the add, match and winking commands
       * @inheritDoc
       */
    }, {
      key: "onTableSelectionChanged",
      value: function onTableSelectionChanged(selectedSubjects) {
        var _this13 = this;
        return _superPropGet(UxLonDeviceManager, "onTableSelectionChanged", this, 3)(arguments).then(function () {
          var mainTableSelection = selectedSubjects.mainTableSelection,
            learnTableSelection = selectedSubjects.learnTableSelection;
          //filter out selected items that are not of the type 'lonworks:LonDevice'
          mainTableSelection = mainTableSelection.filter(function (device) {
            return device.getType().is(LON_DEVICE_TYPE);
          });
          var mainRowSelected = mainTableSelection.length >= 1;
          var isOneMainRowSelected = mainTableSelection.length === 1;
          var isOneLearnRowSelected = learnTableSelection.length === 1;
          var local = false;
          var disable = !(_this13.getNetmgmt().getEnabled() && _this13.getNetwork().getEnabled());
          var enableDownload = true;
          var mfgId;
          if (mainTableSelection[0]) {
            mfgId = mainTableSelection[0].getDeviceData().getProgramId().getMfgLookupId();
          }
          mainTableSelection.forEach(function (device) {
            var status = device.getStatus();
            var deviceData = device.getDeviceData();
            var neuronIdArr = deviceData.getNeuronId().encodeToString().split(" ");
            var neuronIdIsZero = !neuronIdArr.find(function (_byte) {
              return parseInt(_byte, 16) !== 0;
            });
            var currMfgId = deviceData.getProgramId().getMfgLookupId();
            disable = status.isFault() || status.isDisabled() || disable;
            local = isLocalDevice(device);
            if (enableDownload && (neuronIdIsZero || local || deviceData.get('hosted') || mfgId !== currMfgId)) {
              enableDownload = false;
            }
          });
          _this13.$getAppDownloadCommand().setEnabled(!disable && mainRowSelected && enableDownload);
          _this13.$getReplaceCommand().setEnabled(!disable && !local && isOneMainRowSelected);
          _this13.$getCommissionCommand().setEnabled(!disable && isOneMainRowSelected);
          _this13.$getQuikLearnCommand().setEnabled(!disable && !local);
          //isMatchable call happens before onTableSelectionChanged, append to the isEnabled status from isMatchable.
          _this13.$getMatchCommands().forEach(function (matchCommand) {
            return matchCommand.setEnabled(matchCommand.isEnabled() && isOneMainRowSelected && isOneLearnRowSelected);
          });
        });
      }

      /**
       * @inheritDoc
       */
    }, {
      key: "isMatchable",
      value: function isMatchable(learnSelection, mainSelection) {
        if (!mainSelection.getType().is(LON_DEVICE_TYPE) || isLocalDevice(mainSelection)) {
          return Promise.resolve(false);
        }
        var mainSelProgramId = mainSelection.getDeviceData().getProgramId();
        var learnSelProgramId = learnSelection.getProgramId();
        if (mainSelProgramId.isZero() || learnSelProgramId.isZero() || mainSelProgramId.equals(learnSelProgramId)) {
          return Promise.resolve(true);
        }
        return baja.rpc({
          typeSpec: "lonworks:LonworksRpc",
          method: "isProgramIdWildCardMatch",
          args: [mainSelProgramId.encodeToString(), learnSelProgramId.encodeToString()]
        });
      }

      /**
       * @param {module:nmodule/webEditors/rc/wb/table/Table} table
       * @param {JQuery} jq
       * @param {string} selector
       */
    }, {
      key: "armLearnTableContextMenu",
      value: function armLearnTableContextMenu(table, jq, selector) {
        new LonDeviceManagerLearnContextMenu(table, this).arm(jq, selector);
      }

      /**
       * Returns the ReplaceCommand
       * @private
       * @returns {ReplaceCommand}
       */
    }, {
      key: "$getReplaceCommand",
      value: function $getReplaceCommand() {
        return this.$replaceCommand;
      }

      /**
       * Returns the CommissionCommand
       * @private
       * @returns {CommissionCommand}
       */
    }, {
      key: "$getCommissionCommand",
      value: function $getCommissionCommand() {
        return this.$commissionCommand;
      }

      /**
       * @private
       * @returns {ClearTableCommand}
       */
    }, {
      key: "$getClearTableCommand",
      value: function $getClearTableCommand() {
        return this.$clearTableCommand;
      }

      /**
       * @private
       * @returns {UseDbAddressToggleCommand}
       */
    }, {
      key: "$getUseDbAddressToggleCommand",
      value: function $getUseDbAddressToggleCommand() {
        return this.$useDbAddressToggleCommand;
      }

      /**
       * @private
       * @returns {UseNetAddressToggleCommand}
       */
    }, {
      key: "$getNetAddressToggleCommand",
      value: function $getNetAddressToggleCommand() {
        return this.$useNetAddressToggleCommand;
      }

      /**
       * @private
       * @returns {QuikLearnCommand}
       */
    }, {
      key: "$getQuikLearnCommand",
      value: function $getQuikLearnCommand() {
        return this.$quikLearnCommand;
      }

      /**
       * @private
       * @returns {AppDownloadCommand}
       */
    }, {
      key: "$getAppDownloadCommand",
      value: function $getAppDownloadCommand() {
        return this.$appDownloadCommand;
      }

      /**
       * Start the replace process when the command is invoked
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doReplace",
      value: function $doReplace() {
        return this.$doCommissionOrReplace(LON_WORK_LEX.get('commands.commReplace.dialog.replace.title'), 'replaceDevice');
      }

      /*
       * Start the commissiion process when the command is invoked
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doCommission",
      value: function $doCommission() {
        return this.$doCommissionOrReplace(LON_WORK_LEX.get('commands.commReplace.dialog.commission.title'), 'commissionDevice');
      }

      /**
       * Executes the commsion or replace command
       * @private
       * @param {String} title the title to use for the dialog box
       * @param {String} executeCmd the command to be executed
       * @returns {Promise}
       */
    }, {
      key: "$doCommissionOrReplace",
      value: function $doCommissionOrReplace(title, executeCmd) {
        var _this14 = this;
        var selectedDevices = getMainTableSelectedSubjects(this);
        //filter out selected items that are not of the type 'lonworks:LonDevice'
        selectedDevices = selectedDevices.filter(function (device) {
          return device.getType().is(LON_DEVICE_TYPE);
        });
        if (selectedDevices.length > 0) {
          if (selectedDevices.length === 1) {
            var _selectedDevices = selectedDevices,
              _selectedDevices2 = _slicedToArray(_selectedDevices, 1),
              device = _selectedDevices2[0];
            var deviceData = device.getDeviceData();
            var devices = this.getNetmgmt().getDeviceDiscoverTable().getSlots().is(DEVICE_ENTRY_TYPE).toValueArray();
            var neuronIds = this.$buildNeuronList(devices, deviceData);
            var okHandler = function okHandler(editor, servicePin) {
              return editor.read().then(function (neuronId) {
                var subnetNode = deviceData.getSubnetNodeId();
                if (servicePin) {
                  var jobParameters = baja.$(COMMISSION_PARAMETER_TYPE, {
                    subnetNode: subnetNode,
                    servicePin: servicePin
                  });
                  return runJob(_this14, executeCmd, jobParameters).then(function () {
                    _this14.$servicePinMonitor.attachToServicePinJob();
                  });
                }
                if (neuronId) {
                  var _jobParameters = baja.$(COMMISSION_PARAMETER_TYPE, {
                    subnetNode: subnetNode,
                    neuronId: neuronId,
                    servicePin: servicePin
                  });
                  var promises = [];
                  //TODO the calling of the learnModeCmd.invoke is a temporary hack until a more permanent fix can be made
                  var learnModeCmd = _this14.$getLearnModeCommand();
                  if (learnModeCmd && !learnModeCmd.isSelected()) {
                    promises.push(learnModeCmd.invoke());
                  }
                  promises.push(runJob(_this14, executeCmd, _jobParameters));
                  return Promise.all(promises)["catch"](feDialogs.error);
                }
              });
            };
            var handlers = {
              okHandler: okHandler
            };
            return showCommissionOrReplaceDialog(title, neuronIds, handlers);
          } else {
            var subnetNodeArray = subNetNodeIdsToString(selectedDevices.map(function (selectedDevice) {
              return selectedDevice.getDeviceData().getSubnetNodeId();
            }));
            return runJob(this, executeCmd, baja.$(COMMISSION_PARAMETER_TYPE, {
              subnetNodeArray: subnetNodeArray
            }));
          }
        } else {
          return Promise.resolve();
        }
      }

      /**
       * Opens the AppDownloadWidget in a dialog and gets the information from the user
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doAppDownload",
      value: function $doAppDownload() {
        var _this15 = this;
        var value = {
          appFileOrd: baja.Ord.DEFAULT,
          xifFileOrd: baja.Ord.DEFAULT,
          lnmlFileOrd: baja.Ord.DEFAULT,
          useZero: false,
          bindLinks: true
        };
        return feDialogs.showFor({
          value: value,
          title: LON_WORK_LEX.get('appDownLoad.title'),
          type: AppDownloadWidget,
          buttons: [{
            name: "ok",
            handler: function handler(dlg, evt, ed) {
              return ed.read().then(function (value) {
                return _this15.$showConfirmDialog(value);
              });
            }
          }, {
            name: "cancel"
          }]
        });
      }

      /**
       * Shows a confirmation dialog after getting values
       * @private
       * @param {Object} values the values from the editor
       * @returns {Promise}
       */
    }, {
      key: "$showConfirmDialog",
      value: function $showConfirmDialog(values) {
        var _this16 = this;
        var appFileOrd = values.appFileOrd,
          lnmlFileOrd = values.lnmlFileOrd,
          xifFileOrd = values.xifFileOrd;
        var appFileName = appFileOrd.encodeToString().split("/").pop();
        var lnmlFileName = lnmlFileOrd.encodeToString().split("/").pop();
        var xifFileName = xifFileOrd.encodeToString().split("/").pop();
        var text = "";
        var title = LON_WORK_LEX.get('appDownLoad.confirmDialog.title');
        if (!appFileOrd.isNull()) {
          text = text + LON_WORK_LEX.get('appDownLoad.confirmDialog.appFileMsg', appFileName) + "\n";
        }
        if (!xifFileOrd.isNull()) {
          text = text + LON_WORK_LEX.get('appDownLoad.confirmDialog.xifFileMsg', xifFileName) + "\n";
        }
        if (!lnmlFileOrd.isNull()) {
          text = text + LON_WORK_LEX.get('appDownLoad.confirmDialog.lnmlFileMsg', lnmlFileName) + "\n";
        }
        text = text + LON_WORK_LEX.get('appDownLoad.confirmDialog.msg');
        return dialogs.showOkCancel({
          title: title,
          text: text
        }).ok(function () {
          return _this16.$doDeviceUpdate(values);
        }).promise();
      }

      /**
       * Updates the selected devices, using the provided value
       * @private
       * @param {Object} values the values that were entered
       * @returns {Promise}
       */
    }, {
      key: "$doDeviceUpdate",
      value: function $doDeviceUpdate(values) {
        var _this17 = this;
        var appFileOrd = values.appFileOrd,
          bindLinks = values.bindLinks,
          lnmlFileOrd = values.lnmlFileOrd,
          useZero = values.useZero,
          xifFileOrd = values.xifFileOrd;
        var selectedDeviceOrds = [];
        var selectedDevices = getMainTableSelectedSubjects(this);

        //filter out selected items that are not of the type 'lonworks:LonDevice'
        selectedDevices = selectedDevices.filter(function (device) {
          return device.getType().is(LON_DEVICE_TYPE);
        });
        selectedDevices.forEach(function (device) {
          selectedDeviceOrds.push(device.getNavOrd().relativizeToSession().encodeToString());
        });
        return baja.rpc({
          typeSpec: "lonworks:LonworksRpc",
          method: "getParameters",
          args: [selectedDeviceOrds, appFileOrd.encodeToString(), xifFileOrd.encodeToString(), lnmlFileOrd.encodeToString(), useZero, bindLinks]
        }).then(function (parameters) {
          parameters.selectedDeviceOrds = selectedDeviceOrds;
          parameters.lnmlFileOrd = lnmlFileOrd;
          parameters.xifFileOrd = xifFileOrd;
          return _this17.$verifyProgramId(selectedDevices, parameters);
        })["catch"](function (err) {
          return feDialogs.error(err);
        });
      }

      /**
       * compares the program id in the app file and devices, and shows a confirmation dialog if
       * they do not match
       * @private
       * @param selectedDevices
       * @param parameters
       * @returns {Promise}
       */
    }, {
      key: "$verifyProgramId",
      value: function $verifyProgramId(selectedDevices, parameters) {
        var _this18 = this;
        var appPid = ProgramId.DEFAULT.decodeFromString(parameters.appPid);
        var manufactorDeviceList = [];
        var programIdDeviceList = [];
        selectedDevices.forEach(function (device) {
          var devicePid = device.getDeviceData().getProgramId();
          if (!appPid.equals(devicePid)) {
            if (appPid.getMfgLookupId() !== devicePid.getMfgLookupId()) {
              manufactorDeviceList.push(device.getDisplayName());
            } else {
              programIdDeviceList.push(device.getDisplayName());
            }
          }
        });
        if (manufactorDeviceList.length > 0 || programIdDeviceList.length > 0) {
          var title = LON_WORK_LEX.get("appDownload.error.configDeviceChange.title");
          var text = "";
          if (manufactorDeviceList.length > 0) {
            text = text + LON_WORK_LEX.get("appDownload.error.configDeviceChange.manufacturerDifferent.text") + "\n" + manufactorDeviceList.join("\n") + "\n\n";
          }
          if (programIdDeviceList.length > 0) {
            text = text + LON_WORK_LEX.get("appDownload.error.configDeviceChange.programIdDifferent.text") + "\n" + programIdDeviceList.join("\n") + "\n\n";
          }
          text = text + LON_WORK_LEX.get("appDownload.error.configDeviceChange.continue");
          return dialogs.showYesNo({
            title: title,
            text: text
          }).yes(function () {
            return _this18.$startAppDownloadJob(parameters);
          }).promise();
        }
        return this.$startAppDownloadJob(parameters);
      }

      /**
       * Starts the app download job
       * @private
       * @param {Object} parameters the parameters for the job
       * @returns {Promise}
       */
    }, {
      key: "$startAppDownloadJob",
      value: function $startAppDownloadJob(parameters) {
        var _this19 = this;
        var paramBson = parameters.param;
        var selectedDeviceOrds = parameters.selectedDeviceOrds;
        var xifFileOrd = parameters.xifFileOrd.encodeToString();
        var lnmlFileOrd = parameters.lnmlFileOrd.encodeToString();
        var netmgntOrd = this.getNetmgmt().getNavOrd().relativizeToSession().encodeToString();
        return baja.rpc({
          typeSpec: "lonworks:LonworksRpc",
          method: "startJob",
          args: [paramBson, netmgntOrd, selectedDeviceOrds, xifFileOrd, lnmlFileOrd]
        }).then(function (jobOrd) {
          if (!jobOrd.startsWith('station:|')) {
            jobOrd = "station:|" + jobOrd;
          }
          return _this19.setJob(jobOrd);
        });
      }

      /**
       * Builds the list of neuron ids that can be selected from
       * @param {Array.<baja.Struct>} deviceEntries
       * @param {baja.Component} deviceData
       * @returns {Array<baja.Component>} an array of 'lonworks:NeuronId'
       */
    }, {
      key: "$buildNeuronList",
      value: function $buildNeuronList(deviceEntries, deviceData) {
        var neuronIds = [];
        var neuronDefault = baja.$(NEURON_ID_TYPE);
        var neuronId = deviceData.getNeuronId();
        var programId = deviceData.getProgramId();
        if (neuronId.encodeToString() !== neuronDefault.encodeToString()) {
          neuronIds.push(neuronId);
        } else {
          deviceEntries.forEach(function (deviceEntry) {
            if (!deviceEntry.getDevName()) {
              if (!programId || deviceEntry.getProgramId().encodeToString() === programId.encodeToString()) {
                neuronIds.push(deviceEntry.getNeuronId());
              }
            }
          });
          if (neuronIds.length === 0) {
            neuronIds.push(neuronDefault);
          }
        }
        return neuronIds;
      }
    }]);
  }(DeviceMgr);
  return UxLonDeviceManager;
});
