function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/lonworks/rc/wb/mgr/UxLonRouterManager
 */

define(['baja!', 'baja!lonworks:LonRouter,' + 'lonworks:NeuronId,' + 'lonworks:CommissionParameter,' + 'lonworks:LonNetwork,' + 'lonworks:RouterEntry,' + 'lonworks:LonDiscoverJob,' + 'lonworks:LearnParameter', 'bajaux/commands/Command', 'bajaux/commands/ToggleCommand', 'bajaux/events', 'bajaux/mixin/subscriberMixIn', 'bajaux/spandrel', 'lex!lonworks', 'log!nmodule.lonworks.rc.wb.mgr.UxLonRouterManager', 'Promise', 'underscore', 'nmodule/lonworks/rc/util/lonUtils', 'nmodule/lonworks/rc/util/ServicePinMonitor', 'nmodule/lonworks/rc/wb/mgr/model/LonRouterLearnModel', 'nmodule/lonworks/rc/wb/mgr/model/LonRouterManagerModel', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/mgr/commands/AddCommand', 'nmodule/webEditors/rc/wb/mgr/commands/DiscoverCommand', 'nmodule/webEditors/rc/wb/mgr/commands/MatchCommand', 'nmodule/webEditors/rc/wb/mgr/commands/MgrCommand', 'nmodule/webEditors/rc/wb/mgr/commands/QuickAddCommand', 'nmodule/webEditors/rc/wb/mgr/commands/QuickMatchCommand', 'nmodule/webEditors/rc/wb/mgr/componentStatusUtils', 'nmodule/webEditors/rc/wb/mgr/MgrLearn', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/webEditors/rc/wb/mgr/Manager', 'nmodule/webEditors/rc/wb/tree/TreeNode', 'nmodule/webEditors/rc/wb/util/subscriptionUtil'], function (baja, types, Command, ToggleCommand, events, subscribable, spandrel, lexs, log, Promise, _, lonUtils, ServicePinMonitor, LonRouterLearnModel, LonRouterManagerModel, compUtils, DepthSubscriber, feDialogs, AddCommand, DiscoverCommand, MatchCommand, MgrCommand, QuickAddCommand, QuickMatchCommand, componentStatusUtils, addMgrLearnSupport, MgrTypeInfo, mgrUtils, Manager, TreeNode, subscriptionUtil) {
  'use strict';

  var _types = _slicedToArray(types, 5),
    LON_ROUTER_TYPE = _types[0],
    NEURON_ID_TYPE = _types[1],
    COMMISSION_PARAMETER_TYPE = _types[2],
    LON_NETWORK_TYPE = _types[3],
    LON_ROUTER_ENTRY_TYPE = _types[4];
  var addComponentStatusCss = componentStatusUtils.addComponentStatusCss;
  var getLearnTableSelectedSubjects = mgrUtils.getLearnTableSelectedSubjects,
    getMainTableSelectedSubjects = mgrUtils.getMainTableSelectedSubjects;
  var constant = _.constant,
    once = _.once;
  var basicSubscriptionFilter = subscriptionUtil.basicSubscriptionFilter;
  var showCommissionOrReplaceDialog = lonUtils.showCommissionOrReplaceDialog,
    runJob = lonUtils.runJob,
    subNetNodeIdsToString = lonUtils.subNetNodeIdsToString;
  var LEARN_CONTEXT_MENU = MgrCommand.flags.LEARN_CONTEXT_MENU;
  var logSevere = log.severe.bind(log);
  var _lexs = _slicedToArray(lexs, 1),
    LON_WORKS_LEX = _lexs[0];

  /**
   * @inner
   * @class
   * @extends module:bajaux/commands/Command
   */
  var CommissionCommand = /*#__PURE__*/function (_Command) {
    function CommissionCommand(mgr) {
      _classCallCheck(this, CommissionCommand);
      return _callSuper(this, CommissionCommand, [{
        module: 'lonworks',
        lex: 'commands.commission',
        enabled: false,
        func: function func() {
          return mgr.$doCommission();
        }
      }]);
    }
    _inherits(CommissionCommand, _Command);
    return _createClass(CommissionCommand);
  }(Command);
  /**
   * @inner
   * @class
   * @extends module:bajaux/commands/Command
   */
  var ReplaceCommand = /*#__PURE__*/function (_Command2) {
    function ReplaceCommand(mgr) {
      _classCallCheck(this, ReplaceCommand);
      return _callSuper(this, ReplaceCommand, [{
        module: 'lonworks',
        lex: 'commands.replace',
        enabled: false,
        func: function func() {
          return mgr.$doReplace();
        }
      }]);
    }
    _inherits(ReplaceCommand, _Command2);
    return _createClass(ReplaceCommand);
  }(Command);
  /**
   * @inner
   * @class
   * @extends module:bajaux/commands/Command
   */
  var UpdateCommand = /*#__PURE__*/function (_Command3) {
    function UpdateCommand(mgr) {
      _classCallCheck(this, UpdateCommand);
      return _callSuper(this, UpdateCommand, [{
        module: 'lonworks',
        lex: 'commands.updateRouters',
        func: function func() {
          var netmgmt = mgr.getLonNetmgmt();
          return netmgmt.invoke({
            slot: 'updateRouters'
          }).then(function (jobOrd) {
            return mgr.setJob(baja.Ord.make({
              base: baja.Ord.make('station:'),
              child: jobOrd.relativizeToSession()
            }));
          });
        }
      }]);
    }
    _inherits(UpdateCommand, _Command3);
    return _createClass(UpdateCommand);
  }(Command);
  /**
   * @since Niagara 4.14
   * @inner
   * @class
   * @extends module:bajaux/commands/Command
   */
  var ClearTableCommand = /*#__PURE__*/function (_Command4) {
    function ClearTableCommand(mgr) {
      _classCallCheck(this, ClearTableCommand);
      return _callSuper(this, ClearTableCommand, [{
        module: 'lonworks',
        lex: 'commands.clearDiscoverTable',
        flags: LEARN_CONTEXT_MENU,
        func: function func() {
          var discoverTable = mgr.getLonNetmgmt().getRouterDiscoverTable();
          var entries = discoverTable.getSlots().is(LON_ROUTER_ENTRY_TYPE).toValueArray();
          return Promise.all(entries.map(function (entry) {
            return discoverTable.remove(entry);
          })).then(function () {
            return mgr.$updateDiscoveryRows();
          });
        }
      }]);
    }
    _inherits(ClearTableCommand, _Command4);
    return _createClass(ClearTableCommand);
  }(Command);
  /**
   * @inner
   * @class
   * @extends module:bajaux/commands/ToggleCommand
   */
  var TempBridgeCommand = /*#__PURE__*/function (_ToggleCommand) {
    function TempBridgeCommand(mgr) {
      var _this;
      _classCallCheck(this, TempBridgeCommand);
      _this = _callSuper(this, TempBridgeCommand, [{
        module: 'lonworks',
        lex: 'commands.tempBridge'
      }]);
      _this.on(events.command.SELECTION_EVENT, function () {
        var netmgmt = mgr.getLonNetmgmt();
        var slot = _this.isSelected() ? 'tempBridgeOn' : 'tempBridgeOff';
        return netmgmt.invoke({
          slot: slot
        });
      });
      return _this;
    }

    /**
     * Support an additional `silent` param to not trigger a change event
     * @override
     * @param {boolean} selected
     * @param {Object} [params]
     * @param {boolean} [params.silent]
     */
    _inherits(TempBridgeCommand, _ToggleCommand);
    return _createClass(TempBridgeCommand, [{
      key: "setSelected",
      value: function setSelected(selected, params) {
        var _ref = params || {},
          silent = _ref.silent;
        selected = !!selected;
        if (silent && this.$selected !== selected) {
          this.$selected = selected;
        } else {
          _superPropGet(TempBridgeCommand, "setSelected", this, 3)(arguments);
        }
      }
    }]);
  }(ToggleCommand);
  /**
   * @inner
   * @class
   * @extends module:bajaux/commands/Command
   */
  var QuikLearnCommand = /*#__PURE__*/function (_Command5) {
    function QuikLearnCommand(mgr) {
      _classCallCheck(this, QuikLearnCommand);
      return _callSuper(this, QuikLearnCommand, [{
        module: 'lonworks',
        lex: 'commands.quikLearn',
        func: function func() {
          return mgr.$doQuikLearn();
        }
      }]);
    }
    _inherits(QuikLearnCommand, _Command5);
    return _createClass(QuikLearnCommand);
  }(Command);
  /**
   * @inner
   * @class
   * @extends {module:bajaux/spandrel}
   */
  var QuikLearnDialog = /*#__PURE__*/function (_spandrel) {
    function QuikLearnDialog(params) {
      _classCallCheck(this, QuikLearnDialog);
      return _callSuper(this, QuikLearnDialog, [{
        params: params,
        defaults: {
          properties: {
            rootCssClass: "-t-QuikLearnDialog"
          }
        }
      }]);
    }
    _inherits(QuikLearnDialog, _spandrel);
    return _createClass(QuikLearnDialog, [{
      key: "toState",
      value: function toState(value) {
        return value;
      }
    }, {
      key: "fromState",
      value: function fromState(state) {
        return state;
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getUnmanagedNetworksEditor",
      value: function $getUnmanagedNetworksEditor() {
        return this.queryWidget('*');
      }
    }]);
  }(spandrel(function (value, _ref2) {
    var _ref2$includeUnmanage = _ref2.includeUnmanagedNetworks,
      includeUnmanagedNetworks = _ref2$includeUnmanage === void 0 ? false : _ref2$includeUnmanage;
    var checkBoxText = LON_WORKS_LEX.get('learnPopup.unmanaged');
    return spandrel.jsx("div", {
      className: "-t-QuikLearnDialog-wrapper"
    }, spandrel.jsx("any", {
      className: "-t-QuikLearnDialog-unmanaged-checkbox",
      value: includeUnmanagedNetworks,
      bindKey: "includeUnmanagedNetworks",
      properties: {
        displayType: "checkbox",
        trueText: checkBoxText,
        falseText: checkBoxText
      },
      spandrelkey: "unmanagedNetwork"
    }));
  }, {
    strategy: 'niagara'
  }));
  /**
   * @class
   * @since Niagara 4.14
   * @alias module:nmodule/lonworks/rc/wb/mgr/UxLonRouterManager
   * @extends module:nmodule/webEditors/rc/wb/mgr/Manager
   */
  return /*#__PURE__*/function (_Manager) {
    function UxLonRouterManager() {
      var _this2;
      _classCallCheck(this, UxLonRouterManager);
      _this2 = _callSuper(this, UxLonRouterManager, [{
        moduleName: 'lonworks',
        keyName: 'UxLonRouterManager'
      }]);
      // Only subscribe to what is needed
      _this2.$subscriber = new DepthSubscriber({
        depth: 2,
        subscribeCallback: function subscribeCallback(_ref3) {
          var comp = _ref3.comp,
            sub = _ref3.sub;
          if (baja.hasType(comp, 'lonworks:LonNetmgmt')) {
            return sub.subscribe(comp.getRouterDiscoverTable());
          }
        },
        subscriptionFilter: function subscriptionFilter(filterParams) {
          return basicSubscriptionFilter(Object.assign({
            componentTypes: ['lonworks:DeviceData', 'lonworks:LonNetmgmt', LON_ROUTER_TYPE, 'lonworks:RouterEntryTable'],
            allowedDepth: 2
          }, filterParams));
        }
      });
      subscribable(_this2);
      addMgrLearnSupport(_this2);
      _this2.$servicePinMonitor = new ServicePinMonitor(_this2);
      return _this2;
    }

    /**
     * Returns the network that the manager is attached to
     * @returns {baja.Complex}
     */
    _inherits(UxLonRouterManager, _Manager);
    return _createClass(UxLonRouterManager, [{
      key: "getNetwork",
      value: function getNetwork() {
        return compUtils.closest(this.value(), baja.lt(LON_NETWORK_TYPE));
      }

      /**
       * Returns the lonworks:LonNetmgmt instance attached to this network
       * @returns {baja.Complex}
       */
    }, {
      key: "getLonNetmgmt",
      value: function getLonNetmgmt() {
        return this.getNetwork().getLonNetmgmt();
      }
    }, {
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this3 = this;
        this.on('jobcomplete', function (job) {
          if (baja.hasType(job, 'lonworks:LonDiscoverJob')) {
            _this3.$updateDiscoveryRows()["catch"](logSevere);
          }
        });
        return _superPropGet(UxLonRouterManager, "doInitialize", this, 3)(arguments);
      }
    }, {
      key: "doLoad",
      value: function doLoad() {
        var _this4 = this;
        // Show the learn table always
        var showLearnTable = once(function () {
          return _this4.$showLearnTable();
        });
        return _superPropGet(UxLonRouterManager, "doLoad", this, 3)(arguments).then(function () {
          _this4.$getTempBridgeCommand().setSelected(_this4.getLonNetmgmt().getTempBridge(), {
            silent: true
          });
          return Promise.all([showLearnTable(), _this4.$updateDiscoveryRows()]);
        });
      }

      /**
       * @returns {Promise}
       */
    }, {
      key: "doDiscover",
      value: function doDiscover() {
        var _this5 = this;
        return this.getLonNetmgmt().invoke({
          slot: 'discover'
        }).then(function (jobOrd) {
          return _this5.setJob(baja.Ord.make({
            base: baja.Ord.make('station:'),
            child: jobOrd.relativizeToSession()
          }));
        });
      }

      /**
       *
       * @param {baja.Complex} discovery
       * @returns {Promise<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>}
       */
    }, {
      key: "getTypesForDiscoverySubject",
      value: function getTypesForDiscoverySubject(discovery) {
        return MgrTypeInfo.make(LON_ROUTER_TYPE);
      }

      /**
       * Proposed values for add or match commands
       * @param {baja.Complex} discovery the discovered RouterEntry instance
       * @param {baja.Complex} lonRouter the database LonRouter instance
       * @returns {Object}
       */
    }, {
      key: "getProposedValuesFromDiscovery",
      value: function getProposedValuesFromDiscovery(discovery, lonRouter) {
        return {
          name: lonRouter.getName() || discovery.get('devName'),
          values: {
            routerType: discovery.get('routerType'),
            routerMode: discovery.get('mode'),
            nodeState: discovery.get('state'),
            nearChannelId: discovery.get('nearChannel'),
            nearSubnetNodeId: discovery.get('nearAddress'),
            farChannelId: discovery.get('farChannel'),
            farSubnetNodeId: discovery.get('farAddress'),
            nearNeuronId: discovery.get('neuronId'),
            farNeuronId: discovery.get('farNeuronId')
          }
        };
      }

      /**
       * Overrides the basic manager `#finishMainTableRow` function with some extra css information
       * specified on the dom for the table row.
       *
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row a table row instance
       * @param {JQuery} dom
       * @return {Promise<JQuery>}
       */
    }, {
      key: "finishMainTableRow",
      value: function finishMainTableRow(row, dom) {
        var subject = row.getSubject(),
          status = subject.getStatus();
        addComponentStatusCss(status, dom);
        return Promise.resolve(dom);
      }
    }, {
      key: "makeModel",
      value: function makeModel(lonNetwork) {
        return LonRouterManagerModel.make(lonNetwork);
      }
    }, {
      key: "makeLearnModel",
      value: function makeLearnModel() {
        return LonRouterLearnModel.make();
      }

      /**
       * @returns {Promise}
       */
    }, {
      key: "makeCommands",
      value: function makeCommands() {
        var _this6 = this;
        return _superPropGet(UxLonRouterManager, "makeCommands", this, 3)([]).then(function (cmds) {
          var addCommand = cmds.find(function (cmd) {
              return cmd instanceof AddCommand;
            }),
            addFunc = addCommand.getFunction(),
            quickAddCommand = cmds.find(function (cmd) {
              return cmd instanceof QuickAddCommand;
            }),
            quickAddFunc = quickAddCommand.getFunction(),
            matchCommand = cmds.find(function (cmd) {
              return cmd instanceof MatchCommand;
            }),
            matchFunc = matchCommand.getFunction(),
            quickMatchCommand = cmds.find(function (cmd) {
              return cmd instanceof QuickMatchCommand;
            }),
            quickMatchFunc = quickMatchCommand.getFunction(),
            discoverCommand = cmds.find(function (cmd) {
              return cmd instanceof DiscoverCommand;
            });
          addCommand.setFunction(function () {
            return addFunc().then(function () {
              return _this6.$updateDiscoveryRows();
            });
          });
          quickAddCommand.setFunction(function () {
            return quickAddFunc().then(function () {
              return _this6.$updateDiscoveryRows();
            });
          });
          matchCommand.setFunction(function () {
            return matchFunc().then(function () {
              return _this6.$doPostMatch();
            });
          });
          quickMatchCommand.setFunction(function () {
            return quickMatchFunc().then(function () {
              return _this6.$doPostMatch();
            });
          });
          var disable = !(_this6.value().getLonNetmgmt().getEnabled() && _this6.value().getEnabled());
          discoverCommand.setEnabled(!disable);
          var updateCommand = new UpdateCommand(_this6);
          updateCommand.setEnabled(!disable);
          var quikLearnCommand = new QuikLearnCommand(_this6);
          quikLearnCommand.setEnabled(!disable);
          cmds.push(new CommissionCommand(_this6));
          cmds.push(new ReplaceCommand(_this6));
          cmds.push(quikLearnCommand);
          cmds.push(new TempBridgeCommand(_this6));
          cmds.push(updateCommand);
          cmds.push(new ClearTableCommand(_this6));
          return cmds;
        });
      }

      /**
       * enables/disables the EditCommand based on the selected rows
       * @inheritDoc
       */
    }, {
      key: "onTableSelectionChanged",
      value: function onTableSelectionChanged(selectedSubjects) {
        var _this7 = this;
        return _superPropGet(UxLonRouterManager, "onTableSelectionChanged", this, 3)(arguments).then(function () {
          var mainTableSelection = selectedSubjects.mainTableSelection;
          var editCmd = _this7.$getEditCommand();
          var commandsEnabled = !(mainTableSelection.length === 0);
          editCmd.setEnabled(commandsEnabled);
          // Set the enabled status of CommissionCommand
          var disable = !(_this7.value().getLonNetmgmt().getEnabled() && _this7.value().getEnabled());
          var isFault = mainTableSelection.some(function (selectedComp) {
            return selectedComp.getStatus().isFault();
          });
          var commissionCmd = _this7.$getCommissionCommand();
          commissionCmd.setEnabled(!disable && commandsEnabled && !isFault);
          var replaceCmd = _this7.$getReplaceCommand();
          replaceCmd.setEnabled(!disable && commandsEnabled && !isFault);
          var quikLearnCommand = _this7.$getQuikLearnCommand();
          quikLearnCommand.setEnabled(!disable && !commandsEnabled);
        });
      }

      /**
       * Overrides the default onMainTableDblClicked action and invokes the EditCommand
       * @inheritDoc
       */
    }, {
      key: "onMainTableDblClicked",
      value: function onMainTableDblClicked(event, subjects) {
        if (subjects && subjects.length) {
          return this.$getEditCommand().invoke();
        }
      }

      /**
       * Shows the learn table and job bar by invoking the learnMode command
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$showLearnTable",
      value: function $showLearnTable() {
        var learnModeCmd = this.$getLearnModeCommand();
        if (learnModeCmd && !learnModeCmd.isSelected()) {
          return learnModeCmd.invoke();
        }
        return Promise.resolve();
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$updateDiscoveryRows",
      value: function $updateDiscoveryRows() {
        var routerTable = this.getLonNetmgmt().getRouterDiscoverTable(),
          routerEntries = routerTable.getSlots().is(LON_ROUTER_ENTRY_TYPE).toValueArray();
        var nodes = routerEntries.map(function (routerEntry) {
          var nodeName = routerEntry.getName();
          var node = new TreeNode(nodeName, nodeName);
          node.mayHaveKids = constant(false);
          node.value = constant(routerEntry);
          return node;
        });
        var learnModel = this.getLearnModel();
        return learnModel.clearRows().then(function () {
          return learnModel.insertRows(nodes, 0);
        });
      }

      /**
       * After match is complete, remove the matched discovery row entry from the router table
       * See RouterController.doMatch JAVA implementation
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doPostMatch",
      value: function $doPostMatch() {
        var _this8 = this;
        var _getLearnTableSelecte = getLearnTableSelectedSubjects(this),
          _getLearnTableSelecte2 = _slicedToArray(_getLearnTableSelecte, 1),
          learnTableSelectedSubject = _getLearnTableSelecte2[0];
        var routerTable = this.getLonNetmgmt().getRouterDiscoverTable();
        return routerTable.remove(learnTableSelectedSubject.getName()).then(function () {
          return _this8.$updateDiscoveryRows();
        });
      }

      /**
       * @private
       * @returns {module:nmodule/lonworks/rc/wb/mgr/UxLonRouterManager~CommissionCommand}
       */
    }, {
      key: "$getCommissionCommand",
      value: function $getCommissionCommand() {
        return this.getCommandGroup().findCommand(CommissionCommand);
      }

      /**
       * @private
       * @returns {module:nmodule/lonworks/rc/wb/mgr/UxLonRouterManager~ReplaceCommand}
       */
    }, {
      key: "$getReplaceCommand",
      value: function $getReplaceCommand() {
        return this.getCommandGroup().findCommand(ReplaceCommand);
      }

      /**
       * @private
       * @returns {module:nmodule/lonworks/rc/wb/mgr/UxLonRouterManager~UpdateCommand}
       */
    }, {
      key: "$getUpdateCommand",
      value: function $getUpdateCommand() {
        return this.getCommandGroup().findCommand(UpdateCommand);
      }

      /**
       * @private
       * @returns {module:nmodule/lonworks/rc/wb/mgr/UxLonRouterManager~TempBridgeCommand}
       */
    }, {
      key: "$getTempBridgeCommand",
      value: function $getTempBridgeCommand() {
        return this.getCommandGroup().findCommand(TempBridgeCommand);
      }

      /**
       * @private
       * @returns {ClearTableCommand}
       */
    }, {
      key: "$getClearTableCommand",
      value: function $getClearTableCommand() {
        return this.getCommandGroup().findCommand(ClearTableCommand);
      }

      /**
       * @private
       * @returns {module:nmodule/lonworks/rc/wb/mgr/UxLonRouterManager~QuikLearnCommand}
       */
    }, {
      key: "$getQuikLearnCommand",
      value: function $getQuikLearnCommand() {
        return this.getCommandGroup().findCommand(QuikLearnCommand);
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doCommission",
      value: function $doCommission() {
        var title = LON_WORKS_LEX.get('commands.commReplace.dialog.commission.title');
        var executeCmd = 'commissionRouter';
        return this.$doCommissionOrReplace(title, executeCmd);
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doReplace",
      value: function $doReplace() {
        var title = LON_WORKS_LEX.get('commands.commReplace.dialog.replace.title');
        var executeCmd = 'replaceRouter';
        return this.$doCommissionOrReplace(title, executeCmd);
      }

      /**
       * @private
       * @param {string} title
       * @param {string} executeCmd
       * @returns {Promise}
       */
    }, {
      key: "$doCommissionOrReplace",
      value: function $doCommissionOrReplace(title, executeCmd) {
        var _this9 = this;
        var selectedRouters = getMainTableSelectedSubjects(this);
        selectedRouters = selectedRouters.filter(function (device) {
          return device.getType().is(LON_ROUTER_TYPE);
        });
        if (selectedRouters.length > 0) {
          if (selectedRouters.length === 1) {
            var _selectedRouters = selectedRouters,
              _selectedRouters2 = _slicedToArray(_selectedRouters, 1),
              router = _selectedRouters2[0];
            var deviceData = router.getNearDeviceData();
            var routerEntries = this.getLonNetmgmt().getRouterDiscoverTable().getSlots().is(LON_ROUTER_ENTRY_TYPE).toValueArray();
            var neuronIds = this.$buildNeuronList(routerEntries, deviceData);
            var okHandler = function okHandler(editor, servicePin) {
              return editor.read().then(function (neuronId) {
                var subnetNode = deviceData.getSubnetNodeId();
                if (servicePin) {
                  var jobParameters = baja.$(COMMISSION_PARAMETER_TYPE, {
                    subnetNode: subnetNode,
                    servicePin: servicePin
                  });
                  return runJob(_this9, executeCmd, jobParameters).then(function () {
                    _this9.$servicePinMonitor.attachToServicePinJob(_this9);
                  });
                }
                if (neuronId) {
                  var promises = [];
                  //TODO the calling of the learnModeCmd.invoke is a temporary hack until a more permanent fix can be made
                  var learnModeCmd = _this9.$getLearnModeCommand();
                  if (learnModeCmd && !learnModeCmd.isSelected()) {
                    promises.push(learnModeCmd.invoke());
                  }
                  var _jobParameters = baja.$('lonworks:CommissionParameter', {
                    subnetNode: subnetNode,
                    neuronId: neuronId,
                    servicePin: servicePin
                  });
                  promises.push(runJob(_this9, executeCmd, _jobParameters));
                  return Promise.all(promises)["catch"](feDialogs.error);
                }
              });
            };
            var handlers = {
              okHandler: okHandler
            };
            return showCommissionOrReplaceDialog(title, neuronIds, handlers);
          } else {
            var subnetNodeArray = subNetNodeIdsToString(selectedRouters.map(function (selectedRouter) {
              return selectedRouter.getNearDeviceData().getSubnetNodeId();
            }));
            return runJob(this, executeCmd, baja.$('lonworks:CommissionParameter', {
              subnetNodeArray: subnetNodeArray
            }));
          }
        } else {
          return Promise.resolve();
        }
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$showServicePinDialog",
      value: function $showServicePinDialog() {
        return Promise.resolve();
      }

      /**
       * @private
       * @param {Array.<baja.Struct>} routerEntries
       * @param {baja.Component} deviceData
       * @returns {Array.<baja.Component>}
       */
    }, {
      key: "$buildNeuronList",
      value: function $buildNeuronList(routerEntries, deviceData) {
        var neuronIds = [];
        var neuronDefault = baja.$(NEURON_ID_TYPE);
        var neuronId = deviceData.getNeuronId();
        if (neuronId.encodeToString() !== neuronDefault.encodeToString()) {
          neuronIds.push(neuronId);
        } else {
          routerEntries.forEach(function (routerEntry) {
            if (!routerEntry.getDevName()) {
              neuronIds.push(routerEntry.getNeuronId());
            }
          });
          if (neuronIds.length === 0) {
            neuronIds.push(neuronDefault);
          }
        }
        return neuronIds;
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doQuikLearn",
      value: function $doQuikLearn() {
        var _this10 = this;
        return feDialogs.showFor({
          title: LON_WORKS_LEX.get('commands.learn.label'),
          type: QuikLearnDialog,
          value: {
            includeUnmanagedNetworks: false
          }
        }).then(function (result) {
          if (!result) {
            return;
          }
          var learnParameter = baja.$('lonworks:LearnParameter', {
            unmanagedNetwork: result.includeUnmanagedNetworks
          });
          return _this10.getLonNetmgmt().invoke({
            slot: 'learn',
            value: learnParameter
          }).then(function (jobOrd) {
            return _this10.setJob(baja.Ord.make({
              base: baja.Ord.make('station:'),
              child: jobOrd.relativizeToSession()
            }));
          });
        });
      }
    }]);
  }(Manager);
});
