function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/lonworks/rc/wb/mgr/model/LonDeviceManagerModel
 */

define(['baja!', 'baja!lonworks:LonDeviceFolder,lonworks:LonDevice,lonworks:LonMfgId,lonworks:SubnetNode,' + 'lonworks:DeviceData,lonworks:DynamicDevice,lonworks:ImportParameters', 'lex!lonworks', 'Promise', 'underscore', 'nmodule/driver/rc/wb/mgr/DeviceMgrModel', 'nmodule/driver/rc/wb/mgr/columns/DeviceExtsMgrColumn', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PathMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/TypeMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/MgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column'], function (baja, types, lexs, Promise, _, DeviceMgrModel, DeviceExtsMgrColumn, MgrTypeInfo, mgrUtils, IconMgrColumn, NameMgrColumn, PathMgrColumn, PropertyMgrColumn, PropertyPathMgrColumn, TypeMgrColumn, MgrColumn, Column) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    LON_WORKS_LEX = _lexs[0];
  var _Column$flags = Column.flags,
    EDITABLE = _Column$flags.EDITABLE,
    UNSEEN = _Column$flags.UNSEEN,
    READONLY = _Column$flags.READONLY;
  var LON_DEVICE_TYPE = baja.lt('lonworks:LonDevice');
  var LON_DEVICE_DATA = baja.lt('lonworks:DeviceData');
  var getProposedValue = mgrUtils.getProposedValue;

  /**
   * MgrColumn for the status
   *
   * @inner
   * @class
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn
   */
  var StatusColumn = /*#__PURE__*/function (_MgrColumn) {
    function StatusColumn() {
      _classCallCheck(this, StatusColumn);
      return _callSuper(this, StatusColumn, ['status', {
        displayName: LON_WORKS_LEX.get('device.columnTitle.status'),
        flags: UNSEEN
      }]);
    }

    /**
     * Gets the value for the row to display
     * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
     * @returns {*} the row value.
     */
    _inherits(StatusColumn, _MgrColumn);
    return _createClass(StatusColumn, [{
      key: "getValueFor",
      value: function getValueFor(row) {
        var subject = row.getSubject();
        return subject.getStatus().flagsToString(null);
      }
    }]);
  }(MgrColumn);
  /**
   * MgrColumn for the subnet id
   *
   * @inner
   * @class
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn
   */
  var SubnetColumn = /*#__PURE__*/function (_MgrColumn2) {
    function SubnetColumn() {
      _classCallCheck(this, SubnetColumn);
      return _callSuper(this, SubnetColumn, ['subnetId', {
        displayName: LON_WORKS_LEX.get('device.columnTitle.subnet'),
        flags: EDITABLE
      }]);
    }

    /**
     * Reads the value and offically applies it back to the row, by calling the super.commit
     * @param {*} value the proposed value to commit to the row
     * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
     * @returns {Promise}
     */
    _inherits(SubnetColumn, _MgrColumn2);
    return _createClass(SubnetColumn, [{
      key: "commit",
      value: function commit(value, row) {
        var _arguments = arguments,
          _this = this;
        return updateSubnetNodeId(this.getManager().value(), row).then(function () {
          return _superPropGet(SubnetColumn, "commit", _this, 3)(_arguments);
        });
      }

      /**
       * Gets the value for the row to display
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @returns {*} the row value.
       */
    }, {
      key: "getValueFor",
      value: function getValueFor(row) {
        var subnetId = row.getSubject().getDeviceData().getSubnetNodeId().getSubnetId();
        return baja.Integer.make(subnetId);
      }
    }]);
  }(MgrColumn);
  /**
   * MgrColumn for the node id
   *
   * @inner
   * @class
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn
   */
  var NodeColumn = /*#__PURE__*/function (_MgrColumn3) {
    function NodeColumn() {
      _classCallCheck(this, NodeColumn);
      return _callSuper(this, NodeColumn, ['nodeId', {
        displayName: LON_WORKS_LEX.get('device.columnTitle.node'),
        flags: EDITABLE
      }]);
    }

    /**
     * Applies value to the row.
     *
     * @param {baja.Value} value the proposed value to commit to the row
     * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
     * @returns {Promise}
     */
    _inherits(NodeColumn, _MgrColumn3);
    return _createClass(NodeColumn, [{
      key: "commit",
      value: function commit(value, row) {
        var _arguments2 = arguments,
          _this2 = this;
        return updateSubnetNodeId(this.getManager().value(), row).then(function () {
          return _superPropGet(NodeColumn, "commit", _this2, 3)(_arguments2);
        });
      }

      /**
       * Set the config for the editor to readonly if more than one row is selected
       * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} rows
       * @returns {Object} configuration object to be given to `fe.makeFor`
       */
    }, {
      key: "getConfigFor",
      value: function getConfigFor(rows) {
        var config = _superPropGet(NodeColumn, "getConfigFor", this, 3)(arguments);
        // Set readonly if more than one row is selected
        config.readonly = rows.length > 1;
        return config;
      }

      /**
       * Determines if the editor needs to be rebuilt by determining if the editor should be
       * readonly and checking that against the editors current state
       * @param {module:nmodule/webEditors/rc/fe/baja/BaseEditor} editor
       * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} rows
       * @returns {Boolean}
       */
    }, {
      key: "isEditorSuitable",
      value: function isEditorSuitable(editor, rows) {
        var setReadonly = rows.length !== 1;
        return editor.isReadonly() === setReadonly;
      }

      /**
       * Gets the value for the row to display
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @returns {*} the row value.
       */
    }, {
      key: "getValueFor",
      value: function getValueFor(row) {
        var nodeId = row.getSubject().getDeviceData().getSubnetNodeId().getNodeId();
        return baja.Integer.make(nodeId);
      }
    }]);
  }(MgrColumn);
  /**
   * MgrColumn for the manufactor id
   *
   * @inner
   * @class
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn
   */
  var MfgIdColumn = /*#__PURE__*/function (_MgrColumn4) {
    function MfgIdColumn() {
      _classCallCheck(this, MfgIdColumn);
      return _callSuper(this, MfgIdColumn, ['mfgId', {
        displayName: LON_WORKS_LEX.get('device.columnTitle.mfgId')
      }]);
    }

    /**
     * Builds the cell for the manufacture id by getting the display name of the manufacture
     * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
     * @param {JQuery} dom
     * @returns {Promise}
     */
    _inherits(MfgIdColumn, _MgrColumn4);
    return _createClass(MfgIdColumn, [{
      key: "buildCell",
      value: function buildCell(row, dom) {
        var lonMfgEnum = baja.$('lonworks:LonMfgId');
        var mfgRange = lonMfgEnum.getRange();
        return row.getSubject().getDeviceData().getProgramId().getMfgId().then(function (mfgId) {
          var ordinal = mfgRange.tagToOrdinal(mfgId);
          dom.text(mfgRange.getDisplayTag(ordinal));
        })["catch"](function (ignore) {
          dom.text(mfgRange.getDisplayTag(0));
        });
      }
    }]);
  }(MgrColumn);
  /**
   * MgrColumn for the xml file
   *
   * @inner
   * @class
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn
   */
  var XmlColumn = /*#__PURE__*/function (_PropertyMgrColumn) {
    function XmlColumn() {
      _classCallCheck(this, XmlColumn);
      return _callSuper(this, XmlColumn, ['xmlFile', {
        displayName: LON_WORKS_LEX.get('device.columnTitle.xmlFile'),
        type: LON_DEVICE_DATA,
        flags: EDITABLE
      }]);
    }

    /**
     * Reads the value and offically applies it back to the row, by calling the super.commit
     * @param {*} value the proposed value to commit to the row
     * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
     * @returns {Promise}
     */
    _inherits(XmlColumn, _PropertyMgrColumn);
    return _createClass(XmlColumn, [{
      key: "commit",
      value: function commit(value, row) {
        var subject = row.getSubject();
        var originalXml = typeof subject.getXmlFile === 'function' ? subject.getXmlFile() : baja.Ord.DEFAULT;
        return _superPropGet(XmlColumn, "commit", this, 3)(arguments).then(function () {
          row.data('originalXml', originalXml);
        });
      }

      /**
       * Set the config for the editor by setting the display filter, select filter and readonly to
       * true if more than one row selected
       * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} rows
       * @returns {Object} configuration object to be given to `fe.makeFor`
       */
    }, {
      key: "getConfigFor",
      value: function getConfigFor(rows) {
        var config = _superPropGet(XmlColumn, "getConfigFor", this, 3)(arguments);
        config = _.extend({}, config, {
          properties: _.extend({
            displayFilter: this.$displayFilter,
            selectFilter: this.$selectFilter
          }, config.properties)
        });

        //set readonly if more than one row is selected
        config.readonly = rows.length > 1;
        return config;
      }

      /**
       * Filters the entries to be displayed
       * @private
       * @param {module:nmodule/webEditors/rc/wb/tree/TreeNode} parent the parent tree node
       * @param {module:nmodule/webEditors/rc/wb/tree/TreeNode} child the child tree node
       * @returns {boolean}
       */
    }, {
      key: "$displayFilter",
      value: function $displayFilter(parent, child) {
        var typeArray = ['baja:FileSystem', 'baja:Directory', 'baja:ModuleSpace', 'baja:ModuleNavNode'];
        var childValue = child.value();
        if (childValue) {
          var navTypeSpec = childValue.getNavTypeSpec();
          return !!(typeArray.includes(navTypeSpec) || child.value().getNavName().match(/\.(lnml)$/i));
        } else {
          return true;
        }
      }

      /**
       * Returns true if the selected item can be selected by the user
       * @private
       * @param {baja.Ord} selected the ord of the selected item
       */
    }, {
      key: "$selectFilter",
      value: function $selectFilter(selected) {
        if (!selected.toString().match(/\.(lnml)$/i)) {
          throw new Error(LON_WORKS_LEX.get('lonDeviceManagerModel.selectionError'));
        }
      }

      /**
       * Determines if the editor needs to be rebuilt by determining if the editor should be
       * readonly and checking that against the editors current state
       * @param {module:nmodule/webEditors/rc/fe/baja/BaseEditor} editor
       * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} rows
       * @returns {Boolean}
       */
    }, {
      key: "isEditorSuitable",
      value: function isEditorSuitable(editor, rows) {
        var setReadonly = rows.length !== 1;
        return editor.isReadonly() === setReadonly;
      }

      /**
       * Gets the value for the row to display
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @returns {*} the row value.
       */
    }, {
      key: "getValueFor",
      value: function getValueFor(row) {
        var subject = row.getSubject();
        if (subject.getType().is("lonworks:DynamicDevice")) {
          return subject.getXmlFile();
        }
        return baja.Ord.DEFAULT;
      }
    }, {
      key: "coalesceRows",
      value: function coalesceRows(rows) {
        rows.forEach(function (row) {
          var subject = row.getSubject();
          if (subject.getType().is("lonworks:LocalLonDevice")) {
            throw new Error();
          }
        });
        return _superPropGet(XmlColumn, "coalesceRows", this, 3)(arguments);
      }
    }]);
  }(PropertyMgrColumn);
  function updateSubnetNodeId(network, row) {
    var deviceData = row.getSubject().getDeviceData();
    var currSubnetNodeId = deviceData.getSubnetNodeId();
    var currSubnetId = currSubnetNodeId.getSubnetId();
    var currNodeId = currSubnetNodeId.getNodeId();
    var newSubnetId = getProposedValue(row, 'subnetId') || currSubnetId;
    var newNodeId = getProposedValue(row, 'nodeId') || currNodeId;
    if (newSubnetId !== currSubnetId || newNodeId !== currNodeId) {
      var newSubnetNodeId = buildNewSubnetNodeId(network, row, newSubnetId.valueOf(), newNodeId.valueOf());
      return deviceData.setSubnetNodeId(newSubnetNodeId);
    }
    return Promise.resolve();
  }
  function buildNewSubnetNodeId(network, row, newSubnetId, newNodeId) {
    var currDevice = row.getSubject();
    var devices = network.getSlots().is('lonworks:LonDevice').toValueArray();
    var zero = baja.Integer.make(0);
    var newSubnetNodeId = baja.$('lonworks:SubnetNode').make({
      subnetId: newSubnetId,
      nodeId: newNodeId
    });
    devices.forEach(function (device) {
      if (device !== currDevice) {
        var deviceSubnetNodeId = device.getDeviceData().getSubnetNodeId();
        if (deviceSubnetNodeId.getSubnetId() === newSubnetId && deviceSubnetNodeId.getNodeId() === newNodeId) {
          if (currDevice.isMounted()) {
            throw new Error(LON_WORKS_LEX.get('lonDeviceManager.error.duplicateSubnetNode', newSubnetId, newNodeId));
          } else {
            newSubnetNodeId = baja.$('lonworks:SubnetNode').make({
              subnetId: zero,
              nodeId: zero
            });
          }
        }
      }
    });
    return newSubnetNodeId;
  }
  function makeColumns() {
    return [new IconMgrColumn(), new PathMgrColumn({
      flags: UNSEEN
    }), new NameMgrColumn({
      flags: EDITABLE
    }), new StatusColumn(), new TypeMgrColumn({
      flags: EDITABLE | READONLY
    }), new DeviceExtsMgrColumn('exts', {
      dynamic: true
    }), new PropertyPathMgrColumn('deviceData/nodeState', {
      displayName: LON_WORKS_LEX.get('device.columnTitle.state'),
      type: LON_DEVICE_DATA,
      flags: EDITABLE | READONLY
    }), new PropertyPathMgrColumn('deviceData/channelId', {
      displayName: LON_WORKS_LEX.get('device.columnTitle.channelId'),
      type: LON_DEVICE_DATA,
      flags: EDITABLE | UNSEEN
    }), new SubnetColumn(), new NodeColumn(), new PropertyPathMgrColumn('deviceData/workingDomain', {
      displayName: LON_WORKS_LEX.get('device.columnTitle.workDomain'),
      type: LON_DEVICE_DATA,
      flags: EDITABLE | UNSEEN | READONLY
    }), new PropertyPathMgrColumn('faultCause', {
      displayName: LON_WORKS_LEX.get('device.columnTitle.faultCause'),
      type: LON_DEVICE_TYPE,
      flags: READONLY
    }), new MfgIdColumn(), new PropertyPathMgrColumn('deviceData/programId', {
      displayName: LON_WORKS_LEX.get('device.columnTitle.programId'),
      type: LON_DEVICE_DATA,
      flags: EDITABLE | READONLY
    }), new PropertyPathMgrColumn('deviceData/neuronId', {
      displayName: LON_WORKS_LEX.get('device.columnTitle.neuronId'),
      type: LON_DEVICE_DATA,
      flags: EDITABLE | READONLY
    }), new PropertyPathMgrColumn('enabled', {
      displayName: LON_WORKS_LEX.get('device.columnTitle.enabled'),
      type: LON_DEVICE_TYPE,
      flags: EDITABLE | READONLY
    }), new XmlColumn()];
  }

  /**
   * UX Device manager for Lonworks
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/lonworks/rc/wb/mgr/model/LonDeviceManagerModel
   * @extends module:nmodule/driver/rc/wb/mgr/DeviceMgrModel
   */
  var LonDeviceManagerModel = /*#__PURE__*/function (_DeviceMgrModel) {
    function LonDeviceManagerModel() {
      _classCallCheck(this, LonDeviceManagerModel);
      return _callSuper(this, LonDeviceManagerModel, arguments);
    }
    _inherits(LonDeviceManagerModel, _DeviceMgrModel);
    return _createClass(LonDeviceManagerModel, [{
      key: "addInstances",
      value: function addInstances(instances, names) {
        var _this3 = this;
        return _superPropGet(LonDeviceManagerModel, "addInstances", this, 3)(arguments).then(function (instances) {
          return _this3.$applyXmlFiles(instances).then(function (instances) {
            return instances;
          });
        });
      }
    }, {
      key: "postEdit",
      value: function postEdit(instances) {
        return this.$applyXmlFiles(instances);
      }
    }, {
      key: "postMatch",
      value: function postMatch(instances) {
        return this.$applyXmlFiles(instances);
      }

      /**
       * Applies the XML files to those instances where the file value has changed
       * @private
       * @param {Array.<baja.Component>} instances the instances to add
       * @returns {Promise.<Array.<baja.Component>>} the instances that were processed
       */
    }, {
      key: "$applyXmlFiles",
      value: function $applyXmlFiles(instances) {
        var promises = [];
        var rows = this.getRows().filter(function (row) {
          return row.data('originalXml') !== undefined;
        });
        var useLonObjects = this.getComponentSource().getContainer().getLonNetmgmt().getUseLonObjects();
        var params = baja.$('lonworks:ImportParameters', {
          syncNvConfig: false,
          useLonObjects: useLonObjects
        });
        instances.forEach(function (instance) {
          var defaultOrd = baja.Ord.DEFAULT;
          var instanceRow = rows.filter(function (row) {
            return row.getSubject() === instance;
          })[0];
          var xmlFile = instance.get('xmlFile') || defaultOrd;
          var originalXmlFile = instanceRow ? instanceRow.data('orginialXml') || defaultOrd : defaultOrd;
          if (instanceRow) {
            originalXmlFile = instanceRow.data('orginialXml') || defaultOrd;
          }
          var xmlNotEqual = xmlFile.isNull() !== originalXmlFile.isNull() || xmlFile.encodeToString() !== originalXmlFile.encodeToString();
          if (xmlNotEqual) {
            promises.push(instance.importXml(params));
            if (instanceRow) {
              instanceRow.data('originalXml', undefined);
            }
          }
        });
        return Promise.all(promises).then(function () {
          return instances;
        });
      }
    }], [{
      key: "make",
      value:
      /**
       * Create a model of all the 'lonworks:LonDevice's and 'lonworks:LonDeviceFolder's
       * @param {baja.Component} component the Lon Networks that the model is to be created for
       * @returns {Promise<module:nmodule/lonworks/rc/wb/mgr/model/LonDeviceManagerModel>}
       */
      function make(component) {
        return Promise.all([makeColumns(), resolveNewTypes()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            columns = _ref2[0],
            newTypes = _ref2[1];
          return new LonDeviceManagerModel({
            component: component,
            columns: columns,
            newTypes: newTypes,
            folderType: baja.lt('lonworks:LonDeviceFolder')
          });
        });
      }
    }]);
  }(DeviceMgrModel);
  /**
   * Return the types for new model entries
   * @returns {Promise<Array<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>>}
   */
  function resolveNewTypes() {
    var types = [];
    return MgrTypeInfo.make({
      from: 'lonworks:LonDevice',
      concreteTypes: true
    }).then(function (newTypes) {
      newTypes.sort().forEach(function (newType) {
        var typeSpec = newType.getType().getTypeSpec();
        if (typeSpec !== 'lonworks:LonDevice' && typeSpec !== 'lonworks:LocalLonDevice') {
          if (typeSpec === 'lonworks:DynamicDevice') {
            types.unshift(newType);
          } else {
            types.push(newType);
          }
        }
      });
      return types;
    });
  }
  return LonDeviceManagerModel;
});
