function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/lonworks/rc/wb/mgr/model/LonPointManagerModel
 */

define(['baja!', 'baja!lonworks:LonProxyExt,lonworks:LonPointFolder,control:ControlPoint,' + 'lonworks:LonBooleanProxyExt,lonworks:LonFloatProxyExt,lonworks:LonEnumProxyExt,' + 'lonworks:LonStringProxyExt,control:NullProxyExt', 'lex!lonworks,driver', 'Promise', 'nmodule/driver/rc/wb/mgr/PointMgrModel', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/ToStringMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/TypeMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column'], function (baja, types, lexs, Promise, PointMgrModel, compUtils, typeUtils, MgrTypeInfo, NameMgrColumn, IconMgrColumn, PropertyPathMgrColumn, PropertyMgrColumn, ToStringMgrColumn, TypeMgrColumn, Column) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 2),
    LONWORKS_LEX = _lexs[0],
    DRIVER_LEX = _lexs[1];
  var _Column$flags = Column.flags,
    EDITABLE = _Column$flags.EDITABLE,
    UNSEEN = _Column$flags.UNSEEN,
    READONLY = _Column$flags.READONLY;
  var LONWORKS_POINT_DEVICE_EXT_TYPE = baja.lt('lonworks:LonProxyExt');
  var CONTROL_POINT_TYPE = baja.lt('control:ControlPoint');
  var UNIT_FACET_KEY = "units";

  /**
   * MgrColumn for the conversion type
   *
   * @inner
   * @class
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn
   */
  var ConversionColumn = /*#__PURE__*/function (_PropertyPathMgrColum) {
    function ConversionColumn() {
      _classCallCheck(this, ConversionColumn);
      return _callSuper(this, ConversionColumn, arguments);
    }
    _inherits(ConversionColumn, _PropertyPathMgrColum);
    return _createClass(ConversionColumn, [{
      key: "buildCell",
      value: function buildCell(row, dom) {
        var conversion = this.getProposedValueFor(row);
        return typeUtils.getTypeDisplayName(conversion.getType()).then(function (name) {
          dom.text(name);
        });
      }
    }]);
  }(PropertyPathMgrColumn);
  /**
   * MgrColumn for the facet type
   *
   * @inner
   * @class
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn
   */
  var FacetColumn = /*#__PURE__*/function (_PropertyMgrColumn) {
    function FacetColumn() {
      _classCallCheck(this, FacetColumn);
      return _callSuper(this, FacetColumn, arguments);
    }
    _inherits(FacetColumn, _PropertyMgrColumn);
    return _createClass(FacetColumn, [{
      key: "commit",
      value: function commit(value, row) {
        var _arguments = arguments,
          _this = this;
        return this.$updateUnits(value, row).then(function () {
          return _superPropGet(FacetColumn, "commit", _this, 3)(_arguments);
        });
      }

      /**
       * Update applies the facet unit changes to the device point and proxy ext
       * @private
       * @param {baja.Facets} value the new facets that were entered
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row the row to be updated
       * @returns {Promise<*>}
       */
    }, {
      key: "$updateUnits",
      value: function $updateUnits(value, row) {
        var _this2 = this;
        var controlPoint = row.getSubject();
        var proxyExt = controlPoint.getProxyExt();
        var facets = proxyExt.getDeviceFacets();
        var deviceUnit = facets.get("units");
        var newUnit = value.get("units");
        return baja.UnitDatabase.get().then(function (unitDatabase) {
          _this2.$unitDatabase = unitDatabase;
          if (newUnit && deviceUnit) {
            var newDeviceUnit;
            var deviceUnitName = deviceUnit.getUnitName();
            if (_this2.$isTemp(deviceUnit) && _this2.$isTempDiff(newUnit)) {
              newDeviceUnit = _this2.$unitDatabase.getUnit(deviceUnitName + " degrees");
            } else if (_this2.$isTempDiff(deviceUnit) && _this2.$isTemp(newUnit)) {
              newDeviceUnit = _this2.$unitDatabase.getUnit(deviceUnitName.substring(0, deviceUnitName.indexOf(" degrees")));
            }
            if (newDeviceUnit) {
              var newFacets = _this2.$makeNewFacets(facets, newDeviceUnit);
              return proxyExt.setDeviceFacets(newFacets.newCopy()).then(function () {
                return _this2.$setFacetsOnDataPoint(proxyExt, newDeviceUnit);
              });
            }
          }
        });
      }

      /**
       * Applies the unit change to the datapoint facet
       * @private
       * @param proxyExt
       * @param newDeviceUnit
       * @returns {Promise<*>}
       */
    }, {
      key: "$setFacetsOnDataPoint",
      value: function $setFacetsOnDataPoint(proxyExt, newDeviceUnit) {
        var _this3 = this;
        var refPoint;
        var slotName = proxyExt.getTargetName();
        var lonDevice = compUtils.closest(proxyExt, baja.lt('lonworks:LonDevice'));
        var targetOrd = baja.Ord.make("slot:" + proxyExt.getTargetComp());
        return targetOrd.get({
          base: lonDevice
        }).then(function (point) {
          refPoint = point;
          return refPoint.lease();
        }).then(function () {
          var dataPoint = refPoint.getSlot(slotName);
          if (dataPoint) {
            return refPoint.setFacets({
              slot: dataPoint,
              facets: _this3.$makeNewFacets(dataPoint.getFacets(), newDeviceUnit)
            });
          }
        });
      }

      /**
       * Determines if the tested unit is a 'temperature' unit
       * @private
       * @param {baja.Unit} unit the unit that is being applied to the facets
       * @returns {boolean}
       */
    }, {
      key: "$isTemp",
      value: function $isTemp(unit) {
        var qty = this.$unitDatabase.getQuantity(unit);
        return qty.getName() === 'temperature';
      }

      /**
       * Determines if the tested unit is a 'temperature differential' unit
       * @private
       * @param {baja.Unit} unit the unit that is being applied to the facets
       * @returns {boolean}
       */
    }, {
      key: "$isTempDiff",
      value: function $isTempDiff(unit) {
        var qty = this.$unitDatabase.getQuantity(unit);
        return qty.getName() === 'temperature differential';
      }

      /**
       * Makes a new facet by replacing the unit in the supplied facet with the supplied unit
       * @private
       * @param {baja.Facets} facets the current facets
       * @param {baja.Unit} unit the unit that is being added to the supplied facets
       * @returns {baja.Facets}
       */
    }, {
      key: "$makeNewFacets",
      value: function $makeNewFacets(facets, unit) {
        var newFacets = facets.makeRemove(UNIT_FACET_KEY);
        return baja.Facets.make(newFacets, baja.Facets.make([UNIT_FACET_KEY], [unit]));
      }
    }]);
  }(PropertyMgrColumn);
  /**
   * Returns the types that can be added
   * @returns {Promise<Array<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>>}
   */
  function getNewTypes() {
    return MgrTypeInfo.make(['control:BooleanPoint', 'control:NumericPoint', 'control:EnumPoint', 'control:StringPoint']);
  }

  /**
   * Makes the columns for the manager model
   * @returns {Array<module:nmodule/webEditors/rc/wb/table/model/Column>}
   */
  function makeColumns() {
    return [new IconMgrColumn(), new NameMgrColumn({
      flags: EDITABLE
    }), new ToStringMgrColumn(DRIVER_LEX.get("out")), new PropertyPathMgrColumn('proxyExt/faultCause', {
      displayName: LONWORKS_LEX.get("point.columnTitle.faultCause"),
      type: LONWORKS_POINT_DEVICE_EXT_TYPE,
      flags: READONLY
    }), new TypeMgrColumn({
      flags: EDITABLE | UNSEEN
    }), new PropertyPathMgrColumn('proxyExt/targetComp', {
      displayName: LONWORKS_LEX.get("point.columnTitle.targetComp"),
      type: LONWORKS_POINT_DEVICE_EXT_TYPE,
      flags: READONLY | EDITABLE | UNSEEN
    }), new PropertyPathMgrColumn('proxyExt/targetName', {
      displayName: LONWORKS_LEX.get("point.columnTitle.targetName"),
      type: LONWORKS_POINT_DEVICE_EXT_TYPE,
      flags: READONLY | EDITABLE | UNSEEN
    }), new FacetColumn("facets", {
      flags: EDITABLE | UNSEEN,
      type: CONTROL_POINT_TYPE
    }), new ConversionColumn('proxyExt/conversion', {
      type: LONWORKS_POINT_DEVICE_EXT_TYPE,
      flags: EDITABLE | UNSEEN
    }), new PropertyPathMgrColumn('proxyExt/enabled', {
      displayName: LONWORKS_LEX.get("point.columnTitle.enabled"),
      type: LONWORKS_POINT_DEVICE_EXT_TYPE,
      flags: READONLY | UNSEEN
    }), new PropertyPathMgrColumn('proxyExt/readValue', {
      displayName: LONWORKS_LEX.get("point.columnTitle.readValue"),
      type: LONWORKS_POINT_DEVICE_EXT_TYPE,
      flags: READONLY | UNSEEN
    }), new PropertyPathMgrColumn('proxyExt/writeValue', {
      displayName: LONWORKS_LEX.get("point.columnTitle.writeValue"),
      type: LONWORKS_POINT_DEVICE_EXT_TYPE,
      flags: READONLY | UNSEEN
    }), new PropertyPathMgrColumn('proxyExt/linkType', {
      displayName: LONWORKS_LEX.get("point.columnTitle.linkType"),
      type: LONWORKS_POINT_DEVICE_EXT_TYPE,
      flags: EDITABLE | UNSEEN
    })];
  }
  /**
  * Manager model for Lonworks Device Points
  * @since Niagara 4.14
  * @class
  * @alias module:nmodule/lonworks/rc/wb/mgr/model/LonPointManagerModel
  * @extends module:nmodule/driver/rc/wb/mgr/DeviceMgrModel
  */
  var LonPointManagerModel = /*#__PURE__*/function (_PointMgrModel) {
    function LonPointManagerModel() {
      _classCallCheck(this, LonPointManagerModel);
      return _callSuper(this, LonPointManagerModel, arguments);
    }
    _inherits(LonPointManagerModel, _PointMgrModel);
    return _createClass(LonPointManagerModel, [{
      key: "newInstance",
      value:
      /**
       * Applies the correct proxyExt to the point
       * @param typeInfo
       * @returns {module:baja/comp/ControlPoint}
       */
      function newInstance(typeInfo) {
        return typeInfo.newInstance().then(function (point) {
          var ext;
          if (point.getType().is("control:BooleanPoint")) {
            ext = baja.$("lonworks:LonBooleanProxyExt");
          } else if (point.getType().is("control:NumericPoint")) {
            ext = baja.$("lonworks:LonFloatProxyExt");
          } else if (point.getType().is("control:EnumPoint")) {
            ext = baja.$("lonworks:LonEnumProxyExt");
          } else if (point.getType().is("control:StringPoint")) {
            ext = baja.$("lonworks:LonStringProxyExt");
          } else {
            ext = baja.$("control:NullProxyExt");
          }
          point.setProxyExt(ext);
          return point;
        });
      }
    }, {
      key: "addInstances",
      value: function addInstances(instances) {
        instances.forEach(function (instance) {
          //avoid auto-generated name which has the wrong facets `instance.getFacets1()`
          var facets = instance.get('facets');
          var proxyExt = instance.getProxyExt();
          if (baja.hasType(proxyExt, 'lonworks:LonProxyExt')) {
            proxyExt.setDeviceFacets(facets);
          }
        });
        return _superPropGet(LonPointManagerModel, "addInstances", this, 3)(arguments);
      }
    }], [{
      key: "make",
      value: function make(component) {
        return Promise.all([makeColumns(), getNewTypes()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            columns = _ref2[0],
            newTypes = _ref2[1];
          return new LonPointManagerModel({
            component: component,
            columns: columns,
            newTypes: newTypes,
            folderType: baja.lt('lonworks:LonPointFolder'),
            proxyExtType: baja.lt('lonworks:LonProxyExt')
          });
        });
      }
    }]);
  }(PointMgrModel);
  return LonPointManagerModel;
});
