function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/xprotect/rc/xprotect/XProtectCameraSession
 */
define(['Promise', 'underscore', 'nmodule/js/rc/tinyevents/tinyevents', 'nmodule/videoDriver/rc/live/stream/BandwidthMonitor'], function (Promise, _, tinyevents, BandwidthMonitor) {
  'use strict';

  var BANDWIDTH_EVENT = 'XProtectCameraSession:bandwidth';
  var FRAME_EVENT = 'XProtectCameraSession:frame';
  var TIMESTAMP_EVENT = 'XProtectCameraSession:timestamp';

  /**
   * This class represents a single streaming session for one camera. It
   * provides functionality for reading video data as it streams to the browser,
   * and sending per-camera controls to the server such as playback speed and
   * pan/tilt/zoom.
   *
   * It will emit a `XProtectCameraSession.FRAME_EVENT` tinyevent for
   * every video frame received. The payload of the event will be of type
   * {@link module:nmodule/xprotect/rc/xprotect/XProtectCameraSession~FrameData|FrameData}.
   *
   * @class
   * @alias module:nmodule/xprotect/rc/xprotect/XProtectCameraSession
   * @mixes tinyevents
   */
  return /*#__PURE__*/function () {
    /**
     * @param {object} params
     * @param {module:nmodule/xprotect/rc/xprotect/XProtectSession} params.session
     * @param {string} params.cameraId ID of the camera to be controlled
     * @param {module:nmodule/xprotect/rc/xprotect/XProtectSession~StreamProperties} params.streamProperties the
     * initial properties of the camera stream
     */
    function XProtectCameraSession(_ref) {
      var _this = this;
      var session = _ref.session,
        cameraId = _ref.cameraId,
        streamProperties = _ref.streamProperties;
      _classCallCheck(this, XProtectCameraSession);
      if (!session) {
        throw new Error('session required');
      }
      if (!cameraId) {
        throw new Error('cameraId required');
      }
      if (!streamProperties) {
        throw new Error('streamProperties required');
      }
      tinyevents(this);
      this.$session = session;
      this.$cameraId = cameraId;

      /** @type {module:nmodule/xprotect/rc/xprotect/XProtectSession~StreamProperties} */
      this.$streamProperties = _.extend({}, streamProperties);
      this.$monitor = new BandwidthMonitor({
        window: 5000
      });
      this.$logBandwidth = _.throttle(function () {
        _this.emit(BANDWIDTH_EVENT, _this.$monitor.getBandwidthDisplay());
      }, 1000);
    }

    /**
     * Starts a new stream. If already streaming, the current stream will be
     * canceled before starting the new stream.
     *
     * @param {object} params
     * @param {string} params.signalType `Live` or `Playback`
     * @param {number} [params.timestamp] instant to stream from, if
     * `signalType` is `Playback`
     * @returns {Promise}
     */
    return _createClass(XProtectCameraSession, [{
      key: "stream",
      value: function stream(params) {
        var _this2 = this;
        var _this$$updateLocalStr = this.$updateLocalStreamProperties(params),
          width = _this$$updateLocalStr.width,
          height = _this$$updateLocalStr.height,
          compressionLevel = _this$$updateLocalStr.compressionLevel,
          fps = _this$$updateLocalStr.fps,
          pixelMultiplier = _this$$updateLocalStr.pixelMultiplier,
          signalType = _this$$updateLocalStr.signalType,
          timestamp = _this$$updateLocalStr.timestamp;
        var cameraId = this.$cameraId;
        this.$playbackSpeed = 1;
        return Promise.resolve(this.$cancelCurrentStream())
        // eslint-disable-next-line promise/avoid-new
        .then(function () {
          var request = _this2.$session.requestStream({
            cameraId: cameraId,
            timestamp: timestamp,
            streamProperties: {
              width: width / pixelMultiplier,
              height: height / pixelMultiplier,
              compressionLevel: compressionLevel,
              fps: fps,
              signalType: signalType
            }
          });
          _this2.$currentStreamRequest = request;
          return request.resolveVideoConnection();
        }).then(function (videoConnection) {
          _this2.$currentVideoConnection = videoConnection;
          videoConnection.addObserver({
            videoConnectionReceivedFrame: function videoConnectionReceivedFrame(frame) {
              var dataSize = frame.dataSize,
                timestamp = frame.timestamp;
              _this2.$monitor.logBytes(dataSize);
              _this2.$logBandwidth();
              if (dataSize) {
                _this2.emit(XProtectCameraSession.FRAME_EVENT, _this2.$toFrameData(frame));
                _this2.emit(XProtectCameraSession.TIMESTAMP_EVENT, timestamp);
              }
            }
          });
          videoConnection.open();
        });
      }

      /**
       * Set the current stream dimensions. If not currently streaming, these
       * dimensions will be used when starting up a stream for the first time.
       *
       * @param {module:nmodule/xprotect/rc/xprotect/XProtectSession~StreamProperties} streamProperties
       * @returns {Promise}
       */
    }, {
      key: "changeStream",
      value: function changeStream(streamProperties) {
        var props = this.$updateLocalStreamProperties(streamProperties);
        var videoConnection = this.$currentVideoConnection;
        if (!videoConnection) {
          return Promise.resolve();
        }
        var videoId = videoConnection.videoId;
        var width = props.width,
          height = props.height,
          compressionLevel = props.compressionLevel,
          fps = props.fps,
          signalType = props.signalType,
          pixelMultiplier = props.pixelMultiplier;
        return this.$session.changeStream({
          videoId: videoId,
          streamProperties: {
            width: width / pixelMultiplier,
            height: height / pixelMultiplier,
            compressionLevel: compressionLevel,
            fps: fps,
            signalType: signalType
          }
        });
      }

      /**
       * Change current playback speed.
       *
       * @param {number} speed playback speed
       * @param {boolean} force force a speed change even if already at that speed
       */
    }, {
      key: "setPlaybackSpeed",
      value: function setPlaybackSpeed(speed, force) {
        var videoConnection = this.$currentVideoConnection;
        if (videoConnection) {
          if (speed === this.$playbackSpeed && !force) {
            return;
          }
          this.$playbackSpeed = speed;
          this.$session.setPlaybackSpeed(videoConnection, speed);
        }
      }

      /**
       * Perform a pan/tilt/zoom.
       *
       * @param {string} direction PTZ direction
       */
    }, {
      key: "ptz",
      value: function ptz(direction) {
        var videoConnection = this.$currentVideoConnection;
        if (videoConnection) {
          this.$session.ptz(videoConnection, direction);
        }
      }

      /**
       * @returns {number}
       */
    }, {
      key: "getResamplingFactor",
      value: function getResamplingFactor() {
        return this.$session.getResamplingFactor();
      }

      /**
       * Releases resources held by this camera session.
       */
    }, {
      key: "destroy",
      value: function destroy() {
        return this.$cancelCurrentStream();
      }
    }, {
      key: "$updateLocalStreamProperties",
      value: function $updateLocalStreamProperties(streamProperties) {
        return _.extend(this.$streamProperties, streamProperties);
      }

      /**
       * @private
       */
    }, {
      key: "$cancelCurrentStream",
      value: function $cancelCurrentStream() {
        var currentStreamRequest = this.$currentStreamRequest;
        var currentVideoConnection = this.$currentVideoConnection;
        if (currentStreamRequest) {
          currentStreamRequest.cancelRequest();
        }
        if (currentVideoConnection) {
          currentVideoConnection.close();
        }
        delete this.$currentStreamRequest;
        delete this.$currentVideoConnection;
      }

      /**
       * @private
       * @param {object} frame a `VideoConnectionFrame` from XProtect
       * @returns {module:nmodule/xprotect/rc/xprotect/XProtectCameraSession~FrameData}
       */
    }, {
      key: "$toFrameData",
      value: function $toFrameData(frame) {
        var blob = frame.blob,
          dataSize = frame.dataSize,
          hasSizeInformation = frame.hasSizeInformation,
          sizeInfo = frame.sizeInfo,
          timestamp = frame.timestamp;
        var outFrameData = {
          blob: blob,
          dataSize: dataSize,
          timestamp: +timestamp
        };
        if (hasSizeInformation) {
          var _sizeInfo$destination = sizeInfo.destinationSize,
            resampling = _sizeInfo$destination.resampling,
            width = _sizeInfo$destination.width,
            height = _sizeInfo$destination.height;
          var multiplier = resampling * this.$session.getResamplingFactor() || 1;
          outFrameData.width = multiplier * width;
          outFrameData.height = multiplier * height;
        }
        return outFrameData;
      }
    }], [{
      key: "FRAME_EVENT",
      get: function get() {
        return FRAME_EVENT;
      }
    }, {
      key: "BANDWIDTH_EVENT",
      get: function get() {
        return BANDWIDTH_EVENT;
      }
    }, {
      key: "TIMESTAMP_EVENT",
      get: function get() {
        return TIMESTAMP_EVENT;
      }
    }]);
  }();
});

/**
 * @typedef {object} module:nmodule/xprotect/rc/xprotect/XProtectCameraSession~FrameData
 * @property {number} dataSize number of bytes in response
 * @property {number} width displayed width in pixels
 * @property {number} height displayed height in pixels
 * @property {Blob} blob raw data
 * @property {number} timestamp frame timestamp
 */
